/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ini.trakem2.Project;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StaleFiles {
    public static final boolean deleteCoordinateTransforms(Project project) {
        return StaleFiles.delete(project, project.getLoader().getCoordinateTransformsFolder(), new CoordinateTransformPath());
    }

    public static final boolean deleteAlphaMasks(Project project) {
        return StaleFiles.delete(project, project.getLoader().getMasksFolder(), new AlphaMaskPath());
    }

    public static final boolean delete(Project project, String topDir, Path g) {
        if (null == topDir) {
            return true;
        }
        HashSet<String> keepers = new HashSet<String>();
        for (Layer l : project.getRootLayerSet().getLayers()) {
            for (Patch p : l.getAll(Patch.class)) {
                String path = g.get(p);
                if (null == path) continue;
                keepers.add(path);
            }
        }
        String extension = g.extension();
        LinkedList<File> subdirs = new LinkedList<File>();
        subdirs.add(new File(topDir));
        final AtomicInteger counter = new AtomicInteger(0);
        ThreadPoolExecutor exec = Utils.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()), "Stale-file-remover");
        while (!subdirs.isEmpty()) {
            File fdir = (File)subdirs.removeFirst();
            String absPath = fdir.getAbsolutePath();
            for (String s : fdir.list()) {
                final String path = absPath + "/" + s;
                if (s.endsWith(extension)) {
                    if (keepers.contains(path)) continue;
                    exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (!new File(path).delete()) {
                                Utils.log2("Failed to delete: " + path);
                                counter.incrementAndGet();
                            }
                        }
                    });
                    continue;
                }
                File f = new File(path);
                if (!f.isDirectory()) continue;
                subdirs.add(f);
            }
        }
        exec.shutdown();
        try {
            exec.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            IJError.print(e);
        }
        if (counter.get() > 0) {
            Utils.log("ERROR: failed to delete " + counter.get() + " files.\n        See the stdout log for details.");
        }
        return 0 == counter.get();
    }

    public static final class AlphaMaskPath
    implements Path {
        @Override
        public final String get(Patch patch) {
            return patch.getAlphaMaskFilePath();
        }

        @Override
        public final String extension() {
            return ".zip";
        }
    }

    public static final class CoordinateTransformPath
    implements Path {
        @Override
        public final String get(Patch patch) {
            return patch.getCoordinateTransformFilePath();
        }

        @Override
        public final String extension() {
            return ".ct";
        }
    }

    public static interface Path {
        public String get(Patch var1);

        public String extension();
    }
}

