/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class Montage {
    private HashMap<String, HashMap<String, Item>> ht;
    private ArrayList<Item> al;
    private int i_row_start = -1;
    private int i_row_end = -1;
    private int i_col_start = -1;
    private int i_col_end = -1;

    public Montage(String convention, boolean chars_are_columns) {
        int end;
        convention = convention.toLowerCase();
        this.al = new ArrayList();
        this.ht = new HashMap();
        int start = convention.indexOf(99);
        if (convention.length() != end) {
            for (end = start + 1; end < convention.length() && 'c' == convention.charAt(end); ++end) {
            }
        }
        if (chars_are_columns) {
            this.i_col_start = start;
            this.i_col_end = end;
        } else {
            this.i_row_start = start;
            this.i_row_end = end;
        }
        start = convention.indexOf(100);
        if (convention.length() != end) {
            for (end = start + 1; end < convention.length() && 'd' == convention.charAt(end); ++end) {
            }
        }
        if (chars_are_columns) {
            this.i_row_start = start;
            this.i_row_end = end;
        } else {
            this.i_col_start = start;
            this.i_col_end = end;
        }
    }

    public void addAll(String[] file_name) {
        for (int i = 0; i < file_name.length; ++i) {
            this.add(file_name[i]);
        }
    }

    public void add(String file_name) {
        Item item = new Item(file_name);
        this.al.add(item);
        HashMap<String, Item> ob = this.ht.get(item.s_col);
        if (null == ob) {
            HashMap<String, Item> rows = new HashMap<String, Item>();
            rows.put(item.s_row, item);
            this.ht.put(item.s_col, rows);
        } else {
            ob.put(item.s_row, item);
        }
    }

    public ArrayList<String[]> getCols() {
        Object[] cols = new String[this.ht.size()];
        int i = 0;
        int max_col_len = 0;
        Iterator<String> iterator = this.ht.keySet().iterator();
        while (iterator.hasNext()) {
            String c;
            cols[i] = c = iterator.next();
            int len = cols[i].length();
            if (len > max_col_len) {
                max_col_len = len;
            }
            ++i;
        }
        for (i = this.al.size() - 1; i > -1; --i) {
            Item item = this.al.get(i);
            item.fixColLength(max_col_len);
        }
        Arrays.sort(cols);
        ArrayList<String[]> mon = new ArrayList<String[]>();
        for (i = 0; i < cols.length; ++i) {
            HashMap<String, Item> ht_rows = this.ht.get(cols[i]);
            Object[] rows = new String[ht_rows.size()];
            int j = 0;
            int max_row_len = 0;
            Iterator<Object> iterator2 = ht_rows.keySet().iterator();
            while (iterator2.hasNext()) {
                String r;
                rows[j] = r = iterator2.next();
                int len = ((String)rows[j]).length();
                if (len > max_row_len) {
                    max_row_len = len;
                }
                ++j;
            }
            for (Item item : ht_rows.values()) {
                item.fixRowLength(max_row_len);
            }
            Arrays.sort(rows);
            String[] ob_rows = new String[rows.length];
            for (j = 0; j < rows.length; ++j) {
                ob_rows[j] = ht_rows.get((Object)rows[j]).file_name;
            }
            mon.add(ob_rows);
        }
        return mon;
    }

    private class Item {
        String file_name;
        String s_col;
        String s_row;

        Item(String file_name) {
            this.file_name = file_name;
            this.s_col = file_name.substring(Montage.this.i_col_start, Montage.this.i_col_end);
            this.s_row = file_name.substring(Montage.this.i_row_start, Montage.this.i_row_end);
        }

        void fixColLength(int target_len) {
            for (int len = this.s_col.length(); target_len > len; ++len) {
                this.s_col = "0" + this.s_col;
            }
        }

        void fixRowLength(int target_len) {
            for (int len = this.s_row.length(); target_len > len; ++len) {
                this.s_row = "0" + this.s_row;
            }
        }
    }
}

