/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.Utils;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructSection;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructTranslator;
import org.w3c.dom.Element;

public class ReconstructProfile {
    private final Element profile;
    private final int id;
    private final int oid;
    private final ReconstructTranslator translator;
    private final double mag;
    private final ReconstructSection section;

    public ReconstructProfile(Element e, ReconstructTranslator t, ReconstructSection sec) {
        this.translator = t;
        this.profile = e;
        this.section = sec;
        this.id = this.translator.nextOID();
        this.oid = this.translator.nextOID();
        double m = Utils.getMag(e);
        this.mag = Double.isNaN(m) ? t.getMag() : m;
    }

    public int getOID() {
        return this.oid;
    }

    public int getID() {
        return this.id;
    }

    public void appendXML(StringBuilder sb) {
        String colorHex = Utils.hexColor(this.profile.getAttribute("fill"));
        double[] pts = Utils.getTransformedPoints(this.profile, this.section.getHeight(), this.mag);
        double[] wh = Utils.getPathExtent(pts);
        double width = wh[0];
        double height = wh[1];
        sb.append("<t2_profile\noid=\"").append(this.getOID()).append("\"\nwidth=\"").append(width).append("\"\nheight=\"").append(height).append("\"\ntransform=\"matrix(1.0,0.0,0.0,1.0,0,0)\"\ntitle=\"").append(this.profile.getAttribute("name")).append("\"\nlinks=\"\"\nstyle=\"fill:none;stroke-opacity:1.0;stroke:#").append(colorHex).append(";stroke-width:1.0px;\"\n");
        sb.append("d=\"");
        Utils.appendBezierPathXML(sb, pts);
        sb.append("\"\n>\n</t2_profile>\n");
    }
}

