/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.janelia.saalfeldlab.n5.BlockReader;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;

public interface DefaultBlockReader
extends BlockReader {
    public InputStream getInputStream(InputStream var1) throws IOException;

    @Override
    default public <T, B extends DataBlock<T>> void read(B dataBlock, InputStream in) throws IOException {
        ByteBuffer buffer = dataBlock.toByteBuffer();
        try (InputStream inflater = this.getInputStream(in);){
            DataInputStream dis = new DataInputStream(inflater);
            dis.readFully(buffer.array());
        }
        dataBlock.readData(buffer);
    }

    public static DataBlock<?> readBlock(InputStream in, DatasetAttributes datasetAttributes, long[] gridPosition) throws IOException {
        DataBlock<?> dataBlock;
        DataInputStream dis = new DataInputStream(in);
        short mode = dis.readShort();
        if (mode != 2) {
            int nDim = dis.readShort();
            int[] blockSize = new int[nDim];
            for (int d = 0; d < nDim; ++d) {
                blockSize[d] = dis.readInt();
            }
            int numElements = mode == 0 ? DataBlock.getNumElements(blockSize) : dis.readInt();
            dataBlock = datasetAttributes.getDataType().createDataBlock(blockSize, gridPosition, numElements);
        } else {
            int numElements = dis.readInt();
            dataBlock = datasetAttributes.getDataType().createDataBlock(null, gridPosition, numElements);
        }
        BlockReader reader = datasetAttributes.getCompression().getReader();
        reader.read(dataBlock, in);
        return dataBlock;
    }
}

