/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.util.Optional;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.util.CancelTask;

public class HdfEosOmiConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "HDF5-EOS-OMI";

    private HdfEosOmiConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) {
        this.rootGroup.findGroupNested("/HDFEOS/ADDITIONAL/FILE_ATTRIBUTES").ifPresent(nested -> {
            int level;
            Attribute levelAtt = nested.getAttributeContainer().findAttribute("ProcessLevel");
            if (levelAtt == null) {
                return;
            }
            int n = level = levelAtt.getStringValue().startsWith("2") ? 2 : 3;
            if (level == 3) {
                this.augmentDataset3();
            }
        });
    }

    private void augmentDataset3() {
        Optional<Group.Builder> gridso = this.rootGroup.findGroupNested("/HDFEOS/GRIDS");
        gridso.ifPresent(grids -> {
            for (Group.Builder g2 : grids.gbuilders) {
                Attribute gctp = g2.getAttributeContainer().findAttribute("GCTPProjectionCode");
                if (gctp == null || !gctp.getNumericValue().equals(0)) continue;
                Attribute nlon = g2.getAttributeContainer().findAttribute("NumberOfLongitudesInGrid");
                Attribute nlat = g2.getAttributeContainer().findAttribute("NumberOfLatitudesInGrid");
                if (nlon == null || nlon.isString() || nlat == null || nlat.isString()) continue;
                this.datasetBuilder.replaceCoordinateAxis(g2, this.makeLonCoordAxis(g2, nlon.getNumericValue().intValue(), "XDim"));
                this.datasetBuilder.replaceCoordinateAxis(g2, this.makeLatCoordAxis(g2, nlat.getNumericValue().intValue(), "YDim"));
                for (Group.Builder g3 : g2.gbuilders) {
                    for (Variable.Builder<?> vb : g3.vbuilders) {
                        vb.addAttribute(new Attribute("_CoordinateAxes", "lat lon"));
                    }
                }
            }
        });
    }

    private CoordinateAxis.Builder makeLatCoordAxis(Group.Builder g2, int n, String dimName) {
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName("lat")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName(dimName)).setUnits("degrees_north")).setDesc("latitude");
        double incr = 180.0 / (double)n;
        v.setAutoGen(-90.0 + 0.5 * incr, incr);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        return v;
    }

    private CoordinateAxis.Builder makeLonCoordAxis(Group.Builder g2, int n, String dimName) {
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName("lon")).setDataType(DataType.FLOAT)).setParentGroupBuilder(g2)).setDimensionsByName(dimName)).setUnits("degrees_east")).setDesc("longitude");
        double incr = 360.0 / (double)n;
        v.setAutoGen(-180.0 + 0.5 * incr, incr);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        return v;
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return HdfEosOmiConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            if (!ncfile.getFileTypeId().equals("HDF5-EOS")) {
                return false;
            }
            String typeName = ncfile.getRootGroup().findAttributeString("featureType", null);
            if (typeName == null) {
                return false;
            }
            if (!typeName.equals(FeatureType.GRID.toString()) && !typeName.equals(FeatureType.SWATH.toString())) {
                return false;
            }
            Attribute instName = ncfile.findAttribute("/HDFEOS/ADDITIONAL/FILE_ATTRIBUTES/@InstrumentName");
            if (instName == null || !instName.getStringValue().equals("OMI")) {
                return false;
            }
            Attribute level = ncfile.findAttribute("/HDFEOS/ADDITIONAL/FILE_ATTRIBUTES/@ProcessLevel");
            if (level == null) {
                return false;
            }
            return level.getStringValue().startsWith("2") || level.getStringValue().startsWith("3");
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new HdfEosOmiConvention(datasetBuilder);
        }
    }
}

