/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.util.Objects;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;

public class CylindricalEqualAreaProjection
extends ProjectionImpl {
    private double trueScaleLatitude;
    private double lon0;
    private double scaleFactor;
    private double projectionLongitude;
    private double falseEasting;
    private double falseNorthing;
    private Earth earth;
    private double e;
    private double one_es;
    private double totalScale;
    private double qp;
    private double[] apa;

    public CylindricalEqualAreaProjection() {
        this(0.0, 1.0, 0.0, 0.0, EarthEllipsoid.WGS84);
    }

    public CylindricalEqualAreaProjection(double lon0, double trueScaleLatitude, double falseEasting, double falseNorthing, Earth earth) {
        super("CylindricalEqualAreaProjection", false);
        Objects.requireNonNull(earth, "CEA constructor requires non-null Earth");
        this.lon0 = lon0;
        this.projectionLongitude = Math.toRadians(lon0);
        this.trueScaleLatitude = trueScaleLatitude;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.earth = earth;
        this.e = earth.getEccentricity();
        double es = earth.getEccentricitySquared();
        this.one_es = 1.0 - es;
        this.totalScale = earth.getMajor() * 0.001;
        double t = Math.toRadians(trueScaleLatitude);
        this.scaleFactor = Math.cos(t);
        if (!earth.isSpherical()) {
            t = Math.sin(t);
            this.scaleFactor /= Math.sqrt(1.0 - es * t * t);
            this.apa = MapMath.authset(es);
            this.qp = MapMath.qsfn(1.0, this.e, this.one_es);
        }
        this.addParameter("grid_mapping_name", "lambert_cylindrical_equal_area");
        this.addParameter("longitude_of_central_meridian", lon0);
        this.addParameter("standard_parallel", trueScaleLatitude);
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", earth.getMajor());
        this.addParameter("inverse_flattening", 1.0 / earth.getFlattening());
    }

    @Override
    public ProjectionImpl constructCopy() {
        CylindricalEqualAreaProjection result = new CylindricalEqualAreaProjection(this.lon0, this.trueScaleLatitude, this.falseEasting, this.falseNorthing, this.earth);
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    @Override
    public String paramsToString() {
        return null;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl xy) {
        double lam = Math.toRadians(latlon.getLongitude() - this.lon0);
        double phi = Math.toRadians(latlon.getLatitude());
        if (this.earth.isSpherical()) {
            xy.setLocation(this.scaleFactor * lam, Math.sin(phi) / this.scaleFactor);
        } else {
            xy.setLocation(this.scaleFactor * lam, 0.5 * MapMath.qsfn(Math.sin(phi), this.e, this.one_es) / this.scaleFactor);
        }
        xy.setLocation(this.totalScale * xy.getX() + this.falseEasting, this.totalScale * xy.getY() + this.falseNorthing);
        return xy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl lp) {
        double x = (ppt.getX() - this.falseEasting) / this.totalScale;
        double y = (ppt.getY() - this.falseNorthing) / this.totalScale;
        if (this.earth.isSpherical()) {
            double t = Math.abs(y *= this.scaleFactor);
            if (!(t - 1.0E-10 <= 1.0)) throw new IllegalStateException();
            if (t >= 1.0) {
                lp.setLatitude(Math.toDegrees(y < 0.0 ? -1.5707963267948966 : 1.5707963267948966));
            } else {
                lp.setLatitude(Math.toDegrees(Math.asin(y)));
            }
            lp.setLongitude(Math.toDegrees(x / this.scaleFactor));
            return lp;
        } else {
            lp.setLatitude(Math.toDegrees(MapMath.authlat(Math.asin(2.0 * y * this.scaleFactor / this.qp), this.apa)));
            lp.setLongitude(this.lon0 + Math.toDegrees(x / this.scaleFactor));
        }
        return lp;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CylindricalEqualAreaProjection that = (CylindricalEqualAreaProjection)o;
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.projectionLongitude, this.projectionLongitude) != 0) {
            return false;
        }
        if (Double.compare(that.scaleFactor, this.scaleFactor) != 0) {
            return false;
        }
        if (!Objects.equals(this.earth, that.earth)) {
            return false;
        }
        if (this.defaultMapArea == null != (that.defaultMapArea == null)) {
            return false;
        }
        return this.defaultMapArea == null || that.defaultMapArea.equals(this.defaultMapArea);
    }

    public int hashCode() {
        long temp = this.scaleFactor != 0.0 ? Double.doubleToLongBits(this.scaleFactor) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.projectionLongitude != 0.0 ? Double.doubleToLongBits(this.projectionLongitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.earth != null ? this.earth.hashCode() : 0);
        return result;
    }
}

