/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display.imagej;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Collection;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.imagej.InverseTransformDescription;
import mpicbg.imglib.image.display.imagej.SliceTransformableExtraction;
import mpicbg.imglib.image.display.imagej.SliceTransformableExtractionFloat;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.type.Type;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;

public class ImageJVirtualDisplay<T extends Type<T>>
extends ImageStack {
    final Collection<InverseTransformDescription<T>> transformDescription;
    final int type;
    final int[] dimensionPositions;
    final int dimX;
    final int dimY;
    final int dimZ;
    final int sizeX;
    final int sizeY;
    final int sizeZ;
    final ArrayList<SliceTransformableExtraction<T>> threadList = new ArrayList();
    double min;
    double max;
    ImagePlus parent = null;

    public ImageJVirtualDisplay(Collection<InverseTransformDescription<T>> interpolators, int[] dimensions, int type, int[] dim, int[] dimensionPositions) {
        super(dimensions[0], dimensions[1], dimensions[2]);
        this.transformDescription = interpolators;
        this.dimX = dim[0];
        this.dimY = dim[1];
        this.dimZ = dim[2];
        this.dimensionPositions = (int[])dimensionPositions.clone();
        this.type = type;
        this.sizeX = dimensions[0];
        this.sizeY = dimensions[1];
        this.sizeZ = dimensions[2];
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        for (InverseTransformDescription<T> it : interpolators) {
            if (it.getImage().getDisplay().getMax() > this.max) {
                this.max = it.getImage().getDisplay().getMax();
            }
            if (!(it.getImage().getDisplay().getMin() < this.min)) continue;
            this.min = it.getImage().getDisplay().getMin();
        }
    }

    public void setParent(ImagePlus parent) {
        this.parent = parent;
    }

    public Collection<InverseTransformDescription<T>> getTransformDescription() {
        return this.transformDescription;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.sizeZ) {
            throw new IllegalArgumentException("no slice " + n);
        }
        if (this.sizeZ == 0) {
            return null;
        }
        switch (this.type) {
            default: 
        }
        FloatProcessor ip = new FloatProcessor(this.sizeX, this.sizeY, this.extractSliceFloat(n - 1), null);
        ip.setMinAndMax(this.min, this.max);
        return ip;
    }

    public float[] extractSliceFloat(int slice) {
        float[] sliceImg = new float[this.sizeX * this.sizeY];
        if (this.parent == null) {
            return sliceImg;
        }
        for (SliceTransformableExtraction<T> sliceTransformableExtraction : this.threadList) {
            sliceTransformableExtraction.stopThread();
        }
        this.threadList.clear();
        for (InverseTransformDescription inverseTransformDescription : this.transformDescription) {
            SliceTransformableExtractionFloat thread = new SliceTransformableExtractionFloat(this.transformDescription.size(), inverseTransformDescription, sliceImg, this.parent, this.dimensionPositions, this.dimX, this.dimY, this.dimZ, this.sizeX, this.sizeY, slice);
            this.threadList.add(thread);
        }
        for (SliceTransformableExtraction sliceTransformableExtraction : this.threadList) {
            sliceTransformableExtraction.setPriority(1);
            sliceTransformableExtraction.start();
        }
        return sliceImg;
    }

    public float[] extractSliceFloatSingleThreaded(int slice) {
        float[] sliceImg = new float[this.sizeX * this.sizeY];
        double[] initialPosition = new double[this.dimensionPositions.length];
        for (int d = 0; d < initialPosition.length; ++d) {
            initialPosition[d] = this.dimensionPositions[d];
        }
        if (this.dimZ < initialPosition.length) {
            initialPosition[this.dimZ] = slice;
        }
        double[] position = (double[])initialPosition.clone();
        for (InverseTransformDescription<T> desc : this.transformDescription) {
            Interpolator<T> it = desc.getImage().createInterpolator(desc.getInterpolatorFactory());
            InvertibleBoundable transform = desc.getTransform();
            float[] offset = desc.getOffset();
            try {
                T type = it.getType();
                Display<T> display = it.getImage().getDisplay();
                int i = 0;
                for (int y = 0; y < this.sizeY; ++y) {
                    if (this.dimY < initialPosition.length) {
                        initialPosition[this.dimY] = y;
                    }
                    for (int x = 0; x < this.sizeX; ++x) {
                        for (int d = 0; d < initialPosition.length; ++d) {
                            position[d] = initialPosition[d] + (double)offset[d];
                        }
                        position[this.dimX] = (float)x + offset[this.dimX];
                        transform.applyInverseInPlace(position);
                        it.moveTo(position);
                        int n = i++;
                        sliceImg[n] = sliceImg[n] + display.get32Bit(type);
                    }
                }
            }
            catch (NoninvertibleModelException e) {
                System.out.println(it + " has a no invertible model: " + (Object)((Object)e));
            }
            it.close();
        }
        return sliceImg;
    }

    public void addUnsignedShortSlice(String sliceLabel, Object pixels) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    public void deleteSlice(int n) {
    }

    public void deleteLastSlice() {
    }

    public void update(ImageProcessor ip) {
    }

    public Object getPixels(int n) {
        return this.getProcessor(n).getPixels();
    }

    public void setPixels(Object pixels, int n) {
    }

    public Object[] getImageArray() {
        return null;
    }

    public String[] getSliceLabels() {
        return null;
    }

    public String getSliceLabel(int n) {
        return "" + n;
    }

    public String getShortSliceLabel(int n) {
        return this.getSliceLabel(n);
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isRGB() {
        return false;
    }

    public boolean isHSB() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String toString() {
        return "Virtual Display of " + this.transformDescription.size() + " Interpolators";
    }
}

