/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import sc.fiji.io.icns.IcnsCodec;
import sc.fiji.io.icns.IconSuite;

public class Icns_Reader
extends ImagePlus
implements PlugIn {
    private int alreadyShown;

    public void run(String arg) {
        File file = null;
        if (arg != null && arg.length() > 0) {
            file = new File(arg);
        } else {
            OpenDialog od = new OpenDialog("Choose .icns file", null);
            String directory = od.getDirectory();
            if (null == directory) {
                return;
            }
            file = new File(directory + "/" + od.getFileName());
        }
        try {
            FileInputStream in = new FileInputStream(file);
            IcnsCodec codec = new IcnsCodec();
            IconSuite icons = codec.decode(in);
            this.alreadyShown = 0;
            this.show(file.getName(), icons.getThumbnailIcon());
            this.show(file.getName(), icons.getHugeIcon());
            this.show(file.getName(), icons.getLargeIcon());
            this.show(file.getName(), icons.getSmallIcon());
        }
        catch (IOException e) {
            IJ.error((String)("Error reading file " + file.getAbsolutePath() + ": " + e));
        }
    }

    private void show(String name, BufferedImage image) {
        if (image == null) {
            return;
        }
        if (this.alreadyShown > 0) {
            new ImagePlus(name + "-" + ++this.alreadyShown, (Image)image).show();
        } else {
            this.setTitle(name);
            this.setImage(image);
            ++this.alreadyShown;
        }
    }
}

