/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Arrays;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class IntArrayVector
extends IntVector {
    private int[] values;

    private IntArrayVector(AttributeMap attributes2) {
        super(attributes2);
    }

    public IntArrayVector(int ... values) {
        this.values = Arrays.copyOf(values, values.length);
    }

    public IntArrayVector(IntVector vector2) {
        super(vector2.attributes);
        this.values = vector2.toIntArray();
    }

    public IntArrayVector(int[] values, int length2, AttributeMap attributes2) {
        super(attributes2);
        this.values = Arrays.copyOf(values, length2);
    }

    public IntArrayVector(int[] values, AttributeMap attributes2) {
        this(values, values.length, attributes2);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public int getElementAsInt(int i) {
        return this.values[i];
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        IntArrayVector clone = new IntArrayVector(attributes2);
        clone.values = this.values;
        return clone;
    }

    public int[] toIntArrayUnsafe() {
        return this.values;
    }

    public static IntArrayVector unsafe(int[] array2) {
        return IntArrayVector.unsafe(array2, AttributeMap.EMPTY);
    }

    public static IntArrayVector unsafe(int[] array2, AttributeMap attributes2) {
        IntArrayVector vector2 = new IntArrayVector(attributes2);
        vector2.values = array2;
        return vector2;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    static /* synthetic */ int[] access$102(IntArrayVector x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private static final int MIN_INITIAL_CAPACITY = 50;
        private int[] values;
        private int size;

        public Builder(int initialSize, int initialCapacity) {
            if (initialCapacity < 50) {
                initialCapacity = 50;
            }
            if (initialSize > initialCapacity) {
                initialCapacity = initialSize;
            }
            this.values = new int[initialCapacity];
            this.size = initialSize;
            Arrays.fill(this.values, Integer.MIN_VALUE);
        }

        public Builder(int initialSize) {
            this(initialSize, initialSize);
        }

        public Builder(IntVector vector2) {
            this.values = vector2.toIntArray();
            this.size = this.values.length;
            this.copyAttributesFrom(vector2);
        }

        public Builder() {
            this(0, 50);
        }

        public Builder set(int index, int value) {
            this.ensureCapacity(index + 1);
            if (index + 1 > this.size) {
                this.size = index + 1;
            }
            this.values[index] = value;
            return this;
        }

        public Builder add(int value) {
            return this.set(this.size, value);
        }

        @Override
        public Builder add(Number value) {
            return this.add(value.intValue());
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, Integer.MIN_VALUE);
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, source.getElementAsInt(sourceIndex));
        }

        @Override
        public Builder setAttribute(Symbol name, SEXP value) {
            return (Builder)super.setAttribute(name, value);
        }

        @Override
        public int length() {
            return this.size;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.values.length;
            if (minCapacity > oldCapacity) {
                int[] oldData = this.values;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.values = Arrays.copyOf(oldData, newCapacity);
                Arrays.fill(this.values, oldCapacity, this.values.length, Integer.MIN_VALUE);
            }
        }

        @Override
        public IntVector build() {
            if (this.size == this.values.length) {
                IntArrayVector vector2 = new IntArrayVector(this.buildAttributes());
                IntArrayVector.access$102(vector2, this.values);
                this.values = null;
                return vector2;
            }
            return new IntArrayVector(this.values, this.size, this.buildAttributes());
        }

        public static Builder withInitialCapacity(int capacity) {
            return new Builder(0, capacity);
        }
    }
}

