/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Shadows
implements PlugInFilter {
    String arg;
    ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        if (imp != null && imp.getStackSize() > 1 && arg.equals("demo")) {
            IJ.error("Shadows Demo does not work with stacks.");
            return 4096;
        }
        return IJ.setupDialog(imp, 95);
    }

    @Override
    public void run(ImageProcessor ip) {
        if (this.arg.equals("demo")) {
            int iterations = 20;
            IJ.resetEscape();
            for (int i = 0; i < iterations; ++i) {
                this.north(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.northeast(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.east(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.southeast(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.south(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.southwest(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.west(ip);
                Shadows.update(this.imp, ip, i, iterations);
                this.northwest(ip);
                Shadows.update(this.imp, ip, i, iterations);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                break;
            }
        } else if (this.arg.equals("north")) {
            this.north(ip);
        } else if (this.arg.equals("northeast")) {
            this.northeast(ip);
        } else if (this.arg.equals("east")) {
            this.east(ip);
        } else if (this.arg.equals("southeast")) {
            this.southeast(ip);
        } else if (this.arg.equals("south")) {
            this.south(ip);
        } else if (this.arg.equals("southwest")) {
            this.southwest(ip);
        } else if (this.arg.equals("west")) {
            this.west(ip);
        } else if (this.arg.equals("northwest")) {
            this.northwest(ip);
        }
    }

    private static void update(ImagePlus imp, ImageProcessor ip, int i, int iterations) {
        imp.updateAndDraw();
        IJ.showStatus(i + "/" + iterations);
        IJ.wait(50);
        ip.reset();
    }

    public void north(ImageProcessor ip) {
        int[] kernel = new int[]{1, 2, 1, 0, 1, 0, -1, -2, -1};
        ip.convolve3x3(kernel);
    }

    public void south(ImageProcessor ip) {
        int[] kernel = new int[]{-1, -2, -1, 0, 1, 0, 1, 2, 1};
        ip.convolve3x3(kernel);
    }

    public void east(ImageProcessor ip) {
        int[] kernel = new int[]{-1, 0, 1, -2, 1, 2, -1, 0, 1};
        ip.convolve3x3(kernel);
    }

    public void west(ImageProcessor ip) {
        int[] kernel = new int[]{1, 0, -1, 2, 1, -2, 1, 0, -1};
        ip.convolve3x3(kernel);
    }

    public void northwest(ImageProcessor ip) {
        int[] kernel = new int[]{2, 1, 0, 1, 1, -1, 0, -1, -2};
        ip.convolve3x3(kernel);
    }

    public void southeast(ImageProcessor ip) {
        int[] kernel = new int[]{-2, -1, 0, -1, 1, 1, 0, 1, 2};
        ip.convolve3x3(kernel);
    }

    public void northeast(ImageProcessor ip) {
        int[] kernel = new int[]{0, 1, 2, -1, 1, 1, -2, -1, 0};
        ip.convolve3x3(kernel);
    }

    public void southwest(ImageProcessor ip) {
        int[] kernel = new int[]{0, -1, -2, 1, 1, -1, 2, 1, 0};
        ip.convolve3x3(kernel);
    }
}

