/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table.process;

import java.util.ArrayList;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPostprocessorPlugin;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.DefaultColumn;
import org.scijava.table.DefaultGenericTable;
import org.scijava.ui.UIService;
import org.scijava.util.Types;

@Plugin(type=PostprocessorPlugin.class, priority=-9999.0)
public class ResultsPostprocessor
extends AbstractPostprocessorPlugin {
    @Parameter(required=false)
    private UIService ui;

    public void process(Module module) {
        if (this.ui == null) {
            return;
        }
        ArrayList outputs = new ArrayList();
        module.getInfo().outputs().forEach(output -> {
            String name = output.getName();
            if (module.isOutputResolved(name)) {
                return;
            }
            if (module.getOutput(name) == null) {
                return;
            }
            if (!this.isSimple(module, (ModuleItem<?>)output)) {
                return;
            }
            outputs.add(output);
        });
        if (outputs.isEmpty()) {
            return;
        }
        if (outputs.size() == 1 && Types.isText((Class)((ModuleItem)outputs.get(0)).getType())) {
            return;
        }
        DefaultGenericTable outputTable = new DefaultGenericTable();
        DefaultColumn<String> names = new DefaultColumn<String>(String.class, "Name");
        DefaultColumn<Object> values = new DefaultColumn<Object>(Object.class, "Value");
        for (ModuleItem output2 : outputs) {
            String name = output2.getName();
            names.addValue(name);
            values.addValue(module.getOutput(name));
            module.resolveOutput(name);
        }
        outputTable.add(names);
        outputTable.add(values);
        String title = module.getInfo().getTitle();
        this.ui.show(title, (Object)outputTable);
    }

    private boolean isSimple(Module m, ModuleItem<?> item) {
        Class type = item.getType();
        return this.isSimpleType(type) || type == Object.class && this.isSimpleValue(item.getValue(m));
    }

    private boolean isSimpleType(Class<?> type) {
        return Types.isText(type) || Types.isNumber(type) || Types.isBoolean(type);
    }

    private boolean isSimpleValue(Object o) {
        return o != null && this.isSimpleType(o.getClass());
    }
}

