/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.batch;

import java.io.File;
import java.util.HashMap;
import org.scijava.batch.BatchService;
import org.scijava.batch.ModuleBatchProcessor;
import org.scijava.batch.input.BatchInput;
import org.scijava.batch.input.BatchInputProvider;
import org.scijava.command.CommandService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class, priority=-100.0)
public final class FileBatchService
extends AbstractHandlerService<BatchInput, BatchInputProvider<?>>
implements BatchService {
    @Parameter
    private LogService log;
    @Parameter
    private CommandService commandService;

    @Override
    public boolean supportsItem(ModuleItem<?> moduleItem) {
        BatchInputProvider handler = (BatchInputProvider)this.getHandler(new BatchInput(File.class, moduleItem));
        if (handler == null) {
            return false;
        }
        return handler.canProvide(moduleItem);
    }

    @Override
    public <I> void fillInput(Module module, ModuleItem<?> moduleItem, I inputObject) {
        BatchInputProvider handler = (BatchInputProvider)this.getHandler(new BatchInput(File.class, moduleItem));
        if (handler == null) {
            this.log.error((Object)("No handler found for input: " + moduleItem.getName()));
            return;
        }
        handler.populateInput(module, moduleItem, (File)inputObject);
    }

    @Override
    public void run(ModuleInfo moduleInfo) {
        if (this.batchableInputs(moduleInfo).isEmpty()) {
            this.log.error((Object)"No compatible inputs (of type File) found.");
            return;
        }
        HashMap<String, ModuleInfo> inputMap = new HashMap<String, ModuleInfo>();
        inputMap.put("moduleInfo", moduleInfo);
        this.commandService.run(ModuleBatchProcessor.class, true, inputMap);
    }

    public Class<BatchInputProvider<?>> getPluginType() {
        return BatchInputProvider.class;
    }

    public Class<BatchInput> getType() {
        return BatchInput.class;
    }
}

