/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.animation;

import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class Animation
implements Runnable {
    @Parameter
    private LogService log;
    private final ImageDisplay display;
    private boolean active;
    private Thread thread;
    private AxisType axis;
    private long first;
    private long last;
    private double fps = 8.0;
    private boolean backAndForth;
    private long increment = 1L;
    private long delta = 1L;
    private boolean isRelative = true;

    public Animation(ImageDisplay display) {
        this.display = display;
        display.getContext().inject((Object)this);
        if (display.numDimensions() > 2) {
            this.axis = display.dimensionIndex(Axes.TIME) >= 0 ? Axes.TIME : (display.dimensionIndex(Axes.Z) >= 0 ? Axes.Z : ((CalibratedAxis)display.axis(2)).type());
            int axisIndex = display.dimensionIndex(this.axis);
            this.last = display.dimension(axisIndex) - 1L;
        }
    }

    public void start() {
        if (this.axis == null) {
            return;
        }
        this.active = true;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        this.active = false;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException exc) {
                this.log.error((Object)"Error stopping animation", (Throwable)exc);
            }
            this.thread = null;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public AxisType getAxis() {
        return this.axis;
    }

    public void setAxis(AxisType axis) {
        this.axis = axis;
        this.clampPosition();
    }

    public double getFPS() {
        return this.fps;
    }

    public void setFPS(double fps) {
        this.fps = fps;
    }

    public long getFirst() {
        return this.first;
    }

    public void setFirst(long first) {
        this.first = first;
        this.clampPosition();
    }

    public long getLast() {
        return this.last;
    }

    public void setLast(long last) {
        this.last = last;
        this.clampPosition();
    }

    public boolean isBackAndForth() {
        return this.backAndForth;
    }

    public void setBackAndForth(boolean backAndForth) {
        this.backAndForth = backAndForth;
    }

    @Override
    public void run() {
        while (this.active) {
            this.updatePosition();
            try {
                Thread.sleep((long)(1000.0 / this.fps));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void updatePosition() {
        long currPos = this.display.getLongPosition(this.axis);
        if (this.increment > 0L && currPos == this.last) {
            if (!this.backAndForth) {
                this.isRelative = false;
                this.delta = this.first;
                currPos = this.first;
            } else {
                this.increment = -this.increment;
                this.isRelative = true;
                this.delta = -1L;
                --currPos;
            }
        } else if (this.increment < 0L && currPos == this.first) {
            if (!this.backAndForth) {
                this.isRelative = false;
                this.delta = this.last;
                currPos = this.last;
            } else {
                this.increment = -this.increment;
                this.isRelative = true;
                this.delta = 1L;
                ++currPos;
            }
        } else {
            this.isRelative = true;
            if (this.increment > 0L) {
                this.delta = 1L;
                ++currPos;
            } else {
                this.delta = -1L;
                --currPos;
            }
        }
        long pos = this.isRelative ? this.display.getLongPosition(this.axis) + this.delta : this.delta;
        this.display.setPosition(pos, this.axis);
    }

    private void clampPosition() {
        if (this.axis == null) {
            return;
        }
        long pos = this.display.getLongPosition(this.axis);
        if (pos < this.first || pos > this.last) {
            this.display.setPosition(this.first, this.axis);
        }
    }
}

