/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.ArrayList;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.composite.CompositeXYProjector;
import net.imglib2.type.numeric.ARGBType;

public class SourceOptimizedCompositeXYProjector<A, S extends RandomAccessibleInterval<A> & IterableInterval<A>, T extends RandomAccessibleInterval<ARGBType> & IterableInterval<ARGBType>>
extends CompositeXYProjector<A> {
    private int dimIndex = 0;
    private T raTarget = null;
    private S iraSource = null;

    public SourceOptimizedCompositeXYProjector(S source, T target, ArrayList<Converter<A, ARGBType>> converters, int dimIndex) {
        super(source, target, converters, dimIndex);
        this.dimIndex = dimIndex;
        this.raTarget = target;
        this.iraSource = source;
    }

    public void map() {
        int i;
        boolean noComposite = this.dimIndex < 0;
        int size = -1;
        if (!noComposite) {
            size = this.updateCurrentArrays();
        }
        if (noComposite || size == 1) {
            super.map();
            return;
        }
        for (int d = 2; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[0] = this.raTarget.min(0);
        this.min[1] = this.raTarget.min(1);
        this.max[0] = this.raTarget.max(0);
        this.max[1] = this.raTarget.max(1);
        ArrayList<RandomAccess> sourceRandomAccess = new ArrayList<RandomAccess>();
        Cursor leadCursor = this.iraSource.localizingCursor();
        int steps = 1;
        for (i = 0; i < this.min.length; ++i) {
            steps = (int)((long)steps * (this.max[i] + 1L - this.min[i]));
        }
        for (i = 0; i < size; ++i) {
            RandomAccess randomAccess = this.iraSource.randomAccess();
            this.min[this.dimIndex] = this.max[this.dimIndex] = this.currentPositions[i];
            randomAccess.setPosition(this.min);
            sourceRandomAccess.add(randomAccess);
        }
        RandomAccess targetCursor = this.raTarget.randomAccess();
        ARGBType bi = new ARGBType();
        while (leadCursor.hasNext() && --steps >= 0) {
            int aSum = 0;
            int rSum = 0;
            int gSum = 0;
            int bSum = 0;
            leadCursor.fwd();
            for (int i2 = 0; i2 < size; ++i2) {
                RandomAccess randomAccess = (RandomAccess)sourceRandomAccess.get(i2);
                randomAccess.setPosition(leadCursor.getLongPosition(0), 0);
                randomAccess.setPosition(leadCursor.getLongPosition(1), 1);
                randomAccess.setPosition(this.currentPositions[i2], this.dimIndex);
                this.currentConverters[i2].convert(randomAccess.get(), (Object)bi);
                int value = bi.get();
                int a = ARGBType.alpha((int)value);
                int r = ARGBType.red((int)value);
                int g = ARGBType.green((int)value);
                int b = ARGBType.blue((int)value);
                aSum += a;
                rSum += r;
                gSum += g;
                bSum += b;
            }
            if (aSum > 255) {
                aSum = 255;
            }
            if (rSum > 255) {
                rSum = 255;
            }
            if (gSum > 255) {
                gSum = 255;
            }
            if (bSum > 255) {
                bSum = 255;
            }
            targetCursor.setPosition(leadCursor.getLongPosition(0), 0);
            targetCursor.setPosition(leadCursor.getLongPosition(1), 1);
            ((ARGBType)targetCursor.get()).set(ARGBType.rgba((int)rSum, (int)gSum, (int)bSum, (int)aSum));
        }
    }
}

