/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.inverse;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.inverse.AbstractDifferentiableRealTransform;

public class RealTransformFiniteDerivatives
extends AbstractDifferentiableRealTransform {
    protected final RealTransform transform;
    protected final AffineTransform jacobian;
    protected double step;

    public RealTransformFiniteDerivatives(RealTransform transform) {
        this.transform = transform;
        int srcD = transform.numSourceDimensions();
        int tgtD = transform.numTargetDimensions();
        this.jacobian = new AffineTransform(srcD > tgtD ? srcD : tgtD);
        this.step = 0.01;
    }

    public void setStep(double step) {
        this.step = step;
    }

    @Override
    public int numSourceDimensions() {
        return this.transform.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.transform.numTargetDimensions();
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.transform.apply(source, target);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.transform.apply(source, target);
    }

    @Override
    public RealTransformFiniteDerivatives copy() {
        return new RealTransformFiniteDerivatives(this.transform.copy());
    }

    @Override
    public AffineTransform jacobian(double[] x) {
        int ndims = this.numSourceDimensions();
        double[] p = new double[ndims];
        double[] q = new double[ndims];
        double[] qc = new double[ndims];
        double[][] newjac = new double[ndims][ndims + 1];
        this.transform.apply(x, qc);
        for (int i = 0; i < ndims; ++i) {
            int j;
            for (j = 0; j < ndims; ++j) {
                p[j] = j == i ? x[j] + this.step : x[j];
            }
            this.transform.apply(p, q);
            for (j = 0; j < ndims; ++j) {
                newjac[j][i] = (q[j] - qc[j]) / this.step;
            }
        }
        this.jacobian.set(newjac);
        return this.jacobian;
    }
}

