/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.segmentation;

import ij.ImageJ;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.integral.IntegralImageLong;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.io.LOCI;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

public class IntegralImage3d {
    public static final int getIndex(int x, int y, int z, int w, int h) {
        return x + w * (y + z * h);
    }

    public static final Image<LongType> compute(Image<FloatType> img) {
        Image integralTmp;
        if (img.getContainer() instanceof Array) {
            ImageFactory imgFactory = new ImageFactory((Type)new LongType(), (ContainerFactory)new ArrayContainerFactory());
            integralTmp = imgFactory.createImage(new int[]{img.getDimension(0) + 1, img.getDimension(1) + 1, img.getDimension(2) + 1});
            IntegralImage3d.computeArray((Image<LongType>)integralTmp, img);
        } else {
            ImageFactory imgFactory = new ImageFactory((Type)new LongType(), img.getContainerFactory());
            integralTmp = imgFactory.createImage(new int[]{img.getDimension(0) + 1, img.getDimension(1) + 1, img.getDimension(2) + 1});
            IntegralImage3d.compute((Image<LongType>)integralTmp, img);
        }
        return integralTmp;
    }

    public static final void computeIntegralImage(Image<LongType> integralTmp, Image<FloatType> img) {
        if (integralTmp.getContainer() instanceof Array && img.getContainer() instanceof Array) {
            IntegralImage3d.computeArray(integralTmp, img);
        } else {
            IntegralImage3d.compute(integralTmp, img);
        }
    }

    private static final void computeArray(Image<LongType> integralTmp, Image<FloatType> img) {
        int ithread;
        Array array1 = (Array)integralTmp.getContainer();
        LongArray longarray = (LongArray)array1.update(null);
        final long[] data = longarray.getCurrentStorageArray();
        Array array2 = (Array)img.getContainer();
        FloatArray floatarray = (FloatArray)array2.update(null);
        final float[] dataF = floatarray.getCurrentStorageArray();
        final int w = integralTmp.getDimension(0);
        final int h = integralTmp.getDimension(1);
        final int d = integralTmp.getDimension(2);
        final int wf = img.getDimension(0);
        final int hf = img.getDimension(1);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    for (int z = 1; z < d; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 1; y < h; ++y) {
                            long sum;
                            int indexIn = IntegralImage3d.getIndex(0, y - 1, z - 1, wf, hf);
                            int indexOut = IntegralImage3d.getIndex(1, y, z, w, h);
                            data[indexOut] = sum = (long)((int)dataF[indexIn]);
                            for (int x = 2; x < w; ++x) {
                                data[++indexOut] = sum += (long)((int)dataF[++indexIn]);
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        ai.set(0);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    for (int z = 1; z < d; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int x = 1; x < w; ++x) {
                            int index = IntegralImage3d.getIndex(x, 1, z, w, h);
                            long sum = data[index];
                            for (int y = 2; y < h; ++y) {
                                data[index] = sum += data[index += w];
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        ai.set(0);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int inc = w * h;
                    for (int y = 1; y < h; ++y) {
                        if (y % numThreads != myNumber) continue;
                        for (int x = 1; x < w; ++x) {
                            int index = IntegralImage3d.getIndex(x, y, 1, w, h);
                            long sum = data[index];
                            for (int z = 2; z < d; ++z) {
                                data[index] = sum += data[index += inc];
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    private static final void compute(final Image<LongType> integralTmp, final Image<FloatType> img) {
        int ithread;
        final int w = integralTmp.getDimension(0);
        final int h = integralTmp.getDimension(1);
        final int d = integralTmp.getDimension(2);
        int wf = img.getDimension(0);
        int hf = img.getDimension(1);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    LocalizableByDimCursor data = integralTmp.createLocalizableByDimCursor();
                    LocalizableByDimCursor dataF = img.createLocalizableByDimCursor();
                    int[] pos = new int[3];
                    int[] posF = new int[3];
                    for (int z = 1; z < d; ++z) {
                        if (z % numThreads != myNumber) continue;
                        posF[2] = z - 1;
                        pos[2] = z;
                        for (int y = 1; y < h; ++y) {
                            posF[1] = y - 1;
                            posF[0] = 0;
                            pos[1] = y;
                            pos[0] = 1;
                            dataF.setPosition(posF);
                            data.setPosition(pos);
                            long sum = (int)((FloatType)dataF.getType()).get();
                            ((LongType)data.getType()).set(sum);
                            for (int x = 2; x < w; ++x) {
                                data.fwd(0);
                                dataF.fwd(0);
                                ((LongType)data.getType()).set(sum += (long)((int)((FloatType)dataF.getType()).get()));
                            }
                        }
                    }
                    data.close();
                    dataF.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        ai.set(0);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    LocalizableByDimCursor data = integralTmp.createLocalizableByDimCursor();
                    int[] pos = new int[3];
                    for (int z = 1; z < d; ++z) {
                        if (z % numThreads != myNumber) continue;
                        pos[2] = z;
                        for (int x = 1; x < w; ++x) {
                            pos[0] = x;
                            pos[1] = 1;
                            data.setPosition(pos);
                            long sum = ((LongType)data.getType()).get();
                            for (int y = 2; y < h; ++y) {
                                data.fwd(1);
                                ((LongType)data.getType()).set(sum += ((LongType)data.getType()).get());
                            }
                        }
                    }
                    data.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        ai.set(0);
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int inc = w * h;
                    LocalizableByDimCursor data = integralTmp.createLocalizableByDimCursor();
                    int[] pos = new int[3];
                    for (int y = 1; y < h; ++y) {
                        if (y % numThreads != myNumber) continue;
                        pos[1] = y;
                        for (int x = 1; x < w; ++x) {
                            pos[0] = x;
                            pos[2] = 1;
                            data.setPosition(pos);
                            long sum = ((LongType)data.getType()).get();
                            for (int z = 2; z < d; ++z) {
                                data.fwd(2);
                                ((LongType)data.getType()).set(sum += ((LongType)data.getType()).get());
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static void main(String[] args) {
        long t1;
        int i;
        new ImageJ();
        Image img = LOCI.openLOCIFloatType((String)"/Users/preibischs/Documents/Microscopy/SPIM/HisYFP-SPIM/spim_TL18_Angle0.tif", (ContainerFactory)new ArrayContainerFactory());
        long t = 0L;
        System.out.println("new implementation");
        for (i = 0; i < 10; ++i) {
            t1 = System.currentTimeMillis();
            Image<LongType> integralImg = IntegralImage3d.compute((Image<FloatType>)img);
            integralImg.close();
            long t2 = System.currentTimeMillis();
            System.out.println(t2 - t1 + " ms");
            t += t2 - t1;
        }
        System.out.println("avg: " + t / 10L + " ms");
        System.out.println("\nold implementation");
        t = 0L;
        for (i = 0; i < 10; ++i) {
            t1 = System.currentTimeMillis();
            IntegralImageLong intImg = new IntegralImageLong(img, (Converter)new Converter<FloatType, LongType>(){

                public void convert(FloatType input, LongType output) {
                    output.set((long)Util.round((float)input.get()));
                }
            });
            intImg.process();
            Image integralImg = intImg.getResult();
            integralImg.close();
            long t2 = System.currentTimeMillis();
            System.out.println(t2 - t1 + " ms");
            t += t2 - t1;
        }
        System.out.println("avg: " + t / 10L + " ms");
    }
}

