/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.imglib.util.Util;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.cuda.CUDADevice;
import spim.process.cuda.CUDAFourierConvolution;
import spim.process.cuda.CUDATools;
import spim.process.cuda.NativeLibraryTools;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.deconvolution.ChannelPSF;
import spim.process.fusion.deconvolution.ExtractPSF;
import spim.process.fusion.deconvolution.MVDeconFFT;
import spim.process.fusion.deconvolution.MVDeconInput;
import spim.process.fusion.deconvolution.MVDeconvolution;
import spim.process.fusion.deconvolution.ProcessForDeconvolution;
import spim.process.fusion.export.DisplayImage;
import spim.process.fusion.export.FixedNameImgTitler;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.ImgExportTitle;
import spim.process.fusion.weightedavg.WeightedAverageFusion;

public class EfficientBayesianBased
extends Fusion {
    public static String[] computationOnChoice = new String[]{"CPU (Java)", "GPU (Nvidia CUDA via JNA)"};
    public static String[] osemspeedupChoice = new String[]{"1 (balanced)", "minimal number of overlapping views", "average number of overlapping views", "specify manually"};
    public static String[] extractPSFChoice = new String[]{"Extract from beads", "Provide file with PSF"};
    public static String[] blocksChoice = new String[]{"Entire image at once", "in 64x64x64 blocks", "in 128x128x128 blocks", "in 256x256x256 blocks", "in 512x512x512 blocks", "specify maximal blocksize manually"};
    public static String[] displayPSFChoice = new String[]{"Do not show PSFs", "Show MIP of combined PSF's", "Show combined PSF's", "Show individual PSF's", "Show combined PSF's (original scale)", "Show individual PSF's (original scale)"};
    public static String[] iterationTypeString = new String[]{"Efficient Bayesian - Optimization II (very fast, imprecise)", "Efficient Bayesian - Optimization I (fast, precise)", "Efficient Bayesian (less fast, more precise)", "Independent (slow, very precise)"};
    public static String[] weightsString = new String[]{"Precompute weights for all views (more memory, faster)", "Virtual weights (less memory, slower)", "No weights (produces artifacts on partially overlapping data)", "Illustrate overlap of views per pixel (do not deconvolve)"};
    public static int defaultBlendingRangeNumber = 12;
    public static int defaultBlendingBorderNumber = -8;
    public static int[] defaultBlendingRange = null;
    public static int[] defaultBlendingBorder = null;
    public static boolean makeAllPSFSameSize = false;
    public static int defaultFFTImgType = 0;
    public static int defaultIterationType = 1;
    public static int defaultWeightType = 1;
    public static boolean defaultSaveMemory = false;
    public static int defaultOSEMspeedupIndex = 0;
    public static int defaultNumIterations = 10;
    public static boolean defaultUseTikhonovRegularization = true;
    public static double defaultLambda = 0.006;
    public static int defaultBlockSizeIndex = 0;
    public static int defaultBlockSizeX = 256;
    public static int defaultBlockSizeY = 256;
    public static int defaultBlockSizeZ = 256;
    public static int defaultComputationTypeIndex = 0;
    public static int defaultExtractPSF = 0;
    public static int defaultDisplayPSF = 1;
    public static boolean defaultDebugMode = false;
    public static boolean defaultAdjustBlending = false;
    public static int defaultDebugInterval = 1;
    public static double defaultOSEMspeedup = 1.0;
    public static boolean defaultSamePSFForAllAnglesIllums = true;
    public static boolean defaultSamePSFForAllChannels = true;
    public static boolean defaultTransformPSFs = true;
    public static ArrayList<String> defaultPSFFileField = null;
    public static int[] defaultPSFLabelIndex = null;
    public static int defaultPSFSizeX = 19;
    public static int defaultPSFSizeY = 19;
    public static int defaultPSFSizeZ = 25;
    public static String defaultCUDAPath = null;
    public static boolean defaultCUDAPathIsRelative = true;
    MVDeconFFT.PSFTYPE iterationType;
    ProcessForDeconvolution.WeightType weightType;
    boolean saveMemory;
    int osemspeedupIndex;
    int numIterations;
    boolean useTikhonovRegularization;
    double lambda;
    int blockSizeIndex;
    int computationTypeIndex;
    int extractPSFIndex;
    int displayPSF;
    boolean debugMode;
    boolean adjustBlending;
    ImgFactory<FloatType> factory;
    ImgFactory<FloatType> computeFactory = new ArrayImgFactory();
    boolean useBlocks;
    int[] blockSize;
    boolean useCUDA;
    int debugInterval;
    double osemSpeedUp;
    boolean extractPSF;
    boolean transformPSFs;
    HashMap<Channel, ArrayList<Pair<Pair<Angle, Illumination>, String>>> psfFiles;
    HashMap<Channel, ChannelPSF> extractPSFLabels;
    int blendingBorderX;
    int blendingBorderY;
    int blendingBorderZ;
    int blendingRangeX;
    int blendingRangeY;
    int blendingRangeZ;
    int psfSizeX = -1;
    int psfSizeY = -1;
    int psfSizeZ = -1;
    ArrayList<CUDADevice> deviceList = null;
    Choice gpu;
    Choice block;
    Choice it;
    Choice weight;
    Checkbox saveMem;

    public EfficientBayesianBased(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
        BoundingBoxGUI.defaultImgType = 2;
        this.interpolation = 1;
        Fusion.defaultInterpolation = 1;
    }

    @Override
    public boolean fuseData(BoundingBoxGUI bb, ImgExport exporter) {
        try {
            FixedNameImgTitler titler = new FixedNameImgTitler("");
            if (exporter instanceof ImgExportTitle) {
                ((ImgExportTitle)exporter).setImgTitler(titler);
            }
            this.factory = bb.getImgFactory(new FloatType());
            IOFunctions.println("BlendingBorder: " + this.blendingBorderX + ", " + this.blendingBorderY + ", " + this.blendingBorderZ);
            IOFunctions.println("BlendingBorder: " + this.blendingRangeX + ", " + this.blendingRangeY + ", " + this.blendingRangeZ);
            ProcessForDeconvolution pfd = new ProcessForDeconvolution(this.spimData, this.viewIdsToProcess, bb, new int[]{this.blendingBorderX, this.blendingBorderY, this.blendingBorderZ}, new int[]{this.blendingRangeX, this.blendingRangeY, this.blendingRangeZ});
            MVDeconvolution.debug = this.debugMode;
            MVDeconvolution.debugInterval = this.debugInterval;
            int stack = 0;
            for (TimePoint t : this.timepointsToProcess) {
                for (Channel c : this.channelsToProcess) {
                    Img<FloatType> deconvolved;
                    ArrayList<Angle> anglesToProcess = SpimData2.getAllAnglesForChannelTimepointSorted(this.spimData, this.viewIdsToProcess, c, t);
                    ArrayList<Illumination> illumsToProcess = SpimData2.getAllIlluminationsForChannelTimepointSorted(this.spimData, this.viewIdsToProcess, c, t);
                    if (!pfd.fuseStacksAndGetPSFs(t, c, this.factory, this.osemspeedupIndex, this.osemSpeedUp, this.weightType, this.extractPSFLabels, new long[]{this.psfSizeX, this.psfSizeY, this.psfSizeZ}, this.psfFiles, this.transformPSFs)) {
                        IOFunctions.println("FAILED to deconvolve timepoint=" + t.getName() + " (id=" + t.getId() + "), channel=" + c.getName() + " (id=" + c.getId() + ")");
                        continue;
                    }
                    if (stack++ == 0) {
                        if (this.osemspeedupIndex == 1) {
                            this.osemSpeedUp = pfd.getMinOverlappingViews();
                        } else if (this.osemspeedupIndex == 2) {
                            this.osemSpeedUp = pfd.getAvgOverlappingViews();
                        }
                    }
                    this.displayParametersAndPSFs(bb, c, this.extractPSFLabels);
                    if (this.weightType == ProcessForDeconvolution.WeightType.WEIGHTS_ONLY) {
                        return true;
                    }
                    MVDeconInput deconvolutionData = new MVDeconInput(this.factory);
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Block & FFT image factory: " + this.computeFactory.getClass().getSimpleName());
                    for (ViewDescription vd : pfd.getViewDescriptions()) {
                        int[] devList = new int[this.deviceList.size()];
                        for (int i = 0; i < devList.length; ++i) {
                            devList[i] = this.deviceList.get(i).getDeviceId();
                            if (devList[i] < 0 || ArrayImgFactory.class.isInstance(this.computeFactory)) continue;
                            throw new RuntimeException("CUDA computing is only possible when selecting ArrayImg for 'ImgLib2 container FFTs'");
                        }
                        deconvolutionData.add(new MVDeconFFT(pfd.getTransformedImgs().get(vd), pfd.getTransformedWeights().get(vd), pfd.getExtractPSF().getTransformedPSF((ViewId)vd), this.computeFactory, devList, this.useBlocks, this.blockSize, this.saveMemory));
                    }
                    if (!this.useTikhonovRegularization) {
                        this.lambda = 0.0;
                    }
                    try {
                        deconvolved = new MVDeconvolution(deconvolutionData, this.iterationType, this.numIterations, this.lambda, this.osemSpeedUp, this.osemspeedupIndex, "deconvolved").getPsi();
                    }
                    catch (IncompatibleTypeException e) {
                        IOFunctions.println("Failed to initialize deconvolution: " + (Object)((Object)e));
                        e.printStackTrace();
                        return false;
                    }
                    titler.setTitle("TP" + t.getName() + "_Ch" + c.getName() + FusionHelper.getIllumName(illumsToProcess) + FusionHelper.getAngleName(anglesToProcess));
                    exporter.exportImage(deconvolved, bb, t, (ViewSetup)this.newViewsetups.get(SpimData2.getViewSetup(((SequenceDescription)this.spimData.getSequenceDescription()).getViewSetupsOrdered(), c, (Angle)anglesToProcess.get(0), (Illumination)illumsToProcess.get(0))), 0.0, 1.0);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            IJ.log((String)"Out of Memory");
            IJ.error((String)"Multi-View Registration", (String)"Out of memory.  Check \"Edit > Options > Memory & Threads\"");
            return false;
        }
        return true;
    }

    @Override
    public boolean queryParameters() {
        if (!this.getBlocks()) {
            return false;
        }
        if (!this.getCUDA()) {
            return false;
        }
        if (!this.getPSF()) {
            return false;
        }
        if (this.extractPSF && !this.reOrderChannels()) {
            return false;
        }
        if (!this.getOSEM()) {
            return false;
        }
        if (!this.getBlending()) {
            return false;
        }
        return this.getDebug();
    }

    @Override
    public void registerAdditionalListeners(final BoundingBoxGUI.ManageListeners m) {
        this.block.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                m.update();
            }
        });
        this.gpu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                m.update();
            }
        });
        this.it.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                m.update();
            }
        });
        this.weight.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                m.update();
            }
        });
        this.saveMem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                m.update();
            }
        });
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd) {
        gd.addChoice("ImgLib2_container_FFTs", BoundingBoxGUI.imgTypes, BoundingBoxGUI.imgTypes[defaultFFTImgType]);
        gd.addCheckbox("Save_memory (not keep FFT's on CPU, 2x time & 0.5x memory)", defaultSaveMemory);
        this.saveMem = (Checkbox)gd.getCheckboxes().lastElement();
        gd.addChoice("Type_of_iteration", iterationTypeString, iterationTypeString[defaultIterationType]);
        this.it = (Choice)gd.getChoices().lastElement();
        gd.addChoice("Image_weights", weightsString, weightsString[defaultWeightType]);
        this.weight = (Choice)gd.getChoices().lastElement();
        gd.addChoice("OSEM_acceleration", osemspeedupChoice, osemspeedupChoice[defaultOSEMspeedupIndex]);
        gd.addNumericField("Number_of_iterations", (double)defaultNumIterations, 0);
        gd.addCheckbox("Debug_mode", defaultDebugMode);
        gd.addCheckbox("Adjust_blending_parameters (if stripes are visible)", defaultAdjustBlending);
        gd.addCheckbox("Use_Tikhonov_regularization", defaultUseTikhonovRegularization);
        gd.addNumericField("Tikhonov_parameter", defaultLambda, 4);
        gd.addChoice("Compute", blocksChoice, blocksChoice[defaultBlockSizeIndex]);
        this.block = (Choice)gd.getChoices().lastElement();
        gd.addChoice("Compute_on", computationOnChoice, computationOnChoice[defaultComputationTypeIndex]);
        this.gpu = (Choice)gd.getChoices().lastElement();
        gd.addChoice("PSF_estimation", extractPSFChoice, extractPSFChoice[defaultExtractPSF]);
        gd.addChoice("PSF_display", displayPSFChoice, displayPSFChoice[defaultDisplayPSF]);
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd) {
        defaultFFTImgType = gd.getNextChoiceIndex();
        this.computeFactory = defaultFFTImgType == 0 ? new ArrayImgFactory() : (defaultFFTImgType == 1 ? new ImagePlusImgFactory() : new CellImgFactory(new int[]{256}));
        this.saveMemory = defaultSaveMemory = gd.getNextBoolean();
        defaultIterationType = gd.getNextChoiceIndex();
        this.iterationType = defaultIterationType == 0 ? MVDeconFFT.PSFTYPE.OPTIMIZATION_II : (defaultIterationType == 1 ? MVDeconFFT.PSFTYPE.OPTIMIZATION_I : (defaultIterationType == 2 ? MVDeconFFT.PSFTYPE.EFFICIENT_BAYESIAN : MVDeconFFT.PSFTYPE.INDEPENDENT));
        defaultWeightType = gd.getNextChoiceIndex();
        this.weightType = defaultWeightType == 0 ? ProcessForDeconvolution.WeightType.PRECOMPUTED_WEIGHTS : (defaultWeightType == 1 ? ProcessForDeconvolution.WeightType.VIRTUAL_WEIGHTS : (defaultWeightType == 2 ? ProcessForDeconvolution.WeightType.NO_WEIGHTS : ProcessForDeconvolution.WeightType.WEIGHTS_ONLY));
        this.osemspeedupIndex = defaultOSEMspeedupIndex = gd.getNextChoiceIndex();
        this.numIterations = defaultNumIterations = (int)Math.round(gd.getNextNumber());
        this.debugMode = defaultDebugMode = gd.getNextBoolean();
        this.adjustBlending = defaultAdjustBlending = gd.getNextBoolean();
        this.useTikhonovRegularization = defaultUseTikhonovRegularization = gd.getNextBoolean();
        this.lambda = defaultLambda = gd.getNextNumber();
        this.blockSizeIndex = defaultBlockSizeIndex = gd.getNextChoiceIndex();
        this.computationTypeIndex = defaultComputationTypeIndex = gd.getNextChoiceIndex();
        this.extractPSFIndex = defaultExtractPSF = gd.getNextChoiceIndex();
        this.displayPSF = defaultDisplayPSF = gd.getNextChoiceIndex();
        return true;
    }

    @Override
    public Fusion newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new EfficientBayesianBased(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Multi-view deconvolution";
    }

    @Override
    public boolean supports16BitUnsigned() {
        return false;
    }

    @Override
    public boolean supportsDownsampling() {
        return false;
    }

    @Override
    public boolean compressBoundingBoxDialog() {
        return true;
    }

    @Override
    public long totalRAM(long fusedSizeMB, int bytePerPixel) {
        if (this.weight.getSelectedIndex() == weightsString.length - 1) {
            return fusedSizeMB * (long)this.getMaxNumViewsPerTimepoint() + this.avgPixels / 0x100000L * (long)bytePerPixel;
        }
        int blockChoice = this.block.getSelectedIndex();
        long blockSize = blockChoice == 1 ? (long)(262144 * bytePerPixel / 0x100000) : (blockChoice == 2 ? (long)(0x200000 * bytePerPixel / 0x100000) : (blockChoice == 3 ? (long)(0x1000000 * bytePerPixel / 0x100000) : (blockChoice == 4 ? (long)(0x8000000 * bytePerPixel / 0x100000) : fusedSizeMB)));
        long totalRam = this.weight.getSelectedIndex() == 0 ? fusedSizeMB * (long)(this.getMaxNumViewsPerTimepoint() * 2) : (this.weight.getSelectedIndex() == 1 ? fusedSizeMB * (long)(this.getMaxNumViewsPerTimepoint() + 1) : fusedSizeMB * (long)this.getMaxNumViewsPerTimepoint());
        totalRam = this.gpu.getSelectedIndex() == 0 ? (this.saveMem.getState() ? (long)((double)totalRam + (double)blockSize * 1.5) : (long)((double)totalRam + (double)(blockSize * (long)this.getMaxNumViewsPerTimepoint()) * 1.5)) : (totalRam += (long)(160000 * bytePerPixel / 0x100000 * this.getMaxNumViewsPerTimepoint()));
        totalRam = this.gpu.getSelectedIndex() == 0 ? (long)((double)totalRam + (double)(blockSize * 6L) * 1.5) : (totalRam += blockSize * 2L);
        return totalRam += fusedSizeMB * 3L;
    }

    protected void displayParametersAndPSFs(BoundingBoxGUI bb, Channel channel, HashMap<Channel, ChannelPSF> extractPSFLabels) {
        block12: {
            DisplayImage displayImage;
            ExtractPSF<FloatType> ePSF;
            block15: {
                block14: {
                    block13: {
                        block11: {
                            IOFunctions.println("Type of iteration: " + (Object)((Object)this.iterationType));
                            IOFunctions.println("Number iterations: " + this.numIterations);
                            IOFunctions.println("OSEM speedup: " + this.osemSpeedUp);
                            IOFunctions.println("Using blocks: " + this.useBlocks);
                            if (this.useBlocks) {
                                IOFunctions.println("Block size: " + Util.printCoordinates((int[])this.blockSize));
                            }
                            IOFunctions.println("Using CUDA: " + this.useCUDA);
                            IOFunctions.println("Blending border: " + this.blendingBorderX + "x" + this.blendingBorderY + "x" + this.blendingBorderZ);
                            IOFunctions.println("Blending range: " + this.blendingRangeX + "x" + this.blendingRangeY + "x" + this.blendingRangeZ);
                            if (this.extractPSF) {
                                IOFunctions.println("PSF size (extracting): " + this.psfSizeX + "x" + this.psfSizeY + "x" + this.psfSizeZ);
                                for (ChannelPSF channelPSF : extractPSFLabels.values()) {
                                    if (channelPSF.getOtherChannel() == null) {
                                        IOFunctions.println("Channel " + channelPSF.getChannel().getName() + " extracts from label '" + channelPSF.getLabel() + "'. ");
                                        continue;
                                    }
                                    IOFunctions.println("Channel " + channelPSF.getChannel().getName() + " uses same PSF as channel '" + channelPSF.getOtherChannel().getName() + "'. ");
                                }
                            } else {
                                int size = 0;
                                for (Channel c : this.psfFiles.keySet()) {
                                    size += this.psfFiles.get(c).size();
                                }
                                IOFunctions.println("PSF will be read from disc, number of PSF's loaded: " + size);
                            }
                            if (this.debugMode) {
                                IOFunctions.println("Debugging every " + this.debugInterval + " iterations.");
                            }
                            IOFunctions.println("ImgLib container (deconvolved): " + bb.getImgFactory(new FloatType()).getClass().getSimpleName());
                            if (this.useTikhonovRegularization) {
                                IOFunctions.println("Using Tikhonov regularization (lambda = " + this.lambda + ")");
                            } else {
                                IOFunctions.println("Not using Tikhonov regularization");
                            }
                            ePSF = extractPSFLabels.get(channel).getExtractPSFInstance();
                            displayImage = new DisplayImage();
                            if (this.displayPSF != 1) break block11;
                            displayImage.exportImage(ExtractPSF.computeMaxProjection(ePSF.computeAverageTransformedPSF(), -1), "Max projected avg transformed PSF's");
                            break block12;
                        }
                        if (this.displayPSF != 2) break block13;
                        displayImage.exportImage(ePSF.computeAverageTransformedPSF(), "Avg transformed PSF's");
                        break block12;
                    }
                    if (this.displayPSF != 3) break block14;
                    for (int i = 0; i < ePSF.getPSFMap().values().size(); ++i) {
                        ViewId viewId = ePSF.getViewIdsForPSFs().get(i);
                        displayImage.exportImage(ePSF.getTransformedPSF(viewId), "transfomed PSF of viewsetup " + viewId.getViewSetupId());
                    }
                    break block12;
                }
                if (this.displayPSF != 4) break block15;
                displayImage.exportImage(ePSF.computeAveragePSF(), "Avg original PSF's");
                break block12;
            }
            if (this.displayPSF != 5) break block12;
            for (int i = 0; i < ePSF.getInputCalibrationPSFs().size(); ++i) {
                ViewId viewId = ePSF.getViewIdsForPSFs().get(i);
                displayImage.exportImage((RandomAccessibleInterval)ePSF.getInputCalibrationPSFs().get(viewId), "original PSF of viewsetup " + viewId.getViewSetupId());
            }
        }
    }

    protected boolean reOrderChannels() {
        ArrayList<Channel> channelsToExtract = new ArrayList<Channel>();
        ArrayList<Channel> channelsUsingAnotherPSF = new ArrayList<Channel>();
        for (Channel c : this.channelsToProcess) {
            if (this.extractPSFLabels.get(c).getLabel() == null) {
                channelsUsingAnotherPSF.add(c);
                continue;
            }
            channelsToExtract.add(c);
        }
        if (channelsToExtract.size() == 0) {
            IOFunctions.println("At least one channel needs to extract PSFs. Stopping.");
            return false;
        }
        for (Channel c : channelsUsingAnotherPSF) {
            if (this.extractPSFLabels.get(this.extractPSFLabels.get(c).getOtherChannel()).getLabel() != null) continue;
            IOFunctions.println("Channel " + c.getName() + " is supposed to use the PSF from channel " + this.extractPSFLabels.get(c).getOtherChannel().getName() + ", but this one also does notextract PSFs. Stopping.");
            return false;
        }
        this.channelsToProcess.clear();
        this.channelsToProcess.addAll(channelsToExtract);
        this.channelsToProcess.addAll(channelsUsingAnotherPSF);
        return true;
    }

    protected boolean getBlending() {
        if (this.adjustBlending) {
            GenericDialog gd = new GenericDialog("Adjust blending parameters");
            if (defaultBlendingBorder == null || defaultBlendingBorder.length < 3) {
                defaultBlendingBorder = new int[]{defaultBlendingBorderNumber, defaultBlendingBorderNumber, Math.round((float)defaultBlendingBorderNumber / 2.5f)};
            }
            if (defaultBlendingRange == null || defaultBlendingRange.length < 3) {
                defaultBlendingRange = new int[]{defaultBlendingRangeNumber, defaultBlendingRangeNumber, defaultBlendingRangeNumber};
            }
            gd.addSlider("Boundary_pixels_X", -50.0, 50.0, (double)defaultBlendingBorder[0]);
            gd.addSlider("Boundary_pixels_Y", -50.0, 50.0, (double)defaultBlendingBorder[1]);
            gd.addSlider("Boundary_pixels_Z", -50.0, 50.0, (double)defaultBlendingBorder[2]);
            gd.addSlider("Blending_range_X", 0.0, 100.0, (double)defaultBlendingRange[0]);
            gd.addSlider("Blending_range_Y", 0.0, 100.0, (double)defaultBlendingRange[1]);
            gd.addSlider("Blending_range_Z", 0.0, 100.0, (double)defaultBlendingRange[2]);
            gd.addMessage("");
            gd.addMessage("Note: both sizes are in local coordinates of the input views. Increase one or both of those values if stripy artifacts\nare visible in the deconvolution result.\nThe boundary pixels describe a range of pixels at the edge of each input view that are discarded because of the PSF size,\nit should typically correspond to half the size of the extracted PSF.\nThe blending range defines in which outer part of each view the cosine blending is performed. You can manually inspect\nthe results of these operations by choosing 'Illustrate overlap of views per pixel (do not deconvolve)' in the previous\ndialog. Choose just one input view to get an idea of what is cut off for individual stacks.", GUIHelper.mediumstatusfont);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.blendingBorderX = EfficientBayesianBased.defaultBlendingBorder[0] = (int)Math.round(gd.getNextNumber());
            this.blendingBorderY = EfficientBayesianBased.defaultBlendingBorder[1] = (int)Math.round(gd.getNextNumber());
            this.blendingBorderZ = EfficientBayesianBased.defaultBlendingBorder[2] = (int)Math.round(gd.getNextNumber());
            this.blendingRangeX = EfficientBayesianBased.defaultBlendingRange[0] = (int)Math.round(gd.getNextNumber());
            this.blendingRangeY = EfficientBayesianBased.defaultBlendingRange[1] = (int)Math.round(gd.getNextNumber());
            this.blendingRangeZ = EfficientBayesianBased.defaultBlendingRange[2] = (int)Math.round(gd.getNextNumber());
        } else {
            if (defaultBlendingBorder != null && defaultBlendingBorder.length >= 3) {
                this.blendingBorderX = defaultBlendingBorder[0];
                this.blendingBorderY = defaultBlendingBorder[1];
                this.blendingBorderZ = defaultBlendingBorder[2];
            } else {
                this.blendingBorderX = defaultBlendingBorderNumber;
                this.blendingBorderY = defaultBlendingBorderNumber;
                this.blendingBorderZ = Math.round((float)defaultBlendingBorderNumber / 2.5f);
            }
            if (defaultBlendingRange != null && defaultBlendingRange.length >= 3) {
                this.blendingRangeX = defaultBlendingRange[0];
                this.blendingRangeY = defaultBlendingRange[1];
                this.blendingRangeZ = defaultBlendingRange[2];
            } else {
                this.blendingRangeX = defaultBlendingRangeNumber;
                this.blendingRangeY = defaultBlendingRangeNumber;
                this.blendingRangeZ = defaultBlendingRangeNumber;
            }
        }
        return true;
    }

    protected boolean getPSF() {
        block58: {
            ArrayList<ValuePair> files;
            ValuePair aiPair;
            int j;
            int i;
            block57: {
                if (this.extractPSFIndex != 0) break block57;
                this.extractPSF = true;
                this.psfFiles = null;
                HashMap<Channel, ArrayList<Correspondence>> correspondences = new HashMap<Channel, ArrayList<Correspondence>>();
                this.assembleAvailableCorrespondences(correspondences, new HashMap<Channel, Integer>(), true);
                int sumChannels = 0;
                for (Channel c : correspondences.keySet()) {
                    sumChannels += correspondences.get(c).size();
                }
                if (sumChannels == 0) {
                    IOFunctions.println("No detections that have been registered are available to extract a PSF. Quitting.");
                    return false;
                }
                String[][] choices = new String[this.channelsToProcess.size()][];
                if (defaultPSFLabelIndex == null || defaultPSFLabelIndex.length != this.channelsToProcess.size()) {
                    defaultPSFLabelIndex = new int[this.channelsToProcess.size()];
                }
                ArrayList otherChannels = new ArrayList();
                for (int i2 = 0; i2 < this.channelsToProcess.size(); ++i2) {
                    Channel c = (Channel)this.channelsToProcess.get(i2);
                    ArrayList<Correspondence> corr = correspondences.get(c);
                    choices[i2] = new String[corr.size() + this.channelsToProcess.size() - 1];
                    for (int j3 = 0; j3 < corr.size(); ++j3) {
                        choices[i2][j3] = corr.get(j3).getLabel();
                    }
                    HashMap otherChannel = new HashMap();
                    int n = 0;
                    for (int j4 = 0; j4 < this.channelsToProcess.size(); ++j4) {
                        if (((Channel)this.channelsToProcess.get(j4)).equals((Object)c)) continue;
                        choices[i2][n + corr.size()] = "Same PSF as channel " + ((Channel)this.channelsToProcess.get(j4)).getName();
                        otherChannel.put(n + corr.size(), this.channelsToProcess.get(j4));
                        ++n;
                    }
                    otherChannels.add(otherChannel);
                    if (defaultPSFLabelIndex[i2] >= 0 && defaultPSFLabelIndex[i2] < choices[i2].length) continue;
                    EfficientBayesianBased.defaultPSFLabelIndex[i2] = 0;
                }
                GenericDialogPlus gd = new GenericDialogPlus("Extract PSF's ...");
                for (int j2 = 0; j2 < this.channelsToProcess.size(); ++j2) {
                    gd.addChoice("Detections_to_extract_PSF_for_channel_" + ((Channel)this.channelsToProcess.get(j2)).getName(), choices[j2], choices[j2][defaultPSFLabelIndex[j2]]);
                }
                gd.addMessage("");
                gd.addSlider("PSF_size_X", 9.0, 100.0, (double)defaultPSFSizeX);
                gd.addSlider("PSF_size_Y", 9.0, 100.0, (double)defaultPSFSizeY);
                gd.addSlider("PSF_size_Z", 9.0, 100.0, (double)defaultPSFSizeZ);
                gd.addMessage(" \nNote: PSF size is in local coordinates [px] of the input view.", GUIHelper.mediumstatusfont);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return false;
                }
                this.extractPSFLabels = new HashMap();
                for (int j2 = 0; j2 < this.channelsToProcess.size(); ++j2) {
                    Channel c = (Channel)this.channelsToProcess.get(j2);
                    EfficientBayesianBased.defaultPSFLabelIndex[j2] = gd.getNextChoiceIndex();
                    int l = EfficientBayesianBased.defaultPSFLabelIndex[j2];
                    if (l < correspondences.get(c).size()) {
                        this.extractPSFLabels.put(c, new ChannelPSF(c, choices[j2][l]));
                        IOFunctions.println("Channel " + c.getName() + ": extract PSF from label '" + choices[j2][l] + "'");
                        continue;
                    }
                    this.extractPSFLabels.put(c, new ChannelPSF(c, (Channel)((HashMap)otherChannels.get(j2)).get(l)));
                    IOFunctions.println("Channel " + c.getName() + ": uses same PSF as channel " + this.extractPSFLabels.get(c).getOtherChannel().getName());
                }
                this.psfSizeX = defaultPSFSizeX = (int)Math.round(gd.getNextNumber());
                this.psfSizeY = defaultPSFSizeY = (int)Math.round(gd.getNextNumber());
                this.psfSizeZ = defaultPSFSizeZ = (int)Math.round(gd.getNextNumber());
                if (this.psfSizeX % 2 == 0) {
                    defaultPSFSizeX = ++this.psfSizeX;
                }
                if (this.psfSizeY % 2 == 0) {
                    defaultPSFSizeY = ++this.psfSizeY;
                }
                if (this.psfSizeZ % 2 != 0) break block58;
                defaultPSFSizeZ = ++this.psfSizeZ;
                break block58;
            }
            this.extractPSF = false;
            this.extractPSFLabels = new HashMap();
            for (Channel c : this.channelsToProcess) {
                this.extractPSFLabels.put(c, new ChannelPSF(c));
            }
            ArrayList<Angle> anglesToProcess = SpimData2.getAllAnglesSorted(this.spimData, this.viewIdsToProcess);
            ArrayList<Illumination> illumsToProcess = SpimData2.getAllIlluminationsSorted(this.spimData, this.viewIdsToProcess);
            if (anglesToProcess.size() * illumsToProcess.size() * this.channelsToProcess.size() > 1) {
                GenericDialogPlus gd = new GenericDialogPlus("Load PSF File ...");
                if (anglesToProcess.size() * illumsToProcess.size() > 1) {
                    gd.addCheckbox("Use_same_PSF_for_all_angles/illuminations", defaultSamePSFForAllAnglesIllums);
                }
                if (this.channelsToProcess.size() > 1) {
                    gd.addCheckbox("Use_same_PSF_for_all_channels", defaultSamePSFForAllChannels);
                }
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return false;
                }
                if (anglesToProcess.size() * illumsToProcess.size() > 1) {
                    defaultSamePSFForAllAnglesIllums = gd.getNextBoolean();
                }
                if (this.channelsToProcess.size() > 1) {
                    defaultSamePSFForAllChannels = gd.getNextBoolean();
                }
            } else {
                defaultSamePSFForAllChannels = true;
                defaultSamePSFForAllAnglesIllums = true;
            }
            GenericDialogPlus gd2 = new GenericDialogPlus("Select PSF File ...");
            gd2.addCheckbox("Transform_PSFs", defaultTransformPSFs);
            gd2.addMessage("");
            gd2.addMessage("Note: the calibration of the PSF(s) has to match the calibration of the input views\nif you choose to transform them according to the registration of the views!", GUIHelper.mediumstatusfont);
            int numPSFs = defaultSamePSFForAllAnglesIllums ? 1 : anglesToProcess.size() * illumsToProcess.size();
            if (!defaultSamePSFForAllChannels) {
                numPSFs *= this.channelsToProcess.size();
            }
            if (defaultPSFFileField == null) {
                defaultPSFFileField = new ArrayList();
            }
            while (defaultPSFFileField.size() < numPSFs) {
                defaultPSFFileField.add("");
            }
            if (defaultPSFFileField.size() > numPSFs) {
                for (i = numPSFs; i < defaultPSFFileField.size(); ++i) {
                    defaultPSFFileField.remove(numPSFs);
                }
            }
            if (defaultSamePSFForAllAnglesIllums) {
                if (defaultSamePSFForAllChannels) {
                    gd2.addFileField("PSF_file", defaultPSFFileField.get(0), 50);
                } else {
                    j = 0;
                    for (Object c : this.channelsToProcess) {
                        gd2.addFileField("PSF_file_(channel=" + c.getName() + ")", defaultPSFFileField.get(j++), 50);
                    }
                }
            } else {
                j = 0;
                if (defaultSamePSFForAllChannels) {
                    for (Illumination i3 : illumsToProcess) {
                        for (Angle angle : anglesToProcess) {
                            gd2.addFileField("PSF_file_(angle=" + angle.getName() + ", illum=" + i3.getName() + ")", defaultPSFFileField.get(j++), 50);
                        }
                    }
                } else {
                    for (Object c : this.channelsToProcess) {
                        for (Illumination illumination : illumsToProcess) {
                            for (Angle a : anglesToProcess) {
                                gd2.addFileField("PSF_file_(angle=" + a.getName() + ", illum=" + illumination.getName() + ", channel=" + c.getName() + ")", defaultPSFFileField.get(j++), 50);
                            }
                        }
                    }
                }
            }
            GUIHelper.addScrollBars((Container)gd2);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return false;
            }
            this.transformPSFs = defaultTransformPSFs = gd2.getNextBoolean();
            defaultPSFFileField.clear();
            for (i = 0; i < numPSFs; ++i) {
                defaultPSFFileField.add(gd2.getNextString());
            }
            this.psfFiles = new HashMap();
            if (defaultSamePSFForAllAnglesIllums) {
                if (defaultSamePSFForAllChannels) {
                    String fileName = defaultPSFFileField.get(0);
                    ArrayList files2 = new ArrayList();
                    for (Illumination i2 : illumsToProcess) {
                        for (Angle a : anglesToProcess) {
                            aiPair = new ValuePair((Object)a, (Object)i2);
                            files2.add(new ValuePair((Object)aiPair, (Object)fileName));
                        }
                    }
                    for (Channel c : this.channelsToProcess) {
                        this.psfFiles.put(c, files2);
                    }
                } else {
                    j = 0;
                    for (Object c : this.channelsToProcess) {
                        files = new ArrayList<ValuePair>();
                        String string = defaultPSFFileField.get(j);
                        for (Illumination i6 : illumsToProcess) {
                            for (Angle a : anglesToProcess) {
                                ValuePair aiPair2 = new ValuePair((Object)a, (Object)i6);
                                files.add(new ValuePair((Object)aiPair2, (Object)string));
                            }
                        }
                        this.psfFiles.put((Channel)c, files);
                        ++j;
                    }
                }
            } else if (defaultSamePSFForAllChannels) {
                ArrayList<ValuePair> files3 = new ArrayList<ValuePair>();
                int j5 = 0;
                for (Illumination i5 : illumsToProcess) {
                    for (Angle a : anglesToProcess) {
                        aiPair = new ValuePair((Object)a, (Object)i5);
                        files3.add(new ValuePair((Object)aiPair, (Object)defaultPSFFileField.get(j5++)));
                    }
                }
                for (Channel c : this.channelsToProcess) {
                    this.psfFiles.put(c, files3);
                }
            } else {
                j = 0;
                for (Object c : this.channelsToProcess) {
                    files = new ArrayList();
                    for (Illumination i7 : illumsToProcess) {
                        for (Angle a : anglesToProcess) {
                            ValuePair aiPair3 = new ValuePair((Object)a, (Object)i7);
                            files.add(new ValuePair((Object)aiPair3, (Object)defaultPSFFileField.get(j++)));
                        }
                    }
                    this.psfFiles.put((Channel)c, files);
                }
            }
        }
        return true;
    }

    protected boolean getOSEM() {
        if (this.osemspeedupIndex == 0) {
            this.osemSpeedUp = 1.0;
            defaultOSEMspeedup = 1.0;
        } else if (this.osemspeedupIndex == 3) {
            GenericDialog gdOSEM = new GenericDialog("OSEM options");
            gdOSEM.addNumericField("Additional_acceleration = ", defaultOSEMspeedup, 2);
            gdOSEM.showDialog();
            if (gdOSEM.wasCanceled()) {
                return false;
            }
            defaultOSEMspeedup = this.osemSpeedUp = gdOSEM.getNextNumber();
        }
        return true;
    }

    protected boolean getDebug() {
        if (this.weightType == ProcessForDeconvolution.WeightType.WEIGHTS_ONLY) {
            return true;
        }
        if (this.debugMode) {
            GenericDialog gdDebug = new GenericDialog("Debug options");
            gdDebug.addNumericField("Show debug output every n'th frame, n = ", (double)defaultDebugInterval, 0);
            gdDebug.showDialog();
            if (gdDebug.wasCanceled()) {
                return false;
            }
            defaultDebugInterval = this.debugInterval = (int)Math.round(gdDebug.getNextNumber());
        }
        return true;
    }

    protected boolean getBlocks() {
        if (this.blockSizeIndex == 0) {
            this.useBlocks = false;
            this.blockSize = null;
        } else if (this.blockSizeIndex == 1) {
            this.useBlocks = true;
            this.blockSize = new int[]{64, 64, 64};
        } else if (this.blockSizeIndex == 2) {
            this.useBlocks = true;
            this.blockSize = new int[]{128, 128, 128};
        } else if (this.blockSizeIndex == 3) {
            this.useBlocks = true;
            this.blockSize = new int[]{256, 256, 256};
        } else if (this.blockSizeIndex == 4) {
            this.useBlocks = true;
            this.blockSize = new int[]{512, 512, 512};
        }
        if (this.blockSizeIndex == 5) {
            GenericDialog gd = new GenericDialog("Define block sizes");
            gd.addNumericField("blocksize_x", (double)defaultBlockSizeX, 0);
            gd.addNumericField("blocksize_y", (double)defaultBlockSizeY, 0);
            gd.addNumericField("blocksize_z", (double)defaultBlockSizeZ, 0);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            defaultBlockSizeX = Math.max(1, (int)Math.round(gd.getNextNumber()));
            defaultBlockSizeY = Math.max(1, (int)Math.round(gd.getNextNumber()));
            defaultBlockSizeZ = Math.max(1, (int)Math.round(gd.getNextNumber()));
            this.useBlocks = true;
            this.blockSize = new int[]{defaultBlockSizeX, defaultBlockSizeY, defaultBlockSizeZ};
        }
        return true;
    }

    protected boolean getCUDA() {
        this.deviceList = new ArrayList();
        if (this.computationTypeIndex == 0) {
            this.deviceList.add(new CUDADevice(-1, "CPU", Runtime.getRuntime().maxMemory(), Runtime.getRuntime().freeMemory(), 0, 0));
            this.useCUDA = false;
        } else {
            ArrayList<String> potentialNames = new ArrayList<String>();
            potentialNames.add("fftCUDA");
            potentialNames.add("FourierConvolutionCUDA");
            MVDeconFFT.cuda = NativeLibraryTools.loadNativeLibrary(potentialNames, CUDAFourierConvolution.class);
            if (MVDeconFFT.cuda == null) {
                IOFunctions.println("Cannot load CUDA JNA library.");
                return false;
            }
            ArrayList<CUDADevice> selectedDevices = CUDATools.queryCUDADetails(MVDeconFFT.cuda, this.useBlocks);
            if (selectedDevices == null || selectedDevices.size() == 0) {
                return false;
            }
            this.deviceList.addAll(selectedDevices);
            this.useCUDA = true;
        }
        return true;
    }

    protected void assembleAvailableCorrespondences(HashMap<Channel, ArrayList<Correspondence>> correspondences, HashMap<Channel, Integer> viewsPresent, boolean onlyValid) {
        ViewInterestPoints vp = this.spimData.getViewInterestPoints();
        for (Channel c : this.channelsToProcess) {
            int countViews = 0;
            ArrayList<Correspondence> corrList = new ArrayList<Correspondence>();
            for (TimePoint t : this.timepointsToProcess) {
                for (ViewId viewId : SpimData2.getAllViewIdsForTimePointSorted(this.spimData, this.viewIdsToProcess, t)) {
                    ViewDescription vd = ((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(viewId);
                    if (((ViewSetup)vd.getViewSetup()).getChannel().getId() != c.getId() || !vd.isPresent()) continue;
                    ++countViews;
                    ViewInterestPointLists vpl = vp.getViewInterestPointLists(viewId);
                    for (String label : vpl.getHashMap().keySet()) {
                        InterestPointList ipl = vpl.getInterestPointList(label);
                        String name = label + " --- channel: " + c.getName() + " angle: " + ((ViewSetup)vd.getViewSetup()).getAngle().getName() + " illum: " + ((ViewSetup)vd.getViewSetup()).getIllumination().getName() + " timepoint: " + t.getName() + ": ";
                        if (ipl.getInterestPoints() == null) {
                            ipl.loadInterestPoints();
                        }
                        if (ipl.getCorrespondingInterestPoints() == null) {
                            ipl.loadCorrespondingInterestPoints();
                        }
                        if (ipl.getCorrespondingInterestPoints().size() > 0) {
                            Correspondence corrTmp = new Correspondence(label);
                            boolean foundEntry = false;
                            for (Correspondence corr : corrList) {
                                if (!corr.equals(corrTmp)) continue;
                                corr.increaseCount();
                                foundEntry = true;
                                break;
                            }
                            if (!foundEntry) {
                                corrList.add(corrTmp);
                            }
                            IOFunctions.println(name + ipl.getCorrespondingInterestPoints().size() + " correspondences.");
                            continue;
                        }
                        IOFunctions.println(name + " NO correspondences.");
                    }
                }
            }
            correspondences.put(c, corrList);
            viewsPresent.put(c, countViews);
        }
        for (Channel c : this.channelsToProcess) {
            IOFunctions.println();
            IOFunctions.println("Found " + correspondences.get(c).size() + " label(s) with correspondences for channel " + c.getName() + ": ");
            ArrayList<Correspondence> newList = new ArrayList<Correspondence>();
            for (Correspondence corr : correspondences.get(c)) {
                int numViews = viewsPresent.get(c);
                IOFunctions.println("Label '" + corr.getLabel() + "' (channel " + c.getName() + ") has " + corr.getCount() + "/" + numViews + " views with corresponding detections.");
                if (onlyValid && corr.getCount() != numViews) continue;
                newList.add(corr);
            }
            correspondences.remove(c);
            correspondences.put(c, newList);
        }
    }

    @Override
    protected Map<ViewSetup, ViewSetup> createNewViewSetups(BoundingBoxGUI bb) {
        return WeightedAverageFusion.assembleNewViewSetupsFusion(this.spimData, this.viewIdsToProcess, bb, "Decon", "Decon");
    }

    protected class Correspondence {
        final String label;
        int count;

        public Correspondence(String label) {
            this.label = label;
            this.count = 1;
        }

        public void increaseCount() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (o instanceof Correspondence) {
                return ((Correspondence)o).getLabel().equals(this.getLabel());
            }
            return false;
        }
    }
}

