/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.concurrent.Callable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.weights.Blending;

public class TransformWeights
implements Callable<String> {
    final ImagePortion portion;
    final AffineTransform3D transform;
    final RandomAccessibleInterval<FloatType> blendingImg;
    final RandomAccessibleInterval<FloatType> overlapImg;
    final Blending blending;
    final int offsetX;
    final int offsetY;
    final int offsetZ;
    final int imgSizeX;
    final int imgSizeY;
    final int imgSizeZ;

    public TransformWeights(ImagePortion portion, Interval imgInterval, Blending blending, AffineTransform3D transform, RandomAccessibleInterval<FloatType> overlapImg, RandomAccessibleInterval<FloatType> blendingImg, long[] offset) {
        this.portion = portion;
        this.blendingImg = blendingImg;
        this.transform = transform;
        this.overlapImg = overlapImg;
        this.blending = blending;
        this.offsetX = (int)offset[0];
        this.offsetY = (int)offset[1];
        this.offsetZ = (int)offset[2];
        this.imgSizeX = (int)imgInterval.dimension(0);
        this.imgSizeY = (int)imgInterval.dimension(1);
        this.imgSizeZ = (int)imgInterval.dimension(2);
    }

    @Override
    public String call() throws Exception {
        RealRandomAccess<FloatType> wr = this.blending.realRandomAccess();
        Cursor cursorO = Views.iterable(this.overlapImg).localizingCursor();
        Cursor cursorB = Views.iterable(this.blendingImg).cursor();
        float[] s = new float[3];
        float[] t = new float[3];
        cursorO.jumpFwd(this.portion.getStartPosition());
        cursorB.jumpFwd(this.portion.getStartPosition());
        int j = 0;
        while ((long)j < this.portion.getLoopSize()) {
            FloatType o = (FloatType)cursorO.next();
            cursorO.localize(s);
            FloatType b = (FloatType)cursorB.next();
            s[0] = s[0] + (float)this.offsetX;
            s[1] = s[1] + (float)this.offsetY;
            s[2] = s[2] + (float)this.offsetZ;
            this.transform.applyInverse(t, s);
            wr.setPosition(t);
            o.set(o.get() + 1.0f);
            b.set((FloatType)wr.get());
            ++j;
        }
        return this.portion + " finished successfully (visualize weights).";
    }
}

