/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.MetadataLevel;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.BitBuffer;
import io.scif.config.SCIFIOConfig;
import io.scif.util.FormatTools;
import io.scif.util.ImageTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Windows Bitmap")
public class BMPFormat
extends AbstractFormat {
    public static final String BMP_MAGIC_STRING = "BM";
    private static final int RAW = 0;
    private static final int RLE_8 = 1;
    private static final int RLE_4 = 2;
    private static final int RGB_MASK = 3;

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"bmp"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            ImageMetadata imageMeta = meta.get(imageIndex);
            int xIndex = imageMeta.getAxisIndex(Axes.X);
            int yIndex = imageMeta.getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xIndex);
            int y = (int)bounds.min(yIndex);
            int w = (int)bounds.dimension(xIndex);
            int h = (int)bounds.dimension(yIndex);
            byte[] buf = (byte[])plane.getData();
            int compression = meta.getCompression();
            int bpp = imageMeta.getBitsPerPixel();
            int sizeX = (int)imageMeta.getAxisLength(Axes.X);
            int sizeY = (int)imageMeta.getAxisLength(Axes.Y);
            int sizeC = (int)imageMeta.getAxisLength(Axes.CHANNEL);
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, bounds);
            if (compression != 0 && this.getHandle().length() < FormatTools.getPlaneSize(this, imageIndex)) {
                throw new UnsupportedCompressionException(compression + " not supported");
            }
            int rowsToSkip = meta.isInvertY() ? y : sizeY - (h + y);
            int rowLength = sizeX * (imageMeta.isIndexed() ? 1 : sizeC);
            this.getHandle().seek(meta.getGlobal() + (long)(rowsToSkip * rowLength));
            int pad = rowLength * bpp / 8 % 2;
            pad = pad == 0 ? rowLength * bpp / 8 % 4 : (pad *= sizeC);
            int planeSize = sizeX * sizeC * h;
            planeSize = bpp >= 8 ? (planeSize *= bpp / 8) : (planeSize /= 8 / bpp);
            if ((long)(planeSize += pad * h) + this.getHandle().offset() > this.getHandle().length()) {
                if ((long)((planeSize -= pad * h) + sizeY) + this.getHandle().offset() <= this.getHandle().length()) {
                    pad = 1;
                    planeSize += h;
                } else {
                    pad = 0;
                }
            }
            this.getHandle().skipBytes(rowsToSkip * pad);
            byte[] rawPlane = new byte[planeSize];
            this.getHandle().read(rawPlane);
            BitBuffer bb = new BitBuffer(rawPlane);
            ColorTable palette = meta.getColorTable(0, 0L);
            plane.setColorTable(palette);
            int effectiveC = palette != null && palette.getLength() > 0 ? 1 : sizeC;
            for (int row = h - 1; row >= 0; --row) {
                int rowIndex = meta.isInvertY() ? h - 1 - row : row;
                bb.skipBits(x * bpp * effectiveC);
                for (int i = 0; i < w * effectiveC; ++i) {
                    if (bpp <= 8) {
                        buf[rowIndex * w * effectiveC + i] = (byte)(bb.getBits(bpp) & 0xFF);
                        continue;
                    }
                    for (int b = 0; b < bpp / 8; ++b) {
                        buf[bpp / 8 * (rowIndex * w * effectiveC + i) + b] = (byte)(bb.getBits(8) & 0xFF);
                    }
                }
                if (row <= 0) continue;
                bb.skipBits((sizeX - w - x) * bpp * effectiveC + pad * 8);
            }
            if (imageMeta.getAxisLength(Axes.CHANNEL) > 1L) {
                ImageTools.bgrToRgb(buf, imageMeta.getInterleavedAxisCount() > 0, 1, (int)imageMeta.getAxisLength(Axes.CHANNEL));
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            MetaTable globalTable = meta.getTable();
            stream.setOrder(DataHandle.ByteOrder.LITTLE_ENDIAN);
            globalTable.put("Magic identifier", this.getSource().readString(2));
            globalTable.put("File size (in bytes)", this.getSource().readInt());
            this.getSource().skipBytes(4);
            meta.setGlobal(this.getSource().readInt());
            this.getSource().skipBytes(4);
            int sizeX = 0;
            int sizeY = 0;
            sizeX = this.getSource().readInt();
            sizeY = this.getSource().readInt();
            iMeta.addAxis(Axes.X, (long)sizeX);
            iMeta.addAxis(Axes.Y, (long)sizeY);
            if (sizeX < 1) {
                this.log().trace((Object)("Invalid width: " + sizeX + "; using the absolute value"));
                sizeX = Math.abs(sizeX);
            }
            if (sizeY < 1) {
                this.log().trace((Object)("Invalid height: " + sizeY + "; using the absolute value"));
                sizeY = Math.abs(sizeY);
                meta.setInvertY(true);
            }
            globalTable.put("Color planes", this.getSource().readShort());
            short bpp = this.getSource().readShort();
            iMeta.setBitsPerPixel(bpp);
            meta.setCompression(this.getSource().readInt());
            this.getSource().skipBytes(4);
            int pixelSizeX = this.getSource().readInt();
            int pixelSizeY = this.getSource().readInt();
            int nColors = this.getSource().readInt();
            if (nColors == 0 && bpp != 32 && bpp != 24) {
                nColors = bpp < 8 ? 1 << bpp : 256;
            }
            this.getSource().skipBytes(4);
            if (nColors != 0 && bpp == 8) {
                byte[][] palette = new byte[3][256];
                for (int i = 0; i < nColors; ++i) {
                    for (int j = palette.length - 1; j >= 0; --j) {
                        palette[j][i] = this.getSource().readByte();
                    }
                    this.getSource().skipBytes(1);
                }
                meta.palette = new ColorTable8(palette);
            } else if (nColors != 0) {
                this.getSource().skipBytes(nColors * 4);
            }
            if (config.parserGetLevel() != MetadataLevel.MINIMUM) {
                globalTable.put("Indexed color", meta.getColorTable(0, 0L) != null);
                globalTable.put("Image width", sizeX);
                globalTable.put("Image height", sizeY);
                globalTable.put("Bits per pixel", bpp);
                String comp = "invalid";
                switch (meta.getCompression()) {
                    case 0: {
                        comp = "None";
                        break;
                    }
                    case 1: {
                        comp = "8 bit run length encoding";
                        break;
                    }
                    case 2: {
                        comp = "4 bit run length encoding";
                        break;
                    }
                    case 3: {
                        comp = "RGB bitmap with mask";
                    }
                }
                globalTable.put("Compression type", comp);
                globalTable.put("X resolution", pixelSizeX);
                globalTable.put("Y resolution", pixelSizeY);
            }
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            int blockLen = 2;
            if (!FormatTools.validStream(stream, 2, false)) {
                return false;
            }
            return stream.readString(2).startsWith(BMPFormat.BMP_MAGIC_STRING);
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        private ColorTable8 palette;
        private int compression;
        private long global;
        private boolean invertY = false;

        public int getCompression() {
            return this.compression;
        }

        public void setCompression(int compression) {
            this.compression = compression;
        }

        public long getGlobal() {
            return this.global;
        }

        public void setGlobal(long global) {
            this.global = global;
        }

        public boolean isInvertY() {
            return this.invertY;
        }

        public void setInvertY(boolean invertY) {
            this.invertY = invertY;
        }

        @Override
        public void populateImageMetadata() {
            int sizeC;
            this.log().info((Object)"Populating metadata");
            int bpp = this.get(0).getBitsPerPixel();
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisTypes(Axes.X, Axes.Y);
            iMeta.setPlanarAxisCount(2);
            int n = sizeC = bpp != 24 ? 1 : 3;
            if (bpp == 32) {
                sizeC = 4;
            }
            if (bpp > 8) {
                bpp /= sizeC;
            }
            iMeta.setBitsPerPixel(bpp);
            switch (bpp) {
                case 16: {
                    iMeta.setPixelType(3);
                    break;
                }
                case 32: {
                    iMeta.setPixelType(5);
                    break;
                }
                default: {
                    iMeta.setPixelType(1);
                }
            }
            iMeta.setLittleEndian(true);
            iMeta.setMetadataComplete(true);
            iMeta.setIndexed(this.getColorTable(0, 0L) != null);
            if (iMeta.isIndexed()) {
                sizeC = 1;
            }
            if (sizeC > 1 || iMeta.isIndexed()) {
                iMeta.addAxis(Axes.CHANNEL, (long)sizeC);
                if (sizeC > 1) {
                    iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
                }
                iMeta.setPlanarAxisCount(3);
            }
            iMeta.setFalseColor(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.compression = 0;
                this.global = 0L;
                this.palette = null;
                this.invertY = false;
            }
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            return this.palette;
        }
    }
}

