/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LongMappedAccess;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.MappedObject;

public class LabelMultisetEntry
extends MappedObject<LabelMultisetEntry, LongMappedAccess>
implements LabelMultisetType.Entry<Label> {
    public static final LabelMultisetEntry type = new LabelMultisetEntry();
    protected static final int SUPERVOXEL_ID_OFFSET = 0;
    protected static final int COUNT_OFFSET = 8;
    protected static final int SIZE_IN_BYTES = 12;
    public Label id = () -> this.getId();

    public LabelMultisetEntry() {
        super(LongMappedAccessData.factory.createStorage(12L).createAccess(), LongMappedAccessData.factory);
    }

    public LabelMultisetEntry(long superVoxelId, int numOccurrences) {
        this();
        this.setId(superVoxelId);
        this.setCount(numOccurrences);
    }

    protected LabelMultisetEntry(LongMappedAccess access) {
        super(access, LongMappedAccessData.factory);
    }

    @Override
    public Label getElement() {
        return this.id;
    }

    public long getId() {
        return ((LongMappedAccess)this.access).getLong(0);
    }

    @Override
    public int getCount() {
        return ((LongMappedAccess)this.access).getInt(8);
    }

    @Override
    public int getSizeInBytes() {
        return 12;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LabelMultisetEntry)) {
            return false;
        }
        LabelMultisetEntry svo = (LabelMultisetEntry)obj;
        return svo.getId() == this.getId() && svo.getCount() == this.getCount();
    }

    @Override
    public int hashCode() {
        return 31 * Long.hashCode(this.getId()) + Integer.hashCode(this.getCount());
    }

    public String toString() {
        return this.id.id() + " x " + this.getCount();
    }

    @Override
    protected LabelMultisetEntry createRef() {
        return new LabelMultisetEntry(new LongMappedAccess(null, 0L));
    }

    public void setId(long id) {
        ((LongMappedAccess)this.access).putLong(id, 0);
    }

    public void setCount(int count) {
        ((LongMappedAccess)this.access).putInt(count, 8);
    }
}

