/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.CellRendererPane;

public class mxHtmlTextShape
implements mxITextShape {
    protected boolean replaceHtmlLinefeeds = true;

    public boolean isReplaceHtmlLinefeeds() {
        return this.replaceHtmlLinefeeds;
    }

    public void setReplaceHtmlLinefeeds(boolean value) {
        this.replaceHtmlLinefeeds = value;
    }

    protected String createHtmlDocument(Map<String, Object> style, String text, int w, int h) {
        String overflow = mxUtils.getString(style, mxConstants.STYLE_OVERFLOW, "");
        if (overflow.equals("fill")) {
            return mxUtils.createHtmlDocument(style, text, 1.0, w, null, "height:" + h + "pt;");
        }
        if (overflow.equals("width")) {
            return mxUtils.createHtmlDocument(style, text, 1.0, w);
        }
        return mxUtils.createHtmlDocument(style, text);
    }

    @Override
    public void paintShape(mxGraphics2DCanvas canvas, String text, mxCellState state, Map<String, Object> style) {
        mxLightweightLabel textRenderer = mxLightweightLabel.getSharedInstance();
        CellRendererPane rendererPane = canvas.getRendererPane();
        Rectangle rect = state.getLabelBounds().getRectangle();
        Graphics2D g = canvas.getGraphics();
        if (textRenderer != null && rendererPane != null && (g.getClipBounds() == null || g.getClipBounds().intersects(rect))) {
            double scale = canvas.getScale();
            int x = rect.x;
            int y = rect.y;
            int w = rect.width;
            int h = rect.height;
            if (!mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                g.rotate(-1.5707963267948966, x + w / 2, y + h / 2);
                g.translate(w / 2 - h / 2, h / 2 - w / 2);
                int tmp = w;
                w = h;
                h = tmp;
            }
            if (this.isReplaceHtmlLinefeeds()) {
                text = text.replaceAll("\n", "<br>");
            }
            textRenderer.setText(this.createHtmlDocument(style, text, (int)Math.round((double)w / state.getView().getScale()), (int)Math.round((double)h / state.getView().getScale())));
            textRenderer.setFont(mxUtils.getFont(style, canvas.getScale()));
            g.scale(scale, scale);
            rendererPane.paintComponent(g, textRenderer, rendererPane, (int)((double)x / scale) + mxConstants.LABEL_INSET, (int)((double)y / scale) + mxConstants.LABEL_INSET, (int)((double)w / scale), (int)((double)h / scale), true);
        }
    }
}

