/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.Map;
import org.scijava.Context;
import org.scijava.log.LogLevel;
import org.scijava.log.LogMessage;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;

public class LogFormatter {
    private final String prefKey;
    @Parameter(required=false)
    private PrefService prefService;
    private EnumSet<Field> visibleFields = EnumSet.of(Field.TIME, Field.LEVEL, Field.SOURCE, Field.MESSAGE, Field.THROWABLE);

    public LogFormatter(Context context, String prefKey) {
        context.inject((Object)this);
        this.prefKey = prefKey;
        this.applySettings();
    }

    public boolean isVisible(Field field) {
        return this.visibleFields.contains((Object)field);
    }

    public void setVisible(Field field, boolean visible) {
        EnumSet<Field> copy = EnumSet.copyOf(this.visibleFields);
        if (visible) {
            copy.add(field);
        } else {
            copy.remove((Object)field);
        }
        this.visibleFields = copy;
        this.changeSetting(field, visible);
    }

    public String format(LogMessage message) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter printer = new PrintWriter(sw);
            if (this.isVisible(Field.TIME)) {
                this.printWithBrackets(printer, message.time().toString());
            }
            if (this.isVisible(Field.LEVEL)) {
                this.printWithBrackets(printer, LogLevel.prefix((int)message.level()));
            }
            if (this.isVisible(Field.SOURCE)) {
                this.printWithBrackets(printer, message.source().toString());
            }
            if (this.isVisible(Field.ATTACHMENT)) {
                printer.print(message.attachments());
                printer.print(" ");
            }
            if (this.isVisible(Field.MESSAGE)) {
                printer.println(message.text());
            }
            if (this.isVisible(Field.THROWABLE) && message.throwable() != null) {
                message.throwable().printStackTrace(printer);
            }
            return sw.toString();
        }
        catch (Exception e) {
            return "[Exception while formatting log message: " + e + "]\n";
        }
    }

    private void printWithBrackets(PrintWriter printer, String prefix) {
        printer.append('[').append(prefix).append("] ");
    }

    public void applySettings() {
        if (this.skipPersist()) {
            return;
        }
        Map settings = this.prefService.getMap(LogFormatter.class, this.prefKey);
        for (Field field : Field.values()) {
            String defaultValue = Boolean.toString(this.isVisible(field));
            String value = settings.getOrDefault(field.toString(), defaultValue);
            this.setVisible(field, Boolean.valueOf(value));
        }
        this.visibleFields.toString();
    }

    public void changeSetting(Field field, boolean visible) {
        if (this.skipPersist()) {
            return;
        }
        Map settings = this.prefService.getMap(LogFormatter.class, this.prefKey);
        settings.put(field.toString(), Boolean.toString(visible));
        this.prefService.put(LogFormatter.class, this.prefKey, settings);
    }

    private boolean skipPersist() {
        return this.prefService == null || this.prefKey == null || this.prefKey.isEmpty();
    }

    public static enum Field {
        TIME,
        LEVEL,
        SOURCE,
        MESSAGE,
        THROWABLE,
        ATTACHMENT;

    }
}

