/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.BigDataViewer;
import bdv.export.ProgressWriter;
import bdv.ij.util.ProgressWriterIJ;
import bdv.viewer.ViewerOptions;
import com.google.gson.stream.JsonReader;
import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import mpicbg.spim.data.SpimDataException;
import org.apache.commons.lang.StringUtils;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Browse BigDataServer")
public class BigDataBrowserPlugIn
implements Command {
    private final Map<String, ImageIcon> imageMap = new HashMap<String, ImageIcon>();
    private final Map<String, String> datasetUrlMap = new HashMap<String, String>();
    public static String serverUrl = "http://";

    public void run() {
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResourceAsStream("/fiji.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object remoteUrl = JOptionPane.showInputDialog(null, "Enter BigDataServer Remote URL:", "BigDataServer", 3, new ImageIcon(image), null, serverUrl);
        if (remoteUrl == null) {
            return;
        }
        serverUrl = remoteUrl.toString();
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            this.getDatasetList(serverUrl, nameList);
        }
        catch (IOException e) {
            IJ.showMessage((String)("Error connecting to server at " + serverUrl));
            e.printStackTrace();
        }
        this.createDatasetListUI(serverUrl, nameList.toArray());
    }

    private boolean getDatasetList(String remoteUrl, ArrayList<String> nameList) throws IOException {
        URL url = new URL(remoteUrl + "/json/");
        InputStream is = url.openStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));
        reader.beginObject();
        while (reader.hasNext()) {
            reader.nextName();
            reader.beginObject();
            String id = null;
            String description = null;
            String thumbnailUrl = null;
            String datasetUrl = null;
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("id")) {
                    id = reader.nextString();
                    continue;
                }
                if (name.equals("description")) {
                    description = reader.nextString();
                    continue;
                }
                if (name.equals("thumbnailUrl")) {
                    thumbnailUrl = reader.nextString();
                    continue;
                }
                if (name.equals("datasetUrl")) {
                    datasetUrl = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            if (id != null) {
                nameList.add(id);
                if (thumbnailUrl != null && StringUtils.isNotEmpty(thumbnailUrl)) {
                    this.imageMap.put(id, new ImageIcon(new URL(thumbnailUrl)));
                }
                if (datasetUrl != null) {
                    this.datasetUrlMap.put(id, datasetUrl);
                }
            }
            reader.endObject();
        }
        reader.endObject();
        reader.close();
        return true;
    }

    private void createDatasetListUI(String remoteUrl, Object[] values) {
        JList<Object> list = new JList<Object>(values);
        list.setCellRenderer(new ThumbnailListRenderer());
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    String key = String.valueOf(list.getModel().getElementAt(index));
                    System.out.println(key);
                    try {
                        String filename = (String)BigDataBrowserPlugIn.this.datasetUrlMap.get(key);
                        String title = new File(filename).getName();
                        BigDataViewer.open((String)filename, (String)title, (ProgressWriter)new ProgressWriterIJ(), (ViewerOptions)ViewerOptions.options());
                    }
                    catch (SpimDataException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(list);
        scroll.setPreferredSize(new Dimension(600, 800));
        JFrame frame = new JFrame();
        frame.setTitle("BigDataServer Browser - " + remoteUrl);
        frame.add(scroll);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        new BigDataBrowserPlugIn().run();
    }

    public class ThumbnailListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        Font font = new Font("helvetica", 1, 12);

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setIcon((Icon)BigDataBrowserPlugIn.this.imageMap.get(value));
            label.setHorizontalTextPosition(4);
            label.setFont(this.font);
            return label;
        }
    }
}

