/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import fiji.plugin.Bead_Registration;
import fiji.stacks.Hyperstack_rearranger;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.InterpolatedAffineModel2D;
import mpicbg.models.InterpolatedAffineModel3D;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.Model;
import mpicbg.models.RigidModel2D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.SimilarityModel3D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import mpicbg.spim.segmentation.InteractiveDoG;
import plugin.DescriptorParameters;
import plugin.Descriptor_based_registration;
import process.Matching;
import process.OverlayFusion;

public class Descriptor_based_series_registration
implements PlugIn {
    protected static final String myURL = "http://preibischlab.mdc-berlin.de";
    protected static final String paperURL = "http://www.nature.com/nmeth/journal/v7/n6/full/nmeth0610-418.html";
    public static int defaultImg = 0;
    public static boolean defaultReApply = false;
    public static ArrayList<InvertibleBoundable> lastModels = null;
    public static int lastDimensionality = Integer.MAX_VALUE;
    public static float[] offset = null;
    public static boolean oneModelPerChannel = false;
    public String[] transformationModels2d = new String[]{"Translation (2d)", "Rigid (2d)", "Similarity (2d)", "Affine (2d)", "Homography (2d)"};
    public String[] transformationModels3d = new String[]{"Translation (3d)", "Rigid (3d)", "Similarity (3d)", "Affine (3d)"};
    public static String[] localizationChoice = new String[]{"None", "3-dimensional quadratic fit", "Gaussian mask localization fit"};
    public static int defaultTransformationModel = 1;
    public static int defaultLocalization = 1;
    public static int defaultRegularizationTransformationModel = 1;
    public static double defaultLambda = 0.1;
    public static boolean defaultFixFirstTile = false;
    public static boolean defaultRegularize = false;
    public static String[] detectionBrightness = new String[]{"Very low", "Low", "Medium", "Strong", "Advanced ...", "Interactive ..."};
    public static int defaultDetectionBrightness = detectionBrightness.length - 1;
    public static double defaultSigma = 2.0;
    public static double defaultThreshold = 0.03;
    public static String[] detectionSize = new String[]{"2 px", "3 px", "4 px", "5 px", "6 px", "7 px", "8 px", "9 px", "10 px", "Advanced ...", "Interactive ..."};
    public static int defaultDetectionSize = detectionSize.length - 1;
    public static String[] detectionTypes = new String[]{"Maxima only", "Minima only", "Minima & Maxima", "Interactive ..."};
    public static int defaultDetectionType = detectionTypes.length - 1;
    public static boolean defaultSimilarOrientation = false;
    public static int defaultNumNeighbors = 3;
    public static int defaultRedundancy = 1;
    public static double defaultSignificance = 3.0;
    public static double defaultRansacThreshold = 5.0;
    public static String[] globalOptTypes = new String[]{"All-to-all matching (global optimization)", "All-to-all matching with range ('reasonable' global optimization)", "All against first image (no global optimization)", "Consecutive matching of images (no global optimization)"};
    public static int defaultGlobalOpt = 1;
    public static int defaultRange = 5;
    public static int defaultChannel = 1;
    public static String[] resultChoices = new String[]{"Fuse and display", "Write to disk", "Do not fuse"};
    public static int defaultResult = 0;
    public static String[] interpolationChoices = new String[]{"Linear Interpolation", "Nearest Neighbor Interpolation"};
    public static int defaultInterpolation = 0;
    public static String defaultDirectory = "";
    public static double defaultSigmaX = 2.0;
    public static double defaultSigmaY = 2.0;
    public static double defaultSigmaZ = 2.0;
    public static int defaultSupportX = 11;
    public static int defaultSupportY = 11;
    public static int defaultSupportZ = 11;
    public static int defaultIterations = 10;

    public void run(String arg0) {
        int[] idList = WindowManager.getIDList();
        if (idList == null || idList.length < 1) {
            IJ.error((String)"You need at least one open image.");
            return;
        }
        String[] imgList = new String[idList.length];
        for (int i = 0; i < idList.length; ++i) {
            imgList[i] = WindowManager.getImage((int)idList[i]).getTitle();
        }
        if (defaultImg >= imgList.length) {
            defaultImg = 0;
        }
        GenericDialog gd = new GenericDialog("Descriptor based registration");
        gd.addChoice("Series_of_images", imgList, imgList[defaultImg]);
        if (lastModels != null) {
            gd.addCheckbox("Reapply last models", defaultReApply);
        }
        gd.addMessage("Warning: if images are of RGB or 8-bit color they will be converted to hyperstacks.");
        gd.addMessage("Please note that the SPIM Registration is based on a publication.\nIf you use it successfully for your research please be so kind to cite our work:\nPreibisch et al., Nature Methods (2010), 7(6):418-419\n");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        Bead_Registration.addHyperLinkListener((MultiLineLabel)text, (String)paperURL);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        defaultImg = gd.getNextChoiceIndex();
        ImagePlus imp = WindowManager.getImage((int)idList[defaultImg]);
        boolean reApply = false;
        if (lastModels != null) {
            defaultReApply = reApply = gd.getNextBoolean();
        }
        if ((imp = Hyperstack_rearranger.convertToHyperStack((ImagePlus)imp)).getNSlices() == 1 && imp.getNFrames() == 1) {
            IJ.log((String)"The image has only one slice/frame, cannot perform stack registration");
            return;
        }
        int dimensionality = imp.getNSlices() > 1 && imp.getNFrames() > 1 ? 3 : 2;
        if (dimensionality == 2 && imp.getNSlices() > 1) {
            imp = OverlayFusion.switchZTinXYCZT(imp);
        }
        if (reApply) {
            if (lastModels.size() == imp.getNChannels() && imp.getNFrames() != imp.getNChannels()) {
                IJ.log((String)"WARNING: Assuming that there is one model per channel.");
                oneModelPerChannel = true;
            } else {
                if (lastModels.size() < imp.getNFrames()) {
                    IJ.log((String)("Cannot reapply, you have only " + lastModels.size() + " models, but the series size is" + imp.getNFrames() + "."));
                    defaultReApply = false;
                    return;
                }
                if (lastModels.size() > imp.getNFrames()) {
                    IJ.log((String)("WARNING: you have " + lastModels.size() + " models, but the series size is only" + imp.getNFrames() + "."));
                } else {
                    if (dimensionality < lastDimensionality) {
                        IJ.log((String)("Cannot reapply, cannot apply " + lastModels.get(0).getClass().getSimpleName() + " to " + dimensionality + " data."));
                        defaultReApply = false;
                        return;
                    }
                    if (dimensionality > lastDimensionality) {
                        IJ.log((String)("WARNING: applying " + lastModels.get(0).getClass().getSimpleName() + " to " + dimensionality + " data."));
                    }
                }
            }
            GenericDialog gd2 = new GenericDialog("Descriptor based stack registration");
            gd2.addChoice("Image fusion", resultChoices, resultChoices[defaultResult]);
            gd2.addChoice("Interpolation", interpolationChoices, interpolationChoices[defaultInterpolation]);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return;
            }
            int result = defaultResult = gd2.getNextChoiceIndex();
            int interpolation = defaultInterpolation = gd2.getNextChoiceIndex();
            if (defaultResult == 1) {
                GenericDialogPlus gd3 = new GenericDialogPlus("Select output directory");
                gd3.addDirectoryField("Output_directory", defaultDirectory, 60);
                gd3.showDialog();
                if (gd3.wasCanceled()) {
                    return;
                }
                defaultDirectory = gd3.getNextString();
            }
            DescriptorParameters params = new DescriptorParameters();
            params.reApply = true;
            params.dimensionality = dimensionality;
            params.fuse = result;
            params.interpolation = interpolation;
            params.directory = defaultDirectory;
            Matching.descriptorBasedStackRegistration(imp, params);
            return;
        }
        DescriptorParameters params = this.getParameters(imp, dimensionality);
        if (params == null) {
            return;
        }
        Matching.descriptorBasedStackRegistration(imp, params);
    }

    protected DescriptorParameters getParameters(ImagePlus imp, int dimensionality) {
        double[] values;
        String[] transformationModel;
        String[] stringArray = transformationModel = dimensionality == 2 ? this.transformationModels2d : this.transformationModels3d;
        if (defaultTransformationModel >= transformationModel.length) {
            defaultTransformationModel = 1;
        }
        if (defaultRegularizationTransformationModel >= transformationModel.length) {
            defaultRegularizationTransformationModel = 1;
        }
        if (defaultDetectionBrightness == detectionBrightness.length - 1 || defaultDetectionSize == detectionSize.length - 1 || defaultDetectionType == detectionTypes.length - 1) {
            defaultDetectionBrightness = detectionBrightness.length - 1;
            defaultDetectionSize = detectionSize.length - 1;
            defaultDetectionType = detectionTypes.length - 1;
        }
        GenericDialog gd = new GenericDialog("Descriptor based stack registration");
        gd.addChoice("Brightness_of detections", detectionBrightness, detectionBrightness[defaultDetectionBrightness]);
        gd.addChoice("Approximate_size of detections", detectionSize, detectionSize[defaultDetectionSize]);
        gd.addChoice("Type_of_detections", detectionTypes, detectionTypes[defaultDetectionType]);
        gd.addChoice("Subpixel_Localization", localizationChoice, localizationChoice[defaultLocalization]);
        gd.addChoice("Transformation_model", transformationModel, transformationModel[defaultTransformationModel]);
        gd.addCheckbox("Regularize_model", defaultRegularize);
        gd.addCheckbox("Images_are_roughly_aligned", defaultSimilarOrientation);
        if (dimensionality == 2) {
            if (defaultNumNeighbors < 2) {
                defaultNumNeighbors = 2;
            }
            gd.addSlider("Number_of_neighbors for the descriptors", 2.0, 10.0, (double)defaultNumNeighbors);
        } else {
            if (defaultNumNeighbors < 3) {
                defaultNumNeighbors = 3;
            }
            gd.addSlider("Number_of_neighbors for the descriptors", 3.0, 10.0, (double)defaultNumNeighbors);
        }
        gd.addSlider("Redundancy for descriptor matching", 0.0, 10.0, (double)defaultRedundancy);
        gd.addSlider("Significance required for a descriptor match", 1.0, 10.0, defaultSignificance);
        gd.addSlider("Allowed_error_for_RANSAC (px)", 0.5, 20.0, defaultRansacThreshold);
        gd.addChoice("Global_optimization", globalOptTypes, globalOptTypes[defaultGlobalOpt]);
        gd.addSlider("Range for all-to-all matching", 2.0, 10.0, (double)defaultRange);
        int numChannels = imp.getNChannels();
        if (defaultChannel > numChannels) {
            defaultChannel = 1;
        }
        gd.addSlider("Choose_registration_channel", 1.0, (double)numChannels, (double)defaultChannel);
        gd.addMessage("");
        gd.addChoice("Image fusion", resultChoices, resultChoices[defaultResult]);
        gd.addChoice("Interpolation", interpolationChoices, interpolationChoices[defaultInterpolation]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://preibischlab.mdc-berlin.de");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        Bead_Registration.addHyperLinkListener((MultiLineLabel)text, (String)myURL);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        DescriptorParameters params = new DescriptorParameters();
        params.roi1 = imp.getRoi();
        int detectionBrightnessIndex = gd.getNextChoiceIndex();
        int detectionSizeIndex = gd.getNextChoiceIndex();
        int detectionTypeIndex = gd.getNextChoiceIndex();
        int localization = gd.getNextChoiceIndex();
        int transformationModelIndex = gd.getNextChoiceIndex();
        boolean regularize = gd.getNextBoolean();
        boolean similarOrientation = gd.getNextBoolean();
        int numNeighbors = (int)Math.round(gd.getNextNumber());
        int redundancy = (int)Math.round(gd.getNextNumber());
        double significance = gd.getNextNumber();
        double ransacThreshold = gd.getNextNumber();
        int globalOptIndex = gd.getNextChoiceIndex();
        int range = (int)Math.round(gd.getNextNumber());
        int channel = (int)Math.round(gd.getNextNumber()) - 1;
        int result = gd.getNextChoiceIndex();
        int interpolation = gd.getNextChoiceIndex();
        defaultDetectionBrightness = detectionBrightnessIndex;
        defaultDetectionSize = detectionSizeIndex;
        defaultDetectionType = detectionTypeIndex;
        defaultLocalization = localization;
        defaultTransformationModel = transformationModelIndex;
        defaultRegularize = regularize;
        defaultSimilarOrientation = similarOrientation;
        defaultNumNeighbors = numNeighbors;
        defaultRedundancy = redundancy;
        defaultSignificance = significance;
        defaultRansacThreshold = ransacThreshold;
        defaultGlobalOpt = globalOptIndex;
        defaultRange = range;
        defaultChannel = channel + 1;
        defaultResult = result;
        defaultInterpolation = interpolation;
        if (dimensionality == 2) {
            switch (transformationModelIndex) {
                case 0: {
                    params.model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    params.model = new RigidModel2D();
                    break;
                }
                case 2: {
                    params.model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    params.model = new AffineModel2D();
                    break;
                }
                case 4: {
                    if (regularize) {
                        IJ.log((String)"HomographyModel2D cannot be regularized yet");
                        return null;
                    }
                    params.model = new HomographyModel2D();
                    break;
                }
                default: {
                    params.model = new RigidModel2D();
                    break;
                }
            }
        } else {
            switch (transformationModelIndex) {
                case 0: {
                    params.model = new TranslationModel3D();
                    break;
                }
                case 1: {
                    params.model = new RigidModel3D();
                    break;
                }
                case 2: {
                    params.model = new SimilarityModel3D();
                    break;
                }
                case 3: {
                    params.model = new AffineModel3D();
                    break;
                }
                default: {
                    params.model = new RigidModel3D();
                }
            }
        }
        if (regularize) {
            GenericDialog gdRegularize = new GenericDialog("Choose Regularization Model");
            gdRegularize.addChoice("Transformation_model", transformationModel, transformationModel[defaultRegularizationTransformationModel]);
            gdRegularize.addCheckbox("Fix_first_tile", defaultFixFirstTile);
            gdRegularize.addNumericField("Lambda", defaultLambda, 2);
            gdRegularize.showDialog();
            if (gdRegularize.wasCanceled()) {
                return null;
            }
            params.regularize = true;
            int modelIndex = defaultRegularizationTransformationModel = gdRegularize.getNextChoiceIndex();
            params.fixFirstTile = defaultFixFirstTile = gdRegularize.getNextBoolean();
            params.lambda = defaultLambda = gdRegularize.getNextNumber();
            if (dimensionality == 2) {
                switch (modelIndex) {
                    case 0: {
                        params.model = new InterpolatedAffineModel2D(params.model, (Model)new TranslationModel2D(), (double)((float)params.lambda));
                        break;
                    }
                    case 1: {
                        params.model = new InterpolatedAffineModel2D(params.model, (Model)new RigidModel2D(), (double)((float)params.lambda));
                        break;
                    }
                    case 2: {
                        params.model = new InterpolatedAffineModel2D(params.model, (Model)new SimilarityModel2D(), (double)((float)params.lambda));
                        break;
                    }
                    case 3: {
                        params.model = new InterpolatedAffineModel2D(params.model, (Model)new AffineModel2D(), (double)((float)params.lambda));
                        break;
                    }
                    case 4: {
                        IJ.log((String)"HomographyModel2D cannot be used for regularization yet");
                        return null;
                    }
                    default: {
                        params.model = new InterpolatedAffineModel2D(params.model, (Model)new RigidModel2D(), (double)((float)params.lambda));
                        break;
                    }
                }
            } else {
                switch (modelIndex) {
                    case 0: {
                        params.model = new InterpolatedAffineModel3D(params.model, (Model)new TranslationModel3D(), (double)((float)params.lambda));
                        break;
                    }
                    case 1: {
                        params.model = new InterpolatedAffineModel3D(params.model, (Model)new RigidModel3D(), (double)((float)params.lambda));
                        break;
                    }
                    case 2: {
                        params.model = new InterpolatedAffineModel3D(params.model, (Model)new SimilarityModel3D(), (double)((float)params.lambda));
                        break;
                    }
                    case 3: {
                        params.model = new InterpolatedAffineModel3D(params.model, (Model)new AffineModel3D(), (double)((float)params.lambda));
                        break;
                    }
                    default: {
                        params.model = new InterpolatedAffineModel3D(params.model, (Model)new RigidModel3D(), (double)((float)params.lambda));
                    }
                }
            }
        } else {
            params.regularize = false;
            params.fixFirstTile = true;
        }
        if (defaultResult == 1) {
            GenericDialogPlus gd2 = new GenericDialogPlus("Select output directory");
            gd2.addDirectoryField("Output_directory", defaultDirectory, 60);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return null;
            }
            defaultDirectory = gd2.getNextString();
        }
        if (detectionBrightnessIndex == detectionBrightness.length - 1 || detectionSizeIndex == detectionSize.length - 1 || detectionTypeIndex == detectionTypes.length - 1) {
            ImagePlus interactiveTmp;
            values = new double[]{defaultSigma, defaultThreshold};
            if (dimensionality == 2) {
                interactiveTmp = new ImagePlus("First slice of " + imp.getTitle(), imp.getStack().getProcessor(imp.getStackIndex(channel + 1, 1, 1)));
            } else {
                ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
                for (int s = 1; s <= imp.getNSlices(); ++s) {
                    stack.addSlice("", imp.getStack().getProcessor(imp.getStackIndex(channel + 1, s, 1)));
                }
                interactiveTmp = new ImagePlus("First series of " + imp.getTitle(), stack);
            }
            interactiveTmp.show();
            InteractiveDoG idog = Descriptor_based_registration.getInteractiveDoGParameters(interactiveTmp, 1, values, 20.0f);
            interactiveTmp.close();
            if (idog.wasCanceled()) {
                return null;
            }
            params.sigma1 = values[0];
            params.threshold = values[1];
            params.lookForMaxima = idog.getLookForMaxima();
            params.lookForMinima = idog.getLookForMinima();
        } else {
            if (detectionBrightnessIndex == detectionBrightness.length - 2 || detectionSizeIndex == detectionSize.length - 2) {
                values = Descriptor_based_registration.getAdvancedDoGParameters(defaultSigma, defaultThreshold);
                params.sigma1 = values[0];
                params.threshold = values[1];
            } else {
                if (detectionBrightnessIndex == 0) {
                    params.threshold = 0.001;
                } else if (detectionBrightnessIndex == 1) {
                    params.threshold = 0.008;
                } else if (detectionBrightnessIndex == 2) {
                    params.threshold = 0.03;
                } else if (detectionBrightnessIndex == 3) {
                    params.threshold = 0.1;
                }
                params.sigma1 = ((double)detectionSizeIndex + 2.0) / 2.0;
            }
            if (detectionTypeIndex == 2) {
                params.lookForMaxima = true;
                params.lookForMinima = true;
            } else if (detectionTypeIndex == 1) {
                params.lookForMinima = true;
                params.lookForMaxima = false;
            } else {
                params.lookForMinima = false;
                params.lookForMaxima = true;
            }
        }
        if (localization == 2 && !Descriptor_based_series_registration.getGaussianParameters(dimensionality, params)) {
            return null;
        }
        defaultSigma = params.sigma1;
        defaultThreshold = params.threshold;
        defaultDetectionType = params.lookForMaxima && params.lookForMinima ? 2 : (params.lookForMinima ? 1 : 0);
        params.sigma2 = InteractiveDoG.computeSigma2((float)((float)params.sigma1), (int)InteractiveDoG.standardSensitivity);
        params.similarOrientation = similarOrientation;
        params.numNeighbors = numNeighbors;
        params.redundancy = redundancy;
        params.significance = significance;
        params.ransacThreshold = ransacThreshold;
        params.channel1 = channel;
        params.channel2 = -1;
        params.fuse = result;
        params.directory = defaultDirectory;
        params.setPointsRois = false;
        params.globalOpt = globalOptIndex;
        params.range = range;
        params.dimensionality = dimensionality;
        params.localization = localization;
        params.interpolation = interpolation;
        return params;
    }

    public static boolean getGaussianParameters(int dimensionality, DescriptorParameters params) {
        GenericDialog gdGauss = new GenericDialog("Define Gaussian Fit Parameters");
        gdGauss.addNumericField("Sigma_X [px units]", defaultSigmaX, 4);
        gdGauss.addNumericField("Sigma_Y [px units]", defaultSigmaY, 4);
        if (dimensionality == 3) {
            gdGauss.addNumericField("Sigma_Z [px units]", defaultSigmaZ, 4);
        }
        gdGauss.addMessage("");
        gdGauss.addNumericField("Support_region_size_for_fit_X [px]", (double)defaultSupportX, 0);
        gdGauss.addNumericField("Support_region_size_for_fit_Y [px]", (double)defaultSupportY, 0);
        if (dimensionality == 3) {
            gdGauss.addNumericField("Support_region_size_for_fit_Z [px]", (double)defaultSupportZ, 0);
        }
        gdGauss.addMessage("");
        gdGauss.addNumericField("Iterations", (double)defaultIterations, 0);
        gdGauss.showDialog();
        if (gdGauss.wasCanceled()) {
            return false;
        }
        params.sigma = new double[dimensionality];
        params.sigma[0] = defaultSigmaX = gdGauss.getNextNumber();
        params.sigma[1] = defaultSigmaY = gdGauss.getNextNumber();
        if (dimensionality == 3) {
            params.sigma[2] = defaultSigmaZ = gdGauss.getNextNumber();
        }
        params.region = new int[dimensionality];
        params.region[0] = defaultSupportX = (int)Math.round(gdGauss.getNextNumber());
        params.region[1] = defaultSupportY = (int)Math.round(gdGauss.getNextNumber());
        if (dimensionality == 3) {
            params.region[2] = defaultSupportZ = (int)Math.round(gdGauss.getNextNumber());
        }
        params.iterations = defaultIterations = (int)Math.round(gdGauss.getNextNumber());
        return true;
    }
}

