/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.models.Holder;

public class GuiUtils {
    private GuiUtils() {
    }

    public static JButton createActionIconButton(String name, Action action, String icon) {
        JButton button = new JButton(action);
        button.setText(name);
        if (icon.isEmpty()) {
            button.setIcon(GuiUtils.loadIcon(icon));
            button.setIconTextGap(5);
            button.setMargin(new Insets(button.getMargin().top, 3, button.getMargin().bottom, button.getMargin().right));
        }
        return button;
    }

    public static ImageIcon createIcon(Color color) {
        BufferedImage image = new BufferedImage(20, 10, 1);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.dispose();
        return new ImageIcon(image);
    }

    public static JPanel createCheckboxGroupedPanel(Holder<Boolean> visibility, String text, JComponent panel) {
        JPanel dark = new JPanel();
        dark.setLayout(new BorderLayout());
        JCheckBox checkbox = GuiUtils.createCheckbox(visibility, text);
        JPanel title = new JPanel();
        title.setBackground(new Color(200, 200, 200));
        title.setLayout((LayoutManager)new MigLayout("insets 4pt, gap 8pt, fillx", "10[][]10"));
        title.add((Component)new JLabel(checkbox.getText()), "push");
        checkbox.setText("");
        checkbox.setOpaque(false);
        title.add(checkbox);
        dark.setBackground(new Color(200, 200, 200));
        dark.add((Component)title, "First");
        dark.add((Component)panel, "Center");
        return dark;
    }

    private static JCheckBox createCheckbox(Holder<Boolean> visibility, String text) {
        LinkedCheckBox checkbox = new LinkedCheckBox(text, visibility);
        return GuiUtils.styleCheckboxUsingEye(checkbox);
    }

    public static JCheckBox styleCheckboxUsingEye(JCheckBox checkbox) {
        checkbox.setIcon(GuiUtils.loadIcon("invisible.png"));
        checkbox.setSelectedIcon(GuiUtils.loadIcon("visible.png"));
        checkbox.setPressedIcon(GuiUtils.loadIcon("visible-hover.png"));
        checkbox.setRolloverIcon(GuiUtils.loadIcon("invisible-hover.png"));
        checkbox.setRolloverSelectedIcon(GuiUtils.loadIcon("visible-hover.png"));
        checkbox.setFocusable(false);
        return checkbox;
    }

    public static MouseAdapter toMouseListener(final DragBehaviour behavior) {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                behavior.init(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                behavior.end(e.getX(), e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                behavior.drag(e.getX(), e.getY());
            }
        };
    }

    public static JButton createIconButton(Action action) {
        JButton result = new JButton(action);
        result.setText("");
        result.setBorder(BorderFactory.createEmptyBorder());
        result.setContentAreaFilled(false);
        result.setOpaque(false);
        return result;
    }

    public static RunnableAction createAction(String title, Runnable action, String iconPath) {
        RunnableAction result = new RunnableAction(title, action);
        ImageIcon icon = GuiUtils.loadIcon(iconPath);
        result.putValue("SmallIcon", icon);
        result.putValue("SwingLargeIconKey", icon);
        return result;
    }

    public static ImageIcon loadIcon(String iconPath) {
        return new ImageIcon(GuiUtils.class.getResource("/images/" + iconPath));
    }

    private static class LinkedCheckBox
    extends JCheckBox {
        private final Holder<Boolean> model;
        private final Runnable onModelChanged = this::onModelChanged;

        private LinkedCheckBox(String text, Holder<Boolean> model) {
            super(text);
            this.model = model;
            this.model.notifier().addWeakListener(this.onModelChanged);
            this.setSelected(model.get());
            this.addItemListener(this::onUserAction);
        }

        private void onUserAction(ItemEvent itemEvent) {
            this.model.set(this.isSelected());
        }

        private void onModelChanged() {
            this.setSelected(this.model.get());
        }
    }
}

