/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.scijava.plugins.scripteditor.jython.EmptyDotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public interface DotAutocompletions {
    public static final DotAutocompletions EMPTY = new EmptyDotAutocompletions();

    default public String getClassname() {
        return null;
    }

    default public String getSummary() {
        return null;
    }

    public List<CompletionText> get();

    default public Stream<CompletionText> getStream() {
        return this.get().stream();
    }

    public static List<CompletionText> getPublicFieldsAndMethods(String className) {
        ArrayList<CompletionText> ac = new ArrayList<CompletionText>();
        if (null != className) {
            try {
                Class<?> c = Class.forName(className);
                for (Field field : c.getFields()) {
                    ac.add(new CompletionText(field.getName(), c, field));
                }
                for (AccessibleObject accessibleObject : c.getMethods()) {
                    ac.add(new CompletionText(((Method)accessibleObject).getName() + "()", c, (Method)accessibleObject));
                }
            }
            catch (Exception e) {
                JythonDev.print("Could not load class " + className, e);
            }
        }
        return ac;
    }

    public static void staticFieldsAndStaticMethodsInto(Class<?> c, List<CompletionText> ac) {
        for (Field field : c.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            ac.add(new CompletionText(field.getName(), c, field));
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            ac.add(new CompletionText(((Method)accessibleObject).getName() + "()", c, (Method)accessibleObject));
        }
    }

    public static void fieldsAndMethodsInto(Class<?> c, List<CompletionText> ac) {
        for (Field field : c.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ac.add(new CompletionText(field.getName(), c, field));
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            ac.add(new CompletionText(((Method)accessibleObject).getName() + "()", c, (Method)accessibleObject));
        }
    }

    public static Stream<CompletionText> staticFieldsAndStaticMethodsStream(Class<?> c, boolean staticFields, boolean staticMethods) {
        return Stream.concat(Arrays.stream(c.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).map(f -> new CompletionText(f.getName(), c, f)), Arrays.stream(c.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).map(m -> new CompletionText(m.getName(), c, m)));
    }

    public static Stream<CompletionText> fieldsAndMethodsStream(Class<?> c, boolean staticFields, boolean staticMethods) {
        return Stream.concat(Arrays.stream(c.getFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> new CompletionText(f.getName(), c, f)), Arrays.stream(c.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(m -> new CompletionText(m.getName(), c, m)));
    }
}

