/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.awt;

import edu.mines.jtk.awt.ColorMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ColorMapTest
extends TestCase {
    private static float[][] _rgbhsl = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f}, {0.0f, 1.0f, 0.0f, 120.0f, 1.0f, 0.5f}, {0.0f, 0.0f, 1.0f, 240.0f, 1.0f, 0.5f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 60.0f, 1.0f, 0.5f}, {0.0f, 1.0f, 1.0f, 180.0f, 1.0f, 0.5f}, {1.0f, 0.0f, 1.0f, 300.0f, 1.0f, 0.5f}};
    private static float[][] _rgbcielab = new float[][]{{1.0f, 0.0f, 0.0f, 53.23f, 80.1f, 67.22f}, {0.0f, 1.0f, 0.0f, 87.73f, -86.18f, 83.18f}, {0.0f, 0.0f, 1.0f, 32.3f, 79.2f, -107.86f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f, 100.0f, 0.01f, -0.01f}, {1.0f, 1.0f, 0.0f, 97.14f, -21.56f, 94.48f}, {0.0f, 1.0f, 1.0f, 91.12f, -48.08f, -14.14f}, {1.0f, 0.0f, 1.0f, 60.32f, 98.25f, -60.84f}};

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ColorMap.class);
        TestRunner.run((Test)suite);
    }

    public void testRgbToHsl() {
        for (int i = 0; i < _rgbhsl.length; ++i) {
            float r = _rgbhsl[i][0];
            float g = _rgbhsl[i][1];
            float b = _rgbhsl[i][2];
            float h = _rgbhsl[i][3];
            float s = _rgbhsl[i][4];
            float l = _rgbhsl[i][5];
            float[] expected = new float[]{h, s, l};
            float[] test = ColorMap.rgbToHsl(r, g, b);
            ColorMapTest.assertEquals((float)expected[0], (float)test[0], (float)0.0f);
            ColorMapTest.assertEquals((float)expected[1], (float)test[1], (float)0.0f);
            ColorMapTest.assertEquals((float)expected[2], (float)test[2], (float)0.0f);
        }
    }

    public void testHslToRgb() {
        for (int i = 0; i < _rgbhsl.length; ++i) {
            float r = _rgbhsl[i][0];
            float g = _rgbhsl[i][1];
            float b = _rgbhsl[i][2];
            float h = _rgbhsl[i][3];
            float s = _rgbhsl[i][4];
            float l = _rgbhsl[i][5];
            float[] expected = new float[]{r, g, b};
            float[] test = ColorMap.hslToRgb(h, s, l);
            ColorMapTest.assertEquals((float)expected[0], (float)test[0], (float)0.0f);
            ColorMapTest.assertEquals((float)expected[1], (float)test[1], (float)0.0f);
            ColorMapTest.assertEquals((float)expected[2], (float)test[2], (float)0.0f);
        }
    }

    public void testRgbToCieLab() {
        for (int i = 0; i < _rgbcielab.length; ++i) {
            float r = _rgbcielab[i][0];
            float g = _rgbcielab[i][1];
            float b = _rgbcielab[i][2];
            float Ls = _rgbcielab[i][3];
            float as = _rgbcielab[i][4];
            float bs = _rgbcielab[i][5];
            float[] expected = new float[]{Ls, as, bs};
            float[] test = ColorMap.rgbToCieLab(r, g, b);
            ColorMapTest.assertEquals((double)expected[0], (double)test[0], (double)0.01);
            ColorMapTest.assertEquals((double)expected[1], (double)test[1], (double)0.01);
            ColorMapTest.assertEquals((double)expected[2], (double)test[2], (double)0.01);
        }
    }

    public void testCieLabToRgb() {
        for (int i = 0; i < _rgbcielab.length; ++i) {
            float r = _rgbcielab[i][0];
            float g = _rgbcielab[i][1];
            float b = _rgbcielab[i][2];
            float Ls = _rgbcielab[i][3];
            float as = _rgbcielab[i][4];
            float bs = _rgbcielab[i][5];
            float[] expected = new float[]{r, g, b};
            float[] test = ColorMap.cieLabToRgb(Ls, as, bs);
            ColorMapTest.assertEquals((double)expected[0], (double)test[0], (double)0.01);
            ColorMapTest.assertEquals((double)expected[1], (double)test[1], (double)0.01);
            ColorMapTest.assertEquals((double)expected[2], (double)test[2], (double)0.01);
        }
    }
}

