/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.DMatrixEvd;
import edu.mines.jtk.lapack.DMatrixTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixEvdTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixEvdTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSymmetric() {
        DMatrix a = new DMatrix(new double[][]{{4.0, 1.0, 1.0}, {1.0, 2.0, 3.0}, {1.0, 3.0, 6.0}});
        this.test(a);
        a = DMatrix.random(10, 10);
        a.plusEquals(a.transpose());
        this.test(a);
    }

    public void testAsymmetric() {
        DMatrix a = new DMatrix(new double[][]{{0.0, 1.0, 0.0, 0.0}, {1.0, 0.0, 2.0E-7, 0.0}, {0.0, -2.0E-7, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0}});
        this.test(a);
        a = DMatrix.random(10, 10);
        this.test(a);
    }

    private void test(DMatrix a) {
        DMatrixEvd evd = new DMatrixEvd(a);
        DMatrix d = evd.getD();
        DMatrix v = evd.getV();
        DMatrixTest.assertEqualFuzzy(a.times(v), v.times(d));
    }
}

