/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.util.Check;

public class BoundingBox {
    private double _xmin;
    private double _ymin;
    private double _zmin;
    private double _xmax;
    private double _ymax;
    private double _zmax;

    public BoundingBox() {
        this.setEmpty();
    }

    public BoundingBox(Point3 p) {
        this._xmin = this._xmax = p.x;
        this._ymin = this._ymax = p.y;
        this._zmin = this._zmax = p.z;
    }

    public BoundingBox(Point3 p, Point3 q) {
        this._xmin = Math.min(p.x, q.x);
        this._ymin = Math.min(p.y, q.y);
        this._zmin = Math.min(p.z, q.z);
        this._xmax = Math.max(p.x, q.x);
        this._ymax = Math.max(p.y, q.y);
        this._zmax = Math.max(p.z, q.z);
    }

    public BoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        Check.argument(xmin <= xmax, "xmin<=xmax");
        Check.argument(ymin <= ymax, "ymin<=ymax");
        Check.argument(zmin <= zmax, "zmin<=zmax");
        this._xmin = xmin;
        this._ymin = ymin;
        this._zmin = zmin;
        this._xmax = xmax;
        this._ymax = ymax;
        this._zmax = zmax;
    }

    public BoundingBox(float[] xyz) {
        this();
        this.expandBy(xyz);
    }

    public BoundingBox(float[] x, float[] y, float[] z) {
        this();
        this.expandBy(x, y, z);
    }

    public BoundingBox(BoundingBox bb) {
        this._xmin = bb._xmin;
        this._ymin = bb._ymin;
        this._zmin = bb._zmin;
        this._xmax = bb._xmax;
        this._ymax = bb._ymax;
        this._zmax = bb._zmax;
    }

    public boolean isEmpty() {
        return this._xmin > this._xmax || this._ymin > this._ymax || this._zmin > this._zmax;
    }

    public boolean isInfinite() {
        return this._xmin == Double.NEGATIVE_INFINITY && this._ymin == Double.NEGATIVE_INFINITY && this._zmin == Double.NEGATIVE_INFINITY && this._xmax == Double.POSITIVE_INFINITY && this._ymax == Double.POSITIVE_INFINITY && this._zmax == Double.POSITIVE_INFINITY;
    }

    public Point3 getMin() {
        Check.state(!this.isEmpty(), "bounding box is not empty");
        return new Point3(this._xmin, this._ymin, this._zmin);
    }

    public Point3 getMax() {
        Check.state(!this.isEmpty(), "bounding box is not empty");
        return new Point3(this._xmax, this._ymax, this._zmax);
    }

    public Point3 getCenter() {
        Check.state(!this.isEmpty(), "bounding box is not empty");
        Check.state(!this.isInfinite(), "bounding box is not infinite");
        return this.isInfinite() ? new Point3(0.0, 0.0, 0.0) : new Point3(0.5 * (this._xmin + this._xmax), 0.5 * (this._ymin + this._ymax), 0.5 * (this._zmin + this._zmax));
    }

    public double getRadius() {
        return Math.sqrt(this.getRadiusSquared());
    }

    public double getRadiusSquared() {
        Check.state(!this.isEmpty(), "bounding box is not empty");
        double dx = this._xmax - this._xmin;
        double dy = this._ymax - this._ymin;
        double dz = this._zmax - this._zmin;
        return 0.25 * (dx * dx + dy * dy + dz * dz);
    }

    public Point3 getCorner(int index) {
        Check.state(!this.isEmpty(), "bounding box is not empty");
        double x = (index & 1) == 0 ? this._xmin : this._xmax;
        double y = (index & 2) == 0 ? this._ymin : this._ymax;
        double z = (index & 4) == 0 ? this._zmin : this._zmax;
        return new Point3(x, y, z);
    }

    public void expandBy(Point3 p) {
        this.expandBy(p.x, p.y, p.z);
    }

    public void expandBy(double x, double y, double z) {
        if (this._xmin > x) {
            this._xmin = x;
        }
        if (this._ymin > y) {
            this._ymin = y;
        }
        if (this._zmin > z) {
            this._zmin = z;
        }
        if (this._xmax < x) {
            this._xmax = x;
        }
        if (this._ymax < y) {
            this._ymax = y;
        }
        if (this._zmax < z) {
            this._zmax = z;
        }
    }

    public void expandBy(float[] xyz) {
        int n = xyz.length;
        for (int i = 0; i < n; i += 3) {
            this.expandBy(xyz[i], xyz[i + 1], xyz[i + 2]);
        }
    }

    public void expandBy(float[] x, float[] y, float[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            this.expandBy(x[i], y[i], z[i]);
        }
    }

    public void expandBy(BoundingBox bb) {
        if (this._xmin > bb._xmin) {
            this._xmin = bb._xmin;
        }
        if (this._ymin > bb._ymin) {
            this._ymin = bb._ymin;
        }
        if (this._zmin > bb._zmin) {
            this._zmin = bb._zmin;
        }
        if (this._xmax < bb._xmax) {
            this._xmax = bb._xmax;
        }
        if (this._ymax < bb._ymax) {
            this._ymax = bb._ymax;
        }
        if (this._zmax < bb._zmax) {
            this._zmax = bb._zmax;
        }
    }

    public void expandBy(BoundingSphere bs) {
        if (!bs.isInfinite()) {
            if (!bs.isEmpty()) {
                double r = bs.getRadius();
                Point3 c = bs.getCenter();
                double x = c.x;
                double y = c.y;
                double z = c.z;
                if (this._xmin > x - r) {
                    this._xmin = x - r;
                }
                if (this._ymin > y - r) {
                    this._ymin = y - r;
                }
                if (this._zmin > z - r) {
                    this._zmin = z - r;
                }
                if (this._xmax < x + r) {
                    this._xmax = x + r;
                }
                if (this._ymax < y + r) {
                    this._ymax = y + r;
                }
                if (this._zmax < z + r) {
                    this._zmax = z + r;
                }
            }
        } else {
            this.setInfinite();
        }
    }

    public boolean contains(double x, double y, double z) {
        return this._xmin <= x && x <= this._xmax && this._ymin <= y && y <= this._ymax && this._zmin <= z && z <= this._zmax;
    }

    public boolean contains(Point3 p) {
        return this.contains(p.x, p.y, p.z);
    }

    public boolean contains(BoundingBox bb) {
        return this.contains(bb._xmin, bb._ymin, bb._zmin) && this.contains(bb._xmax, bb._ymax, bb._zmax);
    }

    public boolean intersects(BoundingBox bb) {
        return Math.max(this._xmin, bb._xmin) <= Math.min(this._xmax, bb._xmax) && Math.max(this._ymin, bb._ymin) <= Math.min(this._ymax, bb._ymax) && Math.max(this._zmin, bb._zmin) <= Math.min(this._zmax, bb._zmax);
    }

    public static BoundingBox empty() {
        return new BoundingBox();
    }

    public static BoundingBox infinite() {
        BoundingBox bb = new BoundingBox();
        bb.setInfinite();
        return bb;
    }

    public String toString() {
        return "{" + this.getMin() + ":" + this.getMax() + "}";
    }

    private void setEmpty() {
        this._xmin = Double.POSITIVE_INFINITY;
        this._ymin = Double.POSITIVE_INFINITY;
        this._zmin = Double.POSITIVE_INFINITY;
        this._xmax = Double.NEGATIVE_INFINITY;
        this._ymax = Double.NEGATIVE_INFINITY;
        this._zmax = Double.NEGATIVE_INFINITY;
    }

    private void setInfinite() {
        this._xmin = Double.NEGATIVE_INFINITY;
        this._ymin = Double.NEGATIVE_INFINITY;
        this._zmin = Double.NEGATIVE_INFINITY;
        this._xmax = Double.POSITIVE_INFINITY;
        this._ymax = Double.POSITIVE_INFINITY;
        this._zmax = Double.POSITIVE_INFINITY;
    }
}

