/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching.fusion;

import java.util.ArrayList;
import mpicbg.stitching.fusion.ImageInterpolation;
import mpicbg.stitching.fusion.PixelFusion;

public class BlendingPixelFusion
implements PixelFusion {
    public static double fractionBlended = 0.2;
    final int numDimensions;
    final int numImages;
    final long[][] dimensions;
    final double percentScaling;
    final double[] border;
    final ArrayList<? extends ImageInterpolation<?>> images;
    double valueSum;
    double weightSum;

    public BlendingPixelFusion(ArrayList<? extends ImageInterpolation<?>> images) {
        this(images, fractionBlended);
    }

    private BlendingPixelFusion(ArrayList<? extends ImageInterpolation<?>> images, double fractionBlended) {
        this.images = images;
        this.percentScaling = fractionBlended;
        this.numDimensions = images.get(0).getImg().numDimensions();
        this.numImages = images.size();
        this.dimensions = new long[this.numImages][this.numDimensions];
        for (int i = 0; i < this.numImages; ++i) {
            for (int d = 0; d < this.numDimensions; ++d) {
                this.dimensions[i][d] = images.get(i).getImg().dimension(d) - 1L;
            }
        }
        this.border = new double[this.numDimensions];
        this.clear();
    }

    @Override
    public void clear() {
        this.weightSum = 0.0;
        this.valueSum = 0.0;
    }

    @Override
    public void addValue(double value, int imageId, double[] localPosition) {
        double weight = Math.max(1.0E-5, BlendingPixelFusion.computeWeight(localPosition, this.dimensions[imageId], this.border, this.percentScaling));
        this.weightSum += weight;
        this.valueSum += value * weight;
    }

    @Override
    public double getValue() {
        if (this.weightSum == 0.0) {
            return 0.0;
        }
        return this.valueSum / this.weightSum;
    }

    @Override
    public PixelFusion copy() {
        return new BlendingPixelFusion(this.images);
    }

    public static final double computeWeight(double[] location, long[] dimensions, double[] border, double percentScaling) {
        double minDistance = 1.0;
        for (int dim = 0; dim < location.length; ++dim) {
            float imgAreaBlend;
            double localImgPos = location[dim];
            double value = Math.max(1.0, Math.min(localImgPos - border[dim] + 1.0, (double)(dimensions[dim] - 1L) - localImgPos - border[dim] + 1.0));
            value = value < (double)(imgAreaBlend = (float)Math.round(percentScaling * 0.5 * (double)dimensions[dim])) ? (value /= (double)imgAreaBlend) : 1.0;
            minDistance *= value;
        }
        if (minDistance == 1.0) {
            return 1.0;
        }
        if (minDistance <= 0.0) {
            return 1.0E-7;
        }
        return (Math.cos((1.0 - minDistance) * Math.PI) + 1.0) / 2.0;
    }
}

