/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.ZstdCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class SlideBook7Reader
extends FormatReader {
    public static Logger LOGGER = LoggerFactory.getLogger(SlideBook7Reader.class);
    DataLoader mDataLoader;

    public SlideBook7Reader() {
        super("SlideBook 7 SLD (native)", new String[]{"sldy", "sldyz"});
        this.domains = new String[]{"Light Microscopy"};
        this.suffixSufficient = false;
        LOGGER.trace(" LOGGER.trace SlideBook7Reader: Constructed\n");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        try {
            if (this.mDataLoader == null) {
                return false;
            }
            Boolean res = this.mDataLoader.ReadSld(stream);
            this.mDataLoader.CloseFile();
            return res;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.trace("SlideBook7Reader: isThisType - stream: returning false");
            return false;
        }
    }

    public boolean isThisType(String file, boolean open) {
        try {
            String mytestfile = file;
            LOGGER.trace("SlideBook7Reader: isThisType - String - open: " + open);
            if (open) {
                boolean suffixMatch = file.endsWith(".sldy") || file.endsWith(".sldyz");
                LOGGER.trace("SlideBook7Reader: isThisType - String: suffixMatch " + suffixMatch);
                if (!suffixMatch) {
                    LOGGER.trace("SlideBook7Reader: isThisType - String: suffix mismath, returning false");
                    return false;
                }
            }
            if (!open) {
                return super.isThisType(mytestfile, open);
            }
            Location theFileLocation = new Location(mytestfile).getAbsoluteFile();
            DataLoader dataLoader = new DataLoader(theFileLocation.getAbsolutePath());
            Boolean res = dataLoader.ReadSld();
            dataLoader.CloseFile();
            LOGGER.trace("SlideBook7Reader: isThisType - String: returning " + res);
            return res;
        }
        catch (IOException e) {
            LOGGER.trace("SlideBook7Reader: isThisType - String: printStackTrace ", (Throwable)e);
            e.printStackTrace();
            LOGGER.trace("SlideBook7Reader: isThisType - String: return false ");
            return false;
        }
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    private void findAllFiles(Location root, ArrayList<String> files, boolean noPixels) {
        String thePath1 = root.getAbsolutePath();
        LOGGER.trace("findAllFiles on enter " + thePath1);
        if (root.isDirectory()) {
            String[] list;
            for (String file : list = root.list(true)) {
                Location path = new Location(root, file);
                this.findAllFiles(path, files, noPixels);
            }
        } else {
            String thePath = root.getAbsolutePath();
            if (noPixels) {
                if (thePath.endsWith("npy")) {
                    return;
                }
                if (thePath.endsWith("npyz")) {
                    return;
                }
            }
            if (thePath.endsWith("lck")) {
                return;
            }
            if (thePath.endsWith("copy")) {
                return;
            }
            if (thePath.endsWith("dat")) {
                return;
            }
            files.add(thePath);
            LOGGER.trace("added file " + thePath);
        }
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.mDataLoader == null) {
            LOGGER.error("SlideBook7Reader::getUsedFiles: initFile has not been called yet");
        }
        String theRootDirectory = this.mDataLoader.GetRootDirectory();
        LOGGER.trace("theRootDirectory " + theRootDirectory);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getCurrentFile());
        Location theRootLocation = new Location(theRootDirectory).getAbsoluteFile();
        this.findAllFiles(theRootLocation, files, noPixels);
        String[] rtn = files.toArray(new String[files.size()]);
        return rtn;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.mDataLoader == null) {
            return buf;
        }
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int[] zct = FormatTools.getZCTCoords((IFormatReader)this, (int)no);
        int bpc = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int thePlaneSize = FormatTools.getPlaneSize((IFormatReader)this);
        byte[] b = new byte[thePlaneSize];
        String spc = " ";
        LOGGER.trace("openBytes no,x,y,w,h " + no + spc + x + spc + y + spc + w + spc + h);
        LOGGER.trace("openBytes bpc, thePlaneSize " + bpc + spc + thePlaneSize);
        LOGGER.trace("openBytes  ztc " + zct[2] + spc + zct[0] + spc + zct[1]);
        this.mDataLoader.ReadPlane(this.getSeries(), b, 0, zct[2], zct[0], zct[1]);
        int pixel = bpc * this.getRGBChannelCount();
        int rowLen = w * pixel;
        LOGGER.trace("openBytes pixel " + pixel);
        for (int row = 0; row < h; ++row) {
            System.arraycopy(b, pixel * ((row + y) * this.getSizeX() + x), buf, row * rowLen, rowLen);
        }
        if (this.isRGB()) {
            int bpp = this.getSizeC() * bpc;
            int line = w * bpp;
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    int base = row * line + col * bpp;
                    for (int bb = 0; bb < bpc; ++bb) {
                        byte blue = buf[base + bpc * (this.getSizeC() - 1) + bb];
                        buf[base + bpc * (this.getSizeC() - 1) + bb] = buf[base + bb];
                        buf[base + bb] = blue;
                    }
                }
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.mDataLoader == null) {
            return;
        }
        this.mDataLoader.CloseFile();
        this.mDataLoader = null;
    }

    protected int addAnnotation(MetadataStore store, CAnnotation70 inAnn, int inCapture, int inRegionIndex, int inRoiManagerRoiIndex) {
        CSBPoint<Integer> thePoint2;
        if (inAnn.mGraphicType70 == 4) {
            return inRoiManagerRoiIndex;
        }
        if (inAnn.mGraphicType70 == 5) {
            return inRoiManagerRoiIndex;
        }
        if (inAnn.mGraphicType70 == 6) {
            return inRoiManagerRoiIndex;
        }
        if (inAnn.mGraphicType70 == 7) {
            return inRoiManagerRoiIndex;
        }
        String roiID = MetadataTools.createLSID((String)"ROI", (int[])new int[]{inRoiManagerRoiIndex});
        store.setROIID(roiID, inRoiManagerRoiIndex);
        store.setImageROIRef(roiID, inCapture, inRoiManagerRoiIndex);
        store.setROIName("ROI " + inRegionIndex, inRoiManagerRoiIndex);
        String shapeID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{inRoiManagerRoiIndex, 0});
        if (inAnn.mGraphicType70 == 0) {
            store.setPointID(shapeID, inRoiManagerRoiIndex, 0);
            CSBPoint<Integer> thePoint1 = inAnn.mVertexes.get(0);
            store.setPointX(Double.valueOf(((Integer)thePoint1.mX).intValue()), inRoiManagerRoiIndex, 0);
            store.setPointY(Double.valueOf(((Integer)thePoint1.mY).intValue()), inRoiManagerRoiIndex, 0);
        } else if (inAnn.mGraphicType70 == 1) {
            CSBPoint<Integer> thePoint1 = inAnn.mVertexes.get(0);
            thePoint2 = inAnn.mVertexes.get(1);
            store.setLineID(shapeID, inRoiManagerRoiIndex, 0);
            store.setLineX1(Double.valueOf(((Integer)thePoint1.mX).intValue()), inRoiManagerRoiIndex, 0);
            store.setLineY1(Double.valueOf(((Integer)thePoint1.mY).intValue()), inRoiManagerRoiIndex, 0);
            store.setLineX2(Double.valueOf(((Integer)thePoint2.mX).intValue()), inRoiManagerRoiIndex, 0);
            store.setLineY2(Double.valueOf(((Integer)thePoint2.mY).intValue()), inRoiManagerRoiIndex, 0);
        } else if (inAnn.mGraphicType70 == 2) {
            CSBPoint<Integer> thePoint1 = inAnn.mVertexes.get(0);
            thePoint2 = inAnn.mVertexes.get(1);
            int left = (Integer)thePoint1.mX;
            int top = (Integer)thePoint1.mY;
            int width = (Integer)thePoint2.mX - (Integer)thePoint1.mX;
            int height = (Integer)thePoint2.mY - (Integer)thePoint1.mY;
            store.setRectangleID(shapeID, inRoiManagerRoiIndex, 0);
            store.setRectangleX(Double.valueOf(left), inRoiManagerRoiIndex, 0);
            store.setRectangleY(Double.valueOf(top), inRoiManagerRoiIndex, 0);
            store.setRectangleWidth(Double.valueOf(width), inRoiManagerRoiIndex, 0);
            store.setRectangleHeight(Double.valueOf(height), inRoiManagerRoiIndex, 0);
        } else if (inAnn.mGraphicType70 == 3) {
            store.setPolygonID(shapeID, inRoiManagerRoiIndex, 0);
            int numVertex = inAnn.mVertexes.size();
            StringBuilder p = new StringBuilder();
            for (int j = 0; j < numVertex; ++j) {
                CSBPoint<Integer> thePoint = inAnn.mVertexes.get(j);
                p.append(thePoint.mX);
                p.append(",");
                p.append(thePoint.mY);
                if (j >= numVertex - 1) continue;
                p.append(" ");
            }
            store.setPolygonPoints(p.toString(), inRoiManagerRoiIndex, 0);
        } else if (inAnn.mGraphicType70 == 8) {
            CSBPoint<Integer> thePoint1 = inAnn.mVertexes.get(0);
            thePoint2 = inAnn.mVertexes.get(1);
            int theCenterX = ((Integer)thePoint2.mX + (Integer)thePoint1.mX) / 2;
            int theCenterY = ((Integer)thePoint2.mY + (Integer)thePoint1.mY) / 2;
            int theRadiusX = ((Integer)thePoint2.mX - (Integer)thePoint1.mX) / 2;
            int theRadiusY = ((Integer)thePoint2.mY - (Integer)thePoint1.mY) / 2;
            store.setEllipseID(shapeID, inRoiManagerRoiIndex, 0);
            store.setEllipseX(Double.valueOf(theCenterX), inRoiManagerRoiIndex, 0);
            store.setEllipseY(Double.valueOf(theCenterY), inRoiManagerRoiIndex, 0);
            store.setEllipseRadiusX(Double.valueOf(theRadiusX), inRoiManagerRoiIndex, 0);
            store.setEllipseRadiusY(Double.valueOf(theRadiusY), inRoiManagerRoiIndex, 0);
        }
        return ++inRoiManagerRoiIndex;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            CImageGroup theCurrentImageGroup;
            int capture;
            Boolean res;
            if (this.mDataLoader == null) {
                this.mDataLoader = new DataLoader(Location.getMappedId(id));
            }
            if (!(res = this.mDataLoader.LoadMetadata()).booleanValue()) {
                Exception e = new Exception("Could not load metadata");
                throw new FormatException("Could not load metadata", (Throwable)e);
            }
            int numCaptures = this.mDataLoader.GetNumCaptures();
            int[] numPositions = new int[numCaptures];
            int[] numTimepoints = new int[numCaptures];
            int[] numZPlanes = new int[numCaptures];
            int[] numChannels = new int[numCaptures];
            for (capture = 0; capture < numCaptures; ++capture) {
                theCurrentImageGroup = this.mDataLoader.GetImageGroup(capture);
                numPositions[capture] = theCurrentImageGroup.GetNumPositions();
                numTimepoints[capture] = theCurrentImageGroup.GetNumTimepoints() / numPositions[capture];
                numZPlanes[capture] = theCurrentImageGroup.GetNumPlanes();
                numChannels[capture] = theCurrentImageGroup.GetNumChannels();
                LOGGER.trace("capture: " + capture);
                LOGGER.trace("numPositions[capture]: " + numPositions[capture]);
                LOGGER.trace("numTimepoints[capture]: " + numTimepoints[capture]);
                LOGGER.trace("numZPlanes[capture]: " + numZPlanes[capture]);
                LOGGER.trace("numChannels[capture]: " + numChannels[capture]);
            }
            this.core.clear();
            for (capture = 0; capture < numCaptures; ++capture) {
                theCurrentImageGroup = this.mDataLoader.GetImageGroup(capture);
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                this.setSeries(capture);
                ms.sizeX = theCurrentImageGroup.GetNumColumns();
                ms.sizeY = theCurrentImageGroup.GetNumRows();
                LOGGER.trace("ms.sizeX: " + ms.sizeX);
                LOGGER.trace("ms.sizeY: " + ms.sizeY);
                ms.sizeZ = numZPlanes[capture];
                ms.sizeT = numTimepoints[capture] * numPositions[capture];
                ms.sizeC = numChannels[capture];
                LOGGER.trace("ms.sizeT: " + ms.sizeT);
                LOGGER.trace("ms.sizeC: " + ms.sizeC);
                int bytes = theCurrentImageGroup.GetBytesPerPixel();
                LOGGER.trace("initFile: bytes: " + bytes);
                if (bytes % 3 == 0) {
                    ms.sizeC *= 3;
                    bytes /= 3;
                    ms.rgb = true;
                } else {
                    ms.rgb = false;
                }
                ms.pixelType = FormatTools.pixelTypeFromBytes((int)bytes, (boolean)false, (boolean)true);
                LOGGER.trace("initFile: ms.pixelType: " + ms.pixelType);
                ms.imageCount = ms.sizeZ * ms.sizeT;
                if (!ms.rgb) {
                    ms.imageCount *= ms.sizeC;
                }
                ms.interleaved = true;
                ms.littleEndian = true;
                ms.dimensionOrder = "XYCZT";
                ms.indexed = false;
                ms.falseColor = false;
            }
            this.setSeries(0);
            MetadataStore store = this.makeFilterMetadata();
            MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
                store.setInstrumentID(instrumentID, 0);
                int roiManagerRoiIndex = 0;
                for (int capture2 = 0; capture2 < numCaptures; ++capture2) {
                    CImageGroup theCurrentImageGroup2 = this.mDataLoader.GetImageGroup(capture2);
                    this.setSeries(capture2);
                    int theAnnoSize = theCurrentImageGroup2.mAnnotationList.size();
                    for (int theAnnoIndex = 0; theAnnoIndex < theAnnoSize; ++theAnnoIndex) {
                        CImageGroup.CAnnotations theAnno = theCurrentImageGroup2.mAnnotationList.get(theAnnoIndex);
                        for (int theCubeIndex = 0; theCubeIndex < theAnno.mCubeAnnotationList.size(); ++theCubeIndex) {
                            CCubeAnnotation70 theCubeAnno = theAnno.mCubeAnnotationList.get(theCubeIndex);
                            LOGGER.debug("about to add annotation for capture " + capture2 + "roiManagerRoiIndex: " + roiManagerRoiIndex);
                            roiManagerRoiIndex = this.addAnnotation(store, theCubeAnno.mAnn, capture2, theCubeAnno.mRegionIndex, roiManagerRoiIndex);
                        }
                    }
                    store.setImageInstrumentRef(instrumentID, capture2);
                    String imageName = theCurrentImageGroup2.GetName();
                    store.setImageName(imageName, capture2);
                    String imageDescription = theCurrentImageGroup2.GetInfo();
                    store.setImageDescription(imageDescription, capture2);
                    double voxelsize = theCurrentImageGroup2.GetVoxelSize();
                    LOGGER.trace("initFile: voxelsize: " + voxelsize);
                    Length physicalSizeX = FormatTools.getPhysicalSizeX((Double)voxelsize);
                    Length physicalSizeY = FormatTools.getPhysicalSizeY((Double)voxelsize);
                    if (physicalSizeX != null) {
                        store.setPixelsPhysicalSizeX(physicalSizeX, capture2);
                    }
                    if (physicalSizeY != null) {
                        store.setPixelsPhysicalSizeY(physicalSizeY, capture2);
                    }
                    LOGGER.trace("initFile: physicalSizeX: " + physicalSizeX);
                    LOGGER.trace("initFile: physicalSizeY: " + physicalSizeY);
                    double stepSize = 0.0;
                    if (numZPlanes[capture2] > 1) {
                        stepSize = theCurrentImageGroup2.GetInterplaneSpacing();
                    }
                    LOGGER.trace("initFile: stepSize: " + stepSize);
                    Length physicalSizeZ = FormatTools.getPhysicalSizeZ((Double)stepSize);
                    if (physicalSizeZ != null) {
                        store.setPixelsPhysicalSizeZ(physicalSizeZ, capture2);
                    }
                    int imageIndex = 0;
                    for (int timepoint = 0; timepoint < numTimepoints[capture2]; ++timepoint) {
                        int deltaT = theCurrentImageGroup2.GetElapsedTime(timepoint);
                        for (int position = 0; position < numPositions[capture2]; ++position) {
                            for (int zplane = 0; zplane < numZPlanes[capture2]; ++zplane) {
                                int channel = 0;
                                while (channel < numChannels[capture2]) {
                                    store.setPlaneDeltaT(new Time((Number)deltaT, UNITS.MILLISECOND), capture2, imageIndex);
                                    int expTime = theCurrentImageGroup2.GetExposureTime(channel);
                                    store.setPlaneExposureTime(new Time((Number)new Double(expTime), UNITS.MILLISECOND), capture2, imageIndex);
                                    double numberX = theCurrentImageGroup2.GetXPosition(position);
                                    Length positionX = new Length((Number)numberX, UNITS.MICROMETRE);
                                    LOGGER.trace("initFile: positionX: " + numberX);
                                    store.setPlanePositionX(positionX, capture2, imageIndex);
                                    double numberY = theCurrentImageGroup2.GetYPosition(position);
                                    Length positionY = new Length((Number)numberY, UNITS.MICROMETRE);
                                    store.setPlanePositionY(positionY, capture2, imageIndex);
                                    LOGGER.trace("initFile: positionY: " + numberY);
                                    double positionZ = theCurrentImageGroup2.GetZPosition(position, zplane);
                                    Length zPos = new Length((Number)positionZ, UNITS.MICROMETRE);
                                    store.setPlanePositionZ(zPos, capture2, imageIndex);
                                    LOGGER.trace("initFile: positionZ: " + positionZ);
                                    ++channel;
                                    ++imageIndex;
                                }
                            }
                        }
                    }
                    for (int channel = 0; channel < numChannels[capture2]; ++channel) {
                        String theChannelName = theCurrentImageGroup2.GetChannelName(channel);
                        store.setChannelName(theChannelName.trim(), capture2, channel);
                    }
                }
                int objectiveIndex = 0;
                for (int capture3 = 0; capture3 < numCaptures; ++capture3) {
                    CImageGroup theCurrentImageGroup3 = this.mDataLoader.GetImageGroup(capture3);
                    String objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, objectiveIndex});
                    store.setObjectiveID(objectiveID, 0, objectiveIndex);
                    store.setObjectiveSettingsID(objectiveID, capture3);
                    String objective = theCurrentImageGroup3.GetLensName();
                    if (objective != null) {
                        store.setObjectiveModel(objective, 0, objectiveIndex);
                    }
                    store.setObjectiveCorrection(MetadataTools.getCorrection((String)"Other"), 0, objectiveIndex);
                    store.setObjectiveImmersion(MetadataTools.getImmersion((String)"Other"), 0, objectiveIndex);
                    double magnification = theCurrentImageGroup3.GetMagnification();
                    if (magnification > 0.0) {
                        store.setObjectiveNominalMagnification(Double.valueOf(magnification), 0, objectiveIndex);
                    }
                    ++objectiveIndex;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DataLoader {
        public String mSlidePath;
        public String mErrorMessage;
        public CSBFile70 mFile;
        public CSlideRecord70 mSlideRecord;
        public ArrayList<CImageGroup> mCImageGroupList;
        HashMap<String, RandomAccessInputStream> mPathToStreamMap;
        TreeMap<Integer, String> mCounterToPathMap;
        public static final int kMaxNumberOpenFiles = 100;
        public int mCurrentFileCounter;

        public DataLoader(String inSlidePath) {
            this.mSlidePath = inSlidePath;
            this.mFile = new CSBFile70(inSlidePath);
            this.mCImageGroupList = new ArrayList();
            this.mPathToStreamMap = new HashMap();
            this.mCounterToPathMap = new TreeMap();
            this.mCurrentFileCounter = 0;
            this.mErrorMessage = "";
        }

        public Boolean LoadMetadata() {
            try {
                Boolean theResult = this.ReadSld();
                LOGGER.trace("LoadMetadata: ReadSld result: " + theResult);
                if (!theResult.booleanValue()) {
                    return false;
                }
                String[] theImageTitles = this.mFile.GetListOfImageGroupTitles();
                for (int theImageGroupIndex = 0; theImageGroupIndex < theImageTitles.length; ++theImageGroupIndex) {
                    CImageGroup theImageGroup = new CImageGroup(this.mFile, theImageTitles[theImageGroupIndex]);
                    theResult = theImageGroup.Load();
                    LOGGER.trace("LoadMetadata: theImageGroupIndex: " + theImageGroupIndex + "Load:  result: " + theResult);
                    if (!theResult.booleanValue()) continue;
                    this.mCImageGroupList.add(theImageGroup);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("Could not load file: " + this.mSlidePath, (Throwable)e);
                return false;
            }
        }

        /*
         * Exception decompiling
         */
        public Boolean ReadSld() throws FileNotFoundException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Boolean ReadSld(InputStream inInputStream) throws FileNotFoundException {
            this.mSlideRecord = new CSlideRecord70();
            try {
                LOGGER.trace("ReadSld(stream): mByteOrdering: " + this.mSlideRecord.mByteOrdering);
                return true;
            }
            catch (Exception e) {
                this.mErrorMessage = this.mErrorMessage + "Could not load file: " + this.mSlidePath;
                LOGGER.error("ReadSld(): " + this.mErrorMessage, (Throwable)e);
                return false;
            }
        }

        public int GetNumCaptures() {
            return this.mCImageGroupList.size();
        }

        public CImageGroup GetImageGroup(int inCaptureId) {
            return this.mCImageGroupList.get(inCaptureId);
        }

        /*
         * WARNING - void declaration
         */
        public boolean ReadPlane(int inCaptureId, byte[] ouBuf, int inPositionIndex, int inTimepointIndex, int inZPlaneIndex, int inChannelIndex) throws IOException {
            short s;
            RandomAccessInputStream theStream;
            LOGGER.trace("ReadPlane: inPositionIndex: " + inPositionIndex);
            LOGGER.trace("ReadPlane: inTimepointIndex: " + inTimepointIndex);
            LOGGER.trace("ReadPlane: inZPlaneIndex: " + inZPlaneIndex);
            LOGGER.trace("ReadPlane: inChannelIndex: " + inChannelIndex);
            CImageGroup theImageGroup = this.GetImageGroup(inCaptureId);
            int theSbTimepointIndex = inTimepointIndex;
            String thePath = theImageGroup.mFile.GetImageDataFile(theImageGroup.mImageTitle, inChannelIndex, theSbTimepointIndex);
            int theNumRows = theImageGroup.GetNumRows();
            int theNumColumns = theImageGroup.GetNumColumns();
            int theNumPlanes = theImageGroup.GetNumPlanes();
            if (theNumPlanes == 1 && theSbTimepointIndex > 0) {
                String theT0Path = theImageGroup.mFile.RenamePathToTimepoint0(thePath);
                if (theImageGroup.GetSingleTimepointFile().booleanValue()) {
                    thePath = theT0Path;
                }
            }
            if ((theStream = this.mPathToStreamMap.get(thePath)) == null) {
                RandomAccessInputStream theKeyStream;
                Integer theKeyValue;
                String theKeyPath;
                if (this.mCounterToPathMap.size() > 100 && (theKeyPath = this.mCounterToPathMap.get(theKeyValue = this.mCounterToPathMap.firstKey())) != null && (theKeyStream = this.mPathToStreamMap.get(theKeyPath)) != null) {
                    theKeyStream.close();
                    this.mCounterToPathMap.remove(theKeyValue);
                    this.mPathToStreamMap.remove(theKeyPath);
                }
                theStream = new RandomAccessInputStream(thePath);
                this.mPathToStreamMap.put(thePath, theStream);
                this.mCounterToPathMap.put(this.mCurrentFileCounter, thePath);
                ++this.mCurrentFileCounter;
            }
            if (theImageGroup.mNpyHeader == null || inTimepointIndex != theImageGroup.mLastTimepoint || inChannelIndex != theImageGroup.mLastChannel) {
                LOGGER.trace("Resettin npy header, compressor for path " + thePath);
                theImageGroup.mLastTimepoint = inTimepointIndex;
                theImageGroup.mLastChannel = inChannelIndex;
                theImageGroup.mNpyHeader = new CNpyHeader();
                boolean theRes = theImageGroup.mNpyHeader.ParseNpyHeader(theStream);
                if (!theRes) {
                    return false;
                }
                theImageGroup.mCompressionFlag = theImageGroup.mNpyHeader.mCompressionFlag;
                LOGGER.trace("theImageGroup.mCompressionFlag " + theImageGroup.mCompressionFlag);
                if (theImageGroup.mCompressionFlag > 0) {
                    theImageGroup.mCompressor = new CCompressionBase();
                    theImageGroup.mCompressor.Initialize(theImageGroup.mNpyHeader.mHeaderSize.intValue(), theImageGroup.mCompressionFlag, theNumColumns, theNumRows, theNumPlanes, 0);
                    theImageGroup.mCompressor.ReadDictionary(theStream);
                }
            }
            long thePlaneSize = theImageGroup.GetNumColumns() * theImageGroup.GetNumRows() * theImageGroup.mNpyHeader.mBytesPerPixel;
            if (theImageGroup.mCompressionFlag == 0) {
                LOGGER.trace("ReadPlane: thePlaneSize: " + thePlaneSize);
                long theSeekOffset = (long)theImageGroup.mNpyHeader.mHeaderSize.intValue() + thePlaneSize * (long)inZPlaneIndex;
                if (theNumPlanes == 1 && theImageGroup.GetSingleTimepointFile().booleanValue()) {
                    theSeekOffset = (long)theImageGroup.mNpyHeader.mHeaderSize.intValue() + thePlaneSize * (long)inTimepointIndex;
                }
                LOGGER.trace("ReadPlane: theSeekOffset: " + theSeekOffset);
                theStream.seek(theSeekOffset);
                theStream.read(ouBuf, 0, (int)thePlaneSize);
            } else {
                try {
                    void var17_23;
                    byte[] theOutBuffer = theImageGroup.mCompressor.ReadData(theStream, inZPlaneIndex);
                    LOGGER.trace("ReadPlane: theOutBuffer size: " + theOutBuffer.length);
                    LOGGER.trace("ReadPlane: ouBuf size: " + ouBuf.length);
                    boolean bl = false;
                    while ((long)var17_23 < thePlaneSize) {
                        ouBuf[var17_23] = theOutBuffer[var17_23];
                        ++var17_23;
                    }
                }
                catch (FormatException e) {
                    LOGGER.error("ReadPlane(): Could not read compressed data", (Throwable)e);
                    throw new IOException("Could not read compressed data", e);
                }
            }
            short theMax = 0;
            int n = 66000;
            int theI = 0;
            while ((long)theI < thePlaneSize) {
                short theVal = this.ByteArrayToShort(ouBuf, theI);
                if (theVal > theMax) {
                    theMax = theVal;
                }
                if (theVal < s) {
                    s = theVal;
                }
                theI += 2;
            }
            LOGGER.trace("ReadPlane: theMax: " + theMax);
            LOGGER.trace("ReadPlane: theMin: " + s);
            return true;
        }

        short ByteArrayToShort(byte[] bytes, int offset) {
            int theVal = (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 0] & 0xFF) << 0;
            return (short)theVal;
        }

        public void CloseFile() throws IOException {
            for (String key : this.mPathToStreamMap.keySet()) {
                RandomAccessInputStream stream = this.mPathToStreamMap.get(key);
                stream.close();
            }
        }

        public String GetRootDirectory() {
            String theRootDirectory = this.mFile.GetSlideRootDirectory();
            LOGGER.trace("theRootDirectory: " + theRootDirectory);
            return theRootDirectory;
        }
    }

    class CCompressionBase {
        public static final int eCompressionNone = 0;
        public static final int eCompressionZstd = 1;
        public static final int eCompressionZlib = 2;
        public static final int eCompressionLz4 = 3;
        public static final int eCompressionJetRaw = 4;
        public static final int eCompressionRLE = 5;
        public String mErrorMessage;
        public int mAlgorythm = 0;
        public long mNumX = 0L;
        public long mNumY = 0L;
        public long mNumZ = 0L;
        public long mNumBlocks = 0L;
        public long mBufLenBY = 0L;
        public long mDataLenBY = 0L;
        public Boolean mDictionaryRead = false;
        public int mBlockDictionarySize = 16;
        public int mUint16Size = 2;
        public int mNumberOfThreads = 0;
        public long mDictionaryPosition = 0L;
        public long mDataPosition = 0L;
        public byte[] mBlockDictionary;
        public byte[] mOutputBuffer;

        CCompressionBase() {
        }

        public void Initialize(long inDictionaryPosition, int inAlgorythm, int inNumX, int inNumY, int inNumZ, int inNumberOfThreads) {
            this.mAlgorythm = inAlgorythm;
            this.mNumX = inNumX;
            this.mNumY = inNumY;
            this.mNumBlocks = this.mNumZ = (long)inNumZ;
            this.mNumberOfThreads = inNumberOfThreads;
            this.mDictionaryPosition = inDictionaryPosition;
            this.mDataPosition = this.mDictionaryPosition + this.mNumZ * (long)this.mBlockDictionarySize;
            this.mDataLenBY = this.mNumX * this.mNumY * (long)this.mUint16Size;
            this.mBlockDictionary = new byte[(int)this.mNumBlocks * this.mBlockDictionarySize];
            this.mOutputBuffer = new byte[(int)this.mDataLenBY];
        }

        public void Initialize(long inDictionaryPosition, int inAlgorythm, int inNumX, int inNumY, int inNumZ, int inNumBlocks, int inNumberOfThreads) {
            this.mAlgorythm = inAlgorythm;
            this.mNumX = inNumX;
            this.mNumY = inNumY;
            this.mNumZ = inNumZ;
            this.mNumBlocks = inNumBlocks;
            this.mNumberOfThreads = inNumberOfThreads;
            this.mDictionaryPosition = inDictionaryPosition;
            this.mDataPosition = this.mDictionaryPosition + this.mNumBlocks * (long)this.mBlockDictionarySize;
            this.mDataLenBY = this.mNumX * this.mNumY * this.mNumZ * (long)this.mUint16Size;
            this.mBlockDictionary = new byte[(int)this.mNumBlocks * this.mBlockDictionarySize];
            this.mOutputBuffer = new byte[(int)this.mDataLenBY];
        }

        public void ReadDictionary(RandomAccessInputStream inStream) throws IOException {
            LOGGER.trace("ReadDictionary mDictionaryPosition " + this.mDictionaryPosition);
            inStream.seek(this.mDictionaryPosition);
            inStream.read(this.mBlockDictionary, 0, (int)this.mNumBlocks * this.mBlockDictionarySize);
            this.mDictionaryRead = true;
        }

        public long convertToLong(byte[] bytes, int offset) {
            long value = 0L;
            for (int i = offset + 8 - 1; i >= offset; --i) {
                byte b = bytes[i];
                value = (value << 8) + (long)(b & 0xFF);
            }
            return value;
        }

        public long GetDataOffsetForBlock(int inBlock) {
            if (inBlock == 0) {
                return this.mDataPosition;
            }
            LOGGER.trace("GetDataOffsetForBlock inBlock " + inBlock);
            long thePos = this.convertToLong(this.mBlockDictionary, (inBlock - 1) * this.mBlockDictionarySize);
            LOGGER.trace("GetDataOffsetForBlock thePos " + thePos);
            long theLen = this.convertToLong(this.mBlockDictionary, (inBlock - 1) * this.mBlockDictionarySize + 8);
            LOGGER.trace("GetDataOffsetForBlock theLen " + theLen);
            return thePos + theLen;
        }

        public long GetDataSizeForBlock(int inBlock) {
            LOGGER.trace("GetDataOffsetForBlock inBlock " + inBlock);
            long theLen = this.convertToLong(this.mBlockDictionary, inBlock * this.mBlockDictionarySize + 8);
            LOGGER.trace("GetDataOffsetForBlock theLen " + theLen);
            return theLen;
        }

        public byte[] DecompressBuffer(byte[] inBuffer) throws FormatException, IOException {
            LOGGER.trace("DecompressBuffer inBuffer.length " + inBuffer.length);
            if (this.mAlgorythm == 1) {
                for (int i = 0; i < 10; ++i) {
                    LOGGER.trace("i " + i + " val " + inBuffer[i]);
                }
                byte[] theDecompressedBuf = new ZstdCodec().decompress(inBuffer);
                LOGGER.trace("DecompressBuffer theDecompressedBuf.length " + theDecompressedBuf.length);
                return theDecompressedBuf;
            }
            return inBuffer;
        }

        public byte[] ReadData(RandomAccessInputStream inStream, int inBlock) throws FormatException, IOException {
            if (!this.mDictionaryRead.booleanValue()) {
                this.ReadDictionary(inStream);
            }
            long theDataPos = this.GetDataOffsetForBlock(inBlock);
            LOGGER.trace("ReadData theDataPos " + theDataPos);
            long theCompressedLengthBY = this.GetDataSizeForBlock(inBlock);
            LOGGER.trace("ReadData theCompressedLengthBY " + theCompressedLengthBY);
            inStream.seek(theDataPos);
            inStream.read(this.mOutputBuffer, 0, (int)theCompressedLengthBY);
            byte[] theDecompressInput = new byte[(int)theCompressedLengthBY];
            int theI = 0;
            while ((long)theI < theCompressedLengthBY) {
                theDecompressInput[theI] = this.mOutputBuffer[theI];
                ++theI;
            }
            byte[] theUncompressedBuf = this.DecompressBuffer(theDecompressInput);
            if ((long)theUncompressedBuf.length != this.mNumX * this.mNumY * (long)this.mUint16Size) {
                LOGGER.error("ReadData, Uncompress wrong size: " + theUncompressedBuf.length + " should be: " + this.mNumX * this.mNumY * (long)this.mUint16Size);
            } else {
                LOGGER.trace("ReadData, Uncompress size: " + theUncompressedBuf.length);
            }
            return theUncompressedBuf;
        }
    }

    class CUnknownAnnotation70
    extends ClassDecoder {
        CAnnotation70 mAnn;

        CUnknownAnnotation70() {
        }

        @Override
        public int Decode(MappingNode inNode, int inStartIndex) {
            this.mAnn = new CAnnotation70();
            int theLastIndex = super.Decode(inNode, inStartIndex);
            theLastIndex = this.mAnn.Decode(inNode, theLastIndex);
            return theLastIndex;
        }
    }

    class CSlideRecord70
    extends ClassDecoder {
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mNotesLen;
        public Integer mNumImages;
        public Long mNotesPtr;
        public Long mImagePtr;
        public Integer mPrefsFileLen;
        public Integer mPrefsOffset;
        public Integer mHardwareFileOffset;
        public Integer mHighestCount;
        public Integer mUncompactedSpace;
        public Integer mCheckpointNumImages;
        public Long mCheckpointImagePtr;
        public Integer mCheckpointMaxImages;
        public Integer mHardwareFileLen;
        public Integer mCaptureStatus;
        public Integer mDemoFlag;
        public String mName;
        public String mProjectFolder;
        public String mSpecialBuildStr;
        public Integer[] mFileVersion;

        CSlideRecord70() {
        }
    }

    class CRemapPoint
    extends ClassDecoder {
        public Float mGivenValue;
        public Float mDesiredValue;
        public Float mSamplingStdDev;
        public CCube mCube;

        CRemapPoint() {
        }
    }

    class CRemapManipRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mManipID;
        public Integer mRemapType;
        public Integer mNumCalibPoints;
        public Integer mReserved2;
        public Long mCalibDataPtrLow;
        public Long mCalibDataPtrHigh;

        CRemapManipRecord70() {
        }
    }

    class CRemapChannelLUT70
    extends ClassDecoder {
        public Double[] mCoefficients;
        public Float[] mValues;
        public Boolean[] mInsideRange;
        public Float mLowDesired;
        public Float mHighDesired;
        public Integer mLowGiven;
        public Integer mHighGiven;
        public Boolean mBuiltTable;
        public Integer mRemapType;
        public String mEquationString;
        public CRemapPoint[] mPoints;

        CRemapChannelLUT70() {
        }
    }

    class CRatioManipRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mManipID;
        public Float mKd;
        public Float mRmin;
        public Float mRmax;
        public Float mBeta;
        public Float mRlow;
        public Float mRhigh;
        public Integer mNumBackground;
        public Integer mDenBackground;
        public Float mExposureFactor;
        public Integer mBackX1;
        public Integer mBackY1;
        public Integer mBackX2;
        public Integer mBackY2;
        public Integer mNumMin;
        public Integer mNumMax;
        public Integer mDenMin;
        public Integer mDenMax;

        CRatioManipRecord70() {
        }
    }

    class COptovarDef70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public String mName;
        public Float mMagnification;
        public Boolean mDefault;
        public Integer mTurretPosition;

        COptovarDef70() {
        }
    }

    class CMaskRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public String mName;
        public Integer mNumManip;
        public Long mManipPtr;
        public Long mMaskDataTablePtr;
        public Integer mPersistentSubmasks;
        public String mCentroidFeature;
        public Integer mCentroidChannel;

        CMaskRecord70() {
        }
    }

    class CMainViewRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mViewID;
        public Integer mRedChannel;
        public Integer mGreenChannel;
        public Integer mBlueChannel;
        public Integer mBkgndChannel;
        public Integer[] mLow;
        public Integer[] mHigh;
        public Integer mColorDisplay;
        public Float mPseudoFrom;
        public Float mPseudoTo;
        public Integer mThumbPlane;
        public Integer mViewOptions;
        public Float[] mGamma;
        public Integer[] mHue;
        public Integer[] mSaturation;
        public Integer[] mValue;
        public Integer[] mChannelEnabled;
        public Integer[] mBitDepth;
        public Float mBlendFraction;
        public Integer mThumbTimePoint;

        CMainViewRecord70() {
        }
    }

    class CLensDef70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public String mName;
        public Float mNA;
        public Float mdf;
        public Float mMicronPerPixel;
        public Integer mDeprecatedMagnification;
        public Integer mMedium;
        public Boolean mUV;
        public Integer mTurretPosition;
        public Integer mParfocalOffset;
        public Boolean mDefault;
        public Integer mParfocalOffset2;
        public Float mParcentricOffsetX;
        public Float mParcentricOffsetY;
        public Integer mBrightfieldPos;
        public Integer mDarkfieldPos;
        public Integer mDICPos;
        public Integer mPhasePos;
        public Integer mTLFieldDiaphramPos;
        public Integer mTLApertureDiaphramPos;
        public Integer mDICPrismPos;
        public Integer mTopLensPos;
        public Integer mPolarizerPos;
        public String mCameraName;
        public Float mCameraPixelSize;
        public Float mCameraMagnificationChange;
        public Float mActualMagnification;

        CLensDef70() {
        }
    }

    class CImageRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mYear;
        public Integer mMonth;
        public Integer mDay;
        public Integer mHour;
        public Integer mMinute;
        public Integer mSecond;
        public Boolean mImported;
        public Integer mNotesLen;
        public Long mNotesPtr;
        public Integer mWidth;
        public Integer mHeight;
        public Integer mNumPlanes;
        public Integer mNumChannels;
        public Long mChannelPtr;
        public Integer mNumTimepoints;
        public Integer mNumMasks;
        public Long mMaskPtr;
        public Integer mNumViews;
        public Long mViewPtr;
        public Integer mXYInterpolationFactor;
        public Integer mZInterpolationFactor;
        public Integer mImageGroupIndex;
        public Long mAnnotationTablePtr;
        public Long mElapsedTimeTablePtr;
        public Long mSAPositionTablePtr;
        public Long mStagePositionTablePtr;
        public Long mAuxDataTablePtr;
        public Integer mNumAuxDataTables;
        public Long[] mThumbNail;
        public Integer mElapsedTimeOffset;
        public String mName;
        public String mInfo;
        public String mUniqueId;
        CLensDef70 mLensDef;
        CMainViewRecord70 mMainViewRecord;
        COptovarDef70 mOptovarDef;

        CImageRecord70() {
        }

        @Override
        public int Decode(MappingNode inNode) {
            this.mLensDef = new CLensDef70();
            this.mMainViewRecord = new CMainViewRecord70();
            this.mOptovarDef = new COptovarDef70();
            int theLastIndex = super.Decode(inNode, 0);
            theLastIndex = this.mLensDef.Decode(inNode, theLastIndex);
            theLastIndex = this.mOptovarDef.Decode(inNode, theLastIndex);
            theLastIndex = this.mMainViewRecord.Decode(inNode, theLastIndex);
            return theLastIndex;
        }
    }

    class CHistogramRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mMin;
        public Integer mMax;
        public Float mMean;
        public Integer mHistogramType;
        public Integer mNumBins;
        public Integer mDataBlockSize;
        public Integer mChannelIndex;
        public Integer mImageIndex;

        CHistogramRecord70() {
        }
    }

    class CFRETManipRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mManipID;
        public Integer mFRETParadigm;
        public Float mFdDd;
        public Float mFaAa;
        public Float mDisplayLow;
        public Float mDisplayHigh;
        public Integer mDisplayNormalization;
        public Float mSignalThreshold;
        public Float mPhaseZero;
        public Float mModZero;
        public Float mDonor1Lifetime;
        public Float mDonor1X;
        public Float mDonor1Y;
        public Float mDonor2Lifetime;
        public Float mTwoLifetimeRatio;
        public Float mMainFrequency;
        public Boolean mPhaseFlatFieldCorrected;
        public Boolean mModulationFlatFieldCorrected;
        public Integer mNumPhases;
        public Integer mDarkValue;
        public Integer mFRETMethod;
        public Float mFRETAddParameter;

        CFRETManipRecord70() {
        }
    }

    class CFRAPRegionAnnotation70
    extends ClassDecoder {
        public String mXML;
        ArrayList<CCubeAnnotation70> mRegions;
        CAnnotation70 mAnn;

        CFRAPRegionAnnotation70() {
        }

        @Override
        public int Decode(MappingNode inNode, int inStartIndex) {
            this.mAnn = new CAnnotation70();
            int theLastIndex = super.Decode(inNode, inStartIndex);
            theLastIndex = this.mAnn.Decode(inNode, theLastIndex);
            IntIntPair theIIPair = this.GetIntegerValue(inNode, theLastIndex, "theNumRegions");
            Integer theNumRegions = theIIPair.mInt1;
            theLastIndex = theIIPair.mInt2;
            this.mRegions = new ArrayList();
            for (int theRegionIndex = 0; theRegionIndex < theNumRegions; ++theRegionIndex) {
                CCubeAnnotation70 theCubeAnnotation70 = new CCubeAnnotation70();
                theLastIndex = theCubeAnnotation70.Decode(inNode, theLastIndex);
                this.mRegions.add(theCubeAnnotation70);
            }
            return theLastIndex;
        }
    }

    class CFluorDef70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public String mName;
        public Integer mLaserPowerPos;
        public Integer mCameraBitDepth;
        public Integer mAuxFilterWheel7Pos;
        public Integer mNumExposuresAverage;
        public Float mExcitationLambda;
        public Integer mAuxFilterWheel5Pos;
        public Integer mAuxFilterWheel6Pos;
        public Float mLambda;
        public Integer mTurretPosition;
        public Boolean mUV;
        public Integer mImagingMode;
        public Integer mExcitationWheelPos;
        public Integer mEmissionWheelPos;
        public Integer mLightSource;
        public Boolean mTransmittedModePrompt;
        public Integer mLambdaOptions;
        public Integer mAuxFilterWheel4Pos;
        public Integer mDefaultColor;
        public Integer mChannelType;
        public Integer mLCDPos;
        public Integer mTIRFPos;
        public Float[] mRGBFactor;
        public Integer mFilterSet;
        public Integer mCamera;
        public Integer mOcularPhotoTurretPos;
        public Integer mCameraVideoTurretPos;
        public Integer mIlluminationMode;
        public Integer mAltSourcePosition;
        public Integer mCameraGain;
        public Integer mCameraSpeed;
        public Integer mCameraIntensification;
        public Integer mCameraPort;
        public Integer mCameraParameter1;
        public Integer mNDPos;
        public Integer mHue;
        public Integer mSaturation;
        public Integer mValue;
        public Integer mAuxFilterWheelPos;
        public Integer mDefaultColorDisplay;
        public Integer mAuxNDPos;
        public Integer mAuxFilterWheel2Pos;
        public Integer mAuxFilterWheel3Pos;

        CFluorDef70() {
        }
    }

    class CExposureRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Float mAuxZStartPosition;
        public Integer mExposureTime;
        public Integer mXOffset;
        public Integer mYOffset;
        public Integer mXExtent;
        public Integer mYExtent;
        public Boolean mBinning;
        public Boolean mTimeLapse;
        public Integer mCaptureType;
        public Integer mXFactor;
        public Integer mYFactor;
        public Integer mNumPlanes;
        public Integer mNuTSACSampleSize;
        public Boolean mScanning;
        public Float mInterplaneSpacing;
        public Float mInitialOffset;
        public Integer mTimeLapseInterval;
        public Integer mCaptureSetId;
        public Float mXStartPosition;
        public Float mYStartPosition;
        public Float mZStartPosition;
        public Integer mCaptureFlags;
        public Integer mAuxCaptureFlags;
        public Integer mMoveFieldRightSign;
        public Integer mMoveFieldDownSign;

        CExposureRecord70() {
        }
    }

    class CDataTableHeaderRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Long mParentRecordPtr;
        public Integer mChannelIndex;
        public Integer mRows;
        public Integer mColumns;
        public Integer mPlanes;
        public Integer mValueType;
        public Integer mTableType;
        public Integer mTimeBasis;
        public Integer mDescriptorVersion;
        public Integer mDescriptorSize;
        public Long mDescriptorFileOffset;
        public Integer mStartTime;
        public Integer mTimeInterval;
        public Integer mTimePointsWritten;
        public Integer mTimePointsTableSize;
        public Long mNextTableFileOffset;

        CDataTableHeaderRecord70() {
        }
    }

    class CCubeAnnotation70
    extends ClassDecoder {
        public Boolean mIsBackground;
        public Integer mRegionIndex;
        public Boolean mIsFRAP;
        public String mFRAPDevice;
        public Boolean mIsStimulation;
        public Boolean mIsLLS;
        public Boolean mIsNoLabel;
        public String mReservedBuf;
        public Boolean mIsIntSet;
        public Boolean mIsFloatSet;
        public Integer mIntData;
        public Float mFloatData;
        CAnnotation70 mAnn;

        CCubeAnnotation70() {
        }

        @Override
        public int Decode(MappingNode inNode, int inStartIndex) {
            this.mAnn = new CAnnotation70();
            int theLastIndex = super.Decode(inNode, inStartIndex);
            theLastIndex = this.mAnn.Decode(inNode, theLastIndex);
            return theLastIndex;
        }
    }

    class CCube
    extends ClassDecoder {
        public Integer mTopX;
        public Integer mTopY;
        public Integer mTopZ;
        public Integer mBottomX;
        public Integer mBottomY;
        public Integer mBottomZ;

        CCube() {
        }
    }

    class CChannelRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mNumPlanes;
        public Integer mNumManip;
        public Long mManipPtr;
        public Integer mDataType;
        public Long mDataTablePtr;
        public Long mHistogramTablePtr;
        public Long mHistogramSummaryPtr;
        public CExposureRecord70 mExposureRecord;
        public CChannelDef70 mChannelDef;

        CChannelRecord70() {
        }

        @Override
        public int Decode(MappingNode inNode, int inStartIndex) {
            this.mExposureRecord = new CExposureRecord70();
            this.mChannelDef = new CChannelDef70();
            int theLastIndex = super.Decode(inNode, inStartIndex);
            theLastIndex = this.mExposureRecord.Decode(inNode, theLastIndex);
            theLastIndex = this.mChannelDef.Decode(inNode, theLastIndex);
            return theLastIndex;
        }
    }

    class CChannelDef70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public String mName;
        public String mCameraName;
        public CFluorDef70 mFluorDef;

        CChannelDef70() {
        }

        @Override
        public int Decode(MappingNode inNode, int inStartIndex) {
            this.mFluorDef = new CFluorDef70();
            int theLastIndex = super.Decode(inNode, inStartIndex);
            theLastIndex = this.mFluorDef.Decode(inNode, theLastIndex);
            return theLastIndex;
        }
    }

    class CAnnotation70
    extends ClassDecoder {
        public Integer mGraphicType70;
        public Integer mDependencyType70;
        public String mText;
        public Boolean[] mChannelMask;
        public Integer mGroupId;
        public Integer mPlaneId;
        public Integer mSequenceId;
        public Integer mObjectId;
        public Integer mDependencyRef;
        public Integer mVersion;
        public Integer mByteOrdering;
        public CSBPoint<Double> mFieldOffsetMicrons;
        public Double mFieldMicronsPerPixel;
        public Boolean mFieldOffsetSet;
        public CSBPoint<Double> mStageOffsetMicrons;
        public Boolean mStageOffsetSet;
        public Boolean mZStageIncreaseTowardsSample;
        public Double mAuxZStageMicrons;
        public Boolean mAuxZStageMicronsSet;
        public Boolean mAuxZStageIncreaseTowardsSample;
        public Boolean mZStageDirectionsValid;
        public Boolean mStoreMicronPositions;
        public Double mRelativePower;
        public Integer mBorderFillPixels;
        public ArrayList<CSBPoint<Integer>> mVertexes;

        public CAnnotation70() {
            this.mFieldOffsetMicrons = new CSBPoint();
            this.mStageOffsetMicrons = new CSBPoint();
        }

        @Override
        protected void DecodeUnknownString(String inUnknownString, Node inAttrValueNode) {
            block4: {
                block2: {
                    String theAttrValue;
                    block6: {
                        block5: {
                            block3: {
                                LOGGER.trace("inUnknownString: " + inUnknownString);
                                if (!(inAttrValueNode instanceof ScalarNode)) break block2;
                                ScalarNode theAttrValueScalarNode = (ScalarNode)inAttrValueNode;
                                theAttrValue = theAttrValueScalarNode.getValue();
                                if (!inUnknownString.equals("mStageOffsetMicrons.mX")) break block3;
                                this.mStageOffsetMicrons.mX = Double.valueOf(theAttrValue);
                                break block4;
                            }
                            if (!inUnknownString.equals("mStageOffsetMicrons.mY")) break block5;
                            this.mStageOffsetMicrons.mY = Double.valueOf(theAttrValue);
                            break block4;
                        }
                        if (!inUnknownString.equals("mFieldOffsetMicrons.mX")) break block6;
                        this.mFieldOffsetMicrons.mX = Double.valueOf(theAttrValue);
                        break block4;
                    }
                    if (!inUnknownString.equals("mFieldOffsetMicrons.mY")) break block4;
                    this.mFieldOffsetMicrons.mY = Double.valueOf(theAttrValue);
                    break block4;
                }
                if (inAttrValueNode instanceof SequenceNode) {
                    Integer[] thePoints = this.GetIntegerArray(inAttrValueNode, "inUnknownString", false);
                    this.mVertexes = new ArrayList();
                    for (int theP = 0; theP < thePoints.length - 2; theP += 3) {
                        CSBPoint thePoint = new CSBPoint();
                        thePoint.mX = thePoints[theP];
                        thePoint.mY = thePoints[theP + 1];
                        thePoint.mZ = thePoints[theP + 2];
                        this.mVertexes.add(thePoint);
                    }
                }
            }
        }
    }

    class CAlignManipRecord70
    extends ClassDecoder {
        public Integer mStructID;
        public Integer mStructVersion;
        public Integer mByteOrdering;
        public Integer mStructLen;
        public Integer mManipID;
        public Float mXOffset;
        public Float mYOffset;
        public Float mZOffset;

        CAlignManipRecord70() {
        }
    }

    class CImageGroup
    extends ClassDecoder {
        ArrayList<CImageData> mImageDataList;
        ArrayList<CMaskPositions> mMaskPosList;
        ArrayList<CAnnotations> mAnnotationList;
        CImageRecord70 mImageRecord;
        ArrayList<CChannelRecord70> mChannelRecordList;
        ArrayList<CRemapChannelLUT70> mRemapChannelLUTList;
        ArrayList<CAlignManipRecord70> mAlignManipRecordList;
        ArrayList<CRatioManipRecord70> mRatioManipRecordList;
        ArrayList<CFRETManipRecord70> mFRETManipRecList;
        ArrayList<CRemapManipRecord70> mRemapManipRecList;
        ArrayList<CHistogramRecord70> mHistogramRecordList;
        ArrayList<CMaskRecord70> mMaskRecordList;
        Integer[] mElapsedTimes;
        ArrayList<Integer[]> mSAPositionList;
        ArrayList<CSBPoint<Float>> mStagePositions;
        ArrayList<CAuxFloatData> mAuxFloatDataList;
        ArrayList<CAuxDoubleData> mAuxDoubleDataList;
        ArrayList<CAuxSInt32Data> mAuxSInt32DataList;
        ArrayList<CAuxSInt64Data> mAuxSInt64DataList;
        ArrayList<CAuxXmlData> mAuxXmlDataList;
        CSBFile70 mFile;
        String mImageTitle;
        CNpyHeader mNpyHeader;
        CCompressionBase mCompressor;
        int mLastTimepoint;
        int mLastChannel;
        public Boolean mSingleTimepointFile;
        int mCompressionFlag;

        public CImageGroup(CSBFile70 inFile, String inImageTitle) {
            this.mFile = inFile;
            this.mImageTitle = inImageTitle;
            this.mSingleTimepointFile = false;
            this.mCompressionFlag = 0;
            this.mLastTimepoint = -1;
            this.mLastChannel = -1;
        }

        public Boolean Load() {
            Boolean theResult = false;
            LOGGER.trace("CImageGroup: Load");
            theResult = this.LoadImageRecord();
            LOGGER.trace("LoadImageRecord: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadChannelRecord();
            LOGGER.trace("LoadChannelRecord: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadMaks();
            LOGGER.trace("LoadMaks: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadAnnotations();
            LOGGER.trace("LoadAnnotations: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadElapsedTimes();
            LOGGER.trace("LoadElapsedTimes: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadSAPositions();
            LOGGER.trace("LoadSAPositions: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadStagePosition();
            LOGGER.trace("LoadStagePosition: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            theResult = this.LoadAuxData();
            LOGGER.trace("LoadAuxData: result " + theResult);
            if (!theResult.booleanValue()) {
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean LoadImageRecord() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "ImageRecord.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                Yaml yaml = new Yaml();
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                this.mImageRecord = new CImageRecord70();
                int theLastIndex = this.mImageRecord.Decode(theNode);
                LOGGER.trace("LoadImageRecord: theLastIndex " + theLastIndex);
                if (!this.CountImageDataFiles().booleanValue()) {
                    LOGGER.trace("CountImageDataFiles: Did not succeed ");
                    Boolean bl = false;
                    return bl;
                }
                LOGGER.trace("CountImageDataFiles: OK ");
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        public int IsSFMT(String inPath) throws IOException {
            int theNumTimepoints;
            RandomAccessInputStream theStream = new RandomAccessInputStream(inPath);
            CNpyHeader theNpyHeader = new CNpyHeader();
            boolean theRes = theNpyHeader.ParseNpyHeader(theStream);
            theStream.close();
            if (!theRes) {
                return -1;
            }
            if (theNpyHeader.mShape.length == 3 && (theNumTimepoints = theNpyHeader.mShape[0].intValue()) > 1) {
                return theNumTimepoints;
            }
            return -1;
        }

        public Boolean CountImageDataFiles() {
            String[] theImageFileNames = this.mFile.GetListOfImageDataFiles(this.mImageTitle);
            LOGGER.trace("CountImageDataFiles: theImageFileNames.length " + theImageFileNames.length);
            LOGGER.trace("CountImageDataFiles: mImageRecord.mNumChannels " + this.mImageRecord.mNumChannels);
            LOGGER.trace("CountImageDataFiles: mImageRecord.mNumTimepoints " + this.mImageRecord.mNumTimepoints);
            if (theImageFileNames.length == this.mImageRecord.mNumChannels * this.mImageRecord.mNumTimepoints) {
                return true;
            }
            if (theImageFileNames.length == this.mImageRecord.mNumChannels && this.mImageRecord.mNumPlanes == 1) {
                int theNumTimepoints = 0;
                for (int theFile = 0; theFile < theImageFileNames.length; ++theFile) {
                    int theShapeTP = -1;
                    try {
                        theShapeTP = this.IsSFMT(theImageFileNames[theFile]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (theShapeTP < 0 || theNumTimepoints >= theShapeTP) continue;
                    theNumTimepoints = theShapeTP;
                }
                if (theNumTimepoints == 0) {
                    theNumTimepoints = 1;
                }
                if (theNumTimepoints > 1) {
                    this.mSingleTimepointFile = true;
                }
                this.mImageRecord.mNumTimepoints = theNumTimepoints;
                return true;
            }
            Integer theMaxChannel = 0;
            Integer theMaxTimepoint = 0;
            for (int theFileIndex = 0; theFileIndex < theImageFileNames.length; ++theFileIndex) {
                LOGGER.trace("CountImageDataFiles: theFileIndex: " + theFileIndex + " " + theImageFileNames[theFileIndex]);
                Integer theChannel = this.mFile.GetChannelIndexOfPath(theImageFileNames[theFileIndex]);
                Integer theTimepoint = this.mFile.GetTimepointOfPath(theImageFileNames[theFileIndex]);
                theMaxChannel = Integer.max(theMaxChannel, theChannel + 1);
                theMaxTimepoint = Integer.max(theMaxTimepoint, theTimepoint + 1);
            }
            LOGGER.trace("CountImageDataFiles: theMaxChannel + theMaxTimepoint " + theMaxChannel + " " + theMaxTimepoint);
            if (theMaxChannel == 0 || theMaxTimepoint == 0) {
                LOGGER.trace("CountImageDataFiles: theMaxChannel + theMaxTimepoint " + theMaxChannel + theMaxTimepoint);
                return false;
            }
            this.mImageRecord.mNumTimepoints = theMaxTimepoint;
            this.mImageRecord.mNumChannels = theMaxChannel;
            this.mImageDataList = new ArrayList();
            for (int theTimepoint = 0; theTimepoint < this.mImageRecord.mNumTimepoints; ++theTimepoint) {
                this.mImageDataList.add(new CImageData());
            }
            LOGGER.trace("CountImageDataFiles: mImageDataList.length " + this.mImageDataList.size());
            return true;
        }

        public Boolean LoadChannelRecord() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "ChannelRecord.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "ChannelRecord.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                int theLastIndex = 0;
                this.mChannelRecordList = new ArrayList();
                this.mRemapChannelLUTList = new ArrayList();
                this.mAlignManipRecordList = new ArrayList();
                this.mRatioManipRecordList = new ArrayList();
                this.mFRETManipRecList = new ArrayList();
                this.mRemapManipRecList = new ArrayList();
                this.mHistogramRecordList = new ArrayList();
                block20: for (int theChannel = 0; theChannel < this.mImageRecord.mNumChannels; ++theChannel) {
                    CChannelRecord70 theChannelRecord = new CChannelRecord70();
                    this.mChannelRecordList.add(theChannelRecord);
                    CRemapChannelLUT70 theRemapChannelLUT = new CRemapChannelLUT70();
                    CAlignManipRecord70 theAlignManipRecord70 = new CAlignManipRecord70();
                    CRatioManipRecord70 theRatioManipRecord70 = new CRatioManipRecord70();
                    CFRETManipRecord70 theFRETManipRec70 = new CFRETManipRecord70();
                    CRemapManipRecord70 theRemapManipRec70 = new CRemapManipRecord70();
                    CHistogramRecord70 theHistogramRecord70 = new CHistogramRecord70();
                    theLastIndex = theChannelRecord.Decode(theNode, theLastIndex);
                    LOGGER.trace("theLastIndex: " + theLastIndex);
                    while (true) {
                        StrIntPair thePair = this.FindNextClass(theNode, theLastIndex);
                        if (thePair.mInt < 0) continue block20;
                        if (thePair.mStr.equals(theChannelRecord.GetSBClassName())) {
                            theLastIndex = thePair.mInt;
                            continue block20;
                        }
                        if (thePair.mStr.equals(theRemapChannelLUT.GetSBClassName())) {
                            theLastIndex = theRemapChannelLUT.Decode(theNode, thePair.mInt);
                            this.mRemapChannelLUTList.add(theRemapChannelLUT);
                            continue;
                        }
                        if (thePair.mStr.equals(theAlignManipRecord70.GetSBClassName())) {
                            theLastIndex = theAlignManipRecord70.Decode(theNode, thePair.mInt);
                            this.mAlignManipRecordList.add(theAlignManipRecord70);
                            continue;
                        }
                        if (thePair.mStr.equals(theRatioManipRecord70.GetSBClassName())) {
                            theLastIndex = theRatioManipRecord70.Decode(theNode, thePair.mInt);
                            this.mRatioManipRecordList.add(theRatioManipRecord70);
                            continue;
                        }
                        if (thePair.mStr.equals(theFRETManipRec70.GetSBClassName())) {
                            theLastIndex = theFRETManipRec70.Decode(theNode, thePair.mInt);
                            this.mFRETManipRecList.add(theFRETManipRec70);
                            continue;
                        }
                        if (thePair.mStr.equals(theRemapManipRec70.GetSBClassName())) {
                            theLastIndex = theRemapManipRec70.Decode(theNode, thePair.mInt);
                            this.mRemapManipRecList.add(theRemapManipRec70);
                            continue;
                        }
                        if (!thePair.mStr.equals(theHistogramRecord70.GetSBClassName())) continue;
                        theLastIndex = theHistogramRecord70.Decode(theNode, thePair.mInt);
                        this.mHistogramRecordList.add(theHistogramRecord70);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean LoadMaks() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "MaskRecord.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "MaskRecord.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                int theLastIndex = 0;
                List theValueClassList = theNode.getValue();
                ScalarNode theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                String theKey = theKeyNode.getValue();
                if (!theKey.equals("theNumMasks")) return true;
                ScalarNode theValueNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                String theValue = theValueNode.getValue();
                Integer theNumMasks = Integer.valueOf(theValue);
                this.mMaskRecordList = new ArrayList();
                if (theNumMasks <= 0) {
                    Boolean theMask = true;
                    return theMask;
                }
                theLastIndex = 1;
                for (int theMask = 0; theMask < theNumMasks; ++theMask) {
                    CMaskRecord70 theMaskRecord = new CMaskRecord70();
                    theLastIndex = theMaskRecord.Decode(theNode, theLastIndex);
                    this.mMaskRecordList.add(theMaskRecord);
                }
                this.mMaskPosList = new ArrayList();
                while (theLastIndex < theValueClassList.size()) {
                    IntIntPair theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theTimepointIndex");
                    theLastIndex = theIIPair.mInt2;
                    if (theLastIndex < 0) {
                        return true;
                    }
                    CMaskPositions thePos = new CMaskPositions();
                    theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                    theKey = theKeyNode.getValue();
                    if (!theKey.equals("theMaskCompressedSizes")) {
                        return true;
                    }
                    Node theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    thePos.mCompressedSizes = this.GetLongArray(theCurrentNode, "theMaskCompressedSizes", true);
                    if (!(theKey = (theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(++theLastIndex)).getKeyNode()).getValue()).equals("theMaskFileOffsets")) {
                        return true;
                    }
                    theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    thePos.mFileOffsets = this.GetLongArray(theCurrentNode, "theMaskFileOffsets", true);
                    ++theLastIndex;
                    this.mMaskPosList.add(thePos);
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        public Boolean LoadAnnotations() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "AnnotationRecord.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "AnnotationRecord.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                int theLastIndex = 0;
                CDataTableHeaderRecord70 theDataTableHeaderRecord70 = new CDataTableHeaderRecord70();
                theLastIndex = theDataTableHeaderRecord70.Decode(theNode);
                this.mAnnotationList = new ArrayList();
                while (true) {
                    IntIntPair theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theTimepointIndex");
                    theLastIndex = theIIPair.mInt2;
                    if (theLastIndex < 0) {
                        break;
                    }
                    CAnnotations theAnno = new CAnnotations();
                    theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theCubeAnnotation70ListSize");
                    Integer theCubeAnnotation70ListSize = theIIPair.mInt1;
                    theLastIndex = theIIPair.mInt2;
                    for (int theAnnotationIndex = 0; theAnnotationIndex < theCubeAnnotation70ListSize; ++theAnnotationIndex) {
                        CCubeAnnotation70 theCubeAnnotation70 = new CCubeAnnotation70();
                        theLastIndex = theCubeAnnotation70.Decode(theNode, theLastIndex);
                        theAnno.mCubeAnnotationList.add(theCubeAnnotation70);
                    }
                    theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theAnnotation70ListSize");
                    Integer theAnnotation70ListSize = theIIPair.mInt1;
                    theLastIndex = theIIPair.mInt2;
                    for (int theAnnotationIndex = 0; theAnnotationIndex < theAnnotation70ListSize; ++theAnnotationIndex) {
                        CAnnotation70 theAnnotation70 = new CAnnotation70();
                        theLastIndex = theAnnotation70.Decode(theNode, theLastIndex);
                        theAnno.mBaseAnnotationList.add(theAnnotation70);
                    }
                    theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theFRAPRegionAnnotation70ListSize");
                    Integer theFRAPRegionAnnotation70ListSize = theIIPair.mInt1;
                    theLastIndex = theIIPair.mInt2;
                    for (int theAnnotationIndex = 0; theAnnotationIndex < theFRAPRegionAnnotation70ListSize; ++theAnnotationIndex) {
                        CFRAPRegionAnnotation70 theFRAPRegionAnnotation70 = new CFRAPRegionAnnotation70();
                        theLastIndex = theFRAPRegionAnnotation70.Decode(theNode, theLastIndex);
                        theAnno.mFRAPRegionAnnotationList.add(theFRAPRegionAnnotation70);
                    }
                    theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theUnknownAnnotation70ListSize");
                    Integer theUnknownAnnotation70ListSize = theIIPair.mInt1;
                    theLastIndex = theIIPair.mInt2;
                    for (int theAnnotationIndex = 0; theAnnotationIndex < theUnknownAnnotation70ListSize; ++theAnnotationIndex) {
                        CUnknownAnnotation70 theUnknownAnnotation70 = new CUnknownAnnotation70();
                        theLastIndex = theUnknownAnnotation70.Decode(theNode, theLastIndex);
                        theAnno.mUnknownAnnotationList.add(theUnknownAnnotation70);
                    }
                    this.mAnnotationList.add(theAnno);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.trace("LoadAnnotations: FileNotFoundException loading error: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
            catch (Exception e) {
                LOGGER.trace("LoadAnnotations: Exception loading error: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean LoadElapsedTimes() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "ElapsedTimes.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "ElapsedTimes.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                int theLastIndex = 0;
                List theValueClassList = theNode.getValue();
                ScalarNode theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                String theKey = theKeyNode.getValue();
                if (!theKey.equals("theElapsedTimes")) {
                    Boolean bl = false;
                    return bl;
                }
                Node theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                this.mElapsedTimes = this.GetIntegerArray(theCurrentNode, "theElapsedTimesVector", true);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean LoadSAPositions() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "SAPositionData.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "SAPositionData.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                List theValueClassList = theNode.getValue();
                int theLastIndex = 0;
                IntIntPair theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theImageCount");
                Integer theImageCount = theIIPair.mInt1;
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean bl = true;
                    return bl;
                }
                this.mSAPositionList = new ArrayList();
                int theImageIndex = 0;
                while (theImageIndex < theImageCount) {
                    ScalarNode theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                    String theKey = theKeyNode.getValue();
                    if (!theKey.equals("theSAPositions")) {
                        return true;
                    }
                    Node theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    Integer[] theSAPositionsvector = this.GetIntegerArray(theCurrentNode, "theSAPositions", true);
                    this.mSAPositionList.add(theSAPositionsvector);
                    ++theLastIndex;
                    ++theImageIndex;
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean LoadStagePosition() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "StagePositionData.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "StagePositionData.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                List theValueClassList = theNode.getValue();
                int theLastIndex = 0;
                IntIntPair theIIPair = this.GetIntegerValue(theNode, theLastIndex, "StructArraySize");
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean bl = true;
                    return bl;
                }
                this.mStagePositions = new ArrayList();
                ScalarNode theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                String theKey = theKeyNode.getValue();
                if (!theKey.equals("StructArrayValues")) {
                    Boolean bl = false;
                    return bl;
                }
                Node theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                Float[] thePoints = this.GetFloatArray(theCurrentNode, "theStagePositionData", false);
                for (int theP = 0; theP < thePoints.length - 2; theP += 3) {
                    CSBPoint thePoint = new CSBPoint();
                    thePoint.mX = thePoints[theP];
                    thePoint.mY = thePoints[theP + 1];
                    thePoint.mZ = thePoints[theP + 2];
                    this.mStagePositions.add(thePoint);
                }
                ++theLastIndex;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean LoadAuxData() {
            try (FileInputStream inputStream = new FileInputStream(this.mFile.GetImageGroupDirectory(this.mImageTitle) + "AuxData.yaml");
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                Node theCurrentNode;
                String theKey;
                ScalarNode theKeyNode;
                StrIntPair theSIPair;
                CDataTableHeaderRecord70 theAuxDataTable70;
                Object theAux;
                int theTableIndex2;
                String thePath = this.mFile.GetImageGroupDirectory(this.mImageTitle) + "AuxData.yaml";
                File fil = new File(thePath);
                long length = fil.length();
                LoaderOptions loadingConfig = new LoaderOptions();
                loadingConfig.setCodePointLimit((int)length + 10000);
                Yaml yaml = new Yaml(loadingConfig);
                MappingNode theNode = (MappingNode)yaml.compose((Reader)inputStreamReader);
                List theValueClassList = theNode.getValue();
                int theLastIndex = 0;
                IntIntPair theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theAuxFloatDataTablesSize");
                Integer theTableCount = theIIPair.mInt1;
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean bl = true;
                    return bl;
                }
                this.mAuxFloatDataList = new ArrayList();
                for (theTableIndex2 = 0; theTableIndex2 < theTableCount; ++theLastIndex, ++theTableIndex2) {
                    theAux = new CAuxFloatData();
                    theAuxDataTable70 = new CDataTableHeaderRecord70();
                    theLastIndex = theAuxDataTable70.Decode(theNode, theLastIndex);
                    theSIPair = this.GetStringValue(theNode, theLastIndex, "theXMLDescriptor", true);
                    ((CAuxFloatData)theAux).mXmlDescriptor = theSIPair.mStr;
                    theLastIndex = theSIPair.mInt;
                    theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                    theKey = theKeyNode.getValue();
                    if (!theKey.equals("theAuxData")) {
                        Boolean bl = false;
                        return bl;
                    }
                    theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    ((CAuxFloatData)theAux).mFloatData = this.GetFloatArray(theCurrentNode, "theAuxFloatData", true);
                    this.mAuxFloatDataList.add((CAuxFloatData)theAux);
                }
                theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theAuxDoubleDataTablesSize");
                theTableCount = theIIPair.mInt1;
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean theTableIndex2 = true;
                    return theTableIndex2;
                }
                this.mAuxDoubleDataList = new ArrayList();
                for (theTableIndex2 = 0; theTableIndex2 < theTableCount; ++theLastIndex, ++theTableIndex2) {
                    theAux = new CAuxDoubleData();
                    theAuxDataTable70 = new CDataTableHeaderRecord70();
                    theLastIndex = theAuxDataTable70.Decode(theNode, theLastIndex);
                    theSIPair = this.GetStringValue(theNode, theLastIndex, "theXMLDescriptor", true);
                    ((CAuxDoubleData)theAux).mXmlDescriptor = theSIPair.mStr;
                    theLastIndex = theSIPair.mInt;
                    theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                    theKey = theKeyNode.getValue();
                    if (!theKey.equals("theAuxData")) {
                        Boolean bl = false;
                        return bl;
                    }
                    theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    ((CAuxDoubleData)theAux).mDoubleData = this.GetDoubleArray(theCurrentNode, "theAuxDoubleData", true);
                    this.mAuxDoubleDataList.add((CAuxDoubleData)theAux);
                }
                theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theAuxSInt32DataTablesSize");
                theTableCount = theIIPair.mInt1;
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean theTableIndex3 = true;
                    return theTableIndex3;
                }
                this.mAuxSInt32DataList = new ArrayList();
                for (theTableIndex2 = 0; theTableIndex2 < theTableCount; ++theLastIndex, ++theTableIndex2) {
                    theAux = new CAuxSInt32Data();
                    theAuxDataTable70 = new CDataTableHeaderRecord70();
                    theLastIndex = theAuxDataTable70.Decode(theNode, theLastIndex);
                    theSIPair = this.GetStringValue(theNode, theLastIndex, "theXMLDescriptor", true);
                    ((CAuxSInt32Data)theAux).mXmlDescriptor = theSIPair.mStr;
                    theLastIndex = theSIPair.mInt;
                    theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                    theKey = theKeyNode.getValue();
                    if (!theKey.equals("theAuxData")) {
                        Boolean bl = false;
                        return bl;
                    }
                    theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    ((CAuxSInt32Data)theAux).mIntegerData = this.GetIntegerArray(theCurrentNode, "theAuxSInt32Data", true);
                    this.mAuxSInt32DataList.add((CAuxSInt32Data)theAux);
                }
                theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theAuxSInt64DataTablesSize");
                theTableCount = theIIPair.mInt1;
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean theTableIndex4 = true;
                    return theTableIndex4;
                }
                this.mAuxSInt64DataList = new ArrayList();
                for (theTableIndex2 = 0; theTableIndex2 < theTableCount; ++theLastIndex, ++theTableIndex2) {
                    theAux = new CAuxSInt64Data();
                    theAuxDataTable70 = new CDataTableHeaderRecord70();
                    theLastIndex = theAuxDataTable70.Decode(theNode, theLastIndex);
                    theSIPair = this.GetStringValue(theNode, theLastIndex, "theXMLDescriptor", true);
                    ((CAuxSInt64Data)theAux).mXmlDescriptor = theSIPair.mStr;
                    theLastIndex = theSIPair.mInt;
                    theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theLastIndex)).getKeyNode();
                    theKey = theKeyNode.getValue();
                    if (!theKey.equals("theAuxData")) {
                        Boolean bl = false;
                        return bl;
                    }
                    theCurrentNode = ((NodeTuple)theValueClassList.get(theLastIndex)).getValueNode();
                    ((CAuxSInt64Data)theAux).mLongData = this.GetLongArray(theCurrentNode, "theAuxSInt64Data", true);
                    this.mAuxSInt64DataList.add((CAuxSInt64Data)theAux);
                }
                theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theAuxSerializedDataTablesSize");
                theTableCount = theIIPair.mInt1;
                theLastIndex = theIIPair.mInt2;
                if (theLastIndex < 0) {
                    Boolean theTableIndex5 = true;
                    return theTableIndex5;
                }
                this.mAuxXmlDataList = new ArrayList();
                theTableIndex2 = 0;
                while (theTableIndex2 < theTableCount) {
                    theAux = new CAuxXmlData();
                    theAuxDataTable70 = new CDataTableHeaderRecord70();
                    theLastIndex = theAuxDataTable70.Decode(theNode, theLastIndex);
                    theSIPair = this.GetStringValue(theNode, theLastIndex, "theXMLDescriptor", true);
                    theLastIndex = theSIPair.mInt;
                    theIIPair = this.GetIntegerValue(theNode, theLastIndex, "theXmlAuxDataSize");
                    theLastIndex = theIIPair.mInt2;
                    theSIPair = this.GetStringValue(theNode, theLastIndex, "theXmlAuxData", true);
                    ((CAuxXmlData)theAux).mXmlData = theSIPair.mStr;
                    theLastIndex = theSIPair.mInt;
                    this.mAuxXmlDataList.add((CAuxXmlData)theAux);
                    ++theTableIndex2;
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        public int GetNumChannels() {
            return this.mImageRecord.mNumChannels;
        }

        public int GetNumColumns() {
            return this.mImageRecord.mWidth;
        }

        public int GetNumRows() {
            return this.mImageRecord.mHeight;
        }

        public int GetNumPlanes() {
            return this.mImageRecord.mNumPlanes;
        }

        public int GetNumPositions() {
            int theNumStagePositions = this.mStagePositions.size();
            if (theNumStagePositions <= 1) {
                return 1;
            }
            CSBPoint<Float> thePoint0 = this.mStagePositions.get(0);
            LOGGER.trace("GetNumPositions: thePoint0 mX=" + thePoint0.mX + ", mY=" + thePoint0.mY);
            int theNumUniquePositions = 1;
            for (int thePosition = 1; thePosition < theNumStagePositions; ++thePosition) {
                CSBPoint<Float> thePoint1 = this.mStagePositions.get(thePosition);
                LOGGER.trace("GetNumPositions: thePoint1 mX=" + thePoint1.mX + ", mY=" + thePoint1.mY);
                if (((Float)thePoint0.mX).equals(thePoint1.mX) && ((Float)thePoint0.mY).equals(thePoint1.mY)) break;
                ++theNumUniquePositions;
            }
            LOGGER.trace("GetNumPositions: theNumUniquePositions=" + theNumUniquePositions);
            return theNumUniquePositions;
        }

        public int GetNumTimepoints() {
            return this.mImageRecord.mNumTimepoints;
        }

        public int GetElapsedTime(int inTimepoint) {
            return this.mElapsedTimes[inTimepoint];
        }

        public int GetBytesPerPixel() {
            return 2;
        }

        public String GetName() {
            return this.mImageRecord.mName;
        }

        public String GetInfo() {
            return this.mImageRecord.mInfo;
        }

        public String GetChannelName(int inChannel) {
            return this.mChannelRecordList.get((int)inChannel).mChannelDef.mName;
        }

        public String GetLensName() {
            return this.mImageRecord.mLensDef.mName;
        }

        public double GetMagnification() {
            return this.mImageRecord.mLensDef.mActualMagnification.floatValue() * this.mImageRecord.mOptovarDef.mMagnification.floatValue();
        }

        public float GetVoxelSize() {
            float theXFactor;
            float theSize = this.mImageRecord.mLensDef.mMicronPerPixel.floatValue();
            if (this.mImageRecord.mOptovarDef.mMagnification.floatValue() > 0.0f) {
                theSize /= this.mImageRecord.mOptovarDef.mMagnification.floatValue();
            }
            if ((theXFactor = (float)this.mChannelRecordList.get((int)0).mExposureRecord.mXFactor.intValue()) > 0.0f) {
                theSize *= theXFactor;
            }
            return theSize;
        }

        public float GetInterplaneSpacing() {
            return this.mChannelRecordList.get((int)0).mExposureRecord.mInterplaneSpacing.floatValue();
        }

        public int GetExposureTime(int inChannel) {
            return this.mChannelRecordList.get((int)inChannel).mExposureRecord.mExposureTime;
        }

        public float GetXPosition(int inPosition) {
            CSBPoint<Float> thePoint = this.mStagePositions.get(inPosition);
            return ((Float)thePoint.mX).floatValue();
        }

        public float GetYPosition(int inPosition) {
            CSBPoint<Float> thePoint = this.mStagePositions.get(inPosition);
            return ((Float)thePoint.mY).floatValue();
        }

        public float GetZPosition(int inPosition, int zplane) {
            CSBPoint<Float> thePoint = this.mStagePositions.get(inPosition);
            return ((Float)thePoint.mZ).floatValue() + this.GetInterplaneSpacing() * (float)zplane;
        }

        public Boolean GetSingleTimepointFile() {
            return this.mSingleTimepointFile;
        }

        class CAuxXmlData {
            String mXmlData;

            CAuxXmlData() {
            }
        }

        class CAuxSInt64Data {
            String mXmlDescriptor;
            Long[] mLongData;

            CAuxSInt64Data() {
            }
        }

        class CAuxSInt32Data {
            String mXmlDescriptor;
            Integer[] mIntegerData;

            CAuxSInt32Data() {
            }
        }

        class CAuxDoubleData {
            String mXmlDescriptor;
            Double[] mDoubleData;

            CAuxDoubleData() {
            }
        }

        class CAuxFloatData {
            String mXmlDescriptor;
            Float[] mFloatData;

            CAuxFloatData() {
            }
        }

        class CAnnotations {
            ArrayList<CCubeAnnotation70> mCubeAnnotationList = new ArrayList();
            ArrayList<CAnnotation70> mBaseAnnotationList = new ArrayList();
            ArrayList<CFRAPRegionAnnotation70> mFRAPRegionAnnotationList = new ArrayList();
            ArrayList<CUnknownAnnotation70> mUnknownAnnotationList = new ArrayList();
        }

        class CMaskPositions {
            Long[] mCompressedSizes;
            Long[] mFileOffsets;

            CMaskPositions() {
            }
        }
    }

    class CImageData {
        CImageData() {
        }
    }

    class CSBPoint<T> {
        public T mX;
        public T mY;
        public T mZ;

        CSBPoint() {
        }
    }

    class CNpyHeader {
        Boolean mLittleEndian;
        Boolean mFortranOrder;
        Integer[] mShape;
        Integer mHeaderSize;
        String mDataType;
        Integer mBytesPerPixel;
        int mCompressionFlag;
        byte mMajorVersion;
        byte mMinorVersion;

        CNpyHeader() {
        }

        public Boolean ParseNpyHeader(RandomAccessInputStream inStream) {
            try {
                Integer n;
                Integer n2;
                inStream.seek(0L);
                byte[] theBuffer = new byte[1025];
                theBuffer[1024] = 0;
                theBuffer[0] = 0;
                boolean theEOL = false;
                this.mHeaderSize = 0;
                while (this.mHeaderSize < 1024) {
                    theBuffer[this.mHeaderSize.intValue()] = inStream.readByte();
                    if ((char)theBuffer[this.mHeaderSize] == '\n') {
                        theEOL = true;
                        break;
                    }
                    n2 = this.mHeaderSize;
                    n = this.mHeaderSize = Integer.valueOf(this.mHeaderSize + 1);
                }
                n2 = this.mHeaderSize;
                n = this.mHeaderSize = Integer.valueOf(this.mHeaderSize + 1);
                if (!theEOL) {
                    LOGGER.trace("No carriage return");
                    return false;
                }
                this.mMajorVersion = theBuffer[6];
                this.mMinorVersion = theBuffer[7];
                this.mCompressionFlag = this.mMinorVersion;
                LOGGER.trace("ParseNpyHeader mCompressionFlag " + this.mCompressionFlag);
                short theHeaderLen = this.ByteArrayToShort(theBuffer, 8);
                LOGGER.trace("Header length: " + theHeaderLen);
                String theHeader = new String(theBuffer, 10, (int)theHeaderLen);
                LOGGER.trace("Header : " + theHeader);
                int loc1 = theHeader.indexOf("descr") + 9;
                String theEndianess = theHeader.substring(loc1, loc1 + 1);
                this.mLittleEndian = false;
                if (theEndianess.equals("<")) {
                    this.mLittleEndian = true;
                }
                this.mDataType = theHeader.substring(loc1 + 1, loc1 + 3);
                this.mBytesPerPixel = 2;
                if (this.mDataType.equals("u2") || this.mDataType.equals("i2")) {
                    this.mBytesPerPixel = 2;
                } else if (this.mDataType.equals("u4") || this.mDataType.equals("i4")) {
                    this.mBytesPerPixel = 4;
                }
                loc1 = theHeader.indexOf("fortran_order") + 16;
                String theFortranOrder = theHeader.substring(loc1, loc1 + 4);
                this.mFortranOrder = false;
                if (theFortranOrder.equals("True")) {
                    this.mFortranOrder = true;
                }
                loc1 = theHeader.indexOf("(");
                int loc2 = theHeader.indexOf(")");
                String theShape = theHeader.substring(loc1 + 1, loc2);
                String[] theDims = theShape.split(",", 10);
                this.mShape = new Integer[theDims.length];
                for (int theI = 0; theI < theDims.length; ++theI) {
                    String theTrim = theDims[theI].trim();
                    this.mShape[theI] = Integer.valueOf(theTrim);
                }
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }

        short ByteArrayToShort(byte[] bytes, int offset) {
            int theVal = (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 0] & 0xFF) << 0;
            return (short)theVal;
        }

        int ByteArrayToInt(byte[] bytes, int offset) {
            return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 0] & 0xFF) << 0;
        }
    }

    class CSBFile70 {
        public static final String kSlideSuffix = ".sldy";
        public static final String kZSlideSuffix = ".sldyz";
        public static final String kRootDirSuffix = ".dir";
        public static final String kImageDirSuffix = ".imgdir";
        public static final String kBinaryFileSuffix = ".npy";
        public static final String kZBinaryFileSuffix = ".npyz";
        public static final String kImageRecordFilename = "ImageRecord.yaml";
        public static final String kChannelRecordFilename = "ChannelRecord.yaml";
        public static final String kAnnotationRecordFilename = "AnnotationRecord.yaml";
        public static final String kMaskRecordFilename = "MaskRecord.yaml";
        public static final String kAuxDataFilename = "AuxData.yaml";
        public static final String kElapsedTimesFilename = "ElapsedTimes.yaml";
        public static final String kSAPositionDataFilename = "SAPositionData.yaml";
        public static final String kStagePositionDataFilename = "StagePositionData.yaml";
        public static final int kNumDigitsInTimepoint = 7;
        public String mSlidePath;
        public boolean mIsCompressed;

        public CSBFile70(String inSlidePath) {
            this.mSlidePath = inSlidePath;
            this.mIsCompressed = false;
            if (this.mSlidePath.endsWith(kZSlideSuffix)) {
                this.mIsCompressed = true;
            }
        }

        public String GetSlideRootDirectory() {
            String theRootDirectory = !this.mIsCompressed ? this.mSlidePath.replaceAll(".sldy$", kRootDirSuffix) : this.mSlidePath.replaceAll(".sldyz$", kRootDirSuffix);
            return theRootDirectory;
        }

        public String[] GetListOfImageGroupTitles() {
            String theRootDirectory = this.GetSlideRootDirectory();
            File[] theDirectories = new File(theRootDirectory).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (!file.isDirectory()) {
                        return false;
                    }
                    String theDir = file.getAbsolutePath();
                    if (!theDir.endsWith(CSBFile70.kImageDirSuffix)) {
                        return false;
                    }
                    File theImgRecFile = new File(theDir + File.separator + CSBFile70.kImageRecordFilename);
                    if (!theImgRecFile.exists()) {
                        return false;
                    }
                    File[] theFiles = new File(theDir).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            String thePath = file.getAbsolutePath();
                            if (thePath.endsWith(CSBFile70.kBinaryFileSuffix)) {
                                return true;
                            }
                            return thePath.endsWith(CSBFile70.kZBinaryFileSuffix);
                        }
                    });
                    return theFiles.length != 0;
                }
            });
            if (theDirectories.length == 0) {
                LOGGER.info("GetListOfImageGroupTitles: found no directories");
                String[] none = new String[]{};
                return none;
            }
            String[] theTitles = new String[theDirectories.length];
            for (int theDir = 0; theDir < theDirectories.length; ++theDir) {
                String thePath = theDirectories[theDir].getAbsolutePath();
                thePath = thePath.replaceAll("\\\\", "/");
                thePath = thePath.replaceAll(".*/", "");
                theTitles[theDir] = thePath = thePath.replaceAll("\\.imgdir", "");
            }
            return theTitles;
        }

        public String GetImageGroupDirectory(String inTitle) {
            if (inTitle == null) {
                return null;
            }
            String theRootDirectory = this.GetSlideRootDirectory();
            String theImageGroupDirectory = theRootDirectory + File.separator + inTitle + kImageDirSuffix + File.separator;
            return theImageGroupDirectory;
        }

        public String GetImageDataFile(String inTitle, Integer inChannel, Integer inTimepoint) {
            if (inTitle == null) {
                return null;
            }
            String theImageGroupDirectory = this.GetImageGroupDirectory(inTitle);
            String theSuffix = kBinaryFileSuffix;
            if (this.mIsCompressed) {
                theSuffix = kZBinaryFileSuffix;
            }
            String thePath = String.format("%s%s%s_Ch%1d_TP%07d%s", theImageGroupDirectory, File.separator, "ImageData", inChannel, inTimepoint, theSuffix);
            return thePath;
        }

        public String GetMaskDataFile(String inTitle, Integer inTimepoint) {
            if (inTitle == null) {
                return null;
            }
            String theImageGroupDirectory = this.GetImageGroupDirectory(inTitle);
            String thePath = String.format("%s%s%s_TP%07d%s", theImageGroupDirectory, File.separator, "MaskData", inTimepoint, kBinaryFileSuffix);
            return thePath;
        }

        public String GetHistogramDataFile(String inTitle, Integer inChannel, Integer inTimepoint) {
            String theImageGroupDirectory = this.GetImageGroupDirectory(inTitle);
            String thePath = inTimepoint >= 0 ? String.format("%s%s%s_Ch%1d_TP%07d%s", theImageGroupDirectory, File.separator, "HistogramData", inChannel, inTimepoint, kBinaryFileSuffix) : String.format("%s%s%s_Ch%1d%s", theImageGroupDirectory, File.separator, "HistogramSummary", inChannel, kBinaryFileSuffix);
            return thePath;
        }

        public Integer GetChannelIndexOfPath(String inPath) {
            int thePos = inPath.lastIndexOf("_Ch");
            LOGGER.trace("GetChannelIndexOfPath: thePath: " + inPath + " thePos " + thePos);
            if (thePos == -1) {
                return -1;
            }
            String theDigit = inPath.substring(thePos + 3, thePos + 4);
            LOGGER.trace("GetChannelIndexOfPath: theDigit ", (Object)theDigit);
            Integer theChannel = Integer.valueOf(theDigit);
            return theChannel;
        }

        public Integer GetTimepointOfPath(String inPath) {
            int thePos = inPath.lastIndexOf("_TP");
            if (thePos == -1) {
                return -1;
            }
            String theDigit = inPath.substring(thePos + 3, thePos + 3 + 7);
            LOGGER.trace("GetTimepointOfPath: theDigit ", (Object)theDigit);
            Integer theTimepoint = Integer.valueOf(theDigit);
            return theTimepoint;
        }

        public String RenamePathToTimepoint0(String inPath) {
            String ouPath = inPath;
            int thePos = inPath.lastIndexOf("_TP");
            if (thePos == -1) {
                return ouPath;
            }
            ouPath = String.format("%s%s%s", inPath.substring(0, thePos), "_TP0000000", inPath.substring(thePos + 3 + 7, inPath.length()));
            return ouPath;
        }

        public String[] GetListOfImageDataFiles(String inTitle) {
            return this.getListOfNpyDataFiles(inTitle, "ImageData");
        }

        public String[] GetListOfMaskDataFiles(String inTitle) {
            return this.getListOfNpyDataFiles(inTitle, "MaskData");
        }

        public String[] GetListOfHistogramDataFiles(String inTitle) {
            return this.getListOfNpyDataFiles(inTitle, "HistogramData");
        }

        public String[] GetListOfHistogramSummaryFiles(String inTitle) {
            return this.getListOfNpyDataFiles(inTitle, "HistogramSummary");
        }

        protected String[] getListOfNpyDataFiles(String inTitle, final String inStartWith) {
            String theImageGroupDirectory = this.GetImageGroupDirectory(inTitle);
            LOGGER.trace("getListOfNpyDataFiles: theImageGroupDirectory " + theImageGroupDirectory);
            File[] theFiles = new File(theImageGroupDirectory).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String thePath = file.getAbsolutePath();
                    if (!thePath.endsWith(CSBFile70.kBinaryFileSuffix) && !thePath.endsWith(CSBFile70.kZBinaryFileSuffix)) {
                        return false;
                    }
                    String theName = file.getName();
                    return theName.startsWith(inStartWith);
                }
            });
            String[] theFilePaths = new String[theFiles.length];
            LOGGER.trace("getListOfNpyDataFiles: theFiles.length " + theFiles.length);
            for (int theFil = 0; theFil < theFiles.length; ++theFil) {
                theFilePaths[theFil] = theFiles[theFil].getAbsolutePath();
                LOGGER.trace("getListOfNpyDataFiles: theFile " + theFil + theFilePaths[theFil]);
            }
            return theFilePaths;
        }
    }

    class ClassDecoder {
        ClassDecoder() {
        }

        public int Decode(MappingNode inNode) {
            return this.Decode(inNode, 0);
        }

        public int Decode(MappingNode inNode, int inStartIndex) {
            ScalarNode theKeyNode;
            String theStr;
            int theClassIndex;
            Class<?> cls = this.getClass();
            String myName = cls.getName();
            String sbName = this.GetSBClassName();
            Class<Integer> theTypeInteger = Integer.class;
            Class<Long> theTypeLong = Long.class;
            Class<Float> theTypeFloat = Float.class;
            Class<Double> theTypeDouble = Double.class;
            Class<Boolean> theTypeBoolean = Boolean.class;
            Class<String> theTypeString = String.class;
            Class<Integer[]> theTypeIntegerVector = Integer[].class;
            Class<Long[]> theTypeLongVector = Long[].class;
            Class<Float[]> theTypeFloatVector = Float[].class;
            myName = myName.replaceAll(".*\\$", "");
            Field[] fields = cls.getDeclaredFields();
            HashMap<String, Field> nameToFieldMap = new HashMap<String, Field>();
            for (Field theField : fields) {
                nameToFieldMap.put(theField.getName(), theField);
            }
            List theValueClassList = inNode.getValue();
            block25: for (theClassIndex = inStartIndex; theClassIndex < theValueClassList.size() && !(theStr = (theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theClassIndex)).getKeyNode()).getValue()).equals("EndClass"); ++theClassIndex) {
                if (!theStr.equals("StartClass")) continue;
                MappingNode theValueMappingNode = (MappingNode)((NodeTuple)theValueClassList.get(theClassIndex)).getValueNode();
                List theValueAttributeList = theValueMappingNode.getValue();
                for (int theAttrIndex = 0; theAttrIndex < theValueAttributeList.size(); ++theAttrIndex) {
                    String theAttrValue;
                    ScalarNode theAttrValueScalarNode;
                    int theListNode;
                    Number[] theArray;
                    SequenceNode theAttrValueSequenceNode;
                    List theScalarNodeList;
                    int theListSize;
                    ScalarNode theAttrKeyNode = (ScalarNode)((NodeTuple)theValueAttributeList.get(theAttrIndex)).getKeyNode();
                    Node theAttrValueNode = ((NodeTuple)theValueAttributeList.get(theAttrIndex)).getValueNode();
                    String theAttrName = theAttrKeyNode.getValue();
                    Field theField = (Field)nameToFieldMap.get(theAttrName);
                    if (theField == null && theAttrIndex > 0) {
                        this.DecodeUnknownString(theAttrName, theAttrValueNode);
                        continue;
                    }
                    if (theAttrValueNode instanceof ScalarNode) {
                        ScalarNode theAttrValueScalarNode2 = (ScalarNode)theAttrValueNode;
                        String theAttrValue2 = theAttrValueScalarNode2.getValue();
                        if (theAttrIndex == 0) {
                            if (theAttrName.equals("ClassName") && theAttrValue2.equals(sbName)) continue;
                            continue block25;
                        }
                        if (theField.getType().isAssignableFrom(theTypeInteger)) {
                            try {
                                Integer theVal = Integer.valueOf(theAttrValue2);
                                theField.set(this, theVal);
                            }
                            catch (IllegalArgumentException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            catch (IllegalAccessException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            continue;
                        }
                        if (theField.getType().isAssignableFrom(theTypeDouble)) {
                            try {
                                Double theVal = Double.valueOf(theAttrValue2);
                                theField.set(this, theVal);
                            }
                            catch (IllegalArgumentException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            catch (IllegalAccessException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            continue;
                        }
                        if (theField.getType().isAssignableFrom(theTypeFloat)) {
                            try {
                                Float theVal = Float.valueOf(theAttrValue2);
                                theField.set(this, theVal);
                            }
                            catch (IllegalArgumentException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            catch (IllegalAccessException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            continue;
                        }
                        if (theField.getType().isAssignableFrom(theTypeBoolean)) {
                            try {
                                if (theAttrValue2.equals("true")) {
                                    theField.set(this, true);
                                    continue;
                                }
                                theField.set(this, false);
                            }
                            catch (IllegalArgumentException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            catch (IllegalAccessException ex) {
                                LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                            }
                            continue;
                        }
                        if (!theField.getType().isAssignableFrom(theTypeString)) continue;
                        theAttrValue2 = this.RestoreSpecialCharacters(theAttrValue2);
                        try {
                            theField.set(this, theAttrValue2);
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        }
                        catch (IllegalAccessException ex) {
                            LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        }
                        continue;
                    }
                    if (!(theAttrValueNode instanceof SequenceNode) || (theListSize = (theScalarNodeList = (theAttrValueSequenceNode = (SequenceNode)theAttrValueNode).getValue()).size()) <= 1) continue;
                    if (theField.getType().isAssignableFrom(theTypeIntegerVector)) {
                        try {
                            theArray = new Integer[theListSize - 1];
                            for (theListNode = 0; theListNode < theListSize; ++theListNode) {
                                theAttrValueScalarNode = (ScalarNode)theScalarNodeList.get(theListNode);
                                theAttrValue = theAttrValueScalarNode.getValue();
                                if (theListNode == 0) {
                                    if (Integer.valueOf(theAttrValue) == theListSize - 1) continue;
                                    LOGGER.trace("theAttrName: " + theAttrName);
                                    LOGGER.trace("theAttrValue: " + theAttrValue);
                                    LOGGER.trace("theListSize: " + theListSize);
                                    LOGGER.trace("Integer.valueOf(theAttrValue) != theListSize");
                                    continue;
                                }
                                theArray[theListNode - 1] = Integer.valueOf(theAttrValue);
                            }
                            theField.set(this, theArray);
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        }
                        catch (IllegalAccessException ex) {
                            LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        }
                        continue;
                    }
                    if (theField.getType().isAssignableFrom(theTypeLongVector)) {
                        try {
                            theArray = new Long[theListSize - 1];
                            for (theListNode = 0; theListNode < theListSize; ++theListNode) {
                                theAttrValueScalarNode = (ScalarNode)theScalarNodeList.get(theListNode);
                                theAttrValue = theAttrValueScalarNode.getValue();
                                if (theListNode == 0) {
                                    if (Integer.valueOf(theAttrValue) == theListSize - 1) continue;
                                    LOGGER.trace("theAttrName: " + theAttrName);
                                    LOGGER.trace("theAttrValue: " + theAttrValue);
                                    LOGGER.trace("theListSize: " + theListSize);
                                    LOGGER.trace("Long.valueOf(theAttrValue) != theListSize");
                                    continue;
                                }
                                theArray[theListNode - 1] = Long.valueOf(theAttrValue);
                            }
                            theField.set(this, theArray);
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        }
                        catch (IllegalAccessException ex) {
                            LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        }
                        continue;
                    }
                    if (!theField.getType().isAssignableFrom(theTypeFloatVector)) continue;
                    try {
                        theArray = new Float[theListSize - 1];
                        for (theListNode = 0; theListNode < theListSize; ++theListNode) {
                            theAttrValueScalarNode = (ScalarNode)theScalarNodeList.get(theListNode);
                            theAttrValue = theAttrValueScalarNode.getValue();
                            if (theListNode == 0) {
                                if (Integer.valueOf(theAttrValue) == theListSize - 1) continue;
                                LOGGER.trace("Integer.valueOf(theAttrValue) != theListSize");
                                continue;
                            }
                            theArray[theListNode - 1] = Float.valueOf(theAttrValue);
                        }
                        theField.set(this, theArray);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        LOGGER.warn(ClassDecoder.class.getName() + ": " + ex.getMessage());
                    }
                }
            }
            return theClassIndex + 1;
        }

        StrIntPair FindNextClass(MappingNode inNode, int inStartIndex) {
            ScalarNode theKeyNode;
            String theStr;
            List theValueClassList = inNode.getValue();
            block0: for (int theClassIndex = inStartIndex; theClassIndex < theValueClassList.size() && !(theStr = (theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theClassIndex)).getKeyNode()).getValue()).equals("EndClass"); ++theClassIndex) {
                if (!theStr.equals("StartClass")) continue;
                MappingNode theValueMappingNode = (MappingNode)((NodeTuple)theValueClassList.get(theClassIndex)).getValueNode();
                List theValueAttributeList = theValueMappingNode.getValue();
                for (int theAttrIndex = 0; theAttrIndex < theValueAttributeList.size(); ++theAttrIndex) {
                    ScalarNode theAttrKeyNode = (ScalarNode)((NodeTuple)theValueAttributeList.get(theAttrIndex)).getKeyNode();
                    String theAttrName = theAttrKeyNode.getValue();
                    Node theAttrValueNode = ((NodeTuple)theValueAttributeList.get(theAttrIndex)).getValueNode();
                    if (!(theAttrValueNode instanceof ScalarNode)) continue;
                    ScalarNode theAttrValueScalarNode = (ScalarNode)theAttrValueNode;
                    String theAttrValue = theAttrValueScalarNode.getValue();
                    if (theAttrIndex != 0) continue;
                    if (!theAttrName.equals("ClassName")) continue block0;
                    return new StrIntPair(theAttrValue, theClassIndex);
                }
            }
            return new StrIntPair("", -1);
        }

        public String GetSBClassName() {
            Class<?> cls = this.getClass();
            String myName = cls.getName();
            myName = myName.replaceAll(".*\\$", "");
            String sbName = myName.replaceAll(".*\\.", "");
            return sbName;
        }

        IntIntPair GetIntegerValue(MappingNode inNode, int inStartIndex, String inKeyname) {
            StrIntPair theStrIntPair = this.GetStringValue(inNode, inStartIndex, inKeyname, false);
            if (theStrIntPair.mInt != -1) {
                Integer theVal = Integer.valueOf(theStrIntPair.mStr);
                return new IntIntPair(theVal, theStrIntPair.mInt);
            }
            return new IntIntPair(-1, -1);
        }

        StrIntPair GetStringValue(MappingNode inNode, int inStartIndex, String inKeyname, Boolean inRestoreSpecialValues) {
            List theValueClassList = inNode.getValue();
            for (int theNodeIndex = inStartIndex; theNodeIndex < theValueClassList.size(); ++theNodeIndex) {
                ScalarNode theKeyNode = (ScalarNode)((NodeTuple)theValueClassList.get(theNodeIndex)).getKeyNode();
                String theKey = theKeyNode.getValue();
                ScalarNode theValueNode = (ScalarNode)((NodeTuple)theValueClassList.get(theNodeIndex)).getValueNode();
                String theValue = theValueNode.getValue();
                if (!theKey.equals(inKeyname)) continue;
                if (inRestoreSpecialValues.booleanValue()) {
                    theValue = this.RestoreSpecialCharacters(theValue);
                }
                return new StrIntPair(theValue, theNodeIndex + 1);
            }
            return new StrIntPair("", -1);
        }

        protected void DecodeUnknownString(String inUnknownString, Node inAttrValueNode) {
        }

        String RestoreSpecialCharacters(String inString) {
            String ouString = inString;
            ouString = ouString.replace("_#9;", "\t");
            ouString = ouString.replace("_#10;", "\n");
            ouString = ouString.replace("_#13;", "\r");
            ouString = ouString.replace("_#34;", "\"");
            ouString = ouString.replace("_#58;", ":");
            ouString = ouString.replace("_#92;", "\\");
            ouString = ouString.replace("_#91;", "[");
            ouString = ouString.replace("_#93;", "]");
            ouString = ouString.replace("_#124;", "|");
            ouString = ouString.replace("_#60;", "<");
            ouString = ouString.replace("_#62;", ">");
            ouString = ouString.replace("_#32;", " ");
            ouString = ouString.replace("__empty", "");
            return ouString;
        }

        Integer[] GetIntegerArray(Node inNode, String inLogName, Boolean inFirstIsSize) {
            Integer[] theIntegerArray = null;
            String[] theStringArray = null;
            theStringArray = this.GetStringArray(inNode, inLogName, inFirstIsSize, false);
            if (theStringArray.length <= 0) {
                return theIntegerArray;
            }
            theIntegerArray = new Integer[theStringArray.length];
            for (int theI = 0; theI < theStringArray.length; ++theI) {
                theIntegerArray[theI] = Integer.valueOf(theStringArray[theI]);
            }
            return theIntegerArray;
        }

        Long[] GetLongArray(Node inNode, String inLogName, Boolean inFirstIsSize) {
            Long[] theLongArray = null;
            String[] theStringArray = null;
            theStringArray = this.GetStringArray(inNode, inLogName, inFirstIsSize, false);
            if (theStringArray.length <= 0) {
                return theLongArray;
            }
            theLongArray = new Long[theStringArray.length];
            for (int theI = 0; theI < theStringArray.length; ++theI) {
                theLongArray[theI] = Long.valueOf(theStringArray[theI]);
            }
            return theLongArray;
        }

        Float[] GetFloatArray(Node inNode, String inLogName, Boolean inFirstIsSize) {
            Float[] theFloatArray = null;
            String[] theStringArray = null;
            theStringArray = this.GetStringArray(inNode, inLogName, inFirstIsSize, false);
            if (theStringArray.length <= 0) {
                return theFloatArray;
            }
            theFloatArray = new Float[theStringArray.length];
            for (int theI = 0; theI < theStringArray.length; ++theI) {
                theFloatArray[theI] = Float.valueOf(theStringArray[theI]);
            }
            return theFloatArray;
        }

        Double[] GetDoubleArray(Node inNode, String inLogName, Boolean inFirstIsSize) {
            Double[] theDoubleArray = null;
            String[] theStringArray = null;
            theStringArray = this.GetStringArray(inNode, inLogName, inFirstIsSize, false);
            if (theStringArray.length <= 0) {
                return theDoubleArray;
            }
            theDoubleArray = new Double[theStringArray.length];
            for (int theI = 0; theI < theStringArray.length; ++theI) {
                theDoubleArray[theI] = Double.valueOf(theStringArray[theI]);
            }
            return theDoubleArray;
        }

        String[] GetStringArray(Node inNode, String inLogName, Boolean inFirstIsSize, Boolean inRestoreSpecialValues) {
            String[] theArray = null;
            if (!(inNode instanceof SequenceNode)) {
                return theArray;
            }
            SequenceNode theAttrValueSequenceNode = (SequenceNode)inNode;
            List theScalarNodeList = theAttrValueSequenceNode.getValue();
            int theListSize = theScalarNodeList.size();
            if (theListSize < 1) {
                return theArray;
            }
            Integer theOff = 0;
            if (inFirstIsSize.booleanValue()) {
                theOff = 1;
            }
            theArray = new String[theListSize - theOff];
            for (int theListNode = theOff.intValue(); theListNode < theListSize; ++theListNode) {
                ScalarNode theAttrValueScalarNode = (ScalarNode)theScalarNodeList.get(theListNode);
                String theAttrValue = theAttrValueScalarNode.getValue();
                if (theListNode == 0 && inFirstIsSize.booleanValue()) {
                    if (Integer.valueOf(theAttrValue) == theListSize) continue;
                    LOGGER.debug("GetStringArray: List Size mismatch");
                    continue;
                }
                if (inRestoreSpecialValues.booleanValue()) {
                    theAttrValue = this.RestoreSpecialCharacters(theAttrValue);
                }
                theArray[theListNode - theOff.intValue()] = theAttrValue;
            }
            return theArray;
        }
    }

    static class IntIntPair {
        public Integer mInt1;
        public Integer mInt2;

        public IntIntPair(Integer theInt1, Integer theInt2) {
            this.mInt1 = theInt1;
            this.mInt2 = theInt2;
        }
    }

    static class StrIntPair {
        public String mStr;
        public Integer mInt;

        public StrIntPair(String theStr, Integer theInt) {
            this.mStr = theStr;
            this.mInt = theInt;
        }
    }

    static enum EGraphicType {
        ePoint,
        eLine,
        eRectangle,
        ePolygon,
        eVolume,
        eObjectPath,
        eArrow,
        eShape,
        eEllipse;

    }
}

