/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.services.ServiceException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.JPEGTileDecoder;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JPEGTurboService;
import loci.formats.services.JPEGTurboServiceImpl;

public class TileJPEGReader
extends FormatReader {
    private transient JPEGTurboService service;

    public TileJPEGReader() {
        super("Tile JPEG", new String[]{"jpg", "jpeg"});
        this.domains = new String[]{"Graphics"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.service.getTile(buf, x, y, w, h);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.service != null) {
                this.service.close();
            }
            this.service = null;
        }
    }

    public void initFile(String id) throws FormatException, IOException {
        int[] dimensions;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        try (JPEGTileDecoder decoder = new JPEGTileDecoder();){
            dimensions = decoder.preprocess(this.in);
        }
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.interleaved = true;
        m.littleEndian = false;
        m.sizeX = dimensions[0];
        m.sizeY = dimensions[1];
        m.sizeZ = 1;
        m.sizeT = 1;
        this.reopenFile();
        m.sizeC = 3;
        m.rgb = this.getSizeC() > 1;
        m.imageCount = 1;
        m.pixelType = 1;
        m.dimensionOrder = "XYCZT";
        m.metadataComplete = true;
        m.indexed = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    public void reopenFile() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.currentId);
        this.in.seek(0L);
        this.service = new JPEGTurboServiceImpl();
        try {
            this.service.initialize(this.in, this.getSizeX(), this.getSizeY());
        }
        catch (ServiceException se) {
            this.service = null;
            throw new IOException("Could not initialize JPEG service", se);
        }
        if (!this.service.isLibraryLoaded()) {
            throw new IOException("JPEG service failed to load Turbo JPEG library");
        }
    }
}

