/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.groups;

import org.lsmp.djep.groupJep.groups.ExtendedFreeGroup;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.lsmp.djep.groupJep.values.AlgebraicExtensionElement;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.nfunk.jep.type.Complex;

public class AlgebraicExtension
extends ExtendedFreeGroup
implements RingI {
    private Polynomial poly;
    private Polynomial poly2;

    public AlgebraicExtension(RingI K, Polynomial poly) {
        super(K, poly.getSymbol());
        this.poly = poly;
        if (this.baseRing != poly.getBaseRing()) {
            throw new IllegalArgumentException("The polynomial should be specified over the same base ring");
        }
        if (!this.baseRing.equals(poly.getCoeffs()[poly.getDegree()], this.baseRing.getONE())) {
            throw new IllegalArgumentException("poly " + poly.toString() + " should be monic");
        }
        Number[] coeffs = new Number[poly.getDegree()];
        for (int i = 0; i < poly.getDegree(); ++i) {
            coeffs[i] = this.baseRing.getInverse(poly.getCoeffs()[i]);
        }
        this.poly2 = new Polynomial(this.baseRing, poly.getSymbol(), coeffs);
        if (poly.getDegree() == 2) {
            double c;
            double b = poly.getCoeffs()[1].doubleValue();
            double det = b * b - 4.0 * (c = poly.getCoeffs()[0].doubleValue());
            this.rootVal = det < 0.0 ? new Complex(-b / 2.0, Math.sqrt(-det) / 2.0) : new Complex(-b / 2.0 + Math.sqrt(det) / 2.0);
        } else {
            boolean flag = true;
            for (int i = 1; i < poly.getDegree(); ++i) {
                if (this.baseRing.equals(poly.getCoeffs()[i], this.baseRing.getZERO())) continue;
                flag = false;
                break;
            }
            if (flag) {
                double a0 = poly.getCoeffs()[0].doubleValue();
                Complex z = new Complex(-a0);
                this.rootVal = z.power(1.0 / (double)poly.getDegree());
            }
        }
        this.zeroPoly = new AlgebraicExtensionElement(this, new Number[]{this.baseRing.getZERO()});
        this.unitPoly = new AlgebraicExtensionElement(this, new Number[]{this.baseRing.getONE()});
        this.tPoly = new AlgebraicExtensionElement(this, new Number[]{this.baseRing.getZERO(), this.baseRing.getONE()});
    }

    @Override
    public Number valueOf(Number[] coeffs) {
        return new AlgebraicExtensionElement(this, coeffs);
    }

    @Override
    public String toString() {
        return this.baseRing.toString() + '[' + this.poly.toString() + ']';
    }

    public Polynomial getPoly() {
        return this.poly;
    }

    public Polynomial getSubsPoly() {
        return this.poly2;
    }
}

