/*
 * Decompiled with CFR 0.152.
 */
package fiji.process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class SEDT
implements PlugInFilter {
    ImagePlus image;
    ImagePlus scaledResult;
    int w;
    int h;
    int d;
    int current;
    int total;
    float minValue;
    float maxValue;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 129;
    }

    public void run(ImageProcessor ip) {
        this.compute(this.image.getStack()).show();
    }

    public ImagePlus compute(ImageStack stack) {
        this.w = stack.getWidth();
        this.h = stack.getHeight();
        this.d = stack.getSize();
        ImageStack result = new ImageStack(this.w, this.h, this.d);
        for (int i = 1; i <= this.d; ++i) {
            result.setPixels((Object)new float[this.w * this.h], i);
        }
        this.current = 0;
        this.total = this.w * this.h * this.d * 3;
        this.minValue = 0.0f;
        this.maxValue = 0.0f;
        new Z(stack, result).compute();
        new Y(result).compute();
        new X(result).compute();
        this.scaledResult = new ImagePlus("EDT", result);
        this.scaledResult.setDisplayRange((double)this.minValue, (double)this.maxValue);
        return this.scaledResult;
    }

    class X
    extends OneDimension {
        X(ImageStack out) {
            super(out, true);
        }

        @Override
        final void set(int x, float value) {
            value = value < 0.0f ? 0.5f - (float)Math.sqrt(-value) : -0.5f + (float)Math.sqrt(value);
            this.slice[x * this.columnStride + this.offset] = value;
            if (value < SEDT.this.minValue) {
                SEDT.this.minValue = value;
            } else if (value > SEDT.this.maxValue) {
                SEDT.this.maxValue = value;
            }
        }
    }

    class Y
    extends OneDimension {
        Y(ImageStack out) {
            super(out, false);
        }

        @Override
        final void set(int x, float value) {
            this.slice[x * this.columnStride + this.offset] = value;
        }
    }

    abstract class OneDimension
    extends EDTBase {
        ImageStack stack;
        float[] slice;
        int offset;
        int lastOffset;
        int rowStride;
        int columnStride;
        int sliceIndex;

        OneDimension(ImageStack out, boolean iterateX) {
            super(iterateX ? SEDT.this.w : SEDT.this.h);
            this.stack = out;
            this.columnStride = iterateX ? 1 : SEDT.this.w;
            this.rowStride = iterateX ? SEDT.this.w : 1;
            this.offset = SEDT.this.w * SEDT.this.h;
            this.lastOffset = this.rowStride * (iterateX ? SEDT.this.h : SEDT.this.w);
            this.sliceIndex = -1;
        }

        @Override
        final float get(int x) {
            return this.slice[x * this.columnStride + this.offset];
        }

        @Override
        final boolean nextRow() {
            this.offset += this.rowStride;
            if (this.offset >= this.lastOffset) {
                if (++this.sliceIndex >= SEDT.this.d) {
                    return false;
                }
                this.offset = 0;
                this.slice = (float[])this.stack.getPixels(this.sliceIndex + 1);
            }
            return true;
        }
    }

    class Z
    extends EDTBase {
        byte[][] inSlice;
        float[][] outSlice;
        int offset;

        Z(ImageStack in, ImageStack out) {
            super(SEDT.this.d);
            this.inSlice = new byte[SEDT.this.d][];
            this.outSlice = new float[SEDT.this.d][];
            for (int i = 0; i < SEDT.this.d; ++i) {
                this.inSlice[i] = (byte[])in.getPixels(i + 1);
                this.outSlice[i] = (float[])out.getPixels(i + 1);
            }
            this.offset = -1;
        }

        @Override
        final float get(int x) {
            return this.inSlice[x][this.offset] == 0 ? -3.4028235E38f : Float.MAX_VALUE;
        }

        @Override
        final void set(int x, float value) {
            this.outSlice[x][this.offset] = value;
        }

        @Override
        final boolean nextRow() {
            return ++this.offset < SEDT.this.w * SEDT.this.h;
        }
    }

    abstract class EDTBase {
        int width;
        int kNeg;
        int kPos;
        float[] fNeg;
        float[] fPos;
        float[] zNeg;
        float[] zPos;
        int[] yNeg;
        int[] yPos;

        EDTBase(int rowWidth) {
            this.width = rowWidth;
            this.fNeg = new float[this.width + 1];
            this.zNeg = new float[this.width + 1];
            this.yNeg = new int[this.width + 1];
            this.fPos = new float[this.width + 1];
            this.zPos = new float[this.width + 1];
            this.yPos = new int[this.width + 1];
        }

        final void computeRow() {
            this.fNeg[0] = -3.4028235E38f;
            this.yNeg[0] = -1;
            this.zNeg[0] = Float.MAX_VALUE;
            this.kNeg = 0;
            this.fPos[0] = Float.MAX_VALUE;
            this.yPos[0] = -1;
            this.zPos[0] = Float.MAX_VALUE;
            this.kPos = 0;
            int x = 0;
            while (x < this.width) {
                float fxPos;
                float s;
                float fxNeg;
                float fx = this.get(x);
                float f = fxNeg = fx < 0.0f ? fx : 0.0f;
                while (!((s = (fxNeg - (float)(x * x) - (this.fNeg[this.kNeg] - (float)(this.yNeg[this.kNeg] * this.yNeg[this.kNeg]))) / -2.0f / (float)(x - this.yNeg[this.kNeg])) > this.zNeg[this.kNeg]) && --this.kNeg >= 0) {
                }
                ++this.kNeg;
                this.yNeg[this.kNeg] = x;
                this.fNeg[this.kNeg] = fxNeg;
                this.zNeg[this.kNeg] = s;
                float f2 = fxPos = fx > 0.0f ? fx : 0.0f;
                while (!((s = (fxPos + (float)(x * x) - (this.fPos[this.kPos] + (float)(this.yPos[this.kPos] * this.yPos[this.kPos]))) / 2.0f / (float)(x - this.yPos[this.kPos])) > this.zPos[this.kPos]) && --this.kPos >= 0) {
                }
                ++this.kPos;
                this.yPos[this.kPos] = x++;
                this.fPos[this.kPos] = fxPos;
                this.zPos[this.kPos] = s;
            }
            this.zNeg[++this.kNeg] = Float.MAX_VALUE;
            this.zPos[++this.kPos] = Float.MAX_VALUE;
            int iNeg = 0;
            int iPos = 0;
            for (int x2 = 0; x2 < this.width; ++x2) {
                while (this.zNeg[iNeg + 1] < (float)x2) {
                    ++iNeg;
                }
                while (this.zPos[iPos + 1] < (float)x2) {
                    ++iPos;
                }
                if (this.get(x2) < 0.0f) {
                    this.set(x2, (float)(-(x2 - this.yNeg[iNeg]) * (x2 - this.yNeg[iNeg])) + this.fNeg[iNeg]);
                    continue;
                }
                this.set(x2, (float)((x2 - this.yPos[iPos]) * (x2 - this.yPos[iPos])) + this.fPos[iPos]);
            }
        }

        abstract float get(int var1);

        abstract void set(int var1, float var2);

        final void compute() {
            while (this.nextRow()) {
                this.computeRow();
                if (SEDT.this.total <= 0) continue;
                SEDT.this.current += this.width;
                IJ.showProgress((int)SEDT.this.current, (int)SEDT.this.total);
            }
        }

        abstract boolean nextRow();
    }
}

