/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractHasSource;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.TypedMetadata;
import io.scif.TypedWriter;
import io.scif.codec.CodecOptions;
import io.scif.config.SCIFIOConfig;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.awt.image.ColorModel;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.util.ArrayUtils;

public abstract class AbstractWriter<M extends TypedMetadata>
extends AbstractHasSource
implements TypedWriter<M> {
    private M metadata;
    private int fps;
    private String[] compressionTypes;
    private String compression;
    private CodecOptions options;
    private boolean[][] initialized;
    private int validBits;
    private boolean sequential;
    private DataHandle<Location> out;
    private ColorModel model;
    @Parameter
    private DataHandleService handles;

    protected void checkLocation(DataHandle<Location> out, SCIFIOConfig config) throws FormatException, IOException {
        if (config.writerGetFailIfOverwriting() && out.exists() && out.length() > 0L) {
            throw new FormatException("Attempting to write to output that already exists. Please rename the output, remove the existing conflict, or adjust configuration.");
        }
    }

    protected void checkParams(int imageIndex, long planeIndex, byte[] buf, Interval bounds) throws FormatException {
        SCIFIOMetadataTools.verifyMinimumPopulated(this.metadata, this.out, imageIndex);
        if (buf == null) {
            throw new FormatException("Buffer cannot be null.");
        }
        long planes = this.metadata.get(imageIndex).getPlaneCount();
        if (this.metadata.get(imageIndex).isMultichannel()) {
            planes *= this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
        }
        if (planeIndex < 0L) {
            throw new FormatException(String.format("Plane index:%d must be >= 0", planeIndex));
        }
        if (planeIndex >= planes) {
            throw new FormatException(String.format("Plane index:%d must be < %d", planeIndex, planes));
        }
        FormatTools.checkPlaneForWriting(this.getMetadata(), imageIndex, planeIndex, buf.length, bounds);
        FormatTools.assertId(this.out, true, 0);
    }

    protected void initialize(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        this.initialized[imageIndex][(int)planeIndex] = true;
    }

    protected abstract String[] makeCompressionTypes();

    protected abstract void writePlane(int var1, long var2, Plane var4, Interval var5) throws FormatException, IOException;

    @Override
    public void savePlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        FinalInterval bounds = new FinalInterval(this.metadata.get(imageIndex).getAxesLengthsPlanar());
        this.savePlane(imageIndex, planeIndex, plane, (Interval)bounds);
    }

    @Override
    public void savePlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        this.initialize(imageIndex, planeIndex, bounds);
        this.writePlane(imageIndex, planeIndex, plane, bounds);
    }

    @Override
    public boolean canDoStacks() {
        return false;
    }

    @Override
    public void setMetadata(Metadata meta) throws FormatException {
        this.setMetadata((M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)));
    }

    @Override
    public M getMetadata() {
        return this.metadata;
    }

    @Override
    public void setDest(Location fileName) throws FormatException, IOException {
        this.setDest(fileName, 0);
    }

    @Override
    public void setDest(DataHandle<Location> out) throws FormatException, IOException {
        this.setDest(out, 0);
    }

    @Override
    public void setDest(Location loc, int imageIndex) throws FormatException, IOException {
        this.setDest(loc, imageIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setDest(DataHandle<Location> out, int imageIndex) throws FormatException, IOException {
        this.setDest(out, imageIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setDest(Location loc, SCIFIOConfig config) throws FormatException, IOException {
        this.setDest(loc, 0, config);
    }

    @Override
    public void setDest(DataHandle<Location> out, SCIFIOConfig config) throws FormatException, IOException {
        this.setDest(out, 0, config);
    }

    @Override
    public void setDest(Location loc, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
        DataHandle handle = (DataHandle)this.handles.create((Object)loc);
        this.setDestinationMeta(imageIndex, config);
        if (handle != null) {
            this.out = handle;
            this.setDest(this.out, imageIndex, config);
        } else {
            this.getMetadata().setDestinationLocation(loc);
            SCIFIOMetadataTools.verifyMinimumPopulated(this.metadata, loc);
        }
    }

    @Override
    public void setDest(DataHandle<Location> out, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
        this.checkLocation(out, config);
        this.setDestinationMeta(imageIndex, config);
        this.getMetadata().setDatasetName(((Location)out.get()).getName());
        this.out = out;
        SCIFIOMetadataTools.verifyMinimumPopulated(this.metadata, out);
    }

    private void setDestinationMeta(int imageIndex, SCIFIOConfig config) throws FormatException {
        if (this.metadata == null) {
            throw new FormatException("Can not set Destination without setting Metadata first.");
        }
        this.fps = config.writerGetFramesPerSecond();
        this.options = config.writerGetCodecOptions();
        this.model = config.writerGetColorModel();
        this.compression = config.writerGetCompression();
        this.sequential = config.writerIsSequential();
        this.initialized = new boolean[this.metadata.getImageCount()][];
        for (int i = 0; i < this.metadata.getImageCount(); ++i) {
            this.initialized[i] = new boolean[(int)this.metadata.get(imageIndex).getPlaneCount()];
        }
    }

    @Override
    public DataHandle<Location> getHandle() {
        return this.out;
    }

    @Override
    public void setColorModel(ColorModel cm) {
        this.model = cm;
    }

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public String[] getCompressionTypes() {
        if (this.compressionTypes == null) {
            this.compressionTypes = this.makeCompressionTypes();
        }
        return this.compressionTypes;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public CodecOptions getCodecOptions() {
        return this.options;
    }

    @Override
    public boolean writeSequential() {
        return this.sequential;
    }

    @Override
    public int getValidBits() {
        return this.validBits;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    @Override
    public boolean isSupportedType(int type, String codec) {
        int[] types;
        for (int otherType : types = this.getPixelTypes(codec)) {
            if (type != otherType) continue;
            return true;
        }
        return false;
    }

    @Override
    public void isSupportedCompression(String compression) throws FormatException {
        for (String compressionType : this.compressionTypes) {
            if (!compressionType.equals(compression)) continue;
            this.compression = compression;
            return;
        }
        throw new FormatException("Invalid compression type: " + compression);
    }

    @Override
    public void setMetadata(M meta) throws FormatException {
        if (this.metadata != null && this.metadata != meta) {
            try {
                this.metadata.close();
            }
            catch (IOException e) {
                throw new FormatException(e);
            }
        }
        if (this.out != null) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new FormatException(e);
            }
        }
        this.metadata = meta;
        for (int i = 0; i < this.metadata.getImageCount(); ++i) {
            int pixelType = this.metadata.get(i).getPixelType();
            if (ArrayUtils.contains((int[])this.getPixelTypes(this.compression), (int)pixelType)) continue;
            throw new FormatException("Unsupported image type '" + FormatTools.getPixelTypeString(pixelType) + "'.");
        }
    }

    @Override
    public boolean isInitialized(int imageIndex, long planeIndex) {
        return this.initialized[imageIndex][(int)planeIndex];
    }

    @Override
    public String getCompression() {
        return this.compression;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.metadata != null) {
            this.metadata.close(fileOnly);
        }
        this.out = null;
        this.initialized = null;
    }
}

