/*
 * Decompiled with CFR 0.152.
 */
package io.scif.commands;

import io.scif.config.SCIFIOConfig;
import io.scif.img.ImageRegion;
import io.scif.img.Range;
import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menu={@Menu(label="File", weight=0.0), @Menu(label="Import"), @Menu(label="Image... ")})
public class OpenDataset
extends ContextCommand {
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private LogService logService;
    @Parameter
    private UIService uiService;
    @Parameter(label="File to open")
    private File source;
    @Parameter(required=false)
    private Boolean crop;
    @Parameter(label="Autoscale", required=false)
    private Boolean autoscale;
    @Parameter(label="Compute min/max values", required=false)
    private Boolean computeMinMax;
    @Parameter(required=false, min="0")
    private Integer x = 0;
    @Parameter(required=false, min="0")
    private Integer y = 0;
    @Parameter(required=false, min="0")
    private Integer w = 0;
    @Parameter(required=false, min="0")
    private Integer h = 0;
    @Parameter(required=false, label="Image indices")
    private String range;
    @Parameter(required=false, label="Group similar files")
    private Boolean groupFiles;
    @Parameter(required=false, label="Image mode", choices={"Auto", "Planar", "Cell"})
    private String mode = "Auto";
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset dataset;

    public void run() {
        SCIFIOConfig config = new SCIFIOConfig(this.getContext());
        if (this.range != null && !this.range.isEmpty()) {
            try {
                config.imgOpenerSetRange(this.range);
            }
            catch (IllegalArgumentException e) {
                this.logService.warn((Object)("Ignoring bad range: " + this.range));
            }
        }
        if (this.crop != null && this.crop.booleanValue()) {
            if (this.validRange()) {
                HashMap<AxisType, Range> region = new HashMap<AxisType, Range>();
                region.put(Axes.X, new Range(new Long(this.x.intValue()), new Long(this.x + this.w - 1)));
                region.put(Axes.Y, new Range(new Long(this.y.intValue()), new Long(this.y + this.h - 1)));
                config.imgOpenerSetRegion(new ImageRegion(region));
            } else {
                this.logService.warn((Object)("ignoring bad crop region: " + this.x + ", " + this.y + ", " + this.w + ", " + this.h));
            }
        }
        if (this.computeMinMax != null) {
            config.imgOpenerSetComputeMinMax(this.computeMinMax);
        }
        if (this.groupFiles != null) {
            config.groupableSetGroupFiles(this.groupFiles);
        }
        if (this.mode.equals("Planar")) {
            config.imgOpenerSetImgModes(SCIFIOConfig.ImgMode.PLANAR);
        } else if (this.mode.equals("Cell")) {
            config.imgOpenerSetImgModes(SCIFIOConfig.ImgMode.CELL);
        }
        try {
            this.dataset = this.datasetIOService.open(this.source.getAbsolutePath(), config);
        }
        catch (IOException e) {
            this.logService.error((Throwable)e);
            this.error(e.getMessage());
        }
        if (this.autoscale != null && this.autoscale.booleanValue()) {
            for (int c = 0; c < this.dataset.getCompositeChannelCount(); ++c) {
                this.dataset.setChannelMinimum(c, Double.NaN);
                this.dataset.setChannelMaximum(c, Double.NaN);
            }
        }
    }

    private boolean validRange() {
        return this.x != null && this.y != null && this.w != null && this.h != null && this.x >= 0 && this.y >= 0 && this.w >= 0 && this.h >= 0;
    }

    private void error(String message) {
        this.uiService.showDialog(message, DialogPrompt.MessageType.ERROR_MESSAGE);
    }
}

