/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.convert;

import java.lang.reflect.Type;
import net.imagej.convert.ConciseConverter;
import net.imagej.roi.ROITree;
import net.imglib2.roi.MaskPredicate;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.TreeNode;
import org.scijava.util.Types;

@Plugin(type=Converter.class)
public class ROITreeToMaskPredicateConverter
extends ConciseConverter<ROITree, MaskPredicate> {
    public ROITreeToMaskPredicateConverter() {
        super(ROITree.class, MaskPredicate.class, src -> (MaskPredicate)((TreeNode)src.children().get(0)).data());
    }

    public boolean canConvert(Object src, Type dest) {
        return Types.raws((Type)dest).stream().allMatch(c -> this.canConvert(src, (Class<?>)c));
    }

    public boolean canConvert(Object src, Class<?> dest) {
        if (!(src instanceof ROITree)) {
            return false;
        }
        ROITree srcTree = (ROITree)src;
        if (srcTree.children().size() != 1) {
            return false;
        }
        TreeNode onlyChild = (TreeNode)srcTree.children().get(0);
        if (!onlyChild.children().isEmpty()) {
            return false;
        }
        return dest.isInstance(onlyChild.data());
    }
}

