/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReagentRef
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReagentRef.class);
    private String id;

    public ReagentRef() {
    }

    public ReagentRef(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ReagentRef(ReagentRef orig) {
        super(orig);
        this.id = orig.id;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("ReagentRef missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element ReagentRef_element) {
        if (ReagentRef_element == null) {
            ReagentRef_element = document.createElementNS(NAMESPACE, "ReagentRef");
        }
        super.asXMLElement(document, ReagentRef_element);
        if (this.id != null) {
            ReagentRef_element.setAttribute("ID", this.id);
        }
        return ReagentRef_element;
    }
}

