/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.extractheadlines;

import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.examples.text.extractheadlines.SectionConfiguration;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.utils.LogWriter;

public class ExtractSection
extends ExtractTextInRectangle {
    private final boolean debug = false;
    SectionConfiguration sectionConfig;
    String[] sectionTokens;
    private int[] section_x1;
    private int[] section_x2;
    private int[] section_y1;
    private int[] section_y2;
    private String section;

    public String getSection() {
        return this.section;
    }

    private String extractSection(String string) {
        String string2 = null;
        try {
            if (showMessages) {
                System.out.println(string);
            }
            if (string == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = this.sectionTokens.length;
            for (int i = 0; i < n; ++i) {
                hashMap.put(this.sectionTokens[i], "x");
            }
            Object var2_8 = null;
            string2 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
            while (stringTokenizer.hasMoreTokens() && (string2 == null || var2_8 == null)) {
                string3 = stringTokenizer.nextToken();
                if (hashMap.get(string3) == null) continue;
                String string4 = string3;
                string3 = stringTokenizer.nextToken();
                boolean bl = false;
                if (bl || string3.length() <= 2) continue;
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens() && !string3.equals("/font")) {
                    if (string3.indexOf("SpaceC") != -1) {
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(string3);
                    }
                    string3 = stringTokenizer.nextToken();
                }
                string2 = stringBuffer.toString().trim();
                if (!string4.equals("font face=\"TimesClassicDisplay\" style=\"font-size:16pt\"")) continue;
                break;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return string2;
    }

    public ExtractSection(String string, String string2) {
        block11: {
            this.debug = false;
            this.sectionTokens = null;
            this.section = null;
            try {
                showMessages = false;
                this.initSection(string2);
                if (string.toLowerCase().endsWith(".pdf")) {
                    this.decodeFile("", string);
                    break block11;
                }
                String[] stringArray = null;
                File file = null;
                if (!string.endsWith(this.separator)) {
                    string = string + this.separator;
                }
                try {
                    file = new File(string);
                    if (!file.isDirectory()) {
                        System.err.println(string + " is not a directory. Exiting program");
                    }
                    stringArray = file.list();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
                }
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    if (showMessages) {
                        System.out.println(n + "/ " + l + " " + stringArray[n]);
                    }
                    if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                        if (showMessages) {
                            System.out.println(string + stringArray[n]);
                        }
                        this.decodeFile(string, stringArray[n]);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initSection(String string) {
        this.sectionConfig = new SectionConfiguration(string);
        this.section = this.sectionConfig.getValue("default_section");
        int n = Integer.parseInt(this.sectionConfig.getValue("xmlCount"));
        this.sectionTokens = new String[n];
        for (int i = 0; i < n; ++i) {
            this.sectionTokens[i] = this.sectionConfig.getValue("xmlTag_" + i);
            if (!showMessages) continue;
            System.out.println(this.sectionTokens[i]);
        }
        n = Integer.parseInt(this.sectionConfig.getValue("locationCount"));
        this.section_x1 = new int[n];
        this.section_x2 = new int[n];
        this.section_y1 = new int[n];
        this.section_y2 = new int[n];
        String string2 = "locTag";
        String[] stringArray = new String[]{"x1", "y1", "x2", "y2"};
        for (int i = 0; i < n; ++i) {
            block8: for (int j = 0; j < 4; ++j) {
                String string3 = string2 + "_" + i + "_" + stringArray[j];
                String string4 = this.sectionConfig.getValue(string3);
                int n2 = Integer.parseInt(string4);
                switch (j) {
                    case 0: {
                        this.section_x1[i] = n2;
                        continue block8;
                    }
                    case 1: {
                        this.section_y1[i] = n2;
                        continue block8;
                    }
                    case 2: {
                        this.section_x2[i] = n2;
                        continue block8;
                    }
                    case 3: {
                        this.section_y2[i] = n2;
                    }
                }
            }
        }
    }

    protected void decodeFile(String string, String string2) {
        try {
            String string3 = string + string2;
            String string4 = null;
            try {
                this.decodePdf = new PdfDecoder(false);
                this.decodePdf.setExtractionMode(1);
                this.decodePdf.init(true);
                this.decodePdf.openPdfFile(string3);
                if (showMessages) {
                    System.out.println("file_name=" + string3);
                }
            }
            catch (PdfSecurityException pdfSecurityException) {
                System.err.println("Security Exception " + pdfSecurityException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            }
            catch (PdfException pdfException) {
                System.err.println("Pdf Exception " + pdfException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
                exception.printStackTrace();
            }
            if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
                if (showMessages) {
                    System.out.println("Encrypted settings");
                    System.out.println("Please look at SimpleViewer for code sample to handle such files");
                    System.out.println("Or get support/consultancy");
                }
            } else {
                int n = 1;
                int n2 = this.decodePdf.getPageCount();
                int n3 = this.section_x2.length;
                try {
                    for (int i = n; i < n2 + 1; ++i) {
                        this.decodePdf.decodePage(i);
                        for (int j = 0; j < n3; ++j) {
                            PdfGroupingAlgorithms pdfGroupingAlgorithms = new PdfGroupingAlgorithms(this.decodePdf.getPdfData());
                            int n4 = this.section_x1[j];
                            int n5 = this.section_x2[j];
                            int n6 = this.section_y1[j];
                            int n7 = this.section_y2[j];
                            if (showMessages) {
                                System.out.println("Using (" + n4 + "," + n6 + ") (" + n5 + "," + n7 + ")");
                            }
                            try {
                                this.text = pdfGroupingAlgorithms.extractTextInRectangle(n4, n6, n5, n7, i, false, true);
                                if (this.text == null || (string4 = this.extractSection(this.text)) == null) continue;
                                j = n3;
                                continue;
                            }
                            catch (PdfException pdfException) {
                                this.text = null;
                                this.decodePdf.closePdfFile();
                                System.err.println("Exception " + pdfException.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                                pdfException.printStackTrace();
                            }
                        }
                        this.decodePdf.flushObjectValues(false);
                        if (string4 != null) {
                            if (showMessages) {
                                System.out.println("section=" + string4);
                            }
                            this.section = string4;
                        }
                        if (!showMessages) continue;
                        System.out.println("----");
                    }
                }
                catch (Exception exception) {
                    this.decodePdf.closePdfFile();
                    exception.printStackTrace();
                    System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
                }
                this.decodePdf.flushObjectValues(true);
                if (showMessages) {
                    System.out.println("Text read");
                }
            }
            this.decodePdf.closePdfFile();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }
}

