/*
 * Decompiled with CFR 0.152.
 */
package io.scif.labeling;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.scif.labeling.LabelingIOService;
import io.scif.labeling.data.Container;
import io.scif.labeling.utils.LabelingUtil;
import io.scif.services.DatasetIOService;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.ToLongFunction;
import net.imagej.ImageJService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgView;
import net.imglib2.labeling.data.LabelingData;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.type.numeric.IntegerType;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;

@Plugin(type=ImageJService.class)
public class DefaultLabelingIOService
extends AbstractService
implements LabelingIOService {
    @Parameter
    private Context context;
    @Parameter
    private DatasetIOService datasetIOService;
    private final Gson gson = new Gson();

    @Override
    public <T, I extends IntegerType<I>> ImgLabeling<T, I> load(String file, Class<T> labelType, Class<I> backingType) throws IOException {
        return this.getImgLabeling(file, labelType, backingType);
    }

    @Override
    public <S, T, I extends IntegerType<I>> Container<S, T, I> loadWithMetadata(String file, Class<S> metadataType, Class<T> labelType, Class<I> backingType) throws IOException {
        LabelingData<T, S> labelingData = this.readLabelingDataFromJson(file, labelType, metadataType);
        Container<Object, T, I> container = new Container<Object, T, I>();
        container.setImgLabeling(this.getImgLabeling(file, labelType, backingType));
        Object metadata = this.gson.fromJson(this.gson.toJson(labelingData.getMetadata()), metadataType);
        container.setMetadata(metadata);
        return container;
    }

    @Override
    public <S, T, I extends IntegerType<I>> Container<S, T, I> loadWithMetadata(String file, LongFunction<T> idToLabel, Class<S> metadataClazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, I extends IntegerType<I>> void save(ImgLabeling<T, I> imgLabeling, String file) throws IOException {
        this.saveWithMetaData(imgLabeling, file, null);
    }

    @Override
    public <S, T, I extends IntegerType<I>> void saveWithMetaData(ImgLabeling<T, I> imgLabeling, String file, S metadata) throws IOException {
        LabelingMapping labelingMapping = imgLabeling.getMapping();
        LabelingData<T, S> labelingData = this.createBasicLabelingData(file, labelingMapping);
        if (!labelingMapping.getLabels().isEmpty()) {
            this.createLabelsets(labelingMapping, labelingData);
        }
        labelingData.setMetadata(metadata);
        Img img = ImgView.wrap((RandomAccessibleInterval)imgLabeling.getIndexImg(), null);
        LabelingUtil.saveAsTiff(this.context, LabelingUtil.getFilePathWithExtension(file, ".tif", Paths.get(file, new String[0]).getParent().toString()), img);
        this.writeLabelingFile(file, labelingData);
    }

    @Override
    public <S, T, I extends IntegerType<I>> void saveWithMetaData(ImgLabeling<T, I> imgLabeling, String file, ToLongFunction<T> labelToId, S metadata) throws IOException {
        throw new UnsupportedOperationException();
    }

    private <T, I extends IntegerType<I>> ImgLabeling<T, I> getImgLabeling(String file, Class<T> labelType, Class<I> backingType) throws IOException {
        return this.buildImgLabelingAndImage(file, this.readLabelingDataFromJson(file, labelType, Object.class), backingType);
    }

    private <T, S> LabelingData<T, S> readLabelingDataFromJson(String file, Class<T> labelType, Class<S> metadataType) throws IOException {
        String path = LabelingUtil.getFilePathWithExtension(file, ".lbl.json", Paths.get(file, new String[0]).getParent().toString());
        BufferedReader reader = Files.newBufferedReader(Paths.get(path, new String[0]));
        Type type = TypeToken.getParameterized(LabelingData.class, (Type[])new Type[]{labelType, metadataType}).getType();
        return (LabelingData)this.gson.fromJson((Reader)reader, type);
    }

    private <S, T, I extends IntegerType<I>> ImgLabeling<T, I> buildImgLabelingAndImage(String file, LabelingData<T, S> labelingData, Class<I> backingType) throws IOException {
        int numSets = labelingData.getNumSets();
        String indexImg = labelingData.getIndexImg();
        List<Set<T>> labelSets = this.readLabelsets(labelingData, numSets);
        Img img = this.datasetIOService.open(LabelingUtil.getFilePathWithExtension(indexImg, ".tif", Paths.get(file, new String[0]).getParent().toString())).getImgPlus().getImg();
        return ImgLabeling.fromImageAndLabelSets((RandomAccessibleInterval)img, labelSets);
    }

    private <T, S> void createLabelsets(LabelingMapping<T> labelingMapping, LabelingData<T, S> labelingData) {
        Optional optional = labelingMapping.getLabels().stream().findFirst();
        if (optional.isPresent() && optional.get() instanceof Integer) {
            HashMap<String, Set<Integer>> labels = new HashMap<String, Set<Integer>>();
            for (int i = 0; i < labelingMapping.numSets(); ++i) {
                labels.put(Integer.toString(i), labelingMapping.labelsAtIndex(i));
            }
            labelingData.setLabelSets(labels);
        } else {
            HashMap<String, Set<Integer>> labels = new HashMap<String, Set<Integer>>();
            HashMap map = new HashMap();
            for (int i = 0; i < labelingMapping.numSets(); ++i) {
                HashSet<Integer> labelset = new HashSet<Integer>();
                for (Object value : labelingMapping.labelsAtIndex(i)) {
                    if (!map.containsValue(value)) {
                        map.put(map.size() + 1, value);
                    }
                    int mappedInteger = map.entrySet().stream().filter(entry -> value.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
                    labelset.add(mappedInteger);
                }
                labels.put(Integer.toString(i), labelset);
            }
            labelingData.setLabelMapping(map);
            labelingData.setLabelSets(labels);
        }
    }

    private <T, S> List<Set<T>> readLabelsets(LabelingData<T, S> labelingData, int numSets) {
        ArrayList<Set<T>> labelSets = new ArrayList<Set<T>>();
        if (labelingData.getLabelMapping() == null || labelingData.getLabelMapping().isEmpty()) {
            for (Set<Integer> set : labelingData.getLabelSets().values()) {
                HashSet labelSet = new HashSet();
                set.stream().map(v -> (int)v).forEach(v -> labelSet.add(v));
                labelSets.add(labelSet);
            }
        } else {
            for (int i = 0; i < numSets; ++i) {
                HashSet<T> set = new HashSet<T>();
                for (int j : labelingData.getLabelSets().get(Integer.toString(i))) {
                    set.add(labelingData.getLabelMapping().get(j));
                }
                labelSets.add(set);
            }
        }
        return labelSets;
    }

    private <T, S> LabelingData<T, S> createBasicLabelingData(String file, LabelingMapping<T> labelingMapping) {
        LabelingData labelingData = new LabelingData();
        labelingData.setVersion(3);
        labelingData.setNumSets(labelingMapping.numSets());
        labelingData.setNumSources(1);
        labelingData.setIndexImg(LabelingUtil.getFilePathWithExtension(file, ".tif", null));
        return labelingData;
    }

    private <T, S> void writeLabelingFile(String file, LabelingData<T, S> labelingData) throws IOException {
        FileWriter writer = new FileWriter(LabelingUtil.getFilePathWithExtension(file, ".lbl.json", Paths.get(file, new String[0]).getParent().toString()));
        Type labelingDataType = new TypeToken<LabelingData<T, S>>(){}.getType();
        this.gson.toJson(labelingData, labelingDataType, (Appendable)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }
}

