/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli.show;

import io.scif.BufferedImagePlane;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.Writer;
import io.scif.cli.AbstractReaderCommand;
import io.scif.cli.SCIFIOToolCommand;
import io.scif.cli.show.AsciiImage;
import io.scif.filters.ReaderFilter;
import io.scif.gui.AWTImageTools;
import io.scif.gui.GUIService;
import io.scif.services.FormatService;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.Interval;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.scijava.Context;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=SCIFIOToolCommand.class)
public class Show
extends AbstractReaderCommand {
    @Parameter
    private LocationService locationService;
    private List<BufferedImage> bImages;
    @Argument(metaVar="file", index=0, usage="image file to display")
    private String file;
    @Argument(index=1, multiValued=true)
    private final List<String> arguments = new ArrayList<String>();
    @Option(name="-A", aliases={"--ascii"}, usage="display an ascii rendering of the image. useful on headless systems")
    private boolean ascii;
    @Option(name="-n", aliases={"--normalize"}, usage="normalize floating point images (may result in loss of precision)")
    private boolean normalize;
    @Option(name="-p", aliases={"--preload"}, usage="pre-load entire file into a buffer. reduces read time, increases memory use.")
    private boolean preload;
    @Option(name="-w", aliases={"--swap"}, usage="override the default input dimension order")
    private List<String> swap;
    @Option(name="-u", aliases={"--shuffle"}, usage="override the default output dimension order")
    private boolean shuffle;

    @Override
    protected void run() throws CmdLineException {
        ReaderFilter reader = this.makeReader(this.file);
        this.showPixels((Reader)reader);
    }

    @Override
    protected String description() {
        return "command line tool for displaying a dataset.";
    }

    @Override
    protected String getName() {
        return "show";
    }

    @Override
    protected List<String> getExtraArguments() {
        return this.arguments;
    }

    @Override
    protected void validateParams() throws CmdLineException {
        if (this.file == null) {
            throw new CmdLineException(null, "Argument \"file\" is required");
        }
    }

    @Override
    protected Plane processPlane(Reader reader, Plane plane, int imageIndex, long planeIndex, long planeNo, Interval bounds) throws CmdLineException {
        int pixType;
        try {
            plane = plane == null ? reader.openPlane(imageIndex, planeIndex, bounds, this.getConfig()) : reader.openPlane(imageIndex, planeIndex, plane, bounds, this.getConfig());
        }
        catch (FormatException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        catch (IOException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        int pixelType = reader.getMetadata().get(imageIndex).getPixelType();
        boolean littleEndian = reader.getMetadata().get(imageIndex).isLittleEndian();
        Object pix = Bytes.makeArray((byte[])plane.getBytes(), (int)FormatTools.getBytesPerPixel((int)pixelType), (boolean)FormatTools.isFloatingPoint((int)pixelType), (boolean)littleEndian);
        byte[] bytes = null;
        if (pix instanceof short[]) {
            bytes = Bytes.fromShorts((short[])((short[])pix), (boolean)littleEndian);
        } else if (pix instanceof int[]) {
            bytes = Bytes.fromInts((int[])((int[])pix), (boolean)littleEndian);
        } else if (pix instanceof long[]) {
            bytes = Bytes.fromLongs((long[])((long[])pix), (boolean)littleEndian);
        } else if (pix instanceof float[]) {
            if (this.normalize) {
                pix = Bytes.normalize((float[])((float[])pix));
            }
            bytes = Bytes.fromFloats((float[])((float[])pix), (boolean)littleEndian);
        } else if (pix instanceof double[]) {
            if (this.normalize) {
                pix = Bytes.normalize((double[])((double[])pix));
            }
            bytes = Bytes.fromDoubles((double[])((double[])pix), (boolean)littleEndian);
        } else if (pix instanceof byte[]) {
            bytes = (byte[])pix;
        }
        ImageMetadata meta = reader.getMetadata().get(imageIndex);
        try {
            this.bImages.add(AWTImageTools.openImage((Plane)plane, (byte[])bytes, (Reader)reader, (long[])meta.getAxesLengthsPlanar(), (int)imageIndex));
        }
        catch (FormatException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        catch (IOException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        if (this.bImages.get((int)planeNo) == null) {
            this.warn("\t************ Failed to read plane #" + planeNo + " ************");
        }
        if (reader.getMetadata().get(imageIndex).isIndexed() && plane.getColorTable() == null) {
            this.warn("\t************ no LUT for plane #{}" + planeNo + " ************");
        }
        if ((pixType = AWTImageTools.getPixelType((BufferedImage)this.bImages.get((int)planeNo))) != pixelType && pixType != pixelType + 1) {
            this.info("\tPlane #" + planeNo + ": pixel type mismatch: " + FormatTools.getPixelTypeString((int)pixType) + "/" + FormatTools.getPixelTypeString((int)pixelType));
        }
        return plane;
    }

    @Override
    public String commandName() {
        return "show";
    }

    private void showPixels(Reader reader) throws CmdLineException {
        this.bImages = new ArrayList<BufferedImage>();
        this.read(reader);
        if (this.ascii) {
            for (int i = 0; i < this.bImages.size(); ++i) {
                BufferedImage img = this.bImages.get(i);
                this.info("");
                this.info("Image #" + i + ":");
                this.info(new AsciiImage(img).toString());
            }
        } else {
            this.info("");
            this.info("Launching image viewer");
            ImageViewer viewer = new ImageViewer(this.getContext(), false);
            viewer.setImages(reader, this.bImages.toArray(new BufferedImage[this.bImages.size()]));
            viewer.setVisible(true);
        }
    }

    private class ImageViewer
    extends JFrame
    implements ActionListener,
    ChangeListener,
    KeyListener,
    MouseMotionListener,
    Runnable,
    WindowListener {
        @Parameter
        private Context context;
        @Parameter
        private LogService logService;
        @Parameter
        private FormatService formatService;
        @Parameter
        private InitializeService initializeService;
        @Parameter
        private GUIService guiService;
        private static final String TITLE = "SCIFIO Viewer";
        private static final char ANIMATION_KEY = ' ';
        private Reader myReader;
        private Writer myWriter;
        private final JPanel pane;
        private final ImageIcon icon;
        private final JLabel iconLabel;
        private final JPanel sliderPanel;
        private final JSlider nSlider;
        private final JLabel probeLabel;
        private Location location;
        private BufferedImage[] images;
        private boolean anim;
        private int fps;
        private boolean canCloseReader;
        private final StringBuffer sb;

        public ImageViewer(Context context) {
            super(TITLE);
            this.anim = false;
            this.fps = 10;
            this.canCloseReader = true;
            this.sb = new StringBuffer();
            context.inject((Object)this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(this);
            this.pane = new JPanel();
            this.pane.setLayout(new BorderLayout());
            this.setContentPane(this.pane);
            this.setSize(350, 350);
            this.sliderPanel = new JPanel();
            this.sliderPanel.setVisible(false);
            this.sliderPanel.setBorder(new EmptyBorder(5, 3, 5, 3));
            this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 1));
            this.pane.add("South", this.sliderPanel);
            JPanel nPanel = new JPanel();
            nPanel.setLayout(new BoxLayout(nPanel, 0));
            this.sliderPanel.add(nPanel);
            this.sliderPanel.add(Box.createVerticalStrut(2));
            this.nSlider = new JSlider(1, 1);
            this.nSlider.setEnabled(false);
            this.nSlider.addChangeListener(this);
            nPanel.add(new JLabel("N"));
            nPanel.add(Box.createHorizontalStrut(3));
            nPanel.add(this.nSlider);
            JPanel ztcPanel = new JPanel();
            ztcPanel.setLayout(new BoxLayout(ztcPanel, 0));
            this.sliderPanel.add(ztcPanel);
            BufferedImage dummy = AWTImageTools.makeImage((byte[][])new byte[1][1], (int)1, (int)1, (boolean)false);
            this.icon = new ImageIcon(dummy);
            this.iconLabel = new JLabel(this.icon, 2);
            this.iconLabel.setVerticalAlignment(1);
            this.pane.add(new JScrollPane(this.iconLabel));
            this.probeLabel = new JLabel(" ");
            this.probeLabel.setHorizontalAlignment(0);
            this.probeLabel.setBorder(new BevelBorder(0));
            this.pane.add("North", this.probeLabel);
            this.iconLabel.addMouseMotionListener(this);
            this.nSlider.addKeyListener(this);
        }

        public ImageViewer(Context context, boolean canCloseReader) {
            this(context);
            this.canCloseReader = canCloseReader;
        }

        public void open(Location source) {
            this.wait(true);
            try {
                this.canCloseReader = true;
                this.myReader = this.initializeService.initializeReader(source);
                long planeCount = this.myReader.getMetadata().get(0).getPlaneCount();
                ProgressMonitor progress = new ProgressMonitor(this, "Reading " + source, null, 0, 1);
                progress.setProgress(1);
                BufferedImage[] img = new BufferedImage[(int)planeCount];
                for (long planeIndex = 0L; planeIndex < planeCount && !progress.isCanceled(); ++planeIndex) {
                    Plane plane = this.myReader.openPlane(0, planeIndex);
                    img[(int)planeIndex] = AWTImageTools.openImage((Plane)plane, (Reader)this.myReader, (int)0);
                }
                progress.setProgress(2);
                this.setImages(this.myReader, img);
                this.myReader.close(true);
            }
            catch (FormatException exc) {
                this.logService.info((Object)"", (Throwable)exc);
                this.wait(false);
                return;
            }
            catch (IOException exc) {
                this.logService.info((Object)"", (Throwable)exc);
                this.wait(false);
                return;
            }
            this.wait(false);
        }

        public void save(Location destination) {
            if (this.images == null) {
                return;
            }
            this.wait(true);
            try {
                this.myWriter.setDest(destination);
                boolean stack = this.myWriter.canDoStacks();
                ProgressMonitor progress = new ProgressMonitor(this, "Saving " + destination, null, 0, stack ? this.images.length : 1);
                if (stack) {
                    for (int i = 0; i < this.images.length; ++i) {
                        progress.setProgress(i);
                        boolean canceled = progress.isCanceled();
                        this.myWriter.savePlane(0, (long)i, this.getPlane(this.images[i]));
                        if (canceled) break;
                    }
                    progress.setProgress(this.images.length);
                } else {
                    this.myWriter.savePlane(0, 0L, this.getPlane(this.getImage()));
                    progress.setProgress(1);
                }
                this.myWriter.close();
            }
            catch (FormatException | IOException exc) {
                this.logService.info((Object)"", exc);
            }
            this.wait(false);
        }

        public void setImages(Reader reader, BufferedImage[] img) {
            String format;
            this.location = reader == null ? null : reader.getCurrentLocation();
            this.myReader = reader;
            this.images = img;
            this.nSlider.removeChangeListener(this);
            this.nSlider.setValue(1);
            this.nSlider.setMaximum(this.images.length);
            this.nSlider.setEnabled(this.images.length > 1);
            this.nSlider.addChangeListener(this);
            this.sliderPanel.setVisible(this.images.length > 1);
            this.updateLabel(-1, -1);
            this.sb.setLength(0);
            if (this.location != null) {
                this.sb.append(this.location);
                this.sb.append(" ");
            }
            String string = format = reader == null ? null : reader.getFormat().getFormatName();
            if (format != null) {
                this.sb.append("(");
                this.sb.append(format);
                this.sb.append(")");
                this.sb.append(" ");
            }
            if (this.location != null || format != null) {
                this.sb.append("- ");
            }
            this.sb.append(TITLE);
            this.setTitle(this.sb.toString());
            if (this.images != null) {
                this.icon.setImage(this.images[0]);
            }
            this.pack();
        }

        public BufferedImage getImage() {
            int ndx = this.getPlaneIndex();
            return this.images == null || ndx >= this.images.length ? null : this.images[ndx];
        }

        public Plane getPlane(BufferedImage image) {
            BufferedImagePlane plane = new BufferedImagePlane();
            plane.setData(image);
            return plane;
        }

        public int getPlaneIndex() {
            return this.nSlider.getValue() - 1;
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            new Thread(this).start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if ("open".equals(cmd)) {
                this.wait(true);
                JFileChooser chooser = this.guiService.buildFileChooser((Collection)this.formatService.getAllFormats());
                this.wait(false);
                int rval = chooser.showOpenDialog(this);
                if (rval == 0) {
                    File f = chooser.getSelectedFile();
                    FileLocation source = new FileLocation(f);
                    if (f != null) {
                        this.open((Location)source, this.myReader);
                    }
                }
            } else if ("save".equals(cmd)) {
                this.wait(true);
                JFileChooser chooser = this.guiService.buildFileChooser(this.formatService.getOutputFormats());
                this.wait(false);
                int rval = chooser.showSaveDialog(this);
                if (rval == 0) {
                    if (this.myWriter != null) {
                        try {
                            this.myWriter.close();
                        }
                        catch (IOException e1) {
                            this.logService.error((Throwable)e1);
                        }
                    }
                    File f = chooser.getSelectedFile();
                    FileLocation destination = new FileLocation(f);
                    try {
                        this.myWriter = this.initializeService.initializeWriter(this.myReader.getMetadata(), (Location)destination);
                    }
                    catch (FormatException | IOException e1) {
                        this.logService.error((Object)e);
                    }
                    this.save((Location)destination, this.myWriter);
                }
            } else if ("exit".equals(cmd)) {
                this.dispose();
            } else if ("fps".equals(cmd)) {
                this.setDefaultCloseOperation(3);
                String result = JOptionPane.showInputDialog(this, "Animate using space bar. How many frames per second?", "" + this.fps);
                try {
                    this.fps = Integer.parseInt(result);
                }
                catch (NumberFormatException exc) {
                    this.logService.debug((Object)("Could not parse fps " + this.fps), (Throwable)exc);
                }
            } else if ("about".equals(cmd)) {
                this.setDefaultCloseOperation(3);
                String msg = "<html>SCIFIO core for reading and converting file formats.<br>Copyright (C) 2005 - 2013 Open Microscopy Environment:<ul><li>Board of Regents of the University of Wisconsin-Madison</li><li>Glencoe Software, Inc.</li><li>University of Dundee</li></ul><br><br>See <a href=\"http://loci.wisc.edu/software/scifio\">http://loci.wisc.edu/software/scifio</a><br>for help with using SCIFIO.";
                JOptionPane.showMessageDialog(null, "<html>SCIFIO core for reading and converting file formats.<br>Copyright (C) 2005 - 2013 Open Microscopy Environment:<ul><li>Board of Regents of the University of Wisconsin-Madison</li><li>Glencoe Software, Inc.</li><li>University of Dundee</li></ul><br><br>See <a href=\"http://loci.wisc.edu/software/scifio\">http://loci.wisc.edu/software/scifio</a><br>for help with using SCIFIO.", "SCIFIO", 1);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            boolean outOfBounds = false;
            this.updateLabel(-1, -1);
            BufferedImage image = this.getImage();
            if (image == null) {
                this.iconLabel.setIcon(null);
                this.iconLabel.setText("No image plane");
            } else {
                this.icon.setImage(image);
                this.iconLabel.setIcon(this.icon);
                this.iconLabel.setText(null);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.anim = !this.anim;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateLabel(e.getX(), e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateLabel(e.getX(), e.getY());
        }

        @Override
        public void run() {
            while (this.isVisible()) {
                try {
                    Thread.sleep(1000 / this.fps);
                }
                catch (InterruptedException exc) {
                    this.logService.debug((Object)"", (Throwable)exc);
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            try {
                if (this.myWriter != null) {
                    this.myWriter.close();
                }
                if (this.canCloseReader && this.myReader != null) {
                    this.myReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void updateLabel(int x, int y) {
            int h;
            BufferedImage image;
            if (this.images == null) {
                return;
            }
            int ndx = this.getPlaneIndex();
            this.sb.setLength(0);
            if (this.images.length > 1) {
                this.sb.append("N=");
                this.sb.append(ndx + 1);
                this.sb.append("/");
                this.sb.append(this.images.length);
            }
            int w = (image = this.images[ndx]) == null ? -1 : image.getWidth();
            int n = h = image == null ? -1 : image.getHeight();
            if (x >= w) {
                x = w - 1;
            }
            if (y >= h) {
                y = h - 1;
            }
            if (x >= 0 && y >= 0) {
                if (this.images.length > 1) {
                    this.sb.append("; ");
                }
                this.sb.append("X=");
                this.sb.append(x);
                if (w > 0) {
                    this.sb.append("/");
                    this.sb.append(w);
                }
                this.sb.append("; Y=");
                this.sb.append(y);
                if (h > 0) {
                    this.sb.append("/");
                    this.sb.append(h);
                }
                if (image != null) {
                    WritableRaster r = image.getRaster();
                    double[] pix = r.getPixel(x, y, (double[])null);
                    this.sb.append("; value");
                    this.sb.append(pix.length > 1 ? "s=(" : "=");
                    for (int i = 0; i < pix.length; ++i) {
                        if (i > 0) {
                            this.sb.append(", ");
                        }
                        this.sb.append(pix[i]);
                    }
                    if (pix.length > 1) {
                        this.sb.append(")");
                    }
                    this.sb.append("; type=");
                    int pixelType = AWTImageTools.getPixelType((BufferedImage)image);
                    this.sb.append(FormatTools.getPixelTypeString((int)pixelType));
                }
            }
            this.sb.append(" ");
            this.probeLabel.setText(this.sb.toString());
        }

        protected void wait(boolean wait) {
            this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
        }

        protected void open(final Location source, final Reader r) {
            new Thread("ImageViewer-Opener"){

                @Override
                public void run() {
                    try {
                        ImageViewer.this.myReader.close();
                    }
                    catch (IOException exc) {
                        ImageViewer.this.logService.info((Object)"", (Throwable)exc);
                    }
                    ImageViewer.this.myReader = r;
                    ImageViewer.this.open(source);
                }
            }.start();
        }

        protected void save(final Location destination, final Writer w) {
            new Thread("ImageViewer-Saver"){

                @Override
                public void run() {
                    try {
                        ImageViewer.this.myWriter.close();
                    }
                    catch (IOException exc) {
                        ImageViewer.this.logService.info((Object)"", (Throwable)exc);
                    }
                    ImageViewer.this.myWriter = w;
                    ImageViewer.this.save(destination);
                }
            }.start();
        }
    }
}

