/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.remote;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.CoordAxisReader;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageReader;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.TimeAxis2DFmrcReg;
import ucar.nc2.ft2.coverage.TimeOffsetAxis;
import ucar.nc2.ft2.coverage.remote.CdmrCoverageReader;
import ucar.nc2.ft2.coverage.remote.CdmrFeatureProto;
import ucar.nc2.ft2.coverage.remote.CoverageDataResponse;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;

public class CdmrfReader {
    private static final boolean showRequest = false;
    String endpoint;

    public CdmrfReader(String endpoint) {
        this.endpoint = endpoint;
    }

    public CoverageCollection open() throws IOException {
        long start = System.currentTimeMillis();
        HTTPSession httpClient = HTTPFactory.newSession((String)this.endpoint);
        String url = this.endpoint + "?req=header";
        CdmrCoverageReader reader = new CdmrCoverageReader(this.endpoint, httpClient);
        try (HTTPMethod method = HTTPFactory.Get((HTTPSession)httpClient, (String)url);){
            method.setFollowRedirects(true);
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(CdmrfReader.getErrorMessage(method));
            }
            if (statusCode >= 300) {
                throw new IOException(CdmrfReader.getErrorMessage(method));
            }
            InputStream is = method.getResponseAsStream();
            byte[] b = new byte[4];
            NcStream.readFully(is, b);
            if (!NcStream.test(b, NcStream.MAGIC_HEADERCOV)) {
                throw new IOException("Data corrupted on " + this.endpoint);
            }
            int msize = NcStream.readVInt(is);
            byte[] m = new byte[msize];
            NcStream.readFully(is, m);
            CdmrFeatureProto.CoverageDataset proto = CdmrFeatureProto.CoverageDataset.parseFrom(m);
            CoverageCollection gridDataset = this.decodeHeader(proto, reader);
            long took = System.currentTimeMillis() - start;
            CoverageCollection coverageCollection = gridDataset;
            return coverageCollection;
        }
    }

    private static String getErrorMessage(HTTPMethod method) {
        String path = method.getURI().toString();
        String status = method.getStatusLine();
        String content = method.getResponseAsString();
        return content == null ? path + " " + status : path + " " + status + "\n " + content;
    }

    CoverageCollection decodeHeader(CdmrFeatureProto.CoverageDataset proto, CdmrCoverageReader reader) {
        String name = this.endpoint;
        FeatureType csysType = CdmrfReader.convertCoverageType(proto.getCoverageType());
        LatLonRect latLonBoundingBox = this.decodeLatLonRectangle(proto.getLatlonRect());
        ProjectionRect projBoundingBox = this.decodeProjRectangle(proto.getProjRect());
        CalendarDateRange calendarDateRange = proto.hasDateRange() ? this.decodeDateRange(proto.getDateRange()) : null;
        AttributeContainerMutable gatts = new AttributeContainerMutable(name);
        for (NcStreamProto.Attribute attribute : proto.getAttsList()) {
            gatts.addAttribute(NcStream.decodeAtt(attribute));
        }
        ArrayList<CoverageCoordSys> coordSys = new ArrayList<CoverageCoordSys>();
        for (CdmrFeatureProto.CoordSys coordSys2 : proto.getCoordSysList()) {
            coordSys.add(this.decodeCoordSys(coordSys2));
        }
        ArrayList<CoverageTransform> arrayList = new ArrayList<CoverageTransform>();
        for (CdmrFeatureProto.CoordTransform coordTransform : proto.getCoordTransformsList()) {
            arrayList.add(this.decodeCoordTransform(coordTransform));
        }
        ArrayList<CoverageCoordAxis> arrayList2 = new ArrayList<CoverageCoordAxis>();
        for (CdmrFeatureProto.CoordAxis paxes : proto.getCoordAxesList()) {
            arrayList2.add(this.decodeCoordAxis(paxes, reader));
        }
        ArrayList<Coverage> arrayList3 = new ArrayList<Coverage>();
        for (CdmrFeatureProto.Coverage pgrid : proto.getGridsList()) {
            arrayList3.add(this.decodeGrid(pgrid, reader));
        }
        return new CoverageCollection(name, csysType, gatts, latLonBoundingBox, projBoundingBox, calendarDateRange, coordSys, arrayList, arrayList2, arrayList3, reader);
    }

    LatLonRect decodeLatLonRectangle(CdmrFeatureProto.Rectangle proto) {
        LatLonPoint start = LatLonPoint.create(proto.getStarty(), proto.getStartx());
        return new LatLonRect(start, proto.getIncy(), proto.getIncx());
    }

    ProjectionRect decodeProjRectangle(CdmrFeatureProto.Rectangle proto) {
        ProjectionPoint pt = ProjectionPoint.create(proto.getStartx(), proto.getStarty());
        return new ProjectionRect(pt, proto.getIncy(), proto.getIncx());
    }

    CalendarDateRange decodeDateRange(CdmrFeatureProto.CalendarDateRange proto) {
        Calendar cal = CdmrfReader.convertCalendar(proto.getCalendar());
        CalendarDate start = CalendarDate.of(cal, proto.getStart());
        CalendarDate end = CalendarDate.of(cal, proto.getEnd());
        return CalendarDateRange.of(start, end);
    }

    CoverageCoordSys decodeCoordSys(CdmrFeatureProto.CoordSys proto) {
        return new CoverageCoordSys(proto.getName(), (List<String>)proto.getAxisNamesList(), (List<String>)proto.getTransformNamesList(), CdmrfReader.convertCoverageType(proto.getCoverageType()));
    }

    CoverageTransform decodeCoordTransform(CdmrFeatureProto.CoordTransform proto) {
        String name = proto.getName();
        AttributeContainerMutable atts = new AttributeContainerMutable(name);
        for (NcStreamProto.Attribute patt : proto.getParamsList()) {
            atts.addAttribute(NcStream.decodeAtt(patt));
        }
        return new CoverageTransform(name, atts, proto.getIsHoriz());
    }

    CoverageCoordAxis decodeCoordAxis(CdmrFeatureProto.CoordAxis proto, CoordAxisReader reader) {
        AxisType axisType = CdmrfReader.convertAxisType(proto.getAxisType());
        String name = proto.getName();
        DataType dataType = NcStream.convertDataType(proto.getDataType());
        CoverageCoordAxis.DependenceType dependenceType = CdmrfReader.convertDependenceType(proto.getDepend());
        CoverageCoordAxis.Spacing spacing = CdmrfReader.convertSpacing(proto.getSpacing());
        Formatter result = new Formatter();
        for (String s : proto.getDependsOnList()) {
            result.format("%s ", s);
        }
        String dependsOn = result.toString().trim();
        AttributeContainerMutable atts = new AttributeContainerMutable("axis atts");
        for (NcStreamProto.Attribute patt : proto.getAttsList()) {
            atts.addAttribute(NcStream.decodeAtt(patt));
        }
        int ncoords = (int)proto.getNvalues();
        double[] values = null;
        if (!proto.getValues().isEmpty()) {
            ByteBuffer bb = ByteBuffer.wrap(proto.getValues().toByteArray());
            DoubleBuffer db = bb.asDoubleBuffer();
            int n = db.remaining();
            values = new double[n];
            for (int i = 0; i < n; ++i) {
                values[i] = db.get(i);
            }
        }
        int[] shape = new int[proto.getShapeCount()];
        for (int i = 0; i < proto.getShapeCount(); ++i) {
            shape[i] = proto.getShape(i);
        }
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder();
        builder.name = name;
        builder.units = proto.getUnits();
        builder.description = proto.getDescription();
        builder.dataType = dataType;
        builder.axisType = axisType;
        builder.attributes = atts;
        builder.dependenceType = dependenceType;
        builder.setDependsOn(dependsOn);
        builder.spacing = spacing;
        builder.ncoords = ncoords;
        builder.startValue = proto.getStartValue();
        builder.endValue = proto.getEndValue();
        builder.resolution = proto.getResolution();
        builder.values = values;
        builder.reader = reader;
        builder.isSubset = false;
        Object object = builder.shape = (Object)(shape.length > 0 ? shape : null);
        if (dependenceType == CoverageCoordAxis.DependenceType.fmrcReg) {
            return new TimeAxis2DFmrcReg(builder);
        }
        if (dependenceType == CoverageCoordAxis.DependenceType.twoD && (axisType == AxisType.Lat || axisType == AxisType.Lon)) {
            return new LatLonAxis2D(builder);
        }
        if (axisType == AxisType.TimeOffset) {
            return new TimeOffsetAxis(builder);
        }
        return new CoverageCoordAxis1D(builder);
    }

    Coverage decodeGrid(CdmrFeatureProto.Coverage proto, CoverageReader reader) {
        DataType dataType = NcStream.convertDataType(proto.getDataType());
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (NcStreamProto.Attribute patt : proto.getAttsList()) {
            atts.add(NcStream.decodeAtt(patt));
        }
        return new Coverage(proto.getName(), dataType, atts, proto.getCoordSys(), proto.getUnits(), proto.getDescription(), reader, null);
    }

    public static AxisType convertAxisType(CdmrFeatureProto.AxisType dtype) {
        switch (dtype) {
            case RunTime: {
                return AxisType.RunTime;
            }
            case Ensemble: {
                return AxisType.Ensemble;
            }
            case Time: {
                return AxisType.Time;
            }
            case GeoX: {
                return AxisType.GeoX;
            }
            case GeoY: {
                return AxisType.GeoY;
            }
            case GeoZ: {
                return AxisType.GeoZ;
            }
            case Lat: {
                return AxisType.Lat;
            }
            case Lon: {
                return AxisType.Lon;
            }
            case Height: {
                return AxisType.Height;
            }
            case Pressure: {
                return AxisType.Pressure;
            }
            case RadialAzimuth: {
                return AxisType.RadialAzimuth;
            }
            case RadialDistance: {
                return AxisType.RadialDistance;
            }
            case RadialElevation: {
                return AxisType.RadialElevation;
            }
            case Spectral: {
                return AxisType.Spectral;
            }
            case TimeOffset: {
                return AxisType.TimeOffset;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }

    public static Calendar convertCalendar(CdmrFeatureProto.Calendar type) {
        switch (type) {
            case gregorian: {
                return Calendar.gregorian;
            }
            case proleptic_gregorian: {
                return Calendar.proleptic_gregorian;
            }
            case noleap: {
                return Calendar.noleap;
            }
            case all_leap: {
                return Calendar.all_leap;
            }
            case uniform30day: {
                return Calendar.uniform30day;
            }
            case julian: {
                return Calendar.julian;
            }
            case none: {
                return Calendar.none;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)type));
    }

    public static FeatureType convertCoverageType(CdmrFeatureProto.CoverageType type) {
        switch (type) {
            case General: {
                return FeatureType.COVERAGE;
            }
            case Curvilinear: {
                return FeatureType.CURVILINEAR;
            }
            case Grid: {
                return FeatureType.GRID;
            }
            case Swath: {
                return FeatureType.SWATH;
            }
            case Fmrc: {
                return FeatureType.FMRC;
            }
        }
        throw new IllegalStateException("illegal CoverageType " + (Object)((Object)type));
    }

    public static CoverageCoordAxis.DependenceType convertDependenceType(CdmrFeatureProto.DependenceType type) {
        switch (type) {
            case independent: {
                return CoverageCoordAxis.DependenceType.independent;
            }
            case dependent: {
                return CoverageCoordAxis.DependenceType.dependent;
            }
            case scalar: {
                return CoverageCoordAxis.DependenceType.scalar;
            }
            case twoD: {
                return CoverageCoordAxis.DependenceType.twoD;
            }
            case fmrcReg: {
                return CoverageCoordAxis.DependenceType.fmrcReg;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)type));
    }

    public static CoverageCoordAxis.Spacing convertSpacing(CdmrFeatureProto.AxisSpacing type) {
        switch (type) {
            case regularPoint: {
                return CoverageCoordAxis.Spacing.regularPoint;
            }
            case irregularPoint: {
                return CoverageCoordAxis.Spacing.irregularPoint;
            }
            case contiguousInterval: {
                return CoverageCoordAxis.Spacing.contiguousInterval;
            }
            case discontiguousInterval: {
                return CoverageCoordAxis.Spacing.discontiguousInterval;
            }
            case regularInterval: {
                return CoverageCoordAxis.Spacing.regularInterval;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)type));
    }

    public CoverageDataResponse decodeDataResponse(CdmrFeatureProto.CoverageDataResponse dproto) {
        ArrayList<CoverageTransform> transforms = new ArrayList<CoverageTransform>();
        for (CdmrFeatureProto.CoordTransform coordTransform : dproto.getCoordTransformsList()) {
            transforms.add(this.decodeCoordTransform(coordTransform));
        }
        ArrayList<CoverageCoordSys> coordSys = new ArrayList<CoverageCoordSys>();
        for (CdmrFeatureProto.CoordSys coordSys2 : dproto.getCoordSysList()) {
            coordSys.add(this.decodeCoordSys(coordSys2));
        }
        ArrayList<CoverageCoordAxis> arrayList = new ArrayList<CoverageCoordAxis>();
        for (CdmrFeatureProto.CoordAxis paxis : dproto.getCoordAxesList()) {
            arrayList.add(this.decodeCoordAxis(paxis, null));
        }
        CoverageDataResponse coverageDataResponse = new CoverageDataResponse(arrayList, coordSys, transforms);
        for (CdmrFeatureProto.GeoReferencedArray psys : dproto.getGeoArrayList()) {
            coverageDataResponse.arrayResponse.add(this.decodeGeoReferencedArray(coverageDataResponse, psys));
        }
        return coverageDataResponse;
    }

    public GeoReferencedArray decodeGeoReferencedArray(CoverageDataResponse dataResponse, CdmrFeatureProto.GeoReferencedArray parray) {
        DataType dataType = NcStream.convertDataType(parray.getDataType());
        ByteOrder byteOrder = parray.getBigend() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        boolean deflate = parray.getCompress() == NcStreamProto.Compress.DEFLATE;
        long uncompressedSize = parray.getUncompressedSize();
        int[] shape = new int[parray.getShapeCount()];
        for (int i = 0; i < parray.getShapeCount(); ++i) {
            shape[i] = parray.getShape(i);
        }
        ByteBuffer bb = parray.getPrimdata().asReadOnlyByteBuffer();
        bb.order(byteOrder);
        Array data = Array.factory(dataType, shape, bb);
        CoverageCoordSys csys = dataResponse.findCoordSys(parray.getCoordSysName());
        if (csys == null) {
            throw new IllegalStateException("Misformed response - no coordsys");
        }
        return new GeoReferencedArray(parray.getCoverageName(), dataType, data, csys);
    }
}

