/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.plot.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Objects;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.Plot;

class Utils {
    Utils() {
    }

    static JFreeChart setupJFreeChart(String title, Plot plot) {
        JFreeChart chart = new JFreeChart(plot);
        chart.setTitle(title);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        return chart;
    }

    static ValueAxis getJFreeChartAxis(org.scijava.plot.NumberAxis v) {
        return v.isLogarithmic() ? Utils.logarithmicAxis(v) : Utils.linearAxis(v);
    }

    static ValueAxis logarithmicAxis(org.scijava.plot.NumberAxis v) {
        LogAxis axis = new LogAxis(v.getLabel());
        switch (v.getRangeStrategy()) {
            case MANUAL: {
                axis.setRange(v.getMin(), v.getMax());
                break;
            }
            default: {
                axis.setAutoRange(true);
            }
        }
        return axis;
    }

    static ValueAxis linearAxis(org.scijava.plot.NumberAxis v) {
        NumberAxis axis = new NumberAxis(v.getLabel());
        switch (v.getRangeStrategy()) {
            case MANUAL: {
                axis.setRange(v.getMin(), v.getMax());
                break;
            }
            case AUTO: {
                axis.setAutoRange(true);
                axis.setAutoRangeIncludesZero(false);
                break;
            }
            case AUTO_INCLUDE_ZERO: {
                axis.setAutoRange(true);
                axis.setAutoRangeIncludesZero(true);
                break;
            }
            default: {
                axis.setAutoRange(true);
            }
        }
        return axis;
    }

    static class SortedLabel
    implements Comparable<SortedLabel> {
        private final Object label;
        private final int id;

        SortedLabel(int id, Object label) {
            this.label = Objects.requireNonNull(label);
            this.id = id;
        }

        public String toString() {
            return this.label.toString();
        }

        @Override
        public int compareTo(SortedLabel o) {
            return Integer.compare(this.id, o.id);
        }

        public Object getLabel() {
            return this.label;
        }
    }

    static class SortedLabelFactory {
        private int n = 0;

        SortedLabelFactory() {
        }

        SortedLabel newLabel(Object label) {
            return new SortedLabel(this.n++, label);
        }
    }
}

