/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.cfg.CfgPredicates;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.Statement;

public class BasicBlock {
    private final IRBody parent;
    private String debugId;
    private Set<IRLabel> labels;
    private List<Statement> statements = Lists.newArrayList();

    public BasicBlock(IRBody parent2) {
        this.parent = parent2;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public void insertPhiFunction(Variable variable, int count) {
        this.statements.add(0, new Assignment(variable, new PhiFunction(variable, count)));
    }

    public Statement replaceStatement(Statement stmt, Statement newStmt) {
        int i = this.statements.indexOf(stmt);
        this.statements.set(i, newStmt);
        return newStmt;
    }

    public void replaceStatement(int i, Statement stmt) {
        this.statements.set(i, stmt);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setDebugId(int index) {
        this.debugId = "BB" + index;
    }

    public void setDebugId(String string) {
        this.debugId = string;
    }

    public static BasicBlock createWithStartAt(IRBody parent2, int statementIndex) {
        BasicBlock block = new BasicBlock(parent2);
        block.labels = parent2.getIntructionLabels(statementIndex);
        block.statements = Lists.newArrayList();
        block.statements.add(parent2.getStatements().get(statementIndex));
        return block;
    }

    public Set<IRLabel> getLabels() {
        return this.labels;
    }

    public boolean isLabeled() {
        return !this.labels.isEmpty();
    }

    public Statement getTerminal() {
        return this.statements.get(this.statements.size() - 1);
    }

    public boolean returns() {
        return this.getTerminal() instanceof ReturnStatement;
    }

    public boolean fallsThrough() {
        Statement terminal = this.getTerminal();
        return !(terminal instanceof GotoStatement) && !(terminal instanceof IfStatement) && !(terminal instanceof ReturnStatement);
    }

    public Iterable<IRLabel> targets() {
        return this.getTerminal().possibleTargets();
    }

    public String statementsToString() {
        StringBuilder sb = new StringBuilder();
        for (Statement statment : this.statements) {
            sb.append(statment).append("\n");
        }
        return sb.toString();
    }

    public Set<Variable> variables() {
        HashSet variables = Sets.newHashSet();
        for (Statement statement : this.statements) {
            variables.addAll(statement.variables());
        }
        return Collections.unmodifiableSet(variables);
    }

    public Iterable<Assignment> assignments() {
        return Iterables.filter(this.statements, (Predicate)Predicates.instanceOf(Assignment.class));
    }

    public Iterable<Assignment> phiAssignments() {
        return Iterables.filter(this.statements, CfgPredicates.isPhiAssignment());
    }

    public String toString() {
        return this.debugId;
    }
}

