/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.multiKymograph;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class MultipleKymograph_
implements PlugIn {
    double[] profile;

    public void run(String arg) {
        String sPrompt;
        int linewidth;
        boolean storeexist = false;
        int storeID = 0;
        ImagePlus imp = WindowManager.getCurrentImage();
        ImageProcessor ip = imp.getProcessor();
        int numStacks = imp.getStackSize();
        int wincount = WindowManager.getWindowCount();
        int[] idlist = WindowManager.getIDList();
        for (int i = 0; i < wincount; ++i) {
            ImagePlus test = WindowManager.getImage((int)idlist[i]);
            String wintitle = test.getTitle();
            if (!wintitle.equals("Storage") && !wintitle.equals("Storage.tif")) continue;
            storeexist = true;
            storeID = idlist[i];
        }
        int bd = imp.getBitDepth();
        if (numStacks == 1) {
            IJ.error((String)"Sorry! This Plugin only works on Stacks");
            return;
        }
        Roi roi = imp.getRoi();
        int roiType = 0;
        if (roi != null) {
            roiType = roi.getType();
            if (roiType != 5 && roiType != 6) {
                IJ.error((String)"Line or rectangular selection required.");
                return;
            }
        } else if (!storeexist) {
            IJ.error((String)"Selection required");
            return;
        }
        if ((linewidth = (int)IJ.getNumber((String)(sPrompt = "Linewidth "), (double)1.0)) == Integer.MIN_VALUE) {
            return;
        }
        if (linewidth >= numStacks) {
            IJ.error((String)"Sorry, this makes no sense");
            return;
        }
        if (linewidth % 2 == 0) {
            IJ.error((String)"Must enter an odd number");
            return;
        }
        if (storeexist) {
            IJ.showMessage((String)"Line from Store");
            ImagePlus store = WindowManager.getImage((int)storeID);
            ImageProcessor store_ip = store.getProcessor();
            this.multipleKymo(imp, ip, store_ip, numStacks, linewidth);
            return;
        }
        this.profile = roiType == 5 ? ((Line)roi).getPixels() : this.getIrregularProfile(roi, ip, 0);
        int proflength = this.profile.length;
        double[] average = this.sKymo(imp, ip, roi, linewidth, proflength);
        FloatProcessor nip = new FloatProcessor(proflength, imp.getStackSize(), average);
        ImagePlus kymo = new ImagePlus("Kymograph", (ImageProcessor)nip);
        kymo.show();
    }

    public double[] sKymo(ImagePlus imp, ImageProcessor ip, Roi roi, int linewidth, int proflength) {
        int numStacks = imp.getStackSize();
        int dimension = proflength * numStacks;
        double[] sum = new double[dimension];
        int roiType = roi.getType();
        int shift = 0;
        int count = 0;
        for (int i = 1; i <= numStacks; ++i) {
            imp.setSlice(i);
            for (int ii = 0; ii < linewidth; ++ii) {
                shift = -1 * (linewidth - 1) / 2 + ii;
                this.profile = roiType == 5 ? this.getProfile(roi, ip, shift) : this.getIrregularProfile(roi, ip, shift);
                for (int j = 0; j < proflength; ++j) {
                    int n = count = (i - 1) * proflength + j;
                    sum[n] = sum[n] + this.profile[j] / (double)linewidth;
                }
            }
        }
        return sum;
    }

    public void multipleKymo(ImagePlus imp, ImageProcessor ip, ImageProcessor store_ip, int numStacks, int linewidth) {
        short[] zahl = (short[])store_ip.getPixels();
        int shift = 0;
        for (int i = 1; i <= zahl[0]; ++i) {
            this.profile = this.getStoreProfile(store_ip, ip, 0, i);
            int proflength = this.profile.length;
            int dimension = numStacks * proflength;
            double[] sum = new double[dimension];
            for (int j = 1; j <= numStacks; ++j) {
                imp.setSlice(j);
                for (int ii = 0; ii < linewidth; ++ii) {
                    shift = -1 * (linewidth - 1) / 2 + ii;
                    this.profile = this.getStoreProfile(store_ip, ip, shift, i);
                    for (int k = 0; k < proflength; ++k) {
                        int count1;
                        int n = count1 = (j - 1) * proflength + k;
                        sum[n] = sum[n] + this.profile[k] / (double)linewidth;
                    }
                }
            }
            FloatProcessor nip = new FloatProcessor(proflength, imp.getStackSize(), sum);
            ImagePlus kymo = new ImagePlus("Kymograph" + i, (ImageProcessor)nip);
            kymo.show();
        }
    }

    public double[] getStoreProfile(ImageProcessor store_ip, ImageProcessor ip, int shift, int numline) {
        int i;
        int[] x = new int[500];
        int[] y = new int[500];
        short[] pixels = (short[])store_ip.getPixels();
        int n = pixels[0];
        int num = 1;
        for (i = 0; i < n; ++i) {
            int anfang = num + 1;
            int stop = pixels[num];
            num += pixels[num] * 2 + 1;
            if (i + 1 != numline) continue;
            n = pixels[anfang - 1];
            for (int j = 0; j < stop; ++j) {
                x[j] = pixels[anfang + j];
                y[j] = pixels[anfang + stop + j];
            }
        }
        i = 0;
        while (i <= n) {
            int n2 = i;
            x[n2] = x[n2] + shift;
            int n3 = i++;
            y[n3] = y[n3] + shift;
        }
        int xbase = 0;
        int ybase = 0;
        double length = 0.0;
        double[] segmentLengths = new double[n];
        int[] dx = new int[n];
        int[] dy = new int[n];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            int xdelta = x[i2 + 1] - x[i2];
            int ydelta = y[i2 + 1] - y[i2];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            length += segmentLength;
            segmentLengths[i2] = segmentLength;
            dx[i2] = xdelta;
            dy[i2] = ydelta;
        }
        double[] values = new double[(int)length];
        double leftOver = 1.0;
        double distance = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            double len = segmentLengths[i3];
            if (len == 0.0) continue;
            double xinc = (double)dx[i3] / len;
            double yinc = (double)dy[i3] / len;
            double start = 1.0 - leftOver;
            double rx = (double)(xbase + x[i3]) + start * xinc;
            double ry = (double)(ybase + y[i3]) + start * yinc;
            double len2 = len - start;
            int n2 = (int)len2;
            for (int j = 0; j <= n2; ++j) {
                int index = (int)distance + j;
                if (index < values.length) {
                    values[index] = ip.getInterpolatedValue(rx, ry);
                }
                rx += xinc;
                ry += yinc;
            }
            distance += len;
            leftOver = len2 - (double)n2;
        }
        return values;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor ip, int shift) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] x = ((PolygonRoi)roi).getXCoordinates();
        int[] y = ((PolygonRoi)roi).getYCoordinates();
        int i = 0;
        while (i < n) {
            int n2 = i;
            x[n2] = x[n2] + shift;
            int n3 = i++;
            y[n3] = y[n3] + shift;
        }
        Rectangle r = roi.getBoundingRect();
        int xbase = r.x;
        int ybase = r.y;
        double length = 0.0;
        double[] segmentLengths = new double[n];
        int[] dx = new int[n];
        int[] dy = new int[n];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            int xdelta = x[i2 + 1] - x[i2];
            int ydelta = y[i2 + 1] - y[i2];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            length += segmentLength;
            segmentLengths[i2] = segmentLength;
            dx[i2] = xdelta;
            dy[i2] = ydelta;
        }
        double[] values = new double[(int)length];
        double leftOver = 1.0;
        double distance = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            double len = segmentLengths[i3];
            if (len == 0.0) continue;
            double xinc = (double)dx[i3] / len;
            double yinc = (double)dy[i3] / len;
            double start = 1.0 - leftOver;
            double rx = (double)(xbase + x[i3]) + start * xinc;
            double ry = (double)(ybase + y[i3]) + start * yinc;
            double len2 = len - start;
            int n2 = (int)len2;
            for (int j = 0; j <= n2; ++j) {
                int index = (int)distance + j;
                if (index < values.length) {
                    values[index] = ip.getInterpolatedValue(rx, ry);
                }
                rx += xinc;
                ry += yinc;
            }
            distance += len;
            leftOver = len2 - (double)n2;
        }
        return values;
    }

    double[] getProfile(Roi roi, ImageProcessor ip, int shift) {
        int x1 = ((Line)roi).x1;
        int x2 = ((Line)roi).x2;
        int y1 = ((Line)roi).y1;
        int y2 = ((Line)roi).y2;
        ((Line)roi).x1 = x1 + shift;
        ((Line)roi).x2 = x2 + shift;
        ((Line)roi).y1 = y1 + shift;
        ((Line)roi).y2 = y2 + shift;
        double[] values = ((Line)roi).getPixels();
        ((Line)roi).x1 = x1;
        ((Line)roi).x2 = x2;
        ((Line)roi).y1 = y1;
        ((Line)roi).y2 = y2;
        return values;
    }

    void showAbout() {
        IJ.showMessage((String)"About Kymograph...", (String)"This plugin creates a so called time space plot. Look\nIt requires a stack of 8-Bit-Gray scale pictures and a line selection.");
    }
}

