/*
 * Decompiled with CFR 0.152.
 */
package registration3d;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.BrowserLauncher;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.process.StackConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.atomic.AtomicInteger;

public class Fast_FourierTransform
implements PlugIn {
    private String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    private static String[] methodList = new String[]{"No Logarithm", "Base-e Logarithm", "Base-10 Logarithm", "Generalized Logarithm (gLog, c = 2)"};
    private static String[] colorList = new String[]{"Red", "Green", "Blue", "Red and Green", "Red and Blue", "Green and Blue", "Red, Green and Blue"};

    public void run(String arg) {
        boolean isRGB;
        ImagePlus power = null;
        ImagePlus phase = null;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (null == imp) {
            IJ.noImage();
            return;
        }
        if (imp.getType() == 4 || imp.getType() == 3) {
            isRGB = true;
            if (imp.getType() == 3) {
                if (imp.getStackSize() > 1) {
                    new StackConverter(imp).convertToRGB();
                } else {
                    imp.setProcessor(imp.getTitle(), imp.getProcessor().convertToRGB());
                }
            }
        } else {
            isRGB = false;
        }
        if (null == imp) {
            IJ.log((String)"No images open.");
            return;
        }
        GenericDialog gd = new GenericDialog("Fast Fourier Transform (2D/3D)");
        String[] FFTs = new String[]{"Forward", "Backward"};
        gd.addChoice("Use_Channel", colorList, colorList[colorList.length - 1]);
        if (!isRGB) {
            ((Component)gd.getChoices().get(0)).setEnabled(false);
        }
        gd.addChoice("Direction_of_FFT_Transform", FFTs, FFTs[0]);
        gd.addCheckbox("Use_Multi-Threaded FFT", true);
        gd.addCheckbox("Windowing", true);
        gd.addChoice("Type_of_Logarithm_for_Power_Spectrum", methodList, methodList[3]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\n" + this.myURL);
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        this.addHyperLinkListener(text);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String channel = gd.getNextChoice();
        String fftdirection = gd.getNextChoice();
        boolean multiThreaded = gd.getNextBoolean();
        boolean windowing = gd.getNextBoolean();
        String behaviour = gd.getNextChoice();
        boolean forward = true;
        if (fftdirection.equals(FFTs[1])) {
            forward = false;
            int[] idList = WindowManager.getIDList();
            if (idList == null || idList.length < 2) {
                IJ.error((String)"You need two open images, the power and the phase spectrum.");
                return;
            }
            String[] list = new String[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                list[i] = WindowManager.getImage((int)idList[i]).getTitle();
            }
            GenericDialog gdInv = new GenericDialog("Images for inverse FFT");
            gdInv.addChoice("Power_Spectrum", list, list[0]);
            gdInv.addChoice("Phase_Spectrum", list, list[1]);
            gdInv.showDialog();
            if (gdInv.wasCanceled()) {
                return;
            }
            String powerName = gdInv.getNextChoice();
            String phaseName = gdInv.getNextChoice();
            power = WindowManager.getImage((String)powerName);
            phase = WindowManager.getImage((String)phaseName);
        }
        if (forward) {
            this.computeForwardTransform(imp, windowing, behaviour, channel, multiThreaded);
        } else {
            this.computeBackwardTransform(power, phase, behaviour, multiThreaded);
        }
    }

    private final void addHyperLinkListener(final MultiLineLabel text) {
        text.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.openURL((String)Fast_FourierTransform.this.myURL);
                }
                catch (Exception ex) {
                    IJ.error((String)("" + ex));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                text.setForeground(Color.BLUE);
                text.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                text.setForeground(Color.BLACK);
                text.setCursor(new Cursor(0));
            }
        });
    }

    public void computeBackwardTransform(ImagePlus power, ImagePlus phase, String behaviour, boolean multiThreaded) {
        int complexWidth;
        FloatArray img;
        FloatArray phaseSpectrum;
        FloatArray powerSpectrum;
        boolean _3D;
        if (power.getStackSize() != phase.getStackSize() || power.getWidth() != phase.getWidth() || power.getHeight() != phase.getHeight()) {
            IJ.error((String)"Power and Phase Spectrum are not same size. Tip: Extend or crop one of both.");
            return;
        }
        if (power.getStackSize() > 1) {
            ImageStack powerStack = power.getStack();
            ImageStack phaseStack = phase.getStack();
            _3D = true;
            powerSpectrum = this.StackToFloatArray(powerStack);
            phaseSpectrum = this.StackToFloatArray(phaseStack);
        } else {
            _3D = false;
            powerSpectrum = this.ImageToFloatArray(power.getProcessor());
            phaseSpectrum = this.ImageToFloatArray(phase.getProcessor());
        }
        if (_3D) {
            this.rearrangeFFT((FloatArray3D)powerSpectrum);
            this.rearrangeFFT((FloatArray3D)phaseSpectrum);
        } else {
            this.rearrangeFFT((FloatArray2D)powerSpectrum);
            this.rearrangeFFT((FloatArray2D)phaseSpectrum);
        }
        if (behaviour.equals(methodList[3])) {
            for (int i = 0; i < powerSpectrum.data.length; ++i) {
                powerSpectrum.data[i] = (float)Fast_FourierTransform.gLogInv(powerSpectrum.data[i], 2.0);
            }
        } else if (behaviour.equals(methodList[2])) {
            for (int i = 0; i < powerSpectrum.data.length; ++i) {
                powerSpectrum.data[i] = (float)Math.pow(10.0, powerSpectrum.data[i]) - 1.0f;
            }
        } else if (behaviour.equals(methodList[1])) {
            for (int i = 0; i < powerSpectrum.data.length; ++i) {
                powerSpectrum.data[i] = (float)Math.pow(Math.E, powerSpectrum.data[i]) - 1.0f;
            }
        }
        float[] complex = this.computeComplexValues(powerSpectrum.data, phaseSpectrum.data);
        if (_3D) {
            img = new FloatArray3D(complex, ((FloatArray3D)powerSpectrum).width * 2, ((FloatArray3D)powerSpectrum).height, ((FloatArray3D)powerSpectrum).depth);
            complexWidth = ((FloatArray3D)img).width;
        } else {
            img = new FloatArray2D(complex, powerSpectrum.width * 2, powerSpectrum.height);
            complexWidth = img.width;
        }
        phaseSpectrum.data = null;
        powerSpectrum.data = null;
        phaseSpectrum = null;
        powerSpectrum = null;
        int nfft = (complexWidth / 2 - 1) * 2;
        img = _3D ? this.computeInvFFT((FloatArray3D)img, nfft, multiThreaded) : this.computeInvFFT((FloatArray2D)img, nfft);
        if (_3D) {
            this.FloatArrayToStack((FloatArray3D)img, "Inverse FFT", 0.0f, 0.0f).show();
        } else {
            this.FloatArrayToImagePlus((FloatArray2D)img, "Inverse FFT", 0.0f, 0.0f).show();
        }
        img.data = null;
        img = null;
    }

    public void computeForwardTransform(ImagePlus imp, boolean windowing, String behaviour, String rgbType, boolean multiThreaded) {
        int i;
        FloatArray phaseSpectrum;
        FloatArray powerSpectrum;
        FloatArray img;
        boolean _3D;
        String imageName = imp.toString();
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            _3D = true;
            img = this.StackToFloatArray(stack, rgbType);
        } else {
            _3D = false;
            img = this.ImageToFloatArray(imp.getProcessor(), rgbType);
        }
        if (windowing) {
            int imgH;
            int imgW;
            int imgD = 0;
            if (_3D) {
                imgW = ((FloatArray3D)img).width;
                imgH = ((FloatArray3D)img).height;
                imgD = ((FloatArray3D)img).depth;
            } else {
                imgW = img.width;
                imgH = img.height;
            }
            int extW = imgW / 4;
            int extH = imgH / 4;
            int extD = imgD / 4;
            if (extW % 2 != 0) {
                ++extW;
            }
            if (extH % 2 != 0) {
                ++extH;
            }
            if (extD % 2 != 0) {
                ++extD;
            }
            img = _3D ? this.extendImageMirror((FloatArray3D)img, imgW + extW, imgH + extH, imgD + extD) : this.extendImageMirror((FloatArray2D)img, imgW + extW, imgH + extH);
            if (_3D) {
                this.exponentialWindow((FloatArray3D)img);
            } else {
                this.exponentialWindow((FloatArray2D)img);
            }
        }
        img = _3D ? this.zeroPadImage((FloatArray3D)img) : this.zeroPadImage((FloatArray2D)img);
        img = _3D ? this.computeFFT((FloatArray3D)img, multiThreaded) : this.computeFFT((FloatArray2D)img);
        float[] power = this.computePowerSpectrum(img.data);
        float[] phase = this.computePhaseSpectrum(img.data);
        if (_3D) {
            powerSpectrum = new FloatArray3D(power, ((FloatArray3D)img).width / 2, ((FloatArray3D)img).height, ((FloatArray3D)img).depth);
            phaseSpectrum = new FloatArray3D(phase, ((FloatArray3D)img).width / 2, ((FloatArray3D)img).height, ((FloatArray3D)img).depth);
        } else {
            powerSpectrum = new FloatArray2D(power, img.width / 2, img.height);
            phaseSpectrum = new FloatArray2D(phase, img.width / 2, img.height);
        }
        img.data = null;
        img = null;
        if (behaviour.equals(methodList[3])) {
            for (i = 0; i < powerSpectrum.data.length; ++i) {
                powerSpectrum.data[i] = (float)Fast_FourierTransform.gLog(powerSpectrum.data[i], 2.0);
            }
        } else if (behaviour.equals(methodList[2])) {
            for (i = 0; i < powerSpectrum.data.length; ++i) {
                powerSpectrum.data[i] = (float)Math.log10(1.0f + powerSpectrum.data[i]);
            }
        } else if (behaviour.equals(methodList[1])) {
            for (i = 0; i < powerSpectrum.data.length; ++i) {
                powerSpectrum.data[i] = (float)Math.log(1.0f + powerSpectrum.data[i]);
            }
        }
        if (_3D) {
            this.rearrangeFFT((FloatArray3D)powerSpectrum);
            this.rearrangeFFT((FloatArray3D)phaseSpectrum);
        } else {
            this.rearrangeFFT((FloatArray2D)powerSpectrum);
            this.rearrangeFFT((FloatArray2D)phaseSpectrum);
        }
        if (_3D) {
            this.FloatArrayToStack((FloatArray3D)powerSpectrum, "Power of " + imageName, 0.0f, 0.0f).show();
            this.FloatArrayToStack((FloatArray3D)phaseSpectrum, "Phase of " + imageName, 0.0f, 0.0f).show();
        } else {
            this.FloatArrayToImagePlus((FloatArray2D)powerSpectrum, "Power of " + imageName, 0.0f, 0.0f).show();
            this.FloatArrayToImagePlus((FloatArray2D)phaseSpectrum, "Phase of " + imageName, 0.0f, 0.0f).show();
        }
        phaseSpectrum.data = null;
        powerSpectrum.data = null;
        phaseSpectrum = null;
        powerSpectrum = null;
    }

    private void rearrangeFFT(FloatArray2D values) {
        float[] fft = values.data;
        int w = values.width;
        int h = values.height;
        int halfDimYRounded = h / 2;
        float[] buffer = new float[w];
        for (int y = 0; y < halfDimYRounded; ++y) {
            int x;
            int pos1 = y * w;
            for (x = 0; x < w; ++x) {
                buffer[x] = fft[pos1++];
            }
            pos1 = y * w;
            int pos2 = (y + halfDimYRounded) * w;
            for (x = 0; x < w; ++x) {
                fft[pos1++] = fft[pos2++];
            }
            pos1 = (y + halfDimYRounded) * w;
            for (x = 0; x < w; ++x) {
                fft[pos1++] = buffer[x];
            }
        }
    }

    private void rearrangeFFT(FloatArray3D values) {
        int x;
        int w = values.width;
        int h = values.height;
        int d = values.depth;
        int halfDimYRounded = h / 2;
        int halfDimZRounded = d / 2;
        float[] buffer = new float[h];
        for (x = 0; x < w; ++x) {
            for (int z = 0; z < d; ++z) {
                int y;
                for (y = 0; y < h / 2; ++y) {
                    buffer[y] = values.get(x, y, z);
                }
                for (y = 0; y < halfDimYRounded; ++y) {
                    values.set(values.get(x, y + h / 2, z), x, y, z);
                }
                for (y = halfDimYRounded; y < h; ++y) {
                    values.set(buffer[y - halfDimYRounded], x, y, z);
                }
            }
        }
        buffer = new float[d];
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int z;
                for (z = 0; z < d / 2; ++z) {
                    buffer[z] = values.get(x, y, z);
                }
                for (z = 0; z < halfDimZRounded; ++z) {
                    values.set(values.get(x, y, z + d / 2), x, y, z);
                }
                for (z = halfDimZRounded; z < d; ++z) {
                    values.set(buffer[z - halfDimZRounded], x, y, z);
                }
            }
        }
    }

    private static double gLog(double z, double c) {
        if (c == 0.0) {
            return z;
        }
        return Math.log10((z + Math.sqrt(z * z + c * c)) / 2.0);
    }

    private static double gLogInv(double w, double c) {
        if (c == 0.0) {
            return w;
        }
        return Fast_FourierTransform.Exp10(w) - c * c * Fast_FourierTransform.Exp10(-w) / 4.0;
    }

    private static double Exp10(double x) {
        return Math.pow(10.0, x);
    }

    private float[] computeComplexValues(float[] power, float[] phase) {
        if (power.length != phase.length) {
            System.err.println("Power and Phase Spectrum are not of same size.");
            return null;
        }
        float[] complex = new float[power.length * 2];
        for (int pos = 0; pos < power.length; ++pos) {
            if (power[pos] == 0.0f) {
                complex[pos * 2] = 0.0f;
                complex[pos * 2 + 1] = 0.0f;
                continue;
            }
            complex[pos * 2] = (float)(Math.cos(phase[pos]) * (double)power[pos]);
            complex[pos * 2 + 1] = (float)(Math.sin(phase[pos]) * (double)power[pos]);
        }
        return complex;
    }

    private float[] computePhaseSpectrum(float[] complex) {
        int wComplex = complex.length / 2;
        float[] phaseSpectrum = new float[wComplex];
        for (int pos = 0; pos < phaseSpectrum.length; ++pos) {
            float a = complex[pos * 2];
            float b = complex[pos * 2 + 1];
            phaseSpectrum[pos] = (double)a != 0.0 || b != 0.0f ? (float)Math.atan2(b, a) : 0.0f;
        }
        return phaseSpectrum;
    }

    private float[] computePowerSpectrum(float[] complex) {
        int wComplex = complex.length / 2;
        float[] powerSpectrum = new float[wComplex];
        for (int pos = 0; pos < wComplex; ++pos) {
            powerSpectrum[pos] = (float)Math.sqrt(Math.pow(complex[pos * 2], 2.0) + Math.pow(complex[pos * 2 + 1], 2.0));
        }
        return powerSpectrum;
    }

    private FloatArray2D zeroPadImage(FloatArray2D img) {
        int widthFFT = FftReal.nfftFast((int)img.width);
        int heightFFT = FftComplex.nfftFast((int)img.height);
        FloatArray2D result = this.zeroPad(img, widthFFT, heightFFT);
        img.data = null;
        img = null;
        return result;
    }

    private FloatArray3D zeroPadImage(FloatArray3D img) {
        int widthFFT = FftReal.nfftFast((int)img.width);
        int heightFFT = FftComplex.nfftFast((int)img.height);
        int depthFFT = FftComplex.nfftFast((int)img.depth);
        FloatArray3D result = this.zeroPad(img, widthFFT, heightFFT, depthFFT);
        img.data = null;
        img = null;
        return result;
    }

    private void exponentialWindow(FloatArray2D img) {
        int y;
        double relPos;
        double a = 1000.0;
        double[] weightsX = new double[img.width];
        double[] weightsY = new double[img.height];
        for (int x = 0; x < img.width; ++x) {
            relPos = (double)x / (double)(img.width - 1);
            weightsX[x] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (y = 0; y < img.height; ++y) {
            relPos = (double)y / (double)(img.height - 1);
            weightsY[y] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (y = 0; y < img.height; ++y) {
            for (int x = 0; x < img.width; ++x) {
                img.set((float)((double)img.get(x, y) * weightsX[x] * weightsY[y]), x, y);
            }
        }
    }

    private void exponentialWindow(FloatArray3D img) {
        int z;
        double relPos;
        double a = 1000.0;
        double[] weightsX = new double[img.width];
        double[] weightsY = new double[img.height];
        double[] weightsZ = new double[img.depth];
        for (int x = 0; x < img.width; ++x) {
            relPos = (double)x / (double)(img.width - 1);
            weightsX[x] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (int y = 0; y < img.height; ++y) {
            relPos = (double)y / (double)(img.height - 1);
            weightsY[y] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (z = 0; z < img.depth; ++z) {
            relPos = (double)z / (double)(img.depth - 1);
            weightsZ[z] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (z = 0; z < img.depth; ++z) {
            for (int y = 0; y < img.height; ++y) {
                for (int x = 0; x < img.width; ++x) {
                    img.set((float)((double)img.get(x, y, z) * weightsX[x] * weightsY[y] * weightsZ[z]), x, y, z);
                }
            }
        }
    }

    private FloatArray2D extendImageMirror(FloatArray2D ip, int width, int height) {
        FloatArray2D image = new FloatArray2D(width, height);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        if (offsetX < 0) {
            IJ.error((String)("Fast_FourierTransform.extendImageMirror(): Extended size in X smaller than image! " + width + " < " + ip.width));
            return null;
        }
        if (offsetY < 0) {
            IJ.error((String)("Fast_FourierTransform.extendImageMirror(): Extended size in Y smaller than image! " + height + " < " + ip.height));
            return null;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.set(ip.getMirror(x - offsetX, y - offsetY), x, y);
            }
        }
        return image;
    }

    private FloatArray3D extendImageMirror(FloatArray3D ip, int width, int height, int depth) {
        FloatArray3D image = new FloatArray3D(width, height, depth);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        int offsetZ = (depth - ip.depth) / 2;
        if (offsetX < 0) {
            IJ.error((String)("Fast_FourierTransform.extendImageMirror(): Extended size in X smaller than image! " + width + " < " + ip.width));
            return null;
        }
        if (offsetY < 0) {
            IJ.error((String)("Fast_FourierTransform.extendImageMirror(): Extended size in Y smaller than image! " + height + " < " + ip.height));
            return null;
        }
        if (offsetZ < 0) {
            IJ.error((String)("Fast_FourierTransform.extendImageMirror(): Extended size in Z smaller than image! " + depth + " < " + ip.depth));
            return null;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    image.set(ip.getMirror(x - offsetX, y - offsetY, z - offsetZ), x, y, z);
                }
            }
        }
        return image;
    }

    private FloatArray2D zeroPad(FloatArray2D ip, int width, int height) {
        FloatArray2D image = new FloatArray2D(width, height);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        if (offsetX < 0) {
            System.err.println("Fast_FourierTransform.ZeroPad(): Zero-Padding size in X smaller than image! " + width + " < " + ip.width);
            return null;
        }
        if (offsetY < 0) {
            System.err.println("Fast_FourierTransform.ZeroPad(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.height);
            return null;
        }
        int count = 0;
        for (int y = 0; y < ip.height; ++y) {
            for (int x = 0; x < ip.width; ++x) {
                image.set(ip.data[count++], x + offsetX, y + offsetY);
            }
        }
        return image;
    }

    private FloatArray3D zeroPad(FloatArray3D ip, int width, int height, int depth) {
        FloatArray3D image = new FloatArray3D(width, height, depth);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        int offsetZ = (depth - ip.depth) / 2;
        if (offsetX < 0) {
            System.err.println("Fast_FourierTransform.ZeroPad(): Zero-Padding size in X smaller than image! " + width + " < " + ip.width);
            return null;
        }
        if (offsetY < 0) {
            System.err.println("Fast_FourierTransform.ZeroPad(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.height);
            return null;
        }
        if (offsetZ < 0) {
            System.err.println("Fast_FourierTransform.ZeroPad(): Zero-Padding size in Z smaller than image! " + depth + " < " + ip.depth);
            return null;
        }
        for (int z = 0; z < ip.depth; ++z) {
            for (int y = 0; y < ip.height; ++y) {
                for (int x = 0; x < ip.width; ++x) {
                    image.set(ip.get(x, y, z), x + offsetX, y + offsetY, z + offsetZ);
                }
            }
        }
        return image;
    }

    private FloatArray2D computeFFT(FloatArray2D img) {
        FloatArray2D fft = this.pffft2D(img, false);
        img.data = null;
        img = null;
        return fft;
    }

    private FloatArray2D computeInvFFT(FloatArray2D values, int nfft) {
        FloatArray2D img = this.pffftInv2D(values, nfft);
        values.data = null;
        values = null;
        return img;
    }

    private FloatArray3D computeInvFFT(FloatArray3D values, int nfft, boolean multiThreaded) {
        FloatArray3D img = multiThreaded ? this.pffftInv3DMT(values, nfft) : this.pffftInv3D(values, nfft);
        values.data = null;
        values = null;
        return img;
    }

    private FloatArray2D pffft2D(FloatArray2D values, boolean scale) {
        int x;
        float[] tempOut;
        int height = values.height;
        int width = values.width;
        int complexWidth = (width / 2 + 1) * 2;
        FloatArray2D result = new FloatArray2D(complexWidth, height);
        float[] tempIn = new float[width];
        FftReal fft = new FftReal(width);
        for (int y = 0; y < height; ++y) {
            tempOut = new float[complexWidth];
            for (x = 0; x < width; ++x) {
                tempIn[x] = values.get(x, y);
            }
            fft.realToComplex(-1, tempIn, tempOut);
            if (scale) {
                fft.scale(width, tempOut);
            }
            for (x = 0; x < complexWidth; ++x) {
                result.set(tempOut[x], x, y);
            }
        }
        tempIn = new float[height * 2];
        FftComplex fftc = new FftComplex(height);
        for (x = 0; x < complexWidth / 2; ++x) {
            int y;
            tempOut = new float[height * 2];
            for (y = 0; y < height; ++y) {
                tempIn[y * 2] = result.get(x * 2, y);
                tempIn[y * 2 + 1] = result.get(x * 2 + 1, y);
            }
            fftc.complexToComplex(-1, tempIn, tempOut);
            for (y = 0; y < height; ++y) {
                result.set(tempOut[y * 2], x * 2, y);
                result.set(tempOut[y * 2 + 1], x * 2 + 1, y);
            }
        }
        return result;
    }

    private FloatArray2D pffftInv2D(FloatArray2D values, int nfft) {
        int y;
        float[] tempOut;
        int height = values.height;
        int width = nfft;
        int complexWidth = (width / 2 + 1) * 2;
        FloatArray2D result = new FloatArray2D(width, height);
        float[] tempIn = new float[height * 2];
        FftComplex fftc = new FftComplex(height);
        for (int x = 0; x < complexWidth / 2; ++x) {
            tempOut = new float[height * 2];
            for (y = 0; y < height; ++y) {
                tempIn[y * 2] = values.get(x * 2, y);
                tempIn[y * 2 + 1] = values.get(x * 2 + 1, y);
            }
            fftc.complexToComplex(1, tempIn, tempOut);
            for (y = 0; y < height; ++y) {
                values.set(tempOut[y * 2], x * 2, y);
                values.set(tempOut[y * 2 + 1], x * 2 + 1, y);
            }
        }
        tempIn = new float[complexWidth];
        FftReal fft = new FftReal(width);
        for (y = 0; y < height; ++y) {
            int x;
            tempOut = new float[width];
            for (x = 0; x < complexWidth; ++x) {
                tempIn[x] = values.get(x, y);
            }
            fft.complexToReal(1, tempIn, tempOut);
            int i = 0;
            while (i < tempOut.length) {
                int n = i++;
                tempOut[n] = tempOut[n] / (float)(width * height);
            }
            for (x = 0; x < width; ++x) {
                result.set(tempOut[x], x, y);
            }
        }
        return result;
    }

    private FloatArray3D computeFFT(FloatArray3D img, boolean multiThreaded) {
        FloatArray3D fft = multiThreaded ? this.pffft3DMT(img, false) : this.pffft3D(img, false);
        img.data = null;
        img = null;
        return fft;
    }

    private FloatArray3D pffft3D(FloatArray3D values, boolean scale) {
        int x;
        float[] tempOut;
        int y;
        int height = values.height;
        int width = values.width;
        int depth = values.depth;
        int complexWidth = (width / 2 + 1) * 2;
        FloatArray3D result = new FloatArray3D(complexWidth, height, depth);
        float[] tempIn = new float[width];
        FftReal fft = new FftReal(width);
        for (int z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                tempOut = new float[complexWidth];
                for (x = 0; x < width; ++x) {
                    tempIn[x] = values.get(x, y, z);
                }
                fft.realToComplex(-1, tempIn, tempOut);
                if (scale) {
                    fft.scale(width, tempOut);
                }
                for (x = 0; x < complexWidth; ++x) {
                    result.set(tempOut[x], x, y, z);
                }
            }
        }
        tempIn = new float[height * 2];
        FftComplex fftc = new FftComplex(height);
        for (int z = 0; z < depth; ++z) {
            for (x = 0; x < complexWidth / 2; ++x) {
                int y2;
                tempOut = new float[height * 2];
                for (y2 = 0; y2 < height; ++y2) {
                    tempIn[y2 * 2] = result.get(x * 2, y2, z);
                    tempIn[y2 * 2 + 1] = result.get(x * 2 + 1, y2, z);
                }
                fftc.complexToComplex(-1, tempIn, tempOut);
                for (y2 = 0; y2 < height; ++y2) {
                    result.set(tempOut[y2 * 2], x * 2, y2, z);
                    result.set(tempOut[y2 * 2 + 1], x * 2 + 1, y2, z);
                }
            }
        }
        tempIn = new float[depth * 2];
        fftc = new FftComplex(depth);
        for (y = 0; y < height; ++y) {
            for (x = 0; x < complexWidth / 2; ++x) {
                int z;
                tempOut = new float[depth * 2];
                for (z = 0; z < depth; ++z) {
                    tempIn[z * 2] = result.get(x * 2, y, z);
                    tempIn[z * 2 + 1] = result.get(x * 2 + 1, y, z);
                }
                fftc.complexToComplex(-1, tempIn, tempOut);
                for (z = 0; z < depth; ++z) {
                    result.set(tempOut[z * 2], x * 2, y, z);
                    result.set(tempOut[z * 2 + 1], x * 2 + 1, y, z);
                }
            }
        }
        return result;
    }

    private FloatArray3D pffft3DMT(final FloatArray3D values, final boolean scale) {
        int ithread;
        final int height = values.height;
        final int width = values.width;
        final int depth = values.depth;
        final int complexWidth = (width / 2 + 1) * 2;
        final FloatArray3D result = new FloatArray3D(complexWidth, height, depth);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = this.newThreads();
        final int numThreads = threads.length;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    float[] tempIn = new float[width];
                    FftReal fft = new FftReal(width);
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 0; y < height; ++y) {
                            int x;
                            float[] tempOut = new float[complexWidth];
                            for (x = 0; x < width; ++x) {
                                tempIn[x] = values.get(x, y, z);
                            }
                            fft.realToComplex(-1, tempIn, tempOut);
                            if (scale) {
                                fft.scale(width, tempOut);
                            }
                            for (x = 0; x < complexWidth; ++x) {
                                result.set(tempOut[x], x, y, z);
                            }
                        }
                    }
                }
            });
        }
        this.startAndJoin(threads);
        ai.set(0);
        threads = this.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[height * 2];
                    FftComplex fftc = new FftComplex(height);
                    int myNumber = ai.getAndIncrement();
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int y;
                            float[] tempOut = new float[height * 2];
                            for (y = 0; y < height; ++y) {
                                tempIn[y * 2] = result.get(x * 2, y, z);
                                tempIn[y * 2 + 1] = result.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(-1, tempIn, tempOut);
                            for (y = 0; y < height; ++y) {
                                result.set(tempOut[y * 2], x * 2, y, z);
                                result.set(tempOut[y * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        this.startAndJoin(threads);
        ai.set(0);
        threads = this.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[depth * 2];
                    FftComplex fftc = new FftComplex(depth);
                    int myNumber = ai.getAndIncrement();
                    for (int y = 0; y < height; ++y) {
                        if (y % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int z;
                            float[] tempOut = new float[depth * 2];
                            for (z = 0; z < depth; ++z) {
                                tempIn[z * 2] = result.get(x * 2, y, z);
                                tempIn[z * 2 + 1] = result.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(-1, tempIn, tempOut);
                            for (z = 0; z < depth; ++z) {
                                result.set(tempOut[z * 2], x * 2, y, z);
                                result.set(tempOut[z * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        this.startAndJoin(threads);
        return result;
    }

    private FloatArray3D pffftInv3D(FloatArray3D values, int nfft) {
        int y;
        float[] tempOut;
        int x;
        int depth = values.depth;
        int height = values.height;
        int width = nfft;
        int complexWidth = (width / 2 + 1) * 2;
        FloatArray3D result = new FloatArray3D(width, height, depth);
        float[] tempIn = new float[depth * 2];
        FftComplex fftc = new FftComplex(depth);
        for (int y2 = 0; y2 < height; ++y2) {
            for (x = 0; x < complexWidth / 2; ++x) {
                int z;
                tempOut = new float[depth * 2];
                for (z = 0; z < depth; ++z) {
                    tempIn[z * 2] = values.get(x * 2, y2, z);
                    tempIn[z * 2 + 1] = values.get(x * 2 + 1, y2, z);
                }
                fftc.complexToComplex(1, tempIn, tempOut);
                for (z = 0; z < depth; ++z) {
                    values.set(tempOut[z * 2], x * 2, y2, z);
                    values.set(tempOut[z * 2 + 1], x * 2 + 1, y2, z);
                }
            }
        }
        tempIn = new float[height * 2];
        fftc = new FftComplex(height);
        for (int z = 0; z < depth; ++z) {
            for (x = 0; x < complexWidth / 2; ++x) {
                tempOut = new float[height * 2];
                for (y = 0; y < height; ++y) {
                    tempIn[y * 2] = values.get(x * 2, y, z);
                    tempIn[y * 2 + 1] = values.get(x * 2 + 1, y, z);
                }
                fftc.complexToComplex(1, tempIn, tempOut);
                for (y = 0; y < height; ++y) {
                    values.set(tempOut[y * 2], x * 2, y, z);
                    values.set(tempOut[y * 2 + 1], x * 2 + 1, y, z);
                }
            }
        }
        tempIn = new float[complexWidth];
        FftReal fft = new FftReal(width);
        for (int z = 0; z < depth; ++z) {
            for (y = 0; y < height; ++y) {
                int x2;
                tempOut = new float[width];
                for (x2 = 0; x2 < complexWidth; ++x2) {
                    tempIn[x2] = values.get(x2, y, z);
                }
                fft.complexToReal(1, tempIn, tempOut);
                int i = 0;
                while (i < tempOut.length) {
                    int n = i++;
                    tempOut[n] = tempOut[n] / (float)(width * height * depth);
                }
                for (x2 = 0; x2 < width; ++x2) {
                    result.set(tempOut[x2], x2, y, z);
                }
            }
        }
        return result;
    }

    private FloatArray3D pffftInv3DMT(final FloatArray3D values, int nfft) {
        int ithread;
        final int depth = values.depth;
        final int height = values.height;
        final int width = nfft;
        final int complexWidth = (width / 2 + 1) * 2;
        final FloatArray3D result = new FloatArray3D(width, height, depth);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = this.newThreads();
        final int numThreads = threads.length;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    float[] tempIn = new float[depth * 2];
                    FftComplex fftc = new FftComplex(depth);
                    for (int y = 0; y < height; ++y) {
                        if (y % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int z;
                            float[] tempOut = new float[complexWidth];
                            tempOut = new float[depth * 2];
                            for (z = 0; z < depth; ++z) {
                                tempIn[z * 2] = values.get(x * 2, y, z);
                                tempIn[z * 2 + 1] = values.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(1, tempIn, tempOut);
                            for (z = 0; z < depth; ++z) {
                                values.set(tempOut[z * 2], x * 2, y, z);
                                values.set(tempOut[z * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        this.startAndJoin(threads);
        ai.set(0);
        threads = this.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[height * 2];
                    FftComplex fftc = new FftComplex(height);
                    int myNumber = ai.getAndIncrement();
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int x = 0; x < complexWidth / 2; ++x) {
                            int y;
                            float[] tempOut = new float[height * 2];
                            for (y = 0; y < height; ++y) {
                                tempIn[y * 2] = values.get(x * 2, y, z);
                                tempIn[y * 2 + 1] = values.get(x * 2 + 1, y, z);
                            }
                            fftc.complexToComplex(1, tempIn, tempOut);
                            for (y = 0; y < height; ++y) {
                                values.set(tempOut[y * 2], x * 2, y, z);
                                values.set(tempOut[y * 2 + 1], x * 2 + 1, y, z);
                            }
                        }
                    }
                }
            });
        }
        this.startAndJoin(threads);
        ai.set(0);
        threads = this.newThreads();
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    float[] tempIn = new float[complexWidth];
                    FftReal fft = new FftReal(width);
                    int myNumber = ai.getAndIncrement();
                    for (int z = 0; z < depth; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 0; y < height; ++y) {
                            int x;
                            float[] tempOut = new float[width];
                            for (x = 0; x < complexWidth; ++x) {
                                tempIn[x] = values.get(x, y, z);
                            }
                            fft.complexToReal(1, tempIn, tempOut);
                            int i = 0;
                            while (i < tempOut.length) {
                                int n = i++;
                                tempOut[n] = tempOut[n] / (float)(width * height * depth);
                            }
                            for (x = 0; x < width; ++x) {
                                result.set(tempOut[x], x, y, z);
                            }
                        }
                    }
                }
            });
        }
        this.startAndJoin(threads);
        return result;
    }

    private ImagePlus FloatArrayToImagePlus(FloatArray2D image, String name, float min, float max) {
        ImagePlus imp = IJ.createImage((String)name, (String)"32-Bit Black", (int)image.width, (int)image.height, (int)1);
        FloatProcessor ip = (FloatProcessor)imp.getProcessor();
        this.FloatArrayToFloatProcessor((ImageProcessor)ip, image);
        if (min == max) {
            ip.resetMinAndMax();
        } else {
            ip.setMinAndMax((double)min, (double)max);
        }
        imp.updateAndDraw();
        return imp;
    }

    private void FloatArrayToFloatProcessor(ImageProcessor ip, FloatArray2D pixels) {
        float[] img = new float[pixels.width * pixels.height];
        int count = 0;
        for (int y = 0; y < pixels.height; ++y) {
            for (int x = 0; x < pixels.width; ++x) {
                img[count] = pixels.data[count++];
            }
        }
        ip.setPixels((Object)img);
        ip.resetMinAndMax();
    }

    private ImagePlus FloatArrayToStack(FloatArray3D image, String name, float min, float max) {
        if (min == max) {
            float[] minmax = this.getMinMax(image);
            min = minmax[0];
            max = minmax[1];
        }
        int width = image.width;
        int height = image.height;
        int nstacks = image.depth;
        ImageStack stack = new ImageStack(width, height);
        for (int slice = 0; slice < nstacks; ++slice) {
            ImagePlus impResult = IJ.createImage((String)"Result", (String)"32-Bit Black", (int)width, (int)height, (int)1);
            ImageProcessor ipResult = impResult.getProcessor();
            float[] sliceImg = new float[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    sliceImg[y * width + x] = image.get(x, y, slice);
                }
            }
            ipResult.setPixels((Object)sliceImg);
            ipResult.setMinAndMax((double)min, (double)max);
            stack.addSlice("Slice " + slice, ipResult);
        }
        return new ImagePlus(name, stack);
    }

    private float[] getMinMax(FloatArray3D img) {
        float[] result = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        for (int i = 0; i < img.data.length; ++i) {
            if (img.data[i] < result[0]) {
                result[0] = img.data[i];
            }
            if (!(img.data[i] > result[1])) continue;
            result[1] = img.data[i];
        }
        return result;
    }

    private Thread[] newThreads() {
        int nthread = Runtime.getRuntime().availableProcessors();
        return new Thread[nthread];
    }

    private void startAndJoin(Thread[] threads) {
        int ithread;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(5);
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private FloatArray3D StackToFloatArray(ImageStack stack) {
        return this.StackToFloatArray(stack, null);
    }

    private FloatArray3D StackToFloatArray(ImageStack stack, String handleRGB) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        int rgbType = -1;
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            if (handleRGB == null || handleRGB.trim().length() == 0) {
                handleRGB = colorList[colorList.length - 1];
            }
            for (int i = 0; i < colorList.length; ++i) {
                if (!handleRGB.toLowerCase().trim().equals(colorList[i].toLowerCase())) continue;
                rgbType = i;
            }
            if (rgbType == -1) {
                System.err.println("Unrecognized command to handle RGB: " + handleRGB + ". Assuming Average of Red, Green and Blue.");
                rgbType = colorList.length - 1;
            }
        }
        FloatArray3D pixels = new FloatArray3D(width, height, nstacks);
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof float[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++];
                    }
                }
            }
        } else if (imageStack[0] instanceof int[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                int[] pixelTmp = (int[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = this.getPixelValueRGB(pixelTmp[count++], rgbType);
                    }
                }
            }
        } else {
            IJ.error((String)"StackToFloatArray: Unknown image type.");
            return null;
        }
        return pixels;
    }

    private float getPixelValueRGB(int rgb, int rgbType) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        if (rgbType == 0) {
            return r;
        }
        if (rgbType == 1) {
            return g;
        }
        if (rgbType == 2) {
            return b;
        }
        if (rgbType == 3) {
            return (float)(r + g) / 2.0f;
        }
        if (rgbType == 4) {
            return (float)(r + b) / 2.0f;
        }
        if (rgbType == 5) {
            return (float)(g + b) / 2.0f;
        }
        return (float)(r + g + b) / 3.0f;
    }

    private FloatArray2D ImageToFloatArray(ImageProcessor ip) {
        return this.ImageToFloatArray(ip, null);
    }

    private FloatArray2D ImageToFloatArray(ImageProcessor ip, String handleRGB) {
        FloatArray2D image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        int rgbType = -1;
        if (ip instanceof ColorProcessor) {
            if (handleRGB == null || handleRGB.trim().length() == 0) {
                handleRGB = colorList[colorList.length - 1];
            }
            for (int i = 0; i < colorList.length; ++i) {
                if (!handleRGB.toLowerCase().trim().equals(colorList[i].toLowerCase())) continue;
                rgbType = i;
            }
            if (rgbType == -1) {
                System.err.println("Unrecognized command to handle RGB: " + handleRGB + ". Assuming Average of Red, Green and Blue.");
                rgbType = colorList.length - 1;
            }
        }
        if (ip instanceof ByteProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++];
                }
            }
        } else if (ip instanceof ColorProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            int[] pixels = (int[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = this.getPixelValueRGB(pixels[count++], rgbType);
                }
            }
        } else {
            IJ.error((String)"StackToFloatArray: Unknown image type.");
            return null;
        }
        return image;
    }

    public class FloatArray3D
    extends FloatArray {
        public int width;
        public int height;
        public int depth;
        private int doubleWidth;
        private int doubleHeight;
        private int doubleDepth;

        public FloatArray3D(float[] data, int width, int height, int depth) {
            this.width = 0;
            this.height = 0;
            this.depth = 0;
            this.data = data;
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.doubleWidth = 2 * width;
            this.doubleHeight = 2 * height;
            this.doubleDepth = 2 * depth;
        }

        public FloatArray3D(int width, int height, int depth) {
            this.width = 0;
            this.height = 0;
            this.depth = 0;
            this.data = new float[width * height * depth];
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.doubleWidth = 2 * width;
            this.doubleHeight = 2 * height;
            this.doubleDepth = 2 * depth;
        }

        @Override
        public FloatArray3D clone() {
            FloatArray3D clone = new FloatArray3D(this.width, this.height, this.depth);
            System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
            return clone;
        }

        public int getPos(int x, int y, int z) {
            return x + this.width * (y + z * this.height);
        }

        public float get(int x, int y, int z) {
            return this.data[this.getPos(x, y, z)];
        }

        public float getValueOutOfImage(int x, int y, int z, float value) {
            if (x > 0 && x < this.width && y > 0 && y < this.height && z > 0 && z < this.depth) {
                return this.data[this.getPos(x, y, z)];
            }
            return value;
        }

        public float getFlipInRange(int x, int y, int z) {
            if (x < 0) {
                x = this.doubleWidth + x % this.doubleWidth;
            }
            if (x >= this.doubleWidth) {
                x %= this.doubleWidth;
            }
            if (x >= this.width) {
                x = this.width - x % this.width - 1;
            }
            if (y < 0) {
                y = this.doubleHeight + y % this.doubleHeight;
            }
            if (y >= this.doubleHeight) {
                y %= this.doubleHeight;
            }
            if (y >= this.height) {
                y = this.height - y % this.height - 1;
            }
            if (z < 0) {
                z = this.doubleDepth + z % this.doubleDepth;
            }
            if (z >= this.doubleDepth) {
                z %= this.doubleDepth;
            }
            if (z >= this.depth) {
                z = this.depth - z % this.depth - 1;
            }
            return this.data[this.getPos(x, y, z)];
        }

        public float getMirror(int x, int y, int z) {
            int dir;
            int tmp;
            if (x >= this.width) {
                x = this.width - (x - this.width + 2);
            }
            if (y >= this.height) {
                y = this.height - (y - this.height + 2);
            }
            if (z >= this.depth) {
                z = this.depth - (z - this.depth + 2);
            }
            if (x < 0) {
                tmp = 0;
                dir = 1;
                while (x < 0) {
                    if ((tmp += dir) == this.width - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++x;
                }
                x = tmp;
            }
            if (y < 0) {
                tmp = 0;
                dir = 1;
                while (y < 0) {
                    if ((tmp += dir) == this.height - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++y;
                }
                y = tmp;
            }
            if (z < 0) {
                tmp = 0;
                dir = 1;
                while (z < 0) {
                    if ((tmp += dir) == this.height - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++z;
                }
                z = tmp;
            }
            return this.data[this.getPos(x, y, z)];
        }

        public void set(float value, int x, int y, int z) {
            this.data[this.getPos((int)x, (int)y, (int)z)] = value;
        }

        public FloatArray2D getXPlane(int x) {
            FloatArray2D plane = new FloatArray2D(this.height, this.depth);
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    plane.set(this.get(x, y, z), y, z);
                }
            }
            return plane;
        }

        public float[][] getXPlane_float(int x) {
            float[][] plane = new float[this.height][this.depth];
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    plane[y][z] = this.get(x, y, z);
                }
            }
            return plane;
        }

        public FloatArray2D getYPlane(int y) {
            FloatArray2D plane = new FloatArray2D(this.width, this.depth);
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    plane.set(this.get(x, y, z), x, z);
                }
            }
            return plane;
        }

        public float[][] getYPlane_float(int y) {
            float[][] plane = new float[this.width][this.depth];
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    plane[x][z] = this.get(x, y, z);
                }
            }
            return plane;
        }

        public FloatArray2D getZPlane(int z) {
            FloatArray2D plane = new FloatArray2D(this.width, this.height);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    plane.set(this.get(x, y, z), x, y);
                }
            }
            return plane;
        }

        public float[][] getZPlane_float(int z) {
            float[][] plane = new float[this.width][this.height];
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    plane[x][y] = this.get(x, y, z);
                }
            }
            return plane;
        }

        public void setXPlane(FloatArray2D plane, int x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane.get(y, z), x, y, z);
                }
            }
        }

        public void setXPlane(float[][] plane, int x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane[y][z], x, y, z);
                }
            }
        }

        public void setYPlane(FloatArray2D plane, int y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane.get(x, z), x, y, z);
                }
            }
        }

        public void setYPlane(float[][] plane, int y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    this.set(plane[x][z], x, y, z);
                }
            }
        }

        public void setZPlane(FloatArray2D plane, int z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.set(plane.get(x, y), x, y, z);
                }
            }
        }

        public void setZPlane(float[][] plane, int z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.set(plane[x][y], x, y, z);
                }
            }
        }
    }

    public class FloatArray2D
    extends FloatArray {
        public int width;
        public int height;
        private int doubleWidth;
        private int doubleHeight;

        public FloatArray2D(int width, int height) {
            this.width = 0;
            this.height = 0;
            this.data = new float[width * height];
            this.width = width;
            this.height = height;
            this.doubleWidth = 2 * width;
            this.doubleHeight = 2 * height;
        }

        public FloatArray2D(float[] data, int width, int height) {
            this.width = 0;
            this.height = 0;
            this.data = data;
            this.width = width;
            this.height = height;
            this.doubleWidth = 2 * width;
            this.doubleHeight = 2 * height;
        }

        @Override
        public FloatArray2D clone() {
            FloatArray2D clone = new FloatArray2D(this.width, this.height);
            System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
            return clone;
        }

        public int getPos(int x, int y) {
            return x + this.width * y;
        }

        public float get(int x, int y) {
            return this.data[this.getPos(x, y)];
        }

        public float getValueOutOfImage(int x, int y, float value) {
            if (x > 0 && x < this.width && y > 0 && y < this.height) {
                return this.data[this.getPos(x, y)];
            }
            return value;
        }

        public float getFlipInRange(int x, int y) {
            if (x < 0) {
                x = this.doubleWidth + x % this.doubleWidth;
            }
            if (x >= this.doubleWidth) {
                x %= this.doubleWidth;
            }
            if (x >= this.width) {
                x = this.width - x % this.width - 1;
            }
            if (y < 0) {
                y = this.doubleHeight + y % this.doubleHeight;
            }
            if (y >= this.doubleHeight) {
                y %= this.doubleHeight;
            }
            if (y >= this.height) {
                y = this.height - y % this.height - 1;
            }
            return this.data[this.getPos(x, y)];
        }

        public float getMirror(int x, int y) {
            int dir;
            int tmp;
            if (x >= this.width) {
                x = this.width - (x - this.width + 2);
            }
            if (y >= this.height) {
                y = this.height - (y - this.height + 2);
            }
            if (x < 0) {
                tmp = 0;
                dir = 1;
                while (x < 0) {
                    if ((tmp += dir) == this.width - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++x;
                }
                x = tmp;
            }
            if (y < 0) {
                tmp = 0;
                dir = 1;
                while (y < 0) {
                    if ((tmp += dir) == this.height - 1 || tmp == 0) {
                        dir *= -1;
                    }
                    ++y;
                }
                y = tmp;
            }
            return this.data[this.getPos(x, y)];
        }

        public float getZero(int x, int y) {
            if (x >= this.width) {
                return 0.0f;
            }
            if (y >= this.height) {
                return 0.0f;
            }
            if (x < 0) {
                return 0.0f;
            }
            if (y < 0) {
                return 0.0f;
            }
            return this.data[this.getPos(x, y)];
        }

        public void set(float value, int x, int y) {
            this.data[this.getPos((int)x, (int)y)] = value;
        }
    }

    public abstract class FloatArray {
        public float[] data = null;

        public abstract FloatArray clone();
    }
}

