/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.appearance;

import bdv.tools.brightness.ColorIcon;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.border.EmptyBorder;

class StyleElements {
    StyleElements() {
    }

    public static Separator separator() {
        return new Separator();
    }

    public static BooleanElement booleanElement(String label, final BooleanSupplier get, final Consumer<Boolean> set) {
        return new BooleanElement(label){

            @Override
            public boolean get() {
                return get.getAsBoolean();
            }

            @Override
            public void set(boolean b) {
                set.accept(b);
            }
        };
    }

    public static ColorElement colorElement(String label, final IntSupplier get, final IntConsumer set) {
        return new ColorElement(label){

            @Override
            public int getColor() {
                return get.getAsInt();
            }

            @Override
            public void setColor(int c) {
                set.accept(c);
            }
        };
    }

    public static <T> ComboBoxElement<T> comboBoxElement(String label, Supplier<T> get, Consumer<T> set, ComboBoxEntry<T> ... entries) {
        return StyleElements.comboBoxElement(label, get, set, Arrays.asList(entries));
    }

    public static <T extends Enum<T>> ComboBoxElement<T> comboBoxElement(String label, Supplier<T> get, Consumer<T> set, T[] entries) {
        List<ComboBoxEntry<T>> list = Arrays.stream(entries).map(v -> new ComboBoxEntry<Enum>((Enum)v, v.toString())).collect(Collectors.toList());
        return StyleElements.comboBoxElement(label, get, set, list);
    }

    public static <T> ComboBoxElement<T> comboBoxElement(String label, final Supplier<T> get, final Consumer<T> set, List<ComboBoxEntry<T>> entries) {
        return new ComboBoxElement<T>(label, entries){

            @Override
            public T get() {
                return get.get();
            }

            @Override
            public void set(T t) {
                set.accept(t);
            }
        };
    }

    public static <T> ComboBoxEntry<T> cbentry(T value, String name) {
        return new ComboBoxEntry<T>(value, name);
    }

    public static JCheckBox linkedCheckBox(BooleanElement element, String label) {
        JCheckBox checkbox = new JCheckBox(label, element.get());
        checkbox.setFocusable(false);
        checkbox.addActionListener(e -> element.set(checkbox.isSelected()));
        element.onSet(b -> {
            if (b.booleanValue() != checkbox.isSelected()) {
                checkbox.setSelected((boolean)b);
            }
        });
        return checkbox;
    }

    public static JCheckBox linkedCheckBox(BooleanElement element) {
        JCheckBox checkbox = new JCheckBox();
        checkbox.setSelected(element.get());
        checkbox.setFocusable(false);
        checkbox.addActionListener(e -> element.set(checkbox.isSelected()));
        element.onSet(b -> {
            if (b.booleanValue() != checkbox.isSelected()) {
                checkbox.setSelected((boolean)b);
            }
        });
        return checkbox;
    }

    private static Color asColor(int rgba) {
        return new Color(rgba, true);
    }

    private static int asInt(Color color) {
        return color.getRGB();
    }

    public static JButton linkedColorButton(final ColorElement element, final JColorChooser colorChooser) {
        Color outlineColor = Color.BLACK;
        final ColorIcon icon = new ColorIcon(StyleElements.asColor(element.getColor()), 13, 13, 5, 5, true, outlineColor);
        final JButton button = new JButton(icon);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorder(new EmptyBorder(0, 0, 1, 1));
        button.setHorizontalAlignment(2);
        button.setFocusable(false);
        button.addActionListener(e -> {
            colorChooser.setColor(StyleElements.asColor(element.getColor()));
            JDialog d = JColorChooser.createDialog(button, "Choose a color", true, colorChooser, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Color c = colorChooser.getColor();
                    if (c != null) {
                        icon.setColor(c);
                        button.repaint();
                        element.setColor(StyleElements.asInt(c));
                    }
                }
            }, null);
            d.setVisible(true);
        });
        element.onSet(rgba -> icon.setColor(StyleElements.asColor(rgba)));
        return button;
    }

    public static <T> JComboBox<ComboBoxEntry<T>> linkedComboBox(ComboBoxElement<T> element) {
        Vector vector = new Vector();
        vector.addAll(element.entries());
        JComboBox comboBox = new JComboBox(vector);
        comboBox.setEditable(false);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Object value = ((ComboBoxEntry)e.getItem()).value();
                element.set(value);
            }
        });
        Consumer<Object> setEntryForValue = value -> {
            for (ComboBoxEntry entry : vector) {
                if (!Objects.equals(entry.value(), value)) continue;
                comboBox.setSelectedItem(entry);
                break;
            }
        };
        element.onSet(setEntryForValue);
        setEntryForValue.accept(element.get());
        return comboBox;
    }

    public static abstract class ComboBoxElement<T>
    implements StyleElement {
        private final String label;
        private final List<ComboBoxEntry<T>> entries;
        private final ArrayList<Consumer<T>> onSet = new ArrayList();

        public ComboBoxElement(String label, List<ComboBoxEntry<T>> entries) {
            this.label = label;
            this.entries = entries;
            if (entries.isEmpty()) {
                throw new IllegalArgumentException();
            }
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(Consumer<T> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<T>>)((Consumer<Consumer>)c -> c.accept(this.get())));
        }

        public abstract T get();

        public abstract void set(T var1);

        public List<ComboBoxEntry<T>> entries() {
            return this.entries;
        }
    }

    static class ComboBoxEntry<T> {
        private final T value;
        private final String name;

        ComboBoxEntry(T value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public T value() {
            return this.value;
        }
    }

    public static abstract class BooleanElement
    implements StyleElement {
        private final String label;
        private final ArrayList<Consumer<Boolean>> onSet = new ArrayList();

        public BooleanElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(Consumer<Boolean> set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach((Consumer<Consumer<Boolean>>)((Consumer<Consumer>)c -> c.accept(this.get())));
        }

        public abstract boolean get();

        public abstract void set(boolean var1);
    }

    public static abstract class ColorElement
    implements StyleElement {
        private final ArrayList<IntConsumer> onSet = new ArrayList();
        private final String label;

        public ColorElement(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }

        public void onSet(IntConsumer set) {
            this.onSet.add(set);
        }

        @Override
        public void update() {
            this.onSet.forEach(c -> c.accept(this.getColor()));
        }

        public abstract int getColor();

        public abstract void setColor(int var1);
    }

    public static class Separator
    implements StyleElement {
        @Override
        public void accept(StyleElementVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static interface StyleElement {
        default public void update() {
        }

        public void accept(StyleElementVisitor var1);
    }

    public static interface StyleElementVisitor {
        default public void visit(Separator element) {
            throw new UnsupportedOperationException();
        }

        default public void visit(ColorElement colorElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(BooleanElement booleanElement) {
            throw new UnsupportedOperationException();
        }

        default public void visit(ComboBoxElement<?> comboBoxElement) {
            throw new UnsupportedOperationException();
        }
    }
}

