/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.splitpanel;

import bdv.ui.CardPanel;
import bdv.ui.UIUtils;
import bdv.ui.splitpanel.SplitPaneOneTouchExpandAnimator;
import bdv.ui.splitpanel.SplitPaneOneTouchExpandTrigger;
import bdv.viewer.AbstractViewerPanel;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Actions;

public class SplitPanel
extends JSplitPane {
    private static final int DEFAULT_DIVIDER_SIZE = 3;
    private static final String FOCUS_VIEWER_PANEL = "focus viewer panel";
    private static final String HIDE_CARD_PANEL = "hide card panel";
    private final JScrollPane scrollPane;
    private int width;
    private final SplitPaneOneTouchExpandAnimator oneTouchExpandAnimator;
    private int dividerSizeWhenVisible = -1;

    public SplitPanel(AbstractViewerPanel viewerPanel, CardPanel cardPanel) {
        super(1);
        final double uiScale = UIUtils.getUIScaleFactor(this);
        this.configureSplitPane();
        final JComponent cardPanelComponent = cardPanel.getComponent();
        this.scrollPane = new JScrollPane(cardPanelComponent);
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setPreferredSize(new Dimension((int)Math.floor(800.0 * uiScale), (int)Math.floor(200.0 * uiScale)));
        InputMap inputMap = this.scrollPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("F6"), "none");
        InputTriggerConfig inputTriggerConfig = viewerPanel.getInputTriggerConfig();
        Actions actions = new Actions(inputMap, this.scrollPane.getActionMap(), (KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv"});
        actions.runnableAction(viewerPanel::requestFocusInWindow, FOCUS_VIEWER_PANEL, new String[]{"ESCAPE"});
        actions.runnableAction(() -> {
            this.setCollapsed(true);
            viewerPanel.requestFocusInWindow();
        }, HIDE_CARD_PANEL, new String[]{"shift ESCAPE"});
        this.setLeftComponent(viewerPanel);
        this.setRightComponent(null);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setPreferredSize(viewerPanel.getPreferredSize());
        super.setDividerSize(0);
        this.oneTouchExpandAnimator = new SplitPaneOneTouchExpandAnimator(this::isCollapsed);
        viewerPanel.addOverlayAnimator(this.oneTouchExpandAnimator);
        SplitPaneOneTouchExpandTrigger oneTouchExpandTrigger = new SplitPaneOneTouchExpandTrigger(this.oneTouchExpandAnimator, this, viewerPanel);
        viewerPanel.getDisplayComponent().addMouseMotionListener(oneTouchExpandTrigger);
        viewerPanel.getDisplayComponent().addMouseListener(oneTouchExpandTrigger);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = SplitPanel.this.getWidth();
                if (SplitPanel.this.width > 0) {
                    int dl = SplitPanel.this.getLastDividerLocation() + w - SplitPanel.this.width;
                    SplitPanel.this.setLastDividerLocation(Math.max(50, dl));
                } else {
                    SplitPanel.this.setDividerLocation(w);
                    SplitPanel.this.setLastDividerLocation(Math.max(w / 2, w - Math.max((int)Math.floor(200.0 * uiScale), cardPanelComponent.getPreferredSize().width)));
                }
                SplitPanel.this.width = w;
            }
        });
    }

    private void configureSplitPane() {
        this.setResizeWeight(1.0);
        this.setContinuousLayout(true);
    }

    @Override
    public void setDividerSize(int newSize) {
        this.dividerSizeWhenVisible = newSize;
        this.updateDividerSize();
    }

    public void setCollapsed(boolean collapsed) {
        if (this.isCollapsed() == collapsed) {
            return;
        }
        this.oneTouchExpandAnimator.clearPaintState();
        if (collapsed) {
            this.setRightComponent(null);
            this.setDividerLocation(1.0);
        } else {
            this.setRightComponent(this.scrollPane);
            int dl = this.getLastDividerLocation();
            int w = this.getWidth();
            double uiScale = UIUtils.getUIScaleFactor(this);
            this.setDividerLocation(Math.max(Math.min(w / 2, (int)Math.floor(50.0 * uiScale)), Math.min(w - (int)Math.floor(50.0 * uiScale), dl)));
        }
        this.updateDividerSize();
    }

    private void updateDividerSize() {
        int s;
        if (this.isCollapsed()) {
            s = 0;
        } else if (this.dividerSizeWhenVisible >= 0) {
            s = this.dividerSizeWhenVisible;
        } else {
            double uiScale = UIUtils.getUIScaleFactor(this);
            s = (int)Math.round(uiScale * 3.0);
        }
        super.setDividerSize(s);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.scrollPane != null) {
            double uiScale = UIUtils.getUIScaleFactor(this);
            this.scrollPane.setPreferredSize(new Dimension((int)Math.floor(800.0 * uiScale), (int)Math.floor(200.0 * uiScale)));
            if (this.getRightComponent() == null) {
                SwingUtilities.updateComponentTreeUI(this.scrollPane);
            }
            this.updateDividerSize();
        }
    }

    public boolean isCollapsed() {
        return this.getRightComponent() == null;
    }
}

