/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.tools.brightness.ConverterSetup;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.listeners.Listeners;

public final class PlaceHolderConverterSetup
implements ConverterSetup {
    private final int setupId;
    private double min;
    private double max;
    private final ARGBType color;
    private final boolean supportsColor;
    private final Listeners.List<ConverterSetup.SetupChangeListener> listeners;

    public PlaceHolderConverterSetup(int setupId, double min, double max, int rgb) {
        this(setupId, min, max, new ARGBType(rgb));
    }

    public PlaceHolderConverterSetup(int setupId, double min, double max, ARGBType color) {
        this.setupId = setupId;
        this.min = min;
        this.max = max;
        this.color = new ARGBType();
        if (color != null) {
            this.color.set(color);
        }
        this.supportsColor = color != null;
        this.listeners = new Listeners.SynchronizedList();
    }

    @Override
    public Listeners<ConverterSetup.SetupChangeListener> setupChangeListeners() {
        return this.listeners;
    }

    @Override
    public int getSetupId() {
        return this.setupId;
    }

    @Override
    public void setDisplayRange(double min, double max) {
        if (this.min == min && this.max == max) {
            return;
        }
        this.min = min;
        this.max = max;
        this.listeners.list.forEach(l -> l.setupParametersChanged(this));
    }

    @Override
    public void setColor(ARGBType color) {
        this.setColor(color.get());
    }

    public void setColor(int rgb) {
        if (!this.supportsColor() || this.color.get() == rgb) {
            return;
        }
        this.color.set(rgb);
        this.listeners.list.forEach(l -> l.setupParametersChanged(this));
    }

    @Override
    public boolean supportsColor() {
        return this.supportsColor;
    }

    @Override
    public double getDisplayRangeMin() {
        return this.min;
    }

    @Override
    public double getDisplayRangeMax() {
        return this.max;
    }

    @Override
    public ARGBType getColor() {
        return this.color;
    }
}

