/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.util.Affine3DHelpers;
import bdv.viewer.animate.AbstractTransformAnimator;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class RotationAnimator
extends AbstractTransformAnimator {
    private final AffineTransform3D transformStart;
    private final double[] qAddEnd;
    private final double cX;
    private final double cY;

    public RotationAnimator(AffineTransform3D transformStart, double viewerCenterX, double viewerCenterY, double[] targetOrientation, long duration) {
        super(duration);
        this.transformStart = transformStart;
        this.cX = viewerCenterX;
        this.cY = viewerCenterY;
        double[] qCurrent = new double[4];
        Affine3DHelpers.extractRotation(transformStart, qCurrent);
        double[] qTmp = new double[4];
        this.qAddEnd = new double[4];
        LinAlgHelpers.quaternionInvert(qCurrent, qTmp);
        LinAlgHelpers.quaternionMultiply(targetOrientation, qTmp, this.qAddEnd);
        if (this.qAddEnd[0] < 0.0) {
            for (int i = 0; i < 4; ++i) {
                this.qAddEnd[i] = -this.qAddEnd[i];
            }
        }
    }

    @Override
    public AffineTransform3D get(double t) {
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(this.transformStart);
        transform.set(transform.get(0, 3) - this.cX, 0, 3);
        transform.set(transform.get(1, 3) - this.cY, 1, 3);
        double[] qAddCurrent = new double[4];
        AffineTransform3D tAddCurrent = new AffineTransform3D();
        LinAlgHelpers.quaternionPower(this.qAddEnd, t, qAddCurrent);
        double[][] m = new double[3][4];
        LinAlgHelpers.quaternionToR(qAddCurrent, m);
        tAddCurrent.set(m);
        transform.preConcatenate(tAddCurrent);
        transform.set(transform.get(0, 3) + this.cX, 0, 3);
        transform.set(transform.get(1, 3) + this.cY, 1, 3);
        return transform;
    }
}

